/*
 * Decompiled with CFR 0.152.
 */
package android.content.integrity;

import android.content.integrity.AppInstallMetadata;
import android.content.integrity.IntegrityFormula;
import android.content.integrity.IntegrityUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@VisibleForTesting
public abstract class AtomicFormula
extends IntegrityFormula {
    public static final int PACKAGE_NAME = 0;
    public static final int APP_CERTIFICATE = 1;
    public static final int INSTALLER_NAME = 2;
    public static final int INSTALLER_CERTIFICATE = 3;
    public static final int VERSION_CODE = 4;
    public static final int PRE_INSTALLED = 5;
    public static final int STAMP_TRUSTED = 6;
    public static final int STAMP_CERTIFICATE_HASH = 7;
    public static final int EQ = 0;
    public static final int GT = 1;
    public static final int GTE = 2;
    private final int mKey;

    public AtomicFormula(int key) {
        Preconditions.checkArgument(AtomicFormula.isValidKey(key), String.format("Unknown key: %d", key));
        this.mKey = key;
    }

    public int getKey() {
        return this.mKey;
    }

    static String keyToString(int key) {
        switch (key) {
            case 0: {
                return "PACKAGE_NAME";
            }
            case 1: {
                return "APP_CERTIFICATE";
            }
            case 4: {
                return "VERSION_CODE";
            }
            case 2: {
                return "INSTALLER_NAME";
            }
            case 3: {
                return "INSTALLER_CERTIFICATE";
            }
            case 5: {
                return "PRE_INSTALLED";
            }
            case 6: {
                return "STAMP_TRUSTED";
            }
            case 7: {
                return "STAMP_CERTIFICATE_HASH";
            }
        }
        throw new IllegalArgumentException("Unknown key " + key);
    }

    static String operatorToString(int op) {
        switch (op) {
            case 0: {
                return "EQ";
            }
            case 1: {
                return "GT";
            }
            case 2: {
                return "GTE";
            }
        }
        throw new IllegalArgumentException("Unknown operator " + op);
    }

    private static boolean isValidKey(int key) {
        return key == 0 || key == 1 || key == 4 || key == 2 || key == 3 || key == 5 || key == 6 || key == 7;
    }

    public static class BooleanAtomicFormula
    extends AtomicFormula
    implements Parcelable {
        private final Boolean mValue;
        public static final Parcelable.Creator<BooleanAtomicFormula> CREATOR = new Parcelable.Creator<BooleanAtomicFormula>(){

            @Override
            public BooleanAtomicFormula createFromParcel(Parcel in) {
                return new BooleanAtomicFormula(in);
            }

            public BooleanAtomicFormula[] newArray(int size) {
                return new BooleanAtomicFormula[size];
            }
        };

        public BooleanAtomicFormula(int key) {
            super(key);
            Preconditions.checkArgument(key == 5 || key == 6, String.format("Key %s cannot be used with BooleanAtomicFormula", BooleanAtomicFormula.keyToString(key)));
            this.mValue = null;
        }

        public BooleanAtomicFormula(int key, boolean value) {
            super(key);
            Preconditions.checkArgument(key == 5 || key == 6, String.format("Key %s cannot be used with BooleanAtomicFormula", BooleanAtomicFormula.keyToString(key)));
            this.mValue = value;
        }

        BooleanAtomicFormula(Parcel in) {
            super(in.readInt());
            this.mValue = in.readByte() != 0;
        }

        @Override
        public int getTag() {
            return 3;
        }

        @Override
        public boolean matches(AppInstallMetadata appInstallMetadata) {
            if (this.mValue == null) {
                return false;
            }
            return BooleanAtomicFormula.getBooleanMetadataValue(appInstallMetadata, this.getKey()) == this.mValue;
        }

        @Override
        public boolean isAppCertificateFormula() {
            return false;
        }

        @Override
        public boolean isInstallerFormula() {
            return false;
        }

        public String toString() {
            if (this.mValue == null) {
                return String.format("(%s)", BooleanAtomicFormula.keyToString(this.getKey()));
            }
            return String.format("(%s %s %s)", BooleanAtomicFormula.keyToString(this.getKey()), BooleanAtomicFormula.operatorToString(0), this.mValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BooleanAtomicFormula that = (BooleanAtomicFormula)o;
            return this.getKey() == that.getKey() && this.mValue == that.mValue;
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.mValue);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mValue == null) {
                throw new IllegalStateException("Cannot write an empty BooleanAtomicFormula.");
            }
            dest.writeInt(this.getKey());
            dest.writeByte((byte)(this.mValue != false ? 1 : 0));
        }

        public Boolean getValue() {
            return this.mValue;
        }

        private static boolean getBooleanMetadataValue(AppInstallMetadata appInstallMetadata, int key) {
            switch (key) {
                case 5: {
                    return appInstallMetadata.isPreInstalled();
                }
                case 6: {
                    return appInstallMetadata.isStampTrusted();
                }
            }
            throw new IllegalStateException("Unexpected key in BooleanAtomicFormula: " + key);
        }
    }

    public static class StringAtomicFormula
    extends AtomicFormula
    implements Parcelable {
        private final String mValue;
        private final Boolean mIsHashedValue;
        public static final Parcelable.Creator<StringAtomicFormula> CREATOR = new Parcelable.Creator<StringAtomicFormula>(){

            @Override
            public StringAtomicFormula createFromParcel(Parcel in) {
                return new StringAtomicFormula(in);
            }

            public StringAtomicFormula[] newArray(int size) {
                return new StringAtomicFormula[size];
            }
        };

        public StringAtomicFormula(int key) {
            super(key);
            Preconditions.checkArgument(key == 0 || key == 1 || key == 3 || key == 2 || key == 7, String.format("Key %s cannot be used with StringAtomicFormula", StringAtomicFormula.keyToString(key)));
            this.mValue = null;
            this.mIsHashedValue = null;
        }

        public StringAtomicFormula(int key, String value, boolean isHashed) {
            super(key);
            Preconditions.checkArgument(key == 0 || key == 1 || key == 3 || key == 2 || key == 7, String.format("Key %s cannot be used with StringAtomicFormula", StringAtomicFormula.keyToString(key)));
            this.mValue = value;
            this.mIsHashedValue = isHashed;
        }

        public StringAtomicFormula(int key, String value) {
            super(key);
            Preconditions.checkArgument(key == 0 || key == 1 || key == 3 || key == 2 || key == 7, String.format("Key %s cannot be used with StringAtomicFormula", StringAtomicFormula.keyToString(key)));
            this.mValue = StringAtomicFormula.hashValue(key, value);
            this.mIsHashedValue = key == 1 || key == 3 || key == 7 || !this.mValue.equals(value);
        }

        StringAtomicFormula(Parcel in) {
            super(in.readInt());
            this.mValue = in.readStringNoHelper();
            this.mIsHashedValue = in.readByte() != 0;
        }

        @Override
        public int getTag() {
            return 1;
        }

        @Override
        public boolean matches(AppInstallMetadata appInstallMetadata) {
            if (this.mValue == null || this.mIsHashedValue == null) {
                return false;
            }
            return StringAtomicFormula.getMetadataValue(appInstallMetadata, this.getKey()).contains(this.mValue);
        }

        @Override
        public boolean isAppCertificateFormula() {
            return this.getKey() == 1;
        }

        @Override
        public boolean isInstallerFormula() {
            return this.getKey() == 2 || this.getKey() == 3;
        }

        public String toString() {
            if (this.mValue == null || this.mIsHashedValue == null) {
                return String.format("(%s)", StringAtomicFormula.keyToString(this.getKey()));
            }
            return String.format("(%s %s %s)", StringAtomicFormula.keyToString(this.getKey()), StringAtomicFormula.operatorToString(0), this.mValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringAtomicFormula that = (StringAtomicFormula)o;
            return this.getKey() == that.getKey() && Objects.equals(this.mValue, that.mValue);
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.mValue);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mValue == null || this.mIsHashedValue == null) {
                throw new IllegalStateException("Cannot write an empty StringAtomicFormula.");
            }
            dest.writeInt(this.getKey());
            dest.writeStringNoHelper(this.mValue);
            dest.writeByte((byte)(this.mIsHashedValue != false ? 1 : 0));
        }

        public String getValue() {
            return this.mValue;
        }

        public Boolean getIsHashedValue() {
            return this.mIsHashedValue;
        }

        private static List<String> getMetadataValue(AppInstallMetadata appInstallMetadata, int key) {
            switch (key) {
                case 0: {
                    return Collections.singletonList(appInstallMetadata.getPackageName());
                }
                case 1: {
                    return appInstallMetadata.getAppCertificates();
                }
                case 3: {
                    return appInstallMetadata.getInstallerCertificates();
                }
                case 2: {
                    return Collections.singletonList(appInstallMetadata.getInstallerName());
                }
                case 7: {
                    return Collections.singletonList(appInstallMetadata.getStampCertificateHash());
                }
            }
            throw new IllegalStateException("Unexpected key in StringAtomicFormula: " + key);
        }

        private static String hashValue(int key, String value) {
            if (value.length() > 32 && (key == 0 || key == 2)) {
                return StringAtomicFormula.hash(value);
            }
            return value;
        }

        private static String hash(String value) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                byte[] hashBytes = messageDigest.digest(value.getBytes(StandardCharsets.UTF_8));
                return IntegrityUtils.getHexDigest(hashBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SHA-256 algorithm not found", e);
            }
        }
    }

    public static class LongAtomicFormula
    extends AtomicFormula
    implements Parcelable {
        private final Long mValue;
        private final Integer mOperator;
        public static final Parcelable.Creator<LongAtomicFormula> CREATOR = new Parcelable.Creator<LongAtomicFormula>(){

            @Override
            public LongAtomicFormula createFromParcel(Parcel in) {
                return new LongAtomicFormula(in);
            }

            public LongAtomicFormula[] newArray(int size) {
                return new LongAtomicFormula[size];
            }
        };

        public LongAtomicFormula(int key) {
            super(key);
            Preconditions.checkArgument(key == 4, String.format("Key %s cannot be used with LongAtomicFormula", LongAtomicFormula.keyToString(key)));
            this.mValue = null;
            this.mOperator = null;
        }

        public LongAtomicFormula(int key, int operator, long value) {
            super(key);
            Preconditions.checkArgument(key == 4, String.format("Key %s cannot be used with LongAtomicFormula", LongAtomicFormula.keyToString(key)));
            Preconditions.checkArgument(LongAtomicFormula.isValidOperator(operator), String.format("Unknown operator: %d", operator));
            this.mOperator = operator;
            this.mValue = value;
        }

        LongAtomicFormula(Parcel in) {
            super(in.readInt());
            this.mValue = in.readLong();
            this.mOperator = in.readInt();
        }

        @Override
        public int getTag() {
            return 2;
        }

        @Override
        public boolean matches(AppInstallMetadata appInstallMetadata) {
            if (this.mValue == null || this.mOperator == null) {
                return false;
            }
            long metadataValue = LongAtomicFormula.getLongMetadataValue(appInstallMetadata, this.getKey());
            switch (this.mOperator) {
                case 0: {
                    return metadataValue == this.mValue;
                }
                case 1: {
                    return metadataValue > this.mValue;
                }
                case 2: {
                    return metadataValue >= this.mValue;
                }
            }
            throw new IllegalArgumentException(String.format("Unexpected operator %d", this.mOperator));
        }

        @Override
        public boolean isAppCertificateFormula() {
            return false;
        }

        @Override
        public boolean isInstallerFormula() {
            return false;
        }

        public String toString() {
            if (this.mValue == null || this.mOperator == null) {
                return String.format("(%s)", LongAtomicFormula.keyToString(this.getKey()));
            }
            return String.format("(%s %s %s)", LongAtomicFormula.keyToString(this.getKey()), LongAtomicFormula.operatorToString(this.mOperator), this.mValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongAtomicFormula that = (LongAtomicFormula)o;
            return this.getKey() == that.getKey() && this.mValue == that.mValue && this.mOperator == that.mOperator;
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.mOperator, this.mValue);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (this.mValue == null || this.mOperator == null) {
                throw new IllegalStateException("Cannot write an empty LongAtomicFormula.");
            }
            dest.writeInt(this.getKey());
            dest.writeLong(this.mValue);
            dest.writeInt(this.mOperator);
        }

        public Long getValue() {
            return this.mValue;
        }

        public Integer getOperator() {
            return this.mOperator;
        }

        private static boolean isValidOperator(int operator) {
            return operator == 0 || operator == 1 || operator == 2;
        }

        private static long getLongMetadataValue(AppInstallMetadata appInstallMetadata, int key) {
            switch (key) {
                case 4: {
                    return appInstallMetadata.getVersionCode();
                }
            }
            throw new IllegalStateException("Unexpected key in IntAtomicFormula" + key);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Operator {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Key {
    }
}

