/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ContextImpl;
import android.app.WindowTokenClient;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerImpl;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.Reference;

public class WindowContext
extends ContextWrapper {
    private final WindowManagerImpl mWindowManager;
    private final IWindowManager mWms = WindowManagerGlobal.getWindowManagerService();
    private final WindowTokenClient mToken = new WindowTokenClient();
    private boolean mOwnsToken;

    public WindowContext(Context base, int type, Bundle options) {
        super(null);
        int result;
        ContextImpl contextImpl = WindowContext.createBaseWindowContext(base, this.mToken);
        this.attachBaseContext(contextImpl);
        contextImpl.setOuterContext(this);
        this.mToken.attachContext(this);
        this.mWindowManager = new WindowManagerImpl((Context)this);
        this.mWindowManager.setDefaultToken(this.mToken);
        try {
            result = this.mWms.addWindowTokenWithOptions(this.mToken, type, this.getDisplayId(), options, this.getPackageName());
        }
        catch (RemoteException e) {
            this.mOwnsToken = false;
            throw e.rethrowFromSystemServer();
        }
        if (result == -12) {
            throw new UnsupportedOperationException("createWindowContext failed! Too many unused window contexts. Please see Context#createWindowContext documentation for detail.");
        }
        this.mOwnsToken = result == 0;
        Reference.reachabilityFence(this);
    }

    private static ContextImpl createBaseWindowContext(Context outer, IBinder token) {
        ContextImpl contextImpl = ContextImpl.getImpl(outer);
        return contextImpl.createBaseWindowContext(token);
    }

    @Override
    public Object getSystemService(String name) {
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    @VisibleForTesting
    public void release() {
        if (this.mOwnsToken) {
            try {
                this.mWms.removeWindowToken(this.mToken, this.getDisplayId());
                this.mOwnsToken = false;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.destroy();
    }

    void destroy() {
        ContextImpl impl = (ContextImpl)this.getBaseContext();
        impl.scheduleFinalCleanup(this.getClass().getName(), "WindowContext");
        Reference.reachabilityFence(this);
    }
}

