/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.GrantedUriPermission;
import android.app.IUriGrantsManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Singleton;

public class UriGrantsManager {
    private final Context mContext;
    private static final Singleton<IUriGrantsManager> IUriGrantsManagerSingleton = new Singleton<IUriGrantsManager>(){

        @Override
        protected IUriGrantsManager create() {
            IBinder b = ServiceManager.getService("uri_grants");
            return IUriGrantsManager.Stub.asInterface(b);
        }
    };

    UriGrantsManager(Context context, Handler handler) {
        this.mContext = context;
    }

    public static IUriGrantsManager getService() {
        return IUriGrantsManagerSingleton.get();
    }

    public void clearGrantedUriPermissions(String packageName) {
        try {
            UriGrantsManager.getService().clearGrantedUriPermissions(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ParceledListSlice<GrantedUriPermission> getGrantedUriPermissions(String packageName) {
        try {
            ParceledListSlice castedList = UriGrantsManager.getService().getGrantedUriPermissions(packageName, this.mContext.getUserId());
            return castedList;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

