/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.app.AppOpsManager;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.Immutable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@Immutable
public class SyncNotedAppOp
implements Parcelable {
    private final int mOpCode;
    private final String mAttributionTag;
    public static final Parcelable.Creator<SyncNotedAppOp> CREATOR = new Parcelable.Creator<SyncNotedAppOp>(){

        public SyncNotedAppOp[] newArray(int size) {
            return new SyncNotedAppOp[size];
        }

        @Override
        public SyncNotedAppOp createFromParcel(Parcel in) {
            return new SyncNotedAppOp(in);
        }
    };

    public SyncNotedAppOp(int opCode, String attributionTag) {
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 99L);
        this.mAttributionTag = attributionTag;
    }

    public String getOp() {
        return AppOpsManager.opToPublicName(this.mOpCode);
    }

    public String getAttributionTag() {
        return this.mAttributionTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncNotedAppOp that = (SyncNotedAppOp)o;
        return this.mOpCode == that.mOpCode && Objects.equals(this.mAttributionTag, that.mAttributionTag);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mOpCode;
        _hash = 31 * _hash + Objects.hashCode(this.mAttributionTag);
        return _hash;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAttributionTag != null) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mOpCode);
        if (this.mAttributionTag != null) {
            dest.writeString(this.mAttributionTag);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    SyncNotedAppOp(Parcel in) {
        byte flg = in.readByte();
        int opCode = in.readInt();
        String attributionTag = (flg & 2) == 0 ? null : in.readString();
        this.mOpCode = opCode;
        AnnotationValidations.validate(IntRange.class, null, this.mOpCode, "from", 0L, "to", 99L);
        this.mAttributionTag = attributionTag;
    }

    @Deprecated
    private void __metadata() {
    }
}

