/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.IntRange;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.Application;
import android.app.AsyncNotedAppOp;
import android.app.PendingIntent;
import android.app.RuntimeAppOpAccessMessage;
import android.app.SyncNotedAppOp;
import android.compat.Compatibility;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.database.DatabaseUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import android.util.Pools;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.Immutable;
import com.android.internal.app.IAppOpsActiveCallback;
import com.android.internal.app.IAppOpsAsyncNotedCallback;
import com.android.internal.app.IAppOpsCallback;
import com.android.internal.app.IAppOpsNotedCallback;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IAppOpsStartedCallback;
import com.android.internal.app.MessageSamplingConfig;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.ZygoteInit;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Parcelling;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AppOpsManager {
    public static final long CALL_BACK_ON_CHANGED_LISTENER_WITH_SWITCHED_OP_CHANGE = 148180766L;
    private static final int MAX_UNFORWARDED_OPS = 10;
    final Context mContext;
    @UnsupportedAppUsage
    final IAppOpsService mService;
    @GuardedBy(value={"sLock"})
    static IAppOpsService sService;
    @GuardedBy(value={"mModeWatchers"})
    private final ArrayMap<OnOpChangedListener, IAppOpsCallback> mModeWatchers = new ArrayMap();
    @GuardedBy(value={"mActiveWatchers"})
    private final ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> mActiveWatchers = new ArrayMap();
    @GuardedBy(value={"mStartedWatchers"})
    private final ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> mStartedWatchers = new ArrayMap();
    @GuardedBy(value={"mNotedWatchers"})
    private final ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> mNotedWatchers = new ArrayMap();
    private static final Object sLock;
    @GuardedBy(value={"sLock"})
    private static OnOpNotedCallback sOnOpNotedCallback;
    @GuardedBy(value={"sLock"})
    private static ArrayList<AsyncNotedAppOp> sUnforwardedOps;
    private static OnOpNotedCallback sMessageCollector;
    static IBinder sClientId;
    public static final String KEY_TOP_STATE_SETTLE_TIME = "top_state_settle_time";
    public static final String KEY_FG_SERVICE_STATE_SETTLE_TIME = "fg_service_state_settle_time";
    public static final String KEY_BG_STATE_SETTLE_TIME = "bg_state_settle_time";
    public static final int HISTORICAL_MODE_DISABLED = 0;
    public static final int HISTORICAL_MODE_ENABLED_ACTIVE = 1;
    public static final int HISTORICAL_MODE_ENABLED_PASSIVE = 2;
    public static final int MODE_ALLOWED = 0;
    public static final int MODE_IGNORED = 1;
    public static final int MODE_ERRORED = 2;
    public static final int MODE_DEFAULT = 3;
    public static final int MODE_FOREGROUND = 4;
    public static final int WATCH_FOREGROUND_CHANGES = 1;
    public static final int CALL_BACK_ON_SWITCHED_OP = 2;
    public static final boolean NOTE_OP_COLLECTION_ENABLED = false;
    public static final String[] MODE_NAMES;
    @SystemApi
    public static final int UID_STATE_PERSISTENT = 100;
    @SystemApi
    public static final int UID_STATE_TOP = 200;
    @SystemApi
    @Deprecated
    public static final int UID_STATE_FOREGROUND_SERVICE_LOCATION = 300;
    @SystemApi
    public static final int UID_STATE_FOREGROUND_SERVICE = 400;
    @SystemApi
    public static final int UID_STATE_FOREGROUND = 500;
    public static final int UID_STATE_MAX_LAST_NON_RESTRICTED = 500;
    @SystemApi
    public static final int UID_STATE_BACKGROUND = 600;
    @SystemApi
    public static final int UID_STATE_CACHED = 700;
    public static final int MAX_PRIORITY_UID_STATE = 100;
    public static final int MIN_PRIORITY_UID_STATE = 700;
    public static final int[] UID_STATES;
    @SystemApi
    public static final int OP_FLAG_SELF = 1;
    @SystemApi
    public static final int OP_FLAG_TRUSTED_PROXY = 2;
    @SystemApi
    public static final int OP_FLAG_UNTRUSTED_PROXY = 4;
    @SystemApi
    public static final int OP_FLAG_TRUSTED_PROXIED = 8;
    @SystemApi
    public static final int OP_FLAG_UNTRUSTED_PROXIED = 16;
    @SystemApi
    public static final int OP_FLAGS_ALL = 31;
    @SystemApi
    public static final int OP_FLAGS_ALL_TRUSTED = 13;
    public static final int SAMPLING_STRATEGY_DEFAULT = 0;
    public static final int SAMPLING_STRATEGY_UNIFORM = 1;
    public static final int SAMPLING_STRATEGY_RARELY_USED = 2;
    public static final int SAMPLING_STRATEGY_BOOT_TIME_SAMPLING = 3;
    private static final int UID_STATE_OFFSET = 31;
    private static final int FLAGS_MASK = -1;
    @UnsupportedAppUsage
    public static final int OP_NONE = -1;
    @UnsupportedAppUsage
    public static final int OP_COARSE_LOCATION = 0;
    @UnsupportedAppUsage
    public static final int OP_FINE_LOCATION = 1;
    @UnsupportedAppUsage
    public static final int OP_GPS = 2;
    @UnsupportedAppUsage
    public static final int OP_VIBRATE = 3;
    @UnsupportedAppUsage
    public static final int OP_READ_CONTACTS = 4;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CONTACTS = 5;
    @UnsupportedAppUsage
    public static final int OP_READ_CALL_LOG = 6;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CALL_LOG = 7;
    @UnsupportedAppUsage
    public static final int OP_READ_CALENDAR = 8;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CALENDAR = 9;
    @UnsupportedAppUsage
    public static final int OP_WIFI_SCAN = 10;
    @UnsupportedAppUsage
    public static final int OP_POST_NOTIFICATION = 11;
    @UnsupportedAppUsage
    public static final int OP_NEIGHBORING_CELLS = 12;
    @UnsupportedAppUsage
    public static final int OP_CALL_PHONE = 13;
    @UnsupportedAppUsage
    public static final int OP_READ_SMS = 14;
    @UnsupportedAppUsage
    public static final int OP_WRITE_SMS = 15;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_SMS = 16;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_EMERGECY_SMS = 17;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_MMS = 18;
    @UnsupportedAppUsage
    public static final int OP_RECEIVE_WAP_PUSH = 19;
    @UnsupportedAppUsage
    public static final int OP_SEND_SMS = 20;
    @UnsupportedAppUsage
    public static final int OP_READ_ICC_SMS = 21;
    @UnsupportedAppUsage
    public static final int OP_WRITE_ICC_SMS = 22;
    @UnsupportedAppUsage
    public static final int OP_WRITE_SETTINGS = 23;
    @UnsupportedAppUsage
    public static final int OP_SYSTEM_ALERT_WINDOW = 24;
    @UnsupportedAppUsage
    public static final int OP_ACCESS_NOTIFICATIONS = 25;
    @UnsupportedAppUsage
    public static final int OP_CAMERA = 26;
    @UnsupportedAppUsage
    public static final int OP_RECORD_AUDIO = 27;
    @UnsupportedAppUsage
    public static final int OP_PLAY_AUDIO = 28;
    @UnsupportedAppUsage
    public static final int OP_READ_CLIPBOARD = 29;
    @UnsupportedAppUsage
    public static final int OP_WRITE_CLIPBOARD = 30;
    @UnsupportedAppUsage
    public static final int OP_TAKE_MEDIA_BUTTONS = 31;
    @UnsupportedAppUsage
    public static final int OP_TAKE_AUDIO_FOCUS = 32;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_MASTER_VOLUME = 33;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_VOICE_VOLUME = 34;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_RING_VOLUME = 35;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_MEDIA_VOLUME = 36;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_ALARM_VOLUME = 37;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_NOTIFICATION_VOLUME = 38;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_BLUETOOTH_VOLUME = 39;
    @UnsupportedAppUsage
    public static final int OP_WAKE_LOCK = 40;
    @UnsupportedAppUsage
    public static final int OP_MONITOR_LOCATION = 41;
    @UnsupportedAppUsage
    public static final int OP_MONITOR_HIGH_POWER_LOCATION = 42;
    @UnsupportedAppUsage
    public static final int OP_GET_USAGE_STATS = 43;
    @UnsupportedAppUsage
    public static final int OP_MUTE_MICROPHONE = 44;
    @UnsupportedAppUsage
    public static final int OP_TOAST_WINDOW = 45;
    @UnsupportedAppUsage
    public static final int OP_PROJECT_MEDIA = 46;
    @UnsupportedAppUsage
    public static final int OP_ACTIVATE_VPN = 47;
    @UnsupportedAppUsage
    public static final int OP_WRITE_WALLPAPER = 48;
    @UnsupportedAppUsage
    public static final int OP_ASSIST_STRUCTURE = 49;
    @UnsupportedAppUsage
    public static final int OP_ASSIST_SCREENSHOT = 50;
    @UnsupportedAppUsage
    public static final int OP_READ_PHONE_STATE = 51;
    @UnsupportedAppUsage
    public static final int OP_ADD_VOICEMAIL = 52;
    @UnsupportedAppUsage
    public static final int OP_USE_SIP = 53;
    @UnsupportedAppUsage
    public static final int OP_PROCESS_OUTGOING_CALLS = 54;
    @UnsupportedAppUsage
    public static final int OP_USE_FINGERPRINT = 55;
    @UnsupportedAppUsage
    public static final int OP_BODY_SENSORS = 56;
    @UnsupportedAppUsage
    public static final int OP_READ_CELL_BROADCASTS = 57;
    @UnsupportedAppUsage
    public static final int OP_MOCK_LOCATION = 58;
    @UnsupportedAppUsage
    public static final int OP_READ_EXTERNAL_STORAGE = 59;
    @UnsupportedAppUsage
    public static final int OP_WRITE_EXTERNAL_STORAGE = 60;
    @UnsupportedAppUsage
    public static final int OP_TURN_SCREEN_ON = 61;
    @UnsupportedAppUsage
    public static final int OP_GET_ACCOUNTS = 62;
    @UnsupportedAppUsage
    public static final int OP_RUN_IN_BACKGROUND = 63;
    @UnsupportedAppUsage
    public static final int OP_AUDIO_ACCESSIBILITY_VOLUME = 64;
    @UnsupportedAppUsage
    public static final int OP_READ_PHONE_NUMBERS = 65;
    @UnsupportedAppUsage
    public static final int OP_REQUEST_INSTALL_PACKAGES = 66;
    @UnsupportedAppUsage
    public static final int OP_PICTURE_IN_PICTURE = 67;
    @UnsupportedAppUsage
    public static final int OP_INSTANT_APP_START_FOREGROUND = 68;
    @UnsupportedAppUsage
    public static final int OP_ANSWER_PHONE_CALLS = 69;
    @UnsupportedAppUsage
    public static final int OP_RUN_ANY_IN_BACKGROUND = 70;
    @UnsupportedAppUsage
    public static final int OP_CHANGE_WIFI_STATE = 71;
    @UnsupportedAppUsage
    public static final int OP_REQUEST_DELETE_PACKAGES = 72;
    @UnsupportedAppUsage
    public static final int OP_BIND_ACCESSIBILITY_SERVICE = 73;
    @UnsupportedAppUsage
    public static final int OP_ACCEPT_HANDOVER = 74;
    @UnsupportedAppUsage
    public static final int OP_MANAGE_IPSEC_TUNNELS = 75;
    @UnsupportedAppUsage
    public static final int OP_START_FOREGROUND = 76;
    @UnsupportedAppUsage
    public static final int OP_BLUETOOTH_SCAN = 77;
    public static final int OP_USE_BIOMETRIC = 78;
    public static final int OP_ACTIVITY_RECOGNITION = 79;
    public static final int OP_SMS_FINANCIAL_TRANSACTIONS = 80;
    public static final int OP_READ_MEDIA_AUDIO = 81;
    public static final int OP_WRITE_MEDIA_AUDIO = 82;
    public static final int OP_READ_MEDIA_VIDEO = 83;
    public static final int OP_WRITE_MEDIA_VIDEO = 84;
    public static final int OP_READ_MEDIA_IMAGES = 85;
    public static final int OP_WRITE_MEDIA_IMAGES = 86;
    public static final int OP_LEGACY_STORAGE = 87;
    public static final int OP_ACCESS_ACCESSIBILITY = 88;
    public static final int OP_READ_DEVICE_IDENTIFIERS = 89;
    public static final int OP_ACCESS_MEDIA_LOCATION = 90;
    public static final int OP_QUERY_ALL_PACKAGES = 91;
    public static final int OP_MANAGE_EXTERNAL_STORAGE = 92;
    public static final int OP_INTERACT_ACROSS_PROFILES = 93;
    public static final int OP_ACTIVATE_PLATFORM_VPN = 94;
    public static final int OP_LOADER_USAGE_STATS = 95;
    private static final int OP_DEPRECATED_1 = 96;
    public static final int OP_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = 97;
    public static final int OP_AUTO_REVOKE_MANAGED_BY_INSTALLER = 98;
    public static final int OP_NO_ISOLATED_STORAGE = 99;
    @UnsupportedAppUsage
    public static final int _NUM_OP = 100;
    public static final String OPSTR_COARSE_LOCATION = "android:coarse_location";
    public static final String OPSTR_FINE_LOCATION = "android:fine_location";
    public static final String OPSTR_MONITOR_LOCATION = "android:monitor_location";
    public static final String OPSTR_MONITOR_HIGH_POWER_LOCATION = "android:monitor_location_high_power";
    public static final String OPSTR_GET_USAGE_STATS = "android:get_usage_stats";
    @SystemApi
    public static final String OPSTR_ACTIVATE_VPN = "android:activate_vpn";
    public static final String OPSTR_READ_CONTACTS = "android:read_contacts";
    public static final String OPSTR_WRITE_CONTACTS = "android:write_contacts";
    public static final String OPSTR_READ_CALL_LOG = "android:read_call_log";
    public static final String OPSTR_WRITE_CALL_LOG = "android:write_call_log";
    public static final String OPSTR_READ_CALENDAR = "android:read_calendar";
    public static final String OPSTR_WRITE_CALENDAR = "android:write_calendar";
    public static final String OPSTR_CALL_PHONE = "android:call_phone";
    public static final String OPSTR_READ_SMS = "android:read_sms";
    public static final String OPSTR_RECEIVE_SMS = "android:receive_sms";
    public static final String OPSTR_RECEIVE_MMS = "android:receive_mms";
    public static final String OPSTR_RECEIVE_WAP_PUSH = "android:receive_wap_push";
    public static final String OPSTR_SEND_SMS = "android:send_sms";
    public static final String OPSTR_CAMERA = "android:camera";
    public static final String OPSTR_RECORD_AUDIO = "android:record_audio";
    public static final String OPSTR_READ_PHONE_STATE = "android:read_phone_state";
    public static final String OPSTR_ADD_VOICEMAIL = "android:add_voicemail";
    public static final String OPSTR_USE_SIP = "android:use_sip";
    public static final String OPSTR_PROCESS_OUTGOING_CALLS = "android:process_outgoing_calls";
    public static final String OPSTR_USE_FINGERPRINT = "android:use_fingerprint";
    public static final String OPSTR_BODY_SENSORS = "android:body_sensors";
    public static final String OPSTR_READ_CELL_BROADCASTS = "android:read_cell_broadcasts";
    public static final String OPSTR_MOCK_LOCATION = "android:mock_location";
    public static final String OPSTR_READ_EXTERNAL_STORAGE = "android:read_external_storage";
    public static final String OPSTR_WRITE_EXTERNAL_STORAGE = "android:write_external_storage";
    public static final String OPSTR_SYSTEM_ALERT_WINDOW = "android:system_alert_window";
    public static final String OPSTR_WRITE_SETTINGS = "android:write_settings";
    @SystemApi
    public static final String OPSTR_GET_ACCOUNTS = "android:get_accounts";
    public static final String OPSTR_READ_PHONE_NUMBERS = "android:read_phone_numbers";
    public static final String OPSTR_PICTURE_IN_PICTURE = "android:picture_in_picture";
    @SystemApi
    public static final String OPSTR_INSTANT_APP_START_FOREGROUND = "android:instant_app_start_foreground";
    public static final String OPSTR_ANSWER_PHONE_CALLS = "android:answer_phone_calls";
    @SystemApi
    public static final String OPSTR_ACCEPT_HANDOVER = "android:accept_handover";
    @SystemApi
    public static final String OPSTR_GPS = "android:gps";
    @SystemApi
    public static final String OPSTR_VIBRATE = "android:vibrate";
    @SystemApi
    public static final String OPSTR_WIFI_SCAN = "android:wifi_scan";
    @SystemApi
    public static final String OPSTR_POST_NOTIFICATION = "android:post_notification";
    @SystemApi
    public static final String OPSTR_NEIGHBORING_CELLS = "android:neighboring_cells";
    @SystemApi
    public static final String OPSTR_WRITE_SMS = "android:write_sms";
    @SystemApi
    public static final String OPSTR_RECEIVE_EMERGENCY_BROADCAST = "android:receive_emergency_broadcast";
    @SystemApi
    public static final String OPSTR_READ_ICC_SMS = "android:read_icc_sms";
    @SystemApi
    public static final String OPSTR_WRITE_ICC_SMS = "android:write_icc_sms";
    @SystemApi
    public static final String OPSTR_ACCESS_NOTIFICATIONS = "android:access_notifications";
    @SystemApi
    public static final String OPSTR_PLAY_AUDIO = "android:play_audio";
    @SystemApi
    public static final String OPSTR_READ_CLIPBOARD = "android:read_clipboard";
    @SystemApi
    public static final String OPSTR_WRITE_CLIPBOARD = "android:write_clipboard";
    @SystemApi
    public static final String OPSTR_TAKE_MEDIA_BUTTONS = "android:take_media_buttons";
    @SystemApi
    public static final String OPSTR_TAKE_AUDIO_FOCUS = "android:take_audio_focus";
    @SystemApi
    public static final String OPSTR_AUDIO_MASTER_VOLUME = "android:audio_master_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_VOICE_VOLUME = "android:audio_voice_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_RING_VOLUME = "android:audio_ring_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_MEDIA_VOLUME = "android:audio_media_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_ALARM_VOLUME = "android:audio_alarm_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_NOTIFICATION_VOLUME = "android:audio_notification_volume";
    @SystemApi
    public static final String OPSTR_AUDIO_BLUETOOTH_VOLUME = "android:audio_bluetooth_volume";
    @SystemApi
    public static final String OPSTR_WAKE_LOCK = "android:wake_lock";
    @SystemApi
    public static final String OPSTR_MUTE_MICROPHONE = "android:mute_microphone";
    @SystemApi
    public static final String OPSTR_TOAST_WINDOW = "android:toast_window";
    @SystemApi
    public static final String OPSTR_PROJECT_MEDIA = "android:project_media";
    @SystemApi
    public static final String OPSTR_WRITE_WALLPAPER = "android:write_wallpaper";
    @SystemApi
    public static final String OPSTR_ASSIST_STRUCTURE = "android:assist_structure";
    @SystemApi
    public static final String OPSTR_ASSIST_SCREENSHOT = "android:assist_screenshot";
    @SystemApi
    public static final String OPSTR_TURN_SCREEN_ON = "android:turn_screen_on";
    @SystemApi
    public static final String OPSTR_RUN_IN_BACKGROUND = "android:run_in_background";
    @SystemApi
    public static final String OPSTR_AUDIO_ACCESSIBILITY_VOLUME = "android:audio_accessibility_volume";
    @SystemApi
    public static final String OPSTR_REQUEST_INSTALL_PACKAGES = "android:request_install_packages";
    @SystemApi
    public static final String OPSTR_RUN_ANY_IN_BACKGROUND = "android:run_any_in_background";
    @SystemApi
    public static final String OPSTR_CHANGE_WIFI_STATE = "android:change_wifi_state";
    @SystemApi
    public static final String OPSTR_REQUEST_DELETE_PACKAGES = "android:request_delete_packages";
    @SystemApi
    public static final String OPSTR_BIND_ACCESSIBILITY_SERVICE = "android:bind_accessibility_service";
    @SystemApi
    public static final String OPSTR_MANAGE_IPSEC_TUNNELS = "android:manage_ipsec_tunnels";
    @SystemApi
    public static final String OPSTR_START_FOREGROUND = "android:start_foreground";
    public static final String OPSTR_BLUETOOTH_SCAN = "android:bluetooth_scan";
    public static final String OPSTR_USE_BIOMETRIC = "android:use_biometric";
    public static final String OPSTR_ACTIVITY_RECOGNITION = "android:activity_recognition";
    public static final String OPSTR_SMS_FINANCIAL_TRANSACTIONS = "android:sms_financial_transactions";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_AUDIO = "android:read_media_audio";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_AUDIO = "android:write_media_audio";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_VIDEO = "android:read_media_video";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_VIDEO = "android:write_media_video";
    @SystemApi
    public static final String OPSTR_READ_MEDIA_IMAGES = "android:read_media_images";
    @SystemApi
    public static final String OPSTR_WRITE_MEDIA_IMAGES = "android:write_media_images";
    @SystemApi
    public static final String OPSTR_LEGACY_STORAGE = "android:legacy_storage";
    public static final String OPSTR_ACCESS_MEDIA_LOCATION = "android:access_media_location";
    @SystemApi
    public static final String OPSTR_ACCESS_ACCESSIBILITY = "android:access_accessibility";
    public static final String OPSTR_READ_DEVICE_IDENTIFIERS = "android:read_device_identifiers";
    public static final String OPSTR_QUERY_ALL_PACKAGES = "android:query_all_packages";
    @SystemApi
    public static final String OPSTR_MANAGE_EXTERNAL_STORAGE = "android:manage_external_storage";
    @SystemApi
    public static final String OPSTR_AUTO_REVOKE_PERMISSIONS_IF_UNUSED = "android:auto_revoke_permissions_if_unused";
    @SystemApi
    public static final String OPSTR_AUTO_REVOKE_MANAGED_BY_INSTALLER = "android:auto_revoke_managed_by_installer";
    @SystemApi
    public static final String OPSTR_INTERACT_ACROSS_PROFILES = "android:interact_across_profiles";
    public static final String OPSTR_ACTIVATE_PLATFORM_VPN = "android:activate_platform_vpn";
    @SystemApi
    public static final String OPSTR_LOADER_USAGE_STATS = "android:loader_usage_stats";
    public static final String OPSTR_NO_ISOLATED_STORAGE = "android:no_isolated_storage";
    private static final byte SHOULD_COLLECT_NOTE_OP_NOT_INITIALIZED = 0;
    private static final byte SHOULD_NOT_COLLECT_NOTE_OP = 1;
    private static final byte SHOULD_COLLECT_NOTE_OP = 2;
    private static final int[] RUNTIME_AND_APPOP_PERMISSIONS_OPS;
    private static int[] sOpToSwitch;
    private static String[] sOpToString;
    private static String[] sOpNames;
    @UnsupportedAppUsage
    private static String[] sOpPerms;
    private static String[] sOpRestrictions;
    private static RestrictionBypass[] sOpAllowSystemRestrictionBypass;
    private static int[] sOpDefaultMode;
    private static boolean[] sOpDisableReset;
    private static HashMap<String, Integer> sOpStrToOp;
    private static HashMap<String, Integer> sPermToOp;
    private static final ThreadLocal<Integer> sBinderThreadCallingUid;
    private static final ThreadLocal<ArrayMap<String, long[]>> sAppOpsNotedInThisBinderTransaction;
    private static final byte[] sAppOpsToNote;
    private static MessageSamplingConfig sConfig;
    public static final String KEY_HISTORICAL_OPS = "historical_ops";
    private static final String DEBUG_LOGGING_ENABLE_PROP = "appops.logging_enabled";
    private static final String DEBUG_LOGGING_PACKAGES_PROP = "appops.logging_packages";
    private static final String DEBUG_LOGGING_OPS_PROP = "appops.logging_ops";
    private static final String DEBUG_LOGGING_TAG = "AppOpsManager";
    public static final int FILTER_BY_UID = 1;
    public static final int FILTER_BY_PACKAGE_NAME = 2;
    public static final int FILTER_BY_ATTRIBUTION_TAG = 4;
    public static final int FILTER_BY_OP_NAMES = 8;
    private static final int DONT_COLLECT = 0;
    private static final int COLLECT_SELF = 1;
    private static final int COLLECT_SYNC = 2;
    private static final int COLLECT_ASYNC = 3;

    public static int resolveFirstUnrestrictedUidState(int op) {
        return 500;
    }

    public static int resolveLastRestrictedUidState(int op) {
        return 600;
    }

    public static String getUidStateName(int uidState) {
        switch (uidState) {
            case 100: {
                return "pers";
            }
            case 200: {
                return "top";
            }
            case 300: {
                return "fgsvcl";
            }
            case 400: {
                return "fgsvc";
            }
            case 500: {
                return "fg";
            }
            case 600: {
                return "bg";
            }
            case 700: {
                return "cch";
            }
        }
        return "unknown";
    }

    public static String getFlagName(int flag) {
        switch (flag) {
            case 1: {
                return "s";
            }
            case 2: {
                return "tp";
            }
            case 4: {
                return "up";
            }
            case 8: {
                return "tpd";
            }
            case 16: {
                return "upd";
            }
        }
        return "unknown";
    }

    public static String keyToString(long key) {
        int uidState = AppOpsManager.extractUidStateFromKey(key);
        int flags = AppOpsManager.extractFlagsFromKey(key);
        return "[" + AppOpsManager.getUidStateName(uidState) + "-" + AppOpsManager.flagsToString(flags) + "]";
    }

    public static long makeKey(int uidState, int flags) {
        return (long)uidState << 31 | (long)flags;
    }

    public static int extractUidStateFromKey(long key) {
        return (int)(key >> 31);
    }

    public static int extractFlagsFromKey(long key) {
        return (int)(key & 0xFFFFFFFFFFFFFFFFL);
    }

    public static String flagsToString(int flags) {
        StringBuilder flagsBuilder = new StringBuilder();
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            if (flagsBuilder.length() > 0) {
                flagsBuilder.append('|');
            }
            flagsBuilder.append(AppOpsManager.getFlagName(flag));
        }
        return flagsBuilder.toString();
    }

    @UnsupportedAppUsage
    public static int opToSwitch(int op) {
        return sOpToSwitch[op];
    }

    @UnsupportedAppUsage
    public static String opToName(int op) {
        if (op == -1) {
            return "NONE";
        }
        return op < sOpNames.length ? sOpNames[op] : "Unknown(" + op + ")";
    }

    public static String opToPublicName(int op) {
        return sOpToString[op];
    }

    public static int strDebugOpToOp(String op) {
        for (int i = 0; i < sOpNames.length; ++i) {
            if (!sOpNames[i].equals(op)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown operation string: " + op);
    }

    @UnsupportedAppUsage
    public static String opToPermission(int op) {
        return sOpPerms[op];
    }

    @SystemApi
    public static String opToPermission(String op) {
        return AppOpsManager.opToPermission(AppOpsManager.strOpToOp(op));
    }

    public static String opToRestriction(int op) {
        return sOpRestrictions[op];
    }

    @UnsupportedAppUsage
    public static int permissionToOpCode(String permission2) {
        Integer boxedOpCode = sPermToOp.get(permission2);
        return boxedOpCode != null ? boxedOpCode : -1;
    }

    public static RestrictionBypass opAllowSystemBypassRestriction(int op) {
        return sOpAllowSystemRestrictionBypass[op];
    }

    public static int opToDefaultMode(int op) {
        return sOpDefaultMode[op];
    }

    @SystemApi
    public static int opToDefaultMode(String appOp) {
        return AppOpsManager.opToDefaultMode(AppOpsManager.strOpToOp(appOp));
    }

    public static String modeToName(int mode) {
        if (mode >= 0 && mode < MODE_NAMES.length) {
            return MODE_NAMES[mode];
        }
        return "mode=" + mode;
    }

    public static boolean opAllowsReset(int op) {
        return !sOpDisableReset[op];
    }

    public static String toReceiverId(Object obj) {
        if (obj instanceof PendingIntent) {
            return AppOpsManager.toReceiverId((PendingIntent)obj);
        }
        return obj.getClass().getName() + "@" + System.identityHashCode(obj);
    }

    public static String toReceiverId(PendingIntent pendingIntent) {
        return pendingIntent.getTag("");
    }

    private static long sumForFlagsInStates(LongSparseLongArray counts, int beginUidState, int endUidState, int flags) {
        if (counts == null) {
            return 0L;
        }
        long sum = 0L;
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            for (int uidState : UID_STATES) {
                if (uidState < beginUidState || uidState > endUidState) continue;
                long key = AppOpsManager.makeKey(uidState, flag);
                sum += counts.get(key);
            }
        }
        return sum;
    }

    AppOpsManager(Context context, IAppOpsService service) {
        this.mContext = context;
        this.mService = service;
    }

    @SystemApi
    public List<PackageOps> getPackagesForOps(String[] ops) {
        int opCount = ops.length;
        int[] opCodes = new int[opCount];
        for (int i = 0; i < opCount; ++i) {
            opCodes[i] = sOpStrToOp.get(ops[i]);
        }
        List<PackageOps> result = this.getPackagesForOps(opCodes);
        return result != null ? result : Collections.emptyList();
    }

    @UnsupportedAppUsage
    public List<PackageOps> getPackagesForOps(int[] ops) {
        try {
            return this.mService.getPackagesForOps(ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public List<PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        try {
            return this.mService.getOpsForPackage(uid, packageName, ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public List<PackageOps> getOpsForPackage(int uid, String packageName, String ... ops) {
        int[] opCodes = null;
        if (ops != null) {
            opCodes = new int[ops.length];
            for (int i = 0; i < ops.length; ++i) {
                opCodes[i] = AppOpsManager.strOpToOp(ops[i]);
            }
        }
        try {
            List<PackageOps> result = this.mService.getOpsForPackage(uid, packageName, opCodes);
            if (result == null) {
                return Collections.emptyList();
            }
            return result;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void getHistoricalOps(HistoricalOpsRequest request, Executor executor, Consumer<HistoricalOps> callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.getHistoricalOps(request.mUid, request.mPackageName, request.mAttributionTag, request.mOpNames, request.mFilter, request.mBeginTimeMillis, request.mEndTimeMillis, request.mFlags, new RemoteCallback(result -> {
                HistoricalOps ops = (HistoricalOps)result.getParcelable(KEY_HISTORICAL_OPS);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.accept(ops));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void getHistoricalOpsFromDiskRaw(HistoricalOpsRequest request, Executor executor, Consumer<HistoricalOps> callback) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(callback, "callback cannot be null");
        try {
            this.mService.getHistoricalOpsFromDiskRaw(request.mUid, request.mPackageName, request.mAttributionTag, request.mOpNames, request.mFilter, request.mBeginTimeMillis, request.mEndTimeMillis, request.mFlags, new RemoteCallback(result -> {
                HistoricalOps ops = (HistoricalOps)result.getParcelable(KEY_HISTORICAL_OPS);
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> callback.accept(ops));
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void reloadNonHistoricalState() {
        try {
            this.mService.reloadNonHistoricalState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setUidMode(int code, int uid, int mode) {
        try {
            this.mService.setUidMode(code, uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setUidMode(String appOp, int uid, int mode) {
        try {
            this.mService.setUidMode(AppOpsManager.strOpToOp(appOp), uid, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setUserRestriction(int code, boolean restricted, IBinder token) {
        this.setUserRestriction(code, restricted, token, null);
    }

    public void setUserRestriction(int code, boolean restricted, IBinder token, String[] exceptionPackages) {
        this.setUserRestrictionForUser(code, restricted, token, exceptionPackages, this.mContext.getUserId());
    }

    public void setUserRestrictionForUser(int code, boolean restricted, IBinder token, String[] exceptionPackages, int userId) {
        try {
            this.mService.setUserRestriction(code, restricted, token, userId, exceptionPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setMode(int code, int uid, String packageName, int mode) {
        try {
            this.mService.setMode(code, uid, packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setMode(String op, int uid, String packageName, int mode) {
        try {
            this.mService.setMode(AppOpsManager.strOpToOp(op), uid, packageName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void setRestriction(int code, int usage, int mode, String[] exceptionPackages) {
        try {
            int uid = Binder.getCallingUid();
            this.mService.setAudioRestriction(code, usage, uid, mode, exceptionPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public void resetAllModes() {
        try {
            this.mService.resetAllModes(this.mContext.getUserId(), null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static String permissionToOp(String permission2) {
        Integer opCode = sPermToOp.get(permission2);
        if (opCode == null) {
            return null;
        }
        return sOpToString[opCode];
    }

    public void startWatchingMode(String op, String packageName, OnOpChangedListener callback) {
        this.startWatchingMode(AppOpsManager.strOpToOp(op), packageName, callback);
    }

    public void startWatchingMode(String op, String packageName, int flags, OnOpChangedListener callback) {
        this.startWatchingMode(AppOpsManager.strOpToOp(op), packageName, flags, callback);
    }

    public void startWatchingMode(int op, String packageName, OnOpChangedListener callback) {
        this.startWatchingMode(op, packageName, 0, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingMode(int op, String packageName, int flags, final OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.get(callback);
            if (cb == null) {
                cb = new IAppOpsCallback.Stub(){

                    @Override
                    public void opChanged(int op, int uid, String packageName) {
                        if (callback instanceof OnOpChangedInternalListener) {
                            ((OnOpChangedInternalListener)callback).onOpChanged(op, packageName);
                        }
                        if (sOpToString[op] != null) {
                            callback.onOpChanged(sOpToString[op], packageName);
                        }
                    }
                };
                this.mModeWatchers.put(callback, cb);
            }
            if (!Compatibility.isChangeEnabled(148180766L)) {
                flags |= 2;
            }
            try {
                this.mService.startWatchingModeWithFlags(op, packageName, flags, cb);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingMode(OnOpChangedListener callback) {
        ArrayMap<OnOpChangedListener, IAppOpsCallback> arrayMap = this.mModeWatchers;
        synchronized (arrayMap) {
            IAppOpsCallback cb = this.mModeWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingMode(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    @Deprecated
    public void startWatchingActive(int[] ops, OnOpActiveChangedListener callback) {
        String[] strOps = new String[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            strOps[i] = AppOpsManager.opToPublicName(ops[i]);
        }
        this.startWatchingActive(strOps, this.mContext.getMainExecutor(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingActive(String[] ops, final Executor executor, final OnOpActiveChangedListener callback) {
        IAppOpsActiveCallback cb;
        Objects.requireNonNull(ops);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> arrayMap = this.mActiveWatchers;
        synchronized (arrayMap) {
            cb = this.mActiveWatchers.get(callback);
            if (cb != null) {
                return;
            }
            cb = new IAppOpsActiveCallback.Stub(){

                @Override
                public void opActiveChanged(int op, int uid, String packageName, boolean active) {
                    executor.execute(() -> {
                        if (callback instanceof OnOpActiveChangedInternalListener) {
                            ((OnOpActiveChangedInternalListener)callback).onOpActiveChanged(op, uid, packageName, active);
                        }
                        if (sOpToString[op] != null) {
                            callback.onOpActiveChanged(sOpToString[op], uid, packageName, active);
                        }
                    });
                }
            };
            this.mActiveWatchers.put(callback, cb);
        }
        int[] rawOps = new int[ops.length];
        for (int i = 0; i < ops.length; ++i) {
            rawOps[i] = AppOpsManager.strOpToOp(ops[i]);
        }
        try {
            this.mService.startWatchingActive(rawOps, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingActive(OnOpActiveChangedListener callback) {
        ArrayMap<OnOpActiveChangedListener, IAppOpsActiveCallback> arrayMap = this.mActiveWatchers;
        synchronized (arrayMap) {
            IAppOpsActiveCallback cb = this.mActiveWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingActive(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingStarted(int[] ops, final OnOpStartedListener callback) {
        IAppOpsStartedCallback.Stub cb;
        ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> arrayMap = this.mStartedWatchers;
        synchronized (arrayMap) {
            if (this.mStartedWatchers.containsKey(callback)) {
                return;
            }
            cb = new IAppOpsStartedCallback.Stub(){

                @Override
                public void opStarted(int op, int uid, String packageName, int mode) {
                    callback.onOpStarted(op, uid, packageName, mode);
                }
            };
            this.mStartedWatchers.put(callback, cb);
        }
        try {
            this.mService.startWatchingStarted(ops, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingStarted(OnOpStartedListener callback) {
        ArrayMap<OnOpStartedListener, IAppOpsStartedCallback> arrayMap = this.mStartedWatchers;
        synchronized (arrayMap) {
            IAppOpsStartedCallback cb = this.mStartedWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingStarted(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWatchingNoted(int[] ops, final OnOpNotedListener callback) {
        IAppOpsNotedCallback cb;
        ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> arrayMap = this.mNotedWatchers;
        synchronized (arrayMap) {
            cb = this.mNotedWatchers.get(callback);
            if (cb != null) {
                return;
            }
            cb = new IAppOpsNotedCallback.Stub(){

                @Override
                public void opNoted(int op, int uid, String packageName, int mode) {
                    callback.onOpNoted(op, uid, packageName, mode);
                }
            };
            this.mNotedWatchers.put(callback, cb);
        }
        try {
            this.mService.startWatchingNoted(ops, cb);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchingNoted(OnOpNotedListener callback) {
        ArrayMap<OnOpNotedListener, IAppOpsNotedCallback> arrayMap = this.mNotedWatchers;
        synchronized (arrayMap) {
            IAppOpsNotedCallback cb = this.mNotedWatchers.remove(callback);
            if (cb != null) {
                try {
                    this.mService.stopWatchingNoted(cb);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private String buildSecurityExceptionMsg(int op, int uid, String packageName) {
        return packageName + " from uid " + uid + " not allowed to perform " + sOpNames[op];
    }

    @UnsupportedAppUsage
    public static int strOpToOp(String op) {
        Integer val = sOpStrToOp.get(op);
        if (val == null) {
            throw new IllegalArgumentException("Unknown operation string: " + op);
        }
        return val;
    }

    public int unsafeCheckOp(String op, int uid, String packageName) {
        return this.checkOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    @Deprecated
    public int checkOp(String op, int uid, String packageName) {
        return this.checkOp(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    @Deprecated
    public int checkOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpRaw(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(op, uid, packageName);
    }

    public int unsafeCheckOpRawNoThrow(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public int unsafeCheckOpRawNoThrow(int op, int uid, String packageName) {
        try {
            return this.mService.checkOperationRaw(op, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int noteOp(String op, int uid, String packageName) {
        return this.noteOp(op, uid, packageName, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOp(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOp(int op) {
        return this.noteOp(op, Process.myUid(), this.mContext.getOpPackageName(), null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOp(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOp(int op, int uid, String packageName) {
        return this.noteOp(op, uid, packageName, null, null);
    }

    public int noteOp(String op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOp(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag, message);
    }

    public int noteOp(int op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.noteOpNoThrow(op, uid, packageName, attributionTag, message);
        if (mode == 2) {
            throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
        }
        return mode;
    }

    @Deprecated
    public int noteOpNoThrow(String op, int uid, String packageName) {
        return this.noteOpNoThrow(op, uid, packageName, null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteOpNoThrow(java.lang.String, int, java.lang.String, java.lang.String, java.lang.String)} instead")
    public int noteOpNoThrow(int op, int uid, String packageName) {
        return this.noteOpNoThrow(op, uid, packageName, null, null);
    }

    public int noteOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag, message);
    }

    public int noteOpNoThrow(int op, int uid, String packageName, String attributionTag, String message) {
        try {
            int mode;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(uid, packageName, op);
            boolean bl = shouldCollectMessage = Process.myUid() == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((mode = this.mService.noteOperation(op, uid, packageName, attributionTag, collectionMode == 3, message, shouldCollectMessage)) == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(op, attributionTag);
                } else if (collectionMode == 2) {
                    this.collectNotedOpSync(op, attributionTag);
                }
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int noteProxyOp(String op, String proxiedPackageName) {
        return this.noteProxyOp(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link #noteProxyOp(java.lang.String, java.lang.String, int, java.lang.String, java.lang.String)} instead")
    public int noteProxyOp(int op, String proxiedPackageName) {
        return this.noteProxyOp(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    public int noteProxyOp(int op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        int mode = this.noteProxyOpNoThrow(op, proxiedPackageName, proxiedUid, proxiedAttributionTag, message);
        if (mode == 2) {
            throw new SecurityException("Proxy package " + this.mContext.getOpPackageName() + " from uid " + Process.myUid() + " or calling package " + proxiedPackageName + " from uid " + proxiedUid + " not allowed to perform " + sOpNames[op]);
        }
        return mode;
    }

    public int noteProxyOp(String op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        return this.noteProxyOp(AppOpsManager.strOpToOp(op), proxiedPackageName, proxiedUid, proxiedAttributionTag, message);
    }

    @Deprecated
    public int noteProxyOpNoThrow(String op, String proxiedPackageName) {
        return this.noteProxyOpNoThrow(op, proxiedPackageName, Binder.getCallingUid(), null, null);
    }

    @Deprecated
    public int noteProxyOpNoThrow(String op, String proxiedPackageName, int proxiedUid) {
        return this.noteProxyOpNoThrow(op, proxiedPackageName, proxiedUid, null, null);
    }

    public int noteProxyOpNoThrow(String op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        return this.noteProxyOpNoThrow(AppOpsManager.strOpToOp(op), proxiedPackageName, proxiedUid, proxiedAttributionTag, message);
    }

    public int noteProxyOpNoThrow(int op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        int myUid = Process.myUid();
        try {
            int mode;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(proxiedUid, proxiedPackageName, op);
            boolean bl = shouldCollectMessage = myUid == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((mode = this.mService.noteProxyOperation(op, proxiedUid, proxiedPackageName, proxiedAttributionTag, myUid, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), collectionMode == 3, message, shouldCollectMessage)) == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(op, proxiedAttributionTag);
                } else if (collectionMode == 2 && this.mContext.checkPermission("android.permission.UPDATE_APP_OPS_STATS", -1, myUid) == 0) {
                    this.collectNotedOpSync(op, proxiedAttributionTag);
                }
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public int checkOp(int op, int uid, String packageName) {
        try {
            int mode = this.mService.checkOperation(op, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public int checkOpNoThrow(int op, int uid, String packageName) {
        try {
            int mode = this.mService.checkOperation(op, uid, packageName);
            return mode == 4 ? 0 : mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void checkPackage(int uid, String packageName) {
        try {
            if (this.mService.checkPackage(uid, packageName) != 0) {
                throw new SecurityException("Package " + packageName + " does not belong to " + uid);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkAudioOp(int op, int stream, int uid, String packageName) {
        try {
            int mode = this.mService.checkAudioOperation(op, stream, uid, packageName);
            if (mode == 2) {
                throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkAudioOpNoThrow(int op, int stream, int uid, String packageName) {
        try {
            return this.mService.checkAudioOperation(op, stream, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Create own local {@link android.os.Binder}")
    public static IBinder getToken(IAppOpsService service) {
        return AppOpsManager.getClientId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBinder getClientId() {
        Class<AppOpsManager> clazz = AppOpsManager.class;
        synchronized (AppOpsManager.class) {
            if (sClientId == null) {
                sClientId = new Binder();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sClientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IAppOpsService getService() {
        Object object = sLock;
        synchronized (object) {
            if (sService == null) {
                sService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
            }
            return sService;
        }
    }

    @Deprecated
    public int startOp(String op, int uid, String packageName) {
        return this.startOp(op, uid, packageName, null, null);
    }

    @Deprecated
    public int startOp(int op) {
        return this.startOp(op, Process.myUid(), this.mContext.getOpPackageName(), false, null, null);
    }

    @Deprecated
    public int startOp(int op, int uid, String packageName) {
        return this.startOp(op, uid, packageName, false, null, null);
    }

    @Deprecated
    public int startOp(int op, int uid, String packageName, boolean startIfModeDefault) {
        return this.startOp(op, uid, packageName, startIfModeDefault, null, null);
    }

    public int startOp(String op, int uid, String packageName, String attributionTag, String message) {
        return this.startOp(AppOpsManager.strOpToOp(op), uid, packageName, false, attributionTag, message);
    }

    public int startOp(int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message) {
        int mode = this.startOpNoThrow(op, uid, packageName, startIfModeDefault, attributionTag, message);
        if (mode == 2) {
            throw new SecurityException(this.buildSecurityExceptionMsg(op, uid, packageName));
        }
        return mode;
    }

    @Deprecated
    public int startOpNoThrow(String op, int uid, String packageName) {
        return this.startOpNoThrow(op, uid, packageName, null, null);
    }

    @Deprecated
    public int startOpNoThrow(int op, int uid, String packageName) {
        return this.startOpNoThrow(op, uid, packageName, false, null, null);
    }

    @Deprecated
    public int startOpNoThrow(int op, int uid, String packageName, boolean startIfModeDefault) {
        return this.startOpNoThrow(op, uid, packageName, startIfModeDefault, null, null);
    }

    public int startOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        return this.startOpNoThrow(AppOpsManager.strOpToOp(op), uid, packageName, false, attributionTag, message);
    }

    public int startOpNoThrow(int op, int uid, String packageName, boolean startIfModeDefault, String attributionTag, String message) {
        try {
            int mode;
            boolean shouldCollectMessage;
            this.collectNoteOpCallsForValidation(op);
            int collectionMode = this.getNotedOpCollectionMode(uid, packageName, op);
            boolean bl = shouldCollectMessage = Process.myUid() == 1000;
            if (collectionMode == 3 && message == null) {
                message = AppOpsManager.getFormattedStackTrace();
                shouldCollectMessage = true;
            }
            if ((mode = this.mService.startOperation(AppOpsManager.getClientId(), op, uid, packageName, attributionTag, startIfModeDefault, collectionMode == 3, message, shouldCollectMessage)) == 0) {
                if (collectionMode == 1) {
                    this.collectNotedOpForSelf(op, attributionTag);
                } else if (collectionMode == 2) {
                    this.collectNotedOpSync(op, attributionTag);
                }
            }
            return mode;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void finishOp(int op) {
        this.finishOp(op, Process.myUid(), this.mContext.getOpPackageName(), null);
    }

    public void finishOp(String op, int uid, String packageName) {
        this.finishOp(AppOpsManager.strOpToOp(op), uid, packageName, null);
    }

    public void finishOp(String op, int uid, String packageName, String attributionTag) {
        this.finishOp(AppOpsManager.strOpToOp(op), uid, packageName, attributionTag);
    }

    public void finishOp(int op, int uid, String packageName) {
        this.finishOp(op, uid, packageName, null);
    }

    public void finishOp(int op, int uid, String packageName, String attributionTag) {
        try {
            this.mService.finishOperation(AppOpsManager.getClientId(), op, uid, packageName, attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isOpActive(String op, int uid, String packageName) {
        return this.isOperationActive(AppOpsManager.strOpToOp(op), uid, packageName);
    }

    public static void startNotedAppOpsCollection(int callingUid) {
        sBinderThreadCallingUid.set(callingUid);
    }

    public static PausedNotedAppOpsCollection pauseNotedAppOpsCollection() {
        Integer previousUid = sBinderThreadCallingUid.get();
        if (previousUid != null) {
            ArrayMap<String, long[]> previousCollectedNotedAppOps = sAppOpsNotedInThisBinderTransaction.get();
            sBinderThreadCallingUid.remove();
            sAppOpsNotedInThisBinderTransaction.remove();
            return new PausedNotedAppOpsCollection(previousUid, previousCollectedNotedAppOps);
        }
        return null;
    }

    public static void resumeNotedAppOpsCollection(PausedNotedAppOpsCollection prevCollection) {
        if (prevCollection != null) {
            sBinderThreadCallingUid.set(prevCollection.mUid);
            if (prevCollection.mCollectedNotedAppOps != null) {
                sAppOpsNotedInThisBinderTransaction.set(prevCollection.mCollectedNotedAppOps);
            }
        }
    }

    public static void finishNotedAppOpsCollection() {
        sBinderThreadCallingUid.remove();
        sAppOpsNotedInThisBinderTransaction.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectNotedOpForSelf(int op, String attributionTag) {
        Object object = sLock;
        synchronized (object) {
            if (sOnOpNotedCallback != null) {
                sOnOpNotedCallback.onSelfNoted(new SyncNotedAppOp(op, attributionTag));
            }
        }
        sMessageCollector.onSelfNoted(new SyncNotedAppOp(op, attributionTag));
    }

    private void collectNotedOpSync(int op, String attributionTag) {
        long[] appOpsNotedForAttribution;
        ArrayMap<String, Object> appOpsNoted = sAppOpsNotedInThisBinderTransaction.get();
        if (appOpsNoted == null) {
            appOpsNoted = new ArrayMap(1);
            sAppOpsNotedInThisBinderTransaction.set(appOpsNoted);
        }
        if ((appOpsNotedForAttribution = appOpsNoted.get(attributionTag)) == null) {
            appOpsNotedForAttribution = new long[2];
            appOpsNoted.put(attributionTag, appOpsNotedForAttribution);
        }
        if (op < 64) {
            appOpsNotedForAttribution[0] = appOpsNotedForAttribution[0] | 1L << op;
        } else {
            appOpsNotedForAttribution[1] = appOpsNotedForAttribution[1] | 1L << op - 64;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNotedOpCollectionMode(int uid, String packageName, int op) {
        if (packageName == null) {
            packageName = "android";
        }
        if (sAppOpsToNote[op] == 0) {
            boolean shouldCollectNotes;
            try {
                shouldCollectNotes = this.mService.shouldCollectNotes(op);
            }
            catch (RemoteException e) {
                return 0;
            }
            AppOpsManager.sAppOpsToNote[op] = shouldCollectNotes ? 2 : 1;
        }
        if (sAppOpsToNote[op] != 2) {
            return 0;
        }
        Object shouldCollectNotes = sLock;
        synchronized (shouldCollectNotes) {
            if (uid == Process.myUid() && packageName.equals(ActivityThread.currentOpPackageName())) {
                return 1;
            }
        }
        Integer binderUid = sBinderThreadCallingUid.get();
        if (binderUid != null && binderUid == uid) {
            return 2;
        }
        return 3;
    }

    public static void prefixParcelWithAppOpsIfNeeded(Parcel p) {
        ArrayMap<String, long[]> notedAppOps = sAppOpsNotedInThisBinderTransaction.get();
        if (notedAppOps == null) {
            return;
        }
        p.writeInt(-127);
        int numAttributionWithNotesAppOps = notedAppOps.size();
        p.writeInt(numAttributionWithNotesAppOps);
        for (int i = 0; i < numAttributionWithNotesAppOps; ++i) {
            p.writeString(notedAppOps.keyAt(i));
            p.writeLong(notedAppOps.valueAt(i)[0]);
            p.writeLong(notedAppOps.valueAt(i)[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readAndLogNotedAppops(Parcel p) {
        int numAttributionsWithNotedAppOps = p.readInt();
        for (int i = 0; i < numAttributionsWithNotedAppOps; ++i) {
            String attributionTag = p.readString();
            long[] rawNotedAppOps = new long[]{p.readLong(), p.readLong()};
            if (rawNotedAppOps[0] == 0L && rawNotedAppOps[1] == 0L) continue;
            BitSet notedAppOps = BitSet.valueOf(rawNotedAppOps);
            Object object = sLock;
            synchronized (object) {
                int code = notedAppOps.nextSetBit(0);
                while (code != -1) {
                    if (sOnOpNotedCallback != null) {
                        sOnOpNotedCallback.onNoted(new SyncNotedAppOp(code, attributionTag));
                    } else {
                        String message = AppOpsManager.getFormattedStackTrace();
                        sUnforwardedOps.add(new AsyncNotedAppOp(code, Process.myUid(), attributionTag, message, System_Delegate.currentTimeMillis()));
                        if (sUnforwardedOps.size() > 10) {
                            sUnforwardedOps.remove(0);
                        }
                    }
                    code = notedAppOps.nextSetBit(code + 1);
                }
            }
            int code = notedAppOps.nextSetBit(0);
            while (code != -1) {
                sMessageCollector.onNoted(new SyncNotedAppOp(code, attributionTag));
                code = notedAppOps.nextSetBit(code + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnOpNotedCallback(Executor asyncExecutor, OnOpNotedCallback callback) {
        Preconditions.checkState(callback == null == (asyncExecutor == null));
        Object object = sLock;
        synchronized (object) {
            if (callback == null) {
                Preconditions.checkState(sOnOpNotedCallback != null, "No callback is currently registered");
                try {
                    this.mService.stopWatchingAsyncNoted(this.mContext.getPackageName(), sOnOpNotedCallback.mAsyncCb);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                sOnOpNotedCallback = null;
            } else {
                Preconditions.checkState(sOnOpNotedCallback == null, "Another callback is already registered");
                callback.mAsyncExecutor = asyncExecutor;
                sOnOpNotedCallback = callback;
                List<AsyncNotedAppOp> missedAsyncOps = null;
                try {
                    this.mService.startWatchingAsyncNoted(this.mContext.getPackageName(), sOnOpNotedCallback.mAsyncCb);
                    missedAsyncOps = this.mService.extractAsyncOps(this.mContext.getPackageName());
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                if (missedAsyncOps != null) {
                    int numMissedAsyncOps = missedAsyncOps.size();
                    for (int i = 0; i < numMissedAsyncOps; ++i) {
                        AsyncNotedAppOp asyncNotedAppOp = missedAsyncOps.get(i);
                        if (sOnOpNotedCallback == null) continue;
                        sOnOpNotedCallback.getAsyncNotedExecutor().execute(() -> sOnOpNotedCallback.onAsyncNoted(asyncNotedAppOp));
                    }
                }
                AppOpsManager appOpsManager = this;
                synchronized (appOpsManager) {
                    int numMissedSyncOps = sUnforwardedOps.size();
                    for (int i = 0; i < numMissedSyncOps; ++i) {
                        AsyncNotedAppOp syncNotedAppOp = sUnforwardedOps.get(i);
                        if (sOnOpNotedCallback == null) continue;
                        sOnOpNotedCallback.getAsyncNotedExecutor().execute(() -> sOnOpNotedCallback.onAsyncNoted(syncNotedAppOp));
                    }
                    sUnforwardedOps.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @Deprecated
    public void setNotedAppOpsCollector(AppOpsCollector collector) {
        Object object = sLock;
        synchronized (object) {
            if (collector != null) {
                if (AppOpsManager.isListeningForOpNoted()) {
                    this.setOnOpNotedCallback(null, null);
                }
                this.setOnOpNotedCallback(new HandlerExecutor(Handler.getMain()), collector);
            } else if (sOnOpNotedCallback != null) {
                this.setOnOpNotedCallback(null, null);
            }
        }
    }

    public static boolean isListeningForOpNoted() {
        return sOnOpNotedCallback != null || AppOpsManager.isCollectingStackTraces();
    }

    private static boolean isCollectingStackTraces() {
        return sConfig.getSampledOpCode() != -1 || sConfig.getExpirationTimeSinceBootMillis() < SystemClock.elapsedRealtime();
    }

    private static String getFormattedStackTrace() {
        StackTraceElement[] trace = new Exception().getStackTrace();
        int firstInteresting = 0;
        int i = 0;
        while (i < trace.length && (trace[i].getClassName().startsWith(AppOpsManager.class.getName()) || trace[i].getClassName().startsWith(Parcel.class.getName()) || trace[i].getClassName().contains("$Stub$Proxy") || trace[i].getClassName().startsWith(DatabaseUtils.class.getName()) || trace[i].getClassName().startsWith("android.content.ContentProviderProxy") || trace[i].getClassName().startsWith(ContentResolver.class.getName()))) {
            firstInteresting = i++;
        }
        int lastInteresting = trace.length - 1;
        int i2 = trace.length - 1;
        while (i2 >= 0 && (trace[i2].getClassName().startsWith(HandlerThread.class.getName()) || trace[i2].getClassName().startsWith(Handler.class.getName()) || trace[i2].getClassName().startsWith(Looper.class.getName()) || trace[i2].getClassName().startsWith(Binder.class.getName()) || trace[i2].getClassName().startsWith(RuntimeInit.class.getName()) || trace[i2].getClassName().startsWith(ZygoteInit.class.getName()) || trace[i2].getClassName().startsWith(ActivityThread.class.getName()) || trace[i2].getClassName().startsWith(Method.class.getName()) || trace[i2].getClassName().startsWith("com.android.server.SystemServer"))) {
            lastInteresting = i2--;
        }
        StringBuilder sb = new StringBuilder();
        for (int i3 = firstInteresting; i3 <= lastInteresting; ++i3) {
            if (i3 != firstInteresting) {
                sb.append('\n');
            }
            if (sb.length() + trace[i3].toString().length() > 600) break;
            sb.append(trace[i3]);
        }
        return sb.toString();
    }

    public boolean isOperationActive(int code, int uid, String packageName) {
        try {
            return this.mService.isOperationActive(code, uid, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setHistoryParameters(int mode, long baseSnapshotInterval, int compressionStep) {
        try {
            this.mService.setHistoryParameters(mode, baseSnapshotInterval, compressionStep);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void offsetHistory(long offsetMillis) {
        try {
            this.mService.offsetHistory(offsetMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addHistoricalOps(HistoricalOps ops) {
        try {
            this.mService.addHistoricalOps(ops);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void resetHistoryParameters() {
        try {
            this.mService.resetHistoryParameters();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearHistory() {
        try {
            this.mService.clearHistory();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void rebootHistory(long offlineDurationMillis) {
        try {
            this.mService.rebootHistory(offlineDurationMillis);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public RuntimeAppOpAccessMessage collectRuntimeAppOpAccessMessage() {
        try {
            return this.mService.collectRuntimeAppOpAccessMessage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public static String[] getOpStrs() {
        return Arrays.copyOf(sOpToString, sOpToString.length);
    }

    public static int getNumOps() {
        return 100;
    }

    private static NoteOpEvent getLastEvent(LongSparseArray<NoteOpEvent> events, int beginUidState, int endUidState, int flags) {
        if (events == null) {
            return null;
        }
        NoteOpEvent lastEvent = null;
        while (flags != 0) {
            int flag = 1 << Integer.numberOfTrailingZeros(flags);
            flags &= ~flag;
            for (int uidState : UID_STATES) {
                if (uidState < beginUidState || uidState > endUidState) continue;
                long key = AppOpsManager.makeKey(uidState, flag);
                NoteOpEvent event = events.get(key);
                if (lastEvent != null && (event == null || event.getNoteTime() <= lastEvent.getNoteTime())) continue;
                lastEvent = event;
            }
        }
        return lastEvent;
    }

    private static boolean equalsLongSparseLongArray(LongSparseLongArray a, LongSparseLongArray b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        int numEntries = a.size();
        for (int i = 0; i < numEntries; ++i) {
            if (a.keyAt(i) == b.keyAt(i) && a.valueAt(i) == b.valueAt(i)) continue;
            return false;
        }
        return true;
    }

    private static void writeLongSparseLongArrayToParcel(LongSparseLongArray array2, Parcel parcel) {
        if (array2 != null) {
            int size = array2.size();
            parcel.writeInt(size);
            for (int i = 0; i < size; ++i) {
                parcel.writeLong(array2.keyAt(i));
                parcel.writeLong(array2.valueAt(i));
            }
        } else {
            parcel.writeInt(-1);
        }
    }

    private static LongSparseLongArray readLongSparseLongArrayFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size < 0) {
            return null;
        }
        LongSparseLongArray array2 = new LongSparseLongArray(size);
        for (int i = 0; i < size; ++i) {
            array2.append(parcel.readLong(), parcel.readLong());
        }
        return array2;
    }

    private static LongSparseArray<Object> collectKeys(LongSparseLongArray array2, LongSparseArray<Object> result) {
        if (array2 != null) {
            if (result == null) {
                result = new LongSparseArray();
            }
            int accessSize = array2.size();
            for (int i = 0; i < accessSize; ++i) {
                result.put(array2.keyAt(i), null);
            }
        }
        return result;
    }

    public static String uidStateToString(int uidState) {
        switch (uidState) {
            case 100: {
                return "UID_STATE_PERSISTENT";
            }
            case 200: {
                return "UID_STATE_TOP";
            }
            case 300: {
                return "UID_STATE_FOREGROUND_SERVICE_LOCATION";
            }
            case 400: {
                return "UID_STATE_FOREGROUND_SERVICE";
            }
            case 500: {
                return "UID_STATE_FOREGROUND";
            }
            case 600: {
                return "UID_STATE_BACKGROUND";
            }
            case 700: {
                return "UID_STATE_CACHED";
            }
        }
        return "UNKNOWN";
    }

    public static int parseHistoricalMode(String mode) {
        switch (mode) {
            case "HISTORICAL_MODE_ENABLED_ACTIVE": {
                return 1;
            }
            case "HISTORICAL_MODE_ENABLED_PASSIVE": {
                return 2;
            }
        }
        return 0;
    }

    public static String historicalModeToString(int mode) {
        switch (mode) {
            case 0: {
                return "HISTORICAL_MODE_DISABLED";
            }
            case 1: {
                return "HISTORICAL_MODE_ENABLED_ACTIVE";
            }
            case 2: {
                return "HISTORICAL_MODE_ENABLED_PASSIVE";
            }
        }
        return "UNKNOWN";
    }

    private static int getSystemAlertWindowDefault() {
        Application context = ActivityThread.currentApplication();
        if (context == null) {
            return 3;
        }
        PackageManager pm = ((Context)context).getPackageManager();
        if (ActivityManager.isLowRamDeviceStatic() && !pm.hasSystemFeature("android.software.leanback", 0)) {
            return 1;
        }
        return 3;
    }

    public static int leftCircularDistance(int from, int to, int size) {
        return (to + size - from) % size;
    }

    private void collectNoteOpCallsForValidation(int op) {
    }

    static {
        sLock = new Object();
        sUnforwardedOps = new ArrayList();
        sMessageCollector = new OnOpNotedCallback(){

            @Override
            public void onNoted(SyncNotedAppOp op) {
                this.reportStackTraceIfNeeded(op);
            }

            @Override
            public void onAsyncNoted(AsyncNotedAppOp asyncOp) {
            }

            @Override
            public void onSelfNoted(SyncNotedAppOp op) {
                this.reportStackTraceIfNeeded(op);
            }

            private void reportStackTraceIfNeeded(SyncNotedAppOp op) {
                if (!AppOpsManager.isCollectingStackTraces()) {
                    return;
                }
                MessageSamplingConfig config = sConfig;
                if (AppOpsManager.leftCircularDistance(AppOpsManager.strOpToOp(op.getOp()), config.getSampledOpCode(), 100) <= config.getAcceptableLeftDistance() || config.getExpirationTimeSinceBootMillis() < SystemClock.elapsedRealtime()) {
                    String stackTrace = AppOpsManager.getFormattedStackTrace();
                    try {
                        String packageName = ActivityThread.currentOpPackageName();
                        sConfig = AppOpsManager.getService().reportRuntimeAppOpAccessMessageAndGetConfig(packageName == null ? "" : packageName, op, stackTrace);
                    }
                    catch (RemoteException e) {
                        e.rethrowFromSystemServer();
                    }
                }
            }
        };
        MODE_NAMES = new String[]{"allow", "ignore", "deny", "default", "foreground"};
        UID_STATES = new int[]{100, 200, 300, 400, 500, 600, 700};
        RUNTIME_AND_APPOP_PERMISSIONS_OPS = new int[]{4, 5, 62, 8, 9, 20, 16, 14, 19, 18, 57, 59, 60, 90, 0, 1, 51, 65, 13, 6, 7, 52, 53, 54, 69, 74, 27, 26, 56, 79, 81, 82, 83, 84, 85, 86, 25, 24, 23, 66, 76, 80, 75, 68, 92, 93, 95};
        sOpToSwitch = new int[]{0, 0, 0, 3, 4, 5, 6, 7, 8, 9, 0, 11, 0, 13, 14, 15, 16, 16, 18, 19, 20, 14, 15, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 0, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 0, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99};
        sOpToString = new String[]{OPSTR_COARSE_LOCATION, OPSTR_FINE_LOCATION, OPSTR_GPS, OPSTR_VIBRATE, OPSTR_READ_CONTACTS, OPSTR_WRITE_CONTACTS, OPSTR_READ_CALL_LOG, OPSTR_WRITE_CALL_LOG, OPSTR_READ_CALENDAR, OPSTR_WRITE_CALENDAR, OPSTR_WIFI_SCAN, OPSTR_POST_NOTIFICATION, OPSTR_NEIGHBORING_CELLS, OPSTR_CALL_PHONE, OPSTR_READ_SMS, OPSTR_WRITE_SMS, OPSTR_RECEIVE_SMS, OPSTR_RECEIVE_EMERGENCY_BROADCAST, OPSTR_RECEIVE_MMS, OPSTR_RECEIVE_WAP_PUSH, OPSTR_SEND_SMS, OPSTR_READ_ICC_SMS, OPSTR_WRITE_ICC_SMS, OPSTR_WRITE_SETTINGS, OPSTR_SYSTEM_ALERT_WINDOW, OPSTR_ACCESS_NOTIFICATIONS, OPSTR_CAMERA, OPSTR_RECORD_AUDIO, OPSTR_PLAY_AUDIO, OPSTR_READ_CLIPBOARD, OPSTR_WRITE_CLIPBOARD, OPSTR_TAKE_MEDIA_BUTTONS, OPSTR_TAKE_AUDIO_FOCUS, OPSTR_AUDIO_MASTER_VOLUME, OPSTR_AUDIO_VOICE_VOLUME, OPSTR_AUDIO_RING_VOLUME, OPSTR_AUDIO_MEDIA_VOLUME, OPSTR_AUDIO_ALARM_VOLUME, OPSTR_AUDIO_NOTIFICATION_VOLUME, OPSTR_AUDIO_BLUETOOTH_VOLUME, OPSTR_WAKE_LOCK, OPSTR_MONITOR_LOCATION, OPSTR_MONITOR_HIGH_POWER_LOCATION, OPSTR_GET_USAGE_STATS, OPSTR_MUTE_MICROPHONE, OPSTR_TOAST_WINDOW, OPSTR_PROJECT_MEDIA, OPSTR_ACTIVATE_VPN, OPSTR_WRITE_WALLPAPER, OPSTR_ASSIST_STRUCTURE, OPSTR_ASSIST_SCREENSHOT, OPSTR_READ_PHONE_STATE, OPSTR_ADD_VOICEMAIL, OPSTR_USE_SIP, OPSTR_PROCESS_OUTGOING_CALLS, OPSTR_USE_FINGERPRINT, OPSTR_BODY_SENSORS, OPSTR_READ_CELL_BROADCASTS, OPSTR_MOCK_LOCATION, OPSTR_READ_EXTERNAL_STORAGE, OPSTR_WRITE_EXTERNAL_STORAGE, OPSTR_TURN_SCREEN_ON, OPSTR_GET_ACCOUNTS, OPSTR_RUN_IN_BACKGROUND, OPSTR_AUDIO_ACCESSIBILITY_VOLUME, OPSTR_READ_PHONE_NUMBERS, OPSTR_REQUEST_INSTALL_PACKAGES, OPSTR_PICTURE_IN_PICTURE, OPSTR_INSTANT_APP_START_FOREGROUND, OPSTR_ANSWER_PHONE_CALLS, OPSTR_RUN_ANY_IN_BACKGROUND, OPSTR_CHANGE_WIFI_STATE, OPSTR_REQUEST_DELETE_PACKAGES, OPSTR_BIND_ACCESSIBILITY_SERVICE, OPSTR_ACCEPT_HANDOVER, OPSTR_MANAGE_IPSEC_TUNNELS, OPSTR_START_FOREGROUND, OPSTR_BLUETOOTH_SCAN, OPSTR_USE_BIOMETRIC, OPSTR_ACTIVITY_RECOGNITION, OPSTR_SMS_FINANCIAL_TRANSACTIONS, OPSTR_READ_MEDIA_AUDIO, OPSTR_WRITE_MEDIA_AUDIO, OPSTR_READ_MEDIA_VIDEO, OPSTR_WRITE_MEDIA_VIDEO, OPSTR_READ_MEDIA_IMAGES, OPSTR_WRITE_MEDIA_IMAGES, OPSTR_LEGACY_STORAGE, OPSTR_ACCESS_ACCESSIBILITY, OPSTR_READ_DEVICE_IDENTIFIERS, OPSTR_ACCESS_MEDIA_LOCATION, OPSTR_QUERY_ALL_PACKAGES, OPSTR_MANAGE_EXTERNAL_STORAGE, OPSTR_INTERACT_ACROSS_PROFILES, OPSTR_ACTIVATE_PLATFORM_VPN, OPSTR_LOADER_USAGE_STATS, "", OPSTR_AUTO_REVOKE_PERMISSIONS_IF_UNUSED, OPSTR_AUTO_REVOKE_MANAGED_BY_INSTALLER, OPSTR_NO_ISOLATED_STORAGE};
        sOpNames = new String[]{"COARSE_LOCATION", "FINE_LOCATION", "GPS", "VIBRATE", "READ_CONTACTS", "WRITE_CONTACTS", "READ_CALL_LOG", "WRITE_CALL_LOG", "READ_CALENDAR", "WRITE_CALENDAR", "WIFI_SCAN", "POST_NOTIFICATION", "NEIGHBORING_CELLS", "CALL_PHONE", "READ_SMS", "WRITE_SMS", "RECEIVE_SMS", "RECEIVE_EMERGECY_SMS", "RECEIVE_MMS", "RECEIVE_WAP_PUSH", "SEND_SMS", "READ_ICC_SMS", "WRITE_ICC_SMS", "WRITE_SETTINGS", "SYSTEM_ALERT_WINDOW", "ACCESS_NOTIFICATIONS", "CAMERA", "RECORD_AUDIO", "PLAY_AUDIO", "READ_CLIPBOARD", "WRITE_CLIPBOARD", "TAKE_MEDIA_BUTTONS", "TAKE_AUDIO_FOCUS", "AUDIO_MASTER_VOLUME", "AUDIO_VOICE_VOLUME", "AUDIO_RING_VOLUME", "AUDIO_MEDIA_VOLUME", "AUDIO_ALARM_VOLUME", "AUDIO_NOTIFICATION_VOLUME", "AUDIO_BLUETOOTH_VOLUME", "WAKE_LOCK", "MONITOR_LOCATION", "MONITOR_HIGH_POWER_LOCATION", "GET_USAGE_STATS", "MUTE_MICROPHONE", "TOAST_WINDOW", "PROJECT_MEDIA", "ACTIVATE_VPN", "WRITE_WALLPAPER", "ASSIST_STRUCTURE", "ASSIST_SCREENSHOT", "READ_PHONE_STATE", "ADD_VOICEMAIL", "USE_SIP", "PROCESS_OUTGOING_CALLS", "USE_FINGERPRINT", "BODY_SENSORS", "READ_CELL_BROADCASTS", "MOCK_LOCATION", "READ_EXTERNAL_STORAGE", "WRITE_EXTERNAL_STORAGE", "TURN_ON_SCREEN", "GET_ACCOUNTS", "RUN_IN_BACKGROUND", "AUDIO_ACCESSIBILITY_VOLUME", "READ_PHONE_NUMBERS", "REQUEST_INSTALL_PACKAGES", "PICTURE_IN_PICTURE", "INSTANT_APP_START_FOREGROUND", "ANSWER_PHONE_CALLS", "RUN_ANY_IN_BACKGROUND", "CHANGE_WIFI_STATE", "REQUEST_DELETE_PACKAGES", "BIND_ACCESSIBILITY_SERVICE", "ACCEPT_HANDOVER", "MANAGE_IPSEC_TUNNELS", "START_FOREGROUND", "BLUETOOTH_SCAN", "USE_BIOMETRIC", "ACTIVITY_RECOGNITION", "SMS_FINANCIAL_TRANSACTIONS", "READ_MEDIA_AUDIO", "WRITE_MEDIA_AUDIO", "READ_MEDIA_VIDEO", "WRITE_MEDIA_VIDEO", "READ_MEDIA_IMAGES", "WRITE_MEDIA_IMAGES", "LEGACY_STORAGE", "ACCESS_ACCESSIBILITY", "READ_DEVICE_IDENTIFIERS", "ACCESS_MEDIA_LOCATION", "QUERY_ALL_PACKAGES", "MANAGE_EXTERNAL_STORAGE", "INTERACT_ACROSS_PROFILES", "ACTIVATE_PLATFORM_VPN", "LOADER_USAGE_STATS", "deprecated", "AUTO_REVOKE_PERMISSIONS_IF_UNUSED", "AUTO_REVOKE_MANAGED_BY_INSTALLER", "NO_ISOLATED_STORAGE"};
        sOpPerms = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", null, "android.permission.VIBRATE", "android.permission.READ_CONTACTS", "android.permission.WRITE_CONTACTS", "android.permission.READ_CALL_LOG", "android.permission.WRITE_CALL_LOG", "android.permission.READ_CALENDAR", "android.permission.WRITE_CALENDAR", "android.permission.ACCESS_WIFI_STATE", null, null, "android.permission.CALL_PHONE", "android.permission.READ_SMS", null, "android.permission.RECEIVE_SMS", "android.permission.RECEIVE_EMERGENCY_BROADCAST", "android.permission.RECEIVE_MMS", "android.permission.RECEIVE_WAP_PUSH", "android.permission.SEND_SMS", "android.permission.READ_SMS", null, "android.permission.WRITE_SETTINGS", "android.permission.SYSTEM_ALERT_WINDOW", "android.permission.ACCESS_NOTIFICATIONS", "android.permission.CAMERA", "android.permission.RECORD_AUDIO", null, null, null, null, null, null, null, null, null, null, null, null, "android.permission.WAKE_LOCK", null, null, "android.permission.PACKAGE_USAGE_STATS", null, null, null, null, null, null, null, "android.permission.READ_PHONE_STATE", "com.android.voicemail.permission.ADD_VOICEMAIL", "android.permission.USE_SIP", "android.permission.PROCESS_OUTGOING_CALLS", "android.permission.USE_FINGERPRINT", "android.permission.BODY_SENSORS", "android.permission.READ_CELL_BROADCASTS", null, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", null, "android.permission.GET_ACCOUNTS", null, null, "android.permission.READ_PHONE_NUMBERS", "android.permission.REQUEST_INSTALL_PACKAGES", null, "android.permission.INSTANT_APP_FOREGROUND_SERVICE", "android.permission.ANSWER_PHONE_CALLS", null, "android.permission.CHANGE_WIFI_STATE", "android.permission.REQUEST_DELETE_PACKAGES", "android.permission.BIND_ACCESSIBILITY_SERVICE", "android.permission.ACCEPT_HANDOVER", "android.permission.MANAGE_IPSEC_TUNNELS", "android.permission.FOREGROUND_SERVICE", null, "android.permission.USE_BIOMETRIC", "android.permission.ACTIVITY_RECOGNITION", "android.permission.SMS_FINANCIAL_TRANSACTIONS", null, null, null, null, null, null, null, null, null, "android.permission.ACCESS_MEDIA_LOCATION", null, "android.permission.MANAGE_EXTERNAL_STORAGE", "android.permission.INTERACT_ACROSS_PROFILES", null, "android.permission.LOADER_USAGE_STATS", null, null, null, null};
        sOpRestrictions = new String[]{"no_share_location", "no_share_location", "no_share_location", null, null, null, "no_outgoing_calls", "no_outgoing_calls", null, null, "no_share_location", null, null, null, "no_sms", "no_sms", "no_sms", null, "no_sms", null, "no_sms", "no_sms", "no_sms", null, "no_create_windows", null, "no_camera", "no_record_audio", null, null, null, null, null, "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", "no_adjust_volume", null, "no_share_location", "no_share_location", null, "no_unmute_microphone", "no_create_windows", null, null, "no_wallpaper", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "no_adjust_volume", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "no_sms", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        sOpAllowSystemRestrictionBypass = new RestrictionBypass[]{new RestrictionBypass(true, false), new RestrictionBypass(true, false), null, null, null, null, null, null, null, null, new RestrictionBypass(true, false), null, null, null, null, null, null, null, null, null, null, null, null, null, new RestrictionBypass(true, false), null, null, new RestrictionBypass(false, true), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new RestrictionBypass(true, false), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new RestrictionBypass(true, false), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        sOpDefaultMode = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, AppOpsManager.getSystemAlertWindowDefault(), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 3, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 3, 0, 2, 0, 2, 0, 2, 3, 0, 2, 0, 3, 3, 3, 1, 3, 1, 3, 0, 2};
        sOpDisableReset = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, true};
        sOpStrToOp = new HashMap();
        sPermToOp = new HashMap();
        sBinderThreadCallingUid = new ThreadLocal();
        sAppOpsNotedInThisBinderTransaction = new ThreadLocal();
        sAppOpsToNote = new byte[100];
        if (sOpToSwitch.length != 100) {
            throw new IllegalStateException("sOpToSwitch length " + sOpToSwitch.length + " should be " + 100);
        }
        if (sOpToString.length != 100) {
            throw new IllegalStateException("sOpToString length " + sOpToString.length + " should be " + 100);
        }
        if (sOpNames.length != 100) {
            throw new IllegalStateException("sOpNames length " + sOpNames.length + " should be " + 100);
        }
        if (sOpPerms.length != 100) {
            throw new IllegalStateException("sOpPerms length " + sOpPerms.length + " should be " + 100);
        }
        if (sOpDefaultMode.length != 100) {
            throw new IllegalStateException("sOpDefaultMode length " + sOpDefaultMode.length + " should be " + 100);
        }
        if (sOpDisableReset.length != 100) {
            throw new IllegalStateException("sOpDisableReset length " + sOpDisableReset.length + " should be " + 100);
        }
        if (sOpRestrictions.length != 100) {
            throw new IllegalStateException("sOpRestrictions length " + sOpRestrictions.length + " should be " + 100);
        }
        if (sOpAllowSystemRestrictionBypass.length != 100) {
            throw new IllegalStateException("sOpAllowSYstemRestrictionsBypass length " + sOpRestrictions.length + " should be " + 100);
        }
        for (int i = 0; i < 100; ++i) {
            if (sOpToString[i] == null) continue;
            sOpStrToOp.put(sOpToString[i], i);
        }
        for (int op : RUNTIME_AND_APPOP_PERMISSIONS_OPS) {
            if (sOpPerms[op] == null) continue;
            sPermToOp.put(sOpPerms[op], op);
        }
        sConfig = new MessageSamplingConfig(-1, 0, 0L);
    }

    @SystemApi
    @Deprecated
    public static abstract class AppOpsCollector
    extends OnOpNotedCallback {
        @Override
        public Executor getAsyncNotedExecutor() {
            return new HandlerExecutor(Handler.getMain());
        }
    }

    public static abstract class OnOpNotedCallback {
        private Executor mAsyncExecutor;
        private final IAppOpsAsyncNotedCallback mAsyncCb = new IAppOpsAsyncNotedCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void opNoted(AsyncNotedAppOp op) {
                Objects.requireNonNull(op);
                long token = Binder.clearCallingIdentity();
                try {
                    this.getAsyncNotedExecutor().execute(() -> this.onAsyncNoted(op));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };

        protected Executor getAsyncNotedExecutor() {
            return this.mAsyncExecutor;
        }

        public abstract void onNoted(SyncNotedAppOp var1);

        public abstract void onSelfNoted(SyncNotedAppOp var1);

        public abstract void onAsyncNoted(AsyncNotedAppOp var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface NotedOpCollectionMode {
    }

    public static class PausedNotedAppOpsCollection {
        final int mUid;
        final ArrayMap<String, long[]> mCollectedNotedAppOps;

        PausedNotedAppOpsCollection(int uid, ArrayMap<String, long[]> collectedNotedAppOps) {
            this.mUid = uid;
            this.mCollectedNotedAppOps = collectedNotedAppOps;
        }
    }

    public static interface OnOpStartedListener {
        public void onOpStarted(int var1, int var2, String var3, int var4);
    }

    public static interface OnOpActiveChangedInternalListener
    extends OnOpActiveChangedListener {
        @Override
        default public void onOpActiveChanged(String op, int uid, String packageName, boolean active) {
        }

        default public void onOpActiveChanged(int op, int uid, String packageName, boolean active) {
        }
    }

    public static class OnOpChangedInternalListener
    implements OnOpChangedListener {
        @Override
        public void onOpChanged(String op, String packageName) {
        }

        public void onOpChanged(int op, String packageName) {
        }
    }

    public static interface OnOpNotedListener {
        public void onOpNoted(int var1, int var2, String var3, int var4);
    }

    public static interface OnOpActiveChangedListener {
        public void onOpActiveChanged(String var1, int var2, String var3, boolean var4);
    }

    public static interface OnOpChangedListener {
        public void onOpChanged(String var1, String var2);
    }

    @SystemApi
    public static class HistoricalOp
    implements Parcelable {
        private final int mOp;
        private LongSparseLongArray mAccessCount;
        private LongSparseLongArray mRejectCount;
        private LongSparseLongArray mAccessDuration;
        public static final Parcelable.Creator<HistoricalOp> CREATOR = new Parcelable.Creator<HistoricalOp>(){

            @Override
            public HistoricalOp createFromParcel(Parcel source) {
                return new HistoricalOp(source);
            }

            public HistoricalOp[] newArray(int size) {
                return new HistoricalOp[size];
            }
        };

        public HistoricalOp(int op) {
            this.mOp = op;
        }

        private HistoricalOp(HistoricalOp other) {
            this.mOp = other.mOp;
            if (other.mAccessCount != null) {
                this.mAccessCount = other.mAccessCount.clone();
            }
            if (other.mRejectCount != null) {
                this.mRejectCount = other.mRejectCount.clone();
            }
            if (other.mAccessDuration != null) {
                this.mAccessDuration = other.mAccessDuration.clone();
            }
        }

        private HistoricalOp(Parcel parcel) {
            this.mOp = parcel.readInt();
            this.mAccessCount = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
            this.mRejectCount = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
            this.mAccessDuration = AppOpsManager.readLongSparseLongArrayFromParcel(parcel);
        }

        private void filter(double scaleFactor) {
            HistoricalOp.scale(this.mAccessCount, scaleFactor);
            HistoricalOp.scale(this.mRejectCount, scaleFactor);
            HistoricalOp.scale(this.mAccessDuration, scaleFactor);
        }

        private boolean isEmpty() {
            return !this.hasData(this.mAccessCount) && !this.hasData(this.mRejectCount) && !this.hasData(this.mAccessDuration);
        }

        private boolean hasData(LongSparseLongArray array2) {
            return array2 != null && array2.size() > 0;
        }

        private HistoricalOp splice(double fractionToRemove) {
            HistoricalOp splice = new HistoricalOp(this.mOp);
            HistoricalOp.splice(this.mAccessCount, splice::getOrCreateAccessCount, fractionToRemove);
            HistoricalOp.splice(this.mRejectCount, splice::getOrCreateRejectCount, fractionToRemove);
            HistoricalOp.splice(this.mAccessDuration, splice::getOrCreateAccessDuration, fractionToRemove);
            return splice;
        }

        private static void splice(LongSparseLongArray sourceContainer, Supplier<LongSparseLongArray> destContainerProvider, double fractionToRemove) {
            if (sourceContainer != null) {
                int size = sourceContainer.size();
                for (int i = 0; i < size; ++i) {
                    long key = sourceContainer.keyAt(i);
                    long value = sourceContainer.valueAt(i);
                    long removedFraction = Math.round((double)value * fractionToRemove);
                    if (removedFraction <= 0L) continue;
                    destContainerProvider.get().put(key, removedFraction);
                    sourceContainer.put(key, value - removedFraction);
                }
            }
        }

        private void merge(HistoricalOp other) {
            HistoricalOp.merge(this::getOrCreateAccessCount, other.mAccessCount);
            HistoricalOp.merge(this::getOrCreateRejectCount, other.mRejectCount);
            HistoricalOp.merge(this::getOrCreateAccessDuration, other.mAccessDuration);
        }

        private void increaseAccessCount(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateAccessCount(), uidState, flags, increment);
        }

        private void increaseRejectCount(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateRejectCount(), uidState, flags, increment);
        }

        private void increaseAccessDuration(int uidState, int flags, long increment) {
            this.increaseCount(this.getOrCreateAccessDuration(), uidState, flags, increment);
        }

        private void increaseCount(LongSparseLongArray counts, int uidState, int flags, long increment) {
            while (flags != 0) {
                int flag = 1 << Integer.numberOfTrailingZeros(flags);
                flags &= ~flag;
                long key = AppOpsManager.makeKey(uidState, flag);
                counts.put(key, counts.get(key) + increment);
            }
        }

        public String getOpName() {
            return sOpToString[this.mOp];
        }

        public int getOpCode() {
            return this.mOp;
        }

        public long getForegroundAccessCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundAccessCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getAccessCount(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessCount, fromUidState, toUidState, flags);
        }

        public long getForegroundRejectCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundRejectCount(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getRejectCount(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mRejectCount, fromUidState, toUidState, flags);
        }

        public long getForegroundAccessDuration(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, 100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getBackgroundAccessDuration(int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getAccessDuration(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.sumForFlagsInStates(this.mAccessDuration, fromUidState, toUidState, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(this.mOp);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mAccessCount, parcel);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mRejectCount, parcel);
            AppOpsManager.writeLongSparseLongArrayToParcel(this.mAccessDuration, parcel);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalOp other = (HistoricalOp)obj;
            if (this.mOp != other.mOp) {
                return false;
            }
            if (!AppOpsManager.equalsLongSparseLongArray(this.mAccessCount, other.mAccessCount)) {
                return false;
            }
            if (!AppOpsManager.equalsLongSparseLongArray(this.mRejectCount, other.mRejectCount)) {
                return false;
            }
            return AppOpsManager.equalsLongSparseLongArray(this.mAccessDuration, other.mAccessDuration);
        }

        public int hashCode() {
            int result = this.mOp;
            result = 31 * result + Objects.hashCode(this.mAccessCount);
            result = 31 * result + Objects.hashCode(this.mRejectCount);
            result = 31 * result + Objects.hashCode(this.mAccessDuration);
            return result;
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalOp(this);
        }

        private LongSparseLongArray getOrCreateAccessCount() {
            if (this.mAccessCount == null) {
                this.mAccessCount = new LongSparseLongArray();
            }
            return this.mAccessCount;
        }

        private LongSparseLongArray getOrCreateRejectCount() {
            if (this.mRejectCount == null) {
                this.mRejectCount = new LongSparseLongArray();
            }
            return this.mRejectCount;
        }

        private LongSparseLongArray getOrCreateAccessDuration() {
            if (this.mAccessDuration == null) {
                this.mAccessDuration = new LongSparseLongArray();
            }
            return this.mAccessDuration;
        }

        private static void scale(LongSparseLongArray data, double scaleFactor) {
            if (data != null) {
                int size = data.size();
                for (int i = 0; i < size; ++i) {
                    data.put(data.keyAt(i), (long)HistoricalOps.round((double)data.valueAt(i) * scaleFactor));
                }
            }
        }

        private static void merge(Supplier<LongSparseLongArray> thisSupplier, LongSparseLongArray other) {
            if (other != null) {
                int otherSize = other.size();
                for (int i = 0; i < otherSize; ++i) {
                    LongSparseLongArray that = thisSupplier.get();
                    long otherKey = other.keyAt(i);
                    long otherValue = other.valueAt(i);
                    that.put(otherKey, that.get(otherKey) + otherValue);
                }
            }
        }

        public LongSparseArray<Object> collectKeys() {
            LongSparseArray result = AppOpsManager.collectKeys(this.mAccessCount, null);
            result = AppOpsManager.collectKeys(this.mRejectCount, result);
            result = AppOpsManager.collectKeys(this.mAccessDuration, result);
            return result;
        }
    }

    @SystemApi
    public static class AttributedHistoricalOps
    implements Parcelable {
        private final String mTag;
        private ArrayMap<String, HistoricalOp> mHistoricalOps;
        public static final Parcelable.Creator<AttributedHistoricalOps> CREATOR = new Parcelable.Creator<AttributedHistoricalOps>(){

            public AttributedHistoricalOps[] newArray(int size) {
                return new AttributedHistoricalOps[size];
            }

            @Override
            public AttributedHistoricalOps createFromParcel(Parcel in) {
                return new AttributedHistoricalOps(in);
            }
        };

        public AttributedHistoricalOps(String tag) {
            this.mTag = tag;
        }

        private AttributedHistoricalOps(AttributedHistoricalOps other) {
            this.mTag = other.mTag;
            int opCount = other.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp origOp = other.getOpAt(i);
                HistoricalOp cloneOp = new HistoricalOp(origOp);
                if (this.mHistoricalOps == null) {
                    this.mHistoricalOps = new ArrayMap(opCount);
                }
                this.mHistoricalOps.put(cloneOp.getOpName(), cloneOp);
            }
        }

        private AttributedHistoricalOps splice(double fractionToRemove) {
            AttributedHistoricalOps splice = null;
            int opCount = this.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp origOps = this.getOpAt(i);
                HistoricalOp spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new AttributedHistoricalOps(this.mTag, null);
                }
                if (splice.mHistoricalOps == null) {
                    splice.mHistoricalOps = new ArrayMap();
                }
                splice.mHistoricalOps.put(spliceOps.getOpName(), spliceOps);
            }
            return splice;
        }

        private void merge(AttributedHistoricalOps other) {
            int opCount = other.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalOp otherOp = other.getOpAt(i);
                HistoricalOp thisOp = this.getOp(otherOp.getOpName());
                if (thisOp != null) {
                    thisOp.merge(otherOp);
                    continue;
                }
                if (this.mHistoricalOps == null) {
                    this.mHistoricalOps = new ArrayMap();
                }
                this.mHistoricalOps.put(otherOp.getOpName(), otherOp);
            }
        }

        private void filter(String[] opNames, int filter, double scaleFactor) {
            int opCount = this.getOpCount();
            for (int i = opCount - 1; i >= 0; --i) {
                HistoricalOp op = this.mHistoricalOps.valueAt(i);
                if ((filter & 8) != 0 && !ArrayUtils.contains(opNames, op.getOpName())) {
                    this.mHistoricalOps.removeAt(i);
                    continue;
                }
                op.filter(scaleFactor);
            }
        }

        private boolean isEmpty() {
            int opCount = this.getOpCount();
            for (int i = opCount - 1; i >= 0; --i) {
                HistoricalOp op = this.mHistoricalOps.valueAt(i);
                if (op.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseAccessCount(uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseRejectCount(uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalOp(opCode).increaseAccessDuration(uidState, flags, increment);
        }

        public int getOpCount() {
            if (this.mHistoricalOps == null) {
                return 0;
            }
            return this.mHistoricalOps.size();
        }

        public HistoricalOp getOpAt(int index) {
            if (this.mHistoricalOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalOps.valueAt(index);
        }

        public HistoricalOp getOp(String opName) {
            if (this.mHistoricalOps == null) {
                return null;
            }
            return this.mHistoricalOps.get(opName);
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalAttributionOps(this);
            int opCount = this.getOpCount();
            for (int i = 0; i < opCount; ++i) {
                this.getOpAt(i).accept(visitor);
            }
        }

        private HistoricalOp getOrCreateHistoricalOp(int opCode) {
            String opStr;
            HistoricalOp op;
            if (this.mHistoricalOps == null) {
                this.mHistoricalOps = new ArrayMap();
            }
            if ((op = this.mHistoricalOps.get(opStr = sOpToString[opCode])) == null) {
                op = new HistoricalOp(opCode);
                this.mHistoricalOps.put(opStr, op);
            }
            return op;
        }

        public AttributedHistoricalOps(String tag, ArrayMap<String, HistoricalOp> historicalOps) {
            this.mTag = tag;
            this.mHistoricalOps = historicalOps;
        }

        public String getTag() {
            return this.mTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributedHistoricalOps that = (AttributedHistoricalOps)o;
            return Objects.equals(this.mTag, that.mTag) && Objects.equals(this.mHistoricalOps, that.mHistoricalOps);
        }

        public int hashCode() {
            int _hash = 1;
            _hash = 31 * _hash + Objects.hashCode(this.mTag);
            _hash = 31 * _hash + Objects.hashCode(this.mHistoricalOps);
            return _hash;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mTag != null) {
                flg = (byte)(flg | 1);
            }
            if (this.mHistoricalOps != null) {
                flg = (byte)(flg | 2);
            }
            dest.writeByte(flg);
            if (this.mTag != null) {
                dest.writeString(this.mTag);
            }
            if (this.mHistoricalOps != null) {
                dest.writeMap(this.mHistoricalOps);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        AttributedHistoricalOps(Parcel in) {
            byte flg = in.readByte();
            String attributionTag = (flg & 1) == 0 ? null : in.readString();
            ArrayMap historicalOps = null;
            if ((flg & 2) != 0) {
                historicalOps = new ArrayMap();
                in.readMap(historicalOps, HistoricalOp.class.getClassLoader());
            }
            this.mTag = attributionTag;
            this.mHistoricalOps = historicalOps;
        }
    }

    @SystemApi
    public static class HistoricalPackageOps
    implements Parcelable {
        private final String mPackageName;
        private ArrayMap<String, AttributedHistoricalOps> mAttributedHistoricalOps;
        public static final Parcelable.Creator<HistoricalPackageOps> CREATOR = new Parcelable.Creator<HistoricalPackageOps>(){

            @Override
            public HistoricalPackageOps createFromParcel(Parcel parcel) {
                return new HistoricalPackageOps(parcel);
            }

            public HistoricalPackageOps[] newArray(int size) {
                return new HistoricalPackageOps[size];
            }
        };

        public HistoricalPackageOps(String packageName) {
            this.mPackageName = packageName;
        }

        private HistoricalPackageOps(HistoricalPackageOps other) {
            this.mPackageName = other.mPackageName;
            int opCount = other.getAttributedOpsCount();
            for (int i = 0; i < opCount; ++i) {
                AttributedHistoricalOps origOps = other.getAttributedOpsAt(i);
                AttributedHistoricalOps cloneOps = new AttributedHistoricalOps(origOps);
                if (this.mAttributedHistoricalOps == null) {
                    this.mAttributedHistoricalOps = new ArrayMap(opCount);
                }
                this.mAttributedHistoricalOps.put(cloneOps.getTag(), cloneOps);
            }
        }

        private HistoricalPackageOps(Parcel parcel) {
            this.mPackageName = parcel.readString();
            this.mAttributedHistoricalOps = parcel.createTypedArrayMap(AttributedHistoricalOps.CREATOR);
        }

        private HistoricalPackageOps splice(double fractionToRemove) {
            HistoricalPackageOps splice = null;
            int attributionCount = this.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                AttributedHistoricalOps origOps = this.getAttributedOpsAt(i);
                AttributedHistoricalOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalPackageOps(this.mPackageName);
                }
                if (splice.mAttributedHistoricalOps == null) {
                    splice.mAttributedHistoricalOps = new ArrayMap();
                }
                splice.mAttributedHistoricalOps.put(spliceOps.getTag(), spliceOps);
            }
            return splice;
        }

        private void merge(HistoricalPackageOps other) {
            int attributionCount = other.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                AttributedHistoricalOps otherAttributionOps = other.getAttributedOpsAt(i);
                AttributedHistoricalOps thisAttributionOps = this.getAttributedOps(otherAttributionOps.getTag());
                if (thisAttributionOps != null) {
                    thisAttributionOps.merge(otherAttributionOps);
                    continue;
                }
                if (this.mAttributedHistoricalOps == null) {
                    this.mAttributedHistoricalOps = new ArrayMap();
                }
                this.mAttributedHistoricalOps.put(otherAttributionOps.getTag(), otherAttributionOps);
            }
        }

        private void filter(String attributionTag, String[] opNames, int filter, double fractionToRemove) {
            int attributionCount = this.getAttributedOpsCount();
            for (int i = attributionCount - 1; i >= 0; --i) {
                AttributedHistoricalOps attributionOps = this.getAttributedOpsAt(i);
                if ((filter & 4) != 0 && !Objects.equals(attributionTag, attributionOps.getTag())) {
                    this.mAttributedHistoricalOps.removeAt(i);
                    continue;
                }
                attributionOps.filter(opNames, filter, fractionToRemove);
                if (attributionOps.getOpCount() != 0) continue;
                this.mAttributedHistoricalOps.removeAt(i);
            }
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalPackageOps(this);
            int attributionCount = this.getAttributedOpsCount();
            for (int i = 0; i < attributionCount; ++i) {
                this.getAttributedOpsAt(i).accept(visitor);
            }
        }

        private boolean isEmpty() {
            int attributionCount = this.getAttributedOpsCount();
            for (int i = attributionCount - 1; i >= 0; --i) {
                AttributedHistoricalOps attributionOps = this.mAttributedHistoricalOps.valueAt(i);
                if (attributionOps.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseAccessCount(opCode, uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseRejectCount(opCode, uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateAttributedHistoricalOps(attributionTag).increaseAccessDuration(opCode, uidState, flags, increment);
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        private AttributedHistoricalOps getOrCreateAttributedHistoricalOps(String attributionTag) {
            AttributedHistoricalOps historicalAttributionOp;
            if (this.mAttributedHistoricalOps == null) {
                this.mAttributedHistoricalOps = new ArrayMap();
            }
            if ((historicalAttributionOp = this.mAttributedHistoricalOps.get(attributionTag)) == null) {
                historicalAttributionOp = new AttributedHistoricalOps(attributionTag);
                this.mAttributedHistoricalOps.put(attributionTag, historicalAttributionOp);
            }
            return historicalAttributionOp;
        }

        public int getOpCount() {
            int numOps = 0;
            int numAttributions = this.getAttributedOpsCount();
            block0: for (int code = 0; code < 100; ++code) {
                String opName = AppOpsManager.opToPublicName(code);
                for (int attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
                    if (this.getAttributedOpsAt(attributionNum).getOp(opName) == null) continue;
                    ++numOps;
                    continue block0;
                }
            }
            return numOps;
        }

        public HistoricalOp getOpAt(int index) {
            int numOpsFound = 0;
            int numAttributions = this.getAttributedOpsCount();
            block0: for (int code = 0; code < 100; ++code) {
                String opName = AppOpsManager.opToPublicName(code);
                for (int attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
                    if (this.getAttributedOpsAt(attributionNum).getOp(opName) == null) continue;
                    if (numOpsFound == index) {
                        return this.getOp(opName);
                    }
                    ++numOpsFound;
                    continue block0;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        public HistoricalOp getOp(String opName) {
            if (this.mAttributedHistoricalOps == null) {
                return null;
            }
            HistoricalOp combinedOp = null;
            int numAttributions = this.getAttributedOpsCount();
            for (int i = 0; i < numAttributions; ++i) {
                HistoricalOp attributionOp = this.getAttributedOpsAt(i).getOp(opName);
                if (attributionOp == null) continue;
                if (combinedOp == null) {
                    combinedOp = new HistoricalOp(attributionOp);
                    continue;
                }
                combinedOp.merge(attributionOp);
            }
            return combinedOp;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.mPackageName);
            parcel.writeTypedArrayMap(this.mAttributedHistoricalOps, flags);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalPackageOps other = (HistoricalPackageOps)obj;
            if (!this.mPackageName.equals(other.mPackageName)) {
                return false;
            }
            return !(this.mAttributedHistoricalOps == null ? other.mAttributedHistoricalOps != null : !this.mAttributedHistoricalOps.equals(other.mAttributedHistoricalOps));
        }

        public int hashCode() {
            int result = this.mPackageName != null ? this.mPackageName.hashCode() : 0;
            result = 31 * result + (this.mAttributedHistoricalOps != null ? this.mAttributedHistoricalOps.hashCode() : 0);
            return result;
        }

        public int getAttributedOpsCount() {
            if (this.mAttributedHistoricalOps == null) {
                return 0;
            }
            return this.mAttributedHistoricalOps.size();
        }

        public AttributedHistoricalOps getAttributedOpsAt(int index) {
            if (this.mAttributedHistoricalOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mAttributedHistoricalOps.valueAt(index);
        }

        public AttributedHistoricalOps getAttributedOps(String attributionTag) {
            if (this.mAttributedHistoricalOps == null) {
                return null;
            }
            return this.mAttributedHistoricalOps.get(attributionTag);
        }
    }

    @SystemApi
    public static class HistoricalUidOps
    implements Parcelable {
        private final int mUid;
        private ArrayMap<String, HistoricalPackageOps> mHistoricalPackageOps;
        public static final Parcelable.Creator<HistoricalUidOps> CREATOR = new Parcelable.Creator<HistoricalUidOps>(){

            @Override
            public HistoricalUidOps createFromParcel(Parcel parcel) {
                return new HistoricalUidOps(parcel);
            }

            public HistoricalUidOps[] newArray(int size) {
                return new HistoricalUidOps[size];
            }
        };

        public HistoricalUidOps(int uid) {
            this.mUid = uid;
        }

        private HistoricalUidOps(HistoricalUidOps other) {
            this.mUid = other.mUid;
            int opCount = other.getPackageCount();
            for (int i = 0; i < opCount; ++i) {
                HistoricalPackageOps origOps = other.getPackageOpsAt(i);
                HistoricalPackageOps cloneOps = new HistoricalPackageOps(origOps);
                if (this.mHistoricalPackageOps == null) {
                    this.mHistoricalPackageOps = new ArrayMap(opCount);
                }
                this.mHistoricalPackageOps.put(cloneOps.getPackageName(), cloneOps);
            }
        }

        private HistoricalUidOps(Parcel parcel) {
            this.mUid = parcel.readInt();
            this.mHistoricalPackageOps = parcel.createTypedArrayMap(HistoricalPackageOps.CREATOR);
        }

        private HistoricalUidOps splice(double fractionToRemove) {
            HistoricalUidOps splice = null;
            int packageCount = this.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                HistoricalPackageOps origOps = this.getPackageOpsAt(i);
                HistoricalPackageOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalUidOps(this.mUid);
                }
                if (splice.mHistoricalPackageOps == null) {
                    splice.mHistoricalPackageOps = new ArrayMap();
                }
                splice.mHistoricalPackageOps.put(spliceOps.getPackageName(), spliceOps);
            }
            return splice;
        }

        private void merge(HistoricalUidOps other) {
            int packageCount = other.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                HistoricalPackageOps otherPackageOps = other.getPackageOpsAt(i);
                HistoricalPackageOps thisPackageOps = this.getPackageOps(otherPackageOps.getPackageName());
                if (thisPackageOps != null) {
                    thisPackageOps.merge(otherPackageOps);
                    continue;
                }
                if (this.mHistoricalPackageOps == null) {
                    this.mHistoricalPackageOps = new ArrayMap();
                }
                this.mHistoricalPackageOps.put(otherPackageOps.getPackageName(), otherPackageOps);
            }
        }

        private void filter(String packageName, String attributionTag, String[] opNames, int filter, double fractionToRemove) {
            int packageCount = this.getPackageCount();
            for (int i = packageCount - 1; i >= 0; --i) {
                HistoricalPackageOps packageOps = this.getPackageOpsAt(i);
                if ((filter & 2) != 0 && !packageName.equals(packageOps.getPackageName())) {
                    this.mHistoricalPackageOps.removeAt(i);
                    continue;
                }
                packageOps.filter(attributionTag, opNames, filter, fractionToRemove);
                if (packageOps.getAttributedOpsCount() != 0) continue;
                this.mHistoricalPackageOps.removeAt(i);
            }
        }

        private boolean isEmpty() {
            int packageCount = this.getPackageCount();
            for (int i = packageCount - 1; i >= 0; --i) {
                HistoricalPackageOps packageOps = this.mHistoricalPackageOps.valueAt(i);
                if (packageOps.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private void increaseAccessCount(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseAccessCount(opCode, attributionTag, uidState, flags, increment);
        }

        private void increaseRejectCount(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseRejectCount(opCode, attributionTag, uidState, flags, increment);
        }

        private void increaseAccessDuration(int opCode, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalPackageOps(packageName).increaseAccessDuration(opCode, attributionTag, uidState, flags, increment);
        }

        public int getUid() {
            return this.mUid;
        }

        public int getPackageCount() {
            if (this.mHistoricalPackageOps == null) {
                return 0;
            }
            return this.mHistoricalPackageOps.size();
        }

        public HistoricalPackageOps getPackageOpsAt(int index) {
            if (this.mHistoricalPackageOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalPackageOps.valueAt(index);
        }

        public HistoricalPackageOps getPackageOps(String packageName) {
            if (this.mHistoricalPackageOps == null) {
                return null;
            }
            return this.mHistoricalPackageOps.get(packageName);
        }

        private void clearHistory(String packageName) {
            if (this.mHistoricalPackageOps != null) {
                this.mHistoricalPackageOps.remove(packageName);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(this.mUid);
            parcel.writeTypedArrayMap(this.mHistoricalPackageOps, flags);
        }

        private void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalUidOps(this);
            int packageCount = this.getPackageCount();
            for (int i = 0; i < packageCount; ++i) {
                this.getPackageOpsAt(i).accept(visitor);
            }
        }

        private HistoricalPackageOps getOrCreateHistoricalPackageOps(String packageName) {
            HistoricalPackageOps historicalPackageOp;
            if (this.mHistoricalPackageOps == null) {
                this.mHistoricalPackageOps = new ArrayMap();
            }
            if ((historicalPackageOp = this.mHistoricalPackageOps.get(packageName)) == null) {
                historicalPackageOp = new HistoricalPackageOps(packageName);
                this.mHistoricalPackageOps.put(packageName, historicalPackageOp);
            }
            return historicalPackageOp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalUidOps other = (HistoricalUidOps)obj;
            if (this.mUid != other.mUid) {
                return false;
            }
            return !(this.mHistoricalPackageOps == null ? other.mHistoricalPackageOps != null : !this.mHistoricalPackageOps.equals(other.mHistoricalPackageOps));
        }

        public int hashCode() {
            int result = this.mUid;
            result = 31 * result + (this.mHistoricalPackageOps != null ? this.mHistoricalPackageOps.hashCode() : 0);
            return result;
        }
    }

    @SystemApi
    public static class HistoricalOps
    implements Parcelable {
        private long mBeginTimeMillis;
        private long mEndTimeMillis;
        private SparseArray<HistoricalUidOps> mHistoricalUidOps;
        public static final Parcelable.Creator<HistoricalOps> CREATOR = new Parcelable.Creator<HistoricalOps>(){

            @Override
            public HistoricalOps createFromParcel(Parcel parcel) {
                return new HistoricalOps(parcel);
            }

            public HistoricalOps[] newArray(int size) {
                return new HistoricalOps[size];
            }
        };

        public HistoricalOps(long beginTimeMillis, long endTimeMillis) {
            Preconditions.checkState(beginTimeMillis <= endTimeMillis);
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
        }

        public HistoricalOps(HistoricalOps other) {
            this.mBeginTimeMillis = other.mBeginTimeMillis;
            this.mEndTimeMillis = other.mEndTimeMillis;
            Preconditions.checkState(this.mBeginTimeMillis <= this.mEndTimeMillis);
            if (other.mHistoricalUidOps != null) {
                int opCount = other.getUidCount();
                for (int i = 0; i < opCount; ++i) {
                    HistoricalUidOps origOps = other.getUidOpsAt(i);
                    HistoricalUidOps clonedOps = new HistoricalUidOps(origOps);
                    if (this.mHistoricalUidOps == null) {
                        this.mHistoricalUidOps = new SparseArray(opCount);
                    }
                    this.mHistoricalUidOps.put(clonedOps.getUid(), clonedOps);
                }
            }
        }

        private HistoricalOps(Parcel parcel) {
            this.mBeginTimeMillis = parcel.readLong();
            this.mEndTimeMillis = parcel.readLong();
            int[] uids = parcel.createIntArray();
            if (!ArrayUtils.isEmpty(uids)) {
                List uidOps;
                ParceledListSlice listSlice = (ParceledListSlice)parcel.readParcelable(HistoricalOps.class.getClassLoader());
                List list = uidOps = listSlice != null ? listSlice.getList() : null;
                if (uidOps == null) {
                    return;
                }
                for (int i = 0; i < uids.length; ++i) {
                    if (this.mHistoricalUidOps == null) {
                        this.mHistoricalUidOps = new SparseArray();
                    }
                    this.mHistoricalUidOps.put(uids[i], (HistoricalUidOps)uidOps.get(i));
                }
            }
        }

        public HistoricalOps spliceFromBeginning(double splicePoint) {
            return this.splice(splicePoint, true);
        }

        public HistoricalOps spliceFromEnd(double fractionToRemove) {
            return this.splice(fractionToRemove, false);
        }

        private HistoricalOps splice(double fractionToRemove, boolean beginning) {
            long spliceEndTimeMills;
            long spliceBeginTimeMills;
            if (beginning) {
                spliceBeginTimeMills = this.mBeginTimeMillis;
                this.mBeginTimeMillis = spliceEndTimeMills = (long)((double)this.mBeginTimeMillis + (double)this.getDurationMillis() * fractionToRemove);
            } else {
                spliceBeginTimeMills = (long)((double)this.mEndTimeMillis - (double)this.getDurationMillis() * fractionToRemove);
                spliceEndTimeMills = this.mEndTimeMillis;
                this.mEndTimeMillis = spliceBeginTimeMills;
            }
            HistoricalOps splice = null;
            int uidCount = this.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                HistoricalUidOps origOps = this.getUidOpsAt(i);
                HistoricalUidOps spliceOps = origOps.splice(fractionToRemove);
                if (spliceOps == null) continue;
                if (splice == null) {
                    splice = new HistoricalOps(spliceBeginTimeMills, spliceEndTimeMills);
                }
                if (splice.mHistoricalUidOps == null) {
                    splice.mHistoricalUidOps = new SparseArray();
                }
                splice.mHistoricalUidOps.put(spliceOps.getUid(), spliceOps);
            }
            return splice;
        }

        public void merge(HistoricalOps other) {
            this.mBeginTimeMillis = Math.min(this.mBeginTimeMillis, other.mBeginTimeMillis);
            this.mEndTimeMillis = Math.max(this.mEndTimeMillis, other.mEndTimeMillis);
            int uidCount = other.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                HistoricalUidOps otherUidOps = other.getUidOpsAt(i);
                HistoricalUidOps thisUidOps = this.getUidOps(otherUidOps.getUid());
                if (thisUidOps != null) {
                    thisUidOps.merge(otherUidOps);
                    continue;
                }
                if (this.mHistoricalUidOps == null) {
                    this.mHistoricalUidOps = new SparseArray();
                }
                this.mHistoricalUidOps.put(otherUidOps.getUid(), otherUidOps);
            }
        }

        public void filter(int uid, String packageName, String attributionTag, String[] opNames, int filter, long beginTimeMillis, long endTimeMillis) {
            long durationMillis = this.getDurationMillis();
            this.mBeginTimeMillis = Math.max(this.mBeginTimeMillis, beginTimeMillis);
            this.mEndTimeMillis = Math.min(this.mEndTimeMillis, endTimeMillis);
            double scaleFactor = Math.min((double)(endTimeMillis - beginTimeMillis) / (double)durationMillis, 1.0);
            int uidCount = this.getUidCount();
            for (int i = uidCount - 1; i >= 0; --i) {
                HistoricalUidOps uidOp = this.mHistoricalUidOps.valueAt(i);
                if ((filter & 1) != 0 && uid != uidOp.getUid()) {
                    this.mHistoricalUidOps.removeAt(i);
                    continue;
                }
                uidOp.filter(packageName, attributionTag, opNames, filter, scaleFactor);
                if (uidOp.getPackageCount() != 0) continue;
                this.mHistoricalUidOps.removeAt(i);
            }
        }

        public boolean isEmpty() {
            if (this.getBeginTimeMillis() >= this.getEndTimeMillis()) {
                return true;
            }
            int uidCount = this.getUidCount();
            for (int i = uidCount - 1; i >= 0; --i) {
                HistoricalUidOps uidOp = this.mHistoricalUidOps.valueAt(i);
                if (uidOp.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public long getDurationMillis() {
            return this.mEndTimeMillis - this.mBeginTimeMillis;
        }

        public void increaseAccessCount(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseAccessCount(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void increaseRejectCount(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseRejectCount(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void increaseAccessDuration(int opCode, int uid, String packageName, String attributionTag, int uidState, int flags, long increment) {
            this.getOrCreateHistoricalUidOps(uid).increaseAccessDuration(opCode, packageName, attributionTag, uidState, flags, increment);
        }

        public void offsetBeginAndEndTime(long offsetMillis) {
            this.mBeginTimeMillis += offsetMillis;
            this.mEndTimeMillis += offsetMillis;
        }

        public void setBeginAndEndTime(long beginTimeMillis, long endTimeMillis) {
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
        }

        public void setBeginTime(long beginTimeMillis) {
            this.mBeginTimeMillis = beginTimeMillis;
        }

        public void setEndTime(long endTimeMillis) {
            this.mEndTimeMillis = endTimeMillis;
        }

        public long getBeginTimeMillis() {
            return this.mBeginTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.mEndTimeMillis;
        }

        public int getUidCount() {
            if (this.mHistoricalUidOps == null) {
                return 0;
            }
            return this.mHistoricalUidOps.size();
        }

        public HistoricalUidOps getUidOpsAt(int index) {
            if (this.mHistoricalUidOps == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mHistoricalUidOps.valueAt(index);
        }

        public HistoricalUidOps getUidOps(int uid) {
            if (this.mHistoricalUidOps == null) {
                return null;
            }
            return this.mHistoricalUidOps.get(uid);
        }

        public void clearHistory(int uid, String packageName) {
            HistoricalUidOps historicalUidOps = this.getOrCreateHistoricalUidOps(uid);
            historicalUidOps.clearHistory(packageName);
            if (historicalUidOps.isEmpty()) {
                this.mHistoricalUidOps.remove(uid);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeLong(this.mBeginTimeMillis);
            parcel.writeLong(this.mEndTimeMillis);
            if (this.mHistoricalUidOps != null) {
                int uidCount = this.mHistoricalUidOps.size();
                parcel.writeInt(uidCount);
                for (int i = 0; i < uidCount; ++i) {
                    parcel.writeInt(this.mHistoricalUidOps.keyAt(i));
                }
                ArrayList<HistoricalUidOps> opsList = new ArrayList<HistoricalUidOps>(uidCount);
                for (int i = 0; i < uidCount; ++i) {
                    opsList.add(this.mHistoricalUidOps.valueAt(i));
                }
                parcel.writeParcelable(new ParceledListSlice(opsList), flags);
            } else {
                parcel.writeInt(-1);
            }
        }

        public void accept(HistoricalOpsVisitor visitor) {
            visitor.visitHistoricalOps(this);
            int uidCount = this.getUidCount();
            for (int i = 0; i < uidCount; ++i) {
                this.getUidOpsAt(i).accept(visitor);
            }
        }

        private HistoricalUidOps getOrCreateHistoricalUidOps(int uid) {
            HistoricalUidOps historicalUidOp;
            if (this.mHistoricalUidOps == null) {
                this.mHistoricalUidOps = new SparseArray();
            }
            if ((historicalUidOp = this.mHistoricalUidOps.get(uid)) == null) {
                historicalUidOp = new HistoricalUidOps(uid);
                this.mHistoricalUidOps.put(uid, historicalUidOp);
            }
            return historicalUidOp;
        }

        public static double round(double value) {
            BigDecimal decimalScale = new BigDecimal(value);
            return decimalScale.setScale(0, RoundingMode.HALF_UP).doubleValue();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalOps other = (HistoricalOps)obj;
            if (this.mBeginTimeMillis != other.mBeginTimeMillis) {
                return false;
            }
            if (this.mEndTimeMillis != other.mEndTimeMillis) {
                return false;
            }
            return !(this.mHistoricalUidOps == null ? other.mHistoricalUidOps != null : !this.mHistoricalUidOps.equals(other.mHistoricalUidOps));
        }

        public int hashCode() {
            int result = (int)(this.mBeginTimeMillis ^ this.mBeginTimeMillis >>> 32);
            result = 31 * result + this.mHistoricalUidOps.hashCode();
            return result;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[from:" + this.mBeginTimeMillis + " to:" + this.mEndTimeMillis + "]";
        }
    }

    @SystemApi
    @Immutable
    public static class HistoricalOpsRequest {
        private final int mUid;
        private final String mPackageName;
        private final String mAttributionTag;
        private final List<String> mOpNames;
        private final int mFilter;
        private final long mBeginTimeMillis;
        private final long mEndTimeMillis;
        private final int mFlags;

        private HistoricalOpsRequest(int uid, String packageName, String attributionTag, List<String> opNames, int filter, long beginTimeMillis, long endTimeMillis, int flags) {
            this.mUid = uid;
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
            this.mOpNames = opNames;
            this.mFilter = filter;
            this.mBeginTimeMillis = beginTimeMillis;
            this.mEndTimeMillis = endTimeMillis;
            this.mFlags = flags;
        }

        @SystemApi
        public static class Builder {
            private int mUid = -1;
            private String mPackageName;
            private String mAttributionTag;
            private List<String> mOpNames;
            private int mFilter;
            private final long mBeginTimeMillis;
            private final long mEndTimeMillis;
            private int mFlags = 31;

            public Builder(long beginTimeMillis, long endTimeMillis) {
                Preconditions.checkArgument(beginTimeMillis >= 0L && beginTimeMillis < endTimeMillis, "beginTimeMillis must be non negative and lesser than endTimeMillis");
                this.mBeginTimeMillis = beginTimeMillis;
                this.mEndTimeMillis = endTimeMillis;
            }

            public Builder setUid(int uid) {
                Preconditions.checkArgument(uid == -1 || uid >= 0, "uid must be -1 or non negative");
                this.mUid = uid;
                this.mFilter = uid == -1 ? (this.mFilter &= 0xFFFFFFFE) : (this.mFilter |= 1);
                return this;
            }

            public Builder setPackageName(String packageName) {
                this.mPackageName = packageName;
                this.mFilter = packageName == null ? (this.mFilter &= 0xFFFFFFFD) : (this.mFilter |= 2);
                return this;
            }

            public Builder setAttributionTag(String attributionTag) {
                this.mAttributionTag = attributionTag;
                this.mFilter |= 4;
                return this;
            }

            public Builder setOpNames(List<String> opNames) {
                if (opNames != null) {
                    int opCount = opNames.size();
                    for (int i = 0; i < opCount; ++i) {
                        Preconditions.checkArgument(AppOpsManager.strOpToOp(opNames.get(i)) != -1);
                    }
                }
                this.mOpNames = opNames;
                this.mFilter = this.mOpNames == null ? (this.mFilter &= 0xFFFFFFF7) : (this.mFilter |= 8);
                return this;
            }

            public Builder setFlags(int flags) {
                Preconditions.checkFlagsArgument(flags, 31);
                this.mFlags = flags;
                return this;
            }

            public HistoricalOpsRequest build() {
                return new HistoricalOpsRequest(this.mUid, this.mPackageName, this.mAttributionTag, this.mOpNames, this.mFilter, this.mBeginTimeMillis, this.mEndTimeMillis, this.mFlags);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HistoricalOpsRequestFilter {
    }

    public static interface HistoricalOpsVisitor {
        public void visitHistoricalOps(HistoricalOps var1);

        public void visitHistoricalUidOps(HistoricalUidOps var1);

        public void visitHistoricalPackageOps(HistoricalPackageOps var1);

        public void visitHistoricalAttributionOps(AttributedHistoricalOps var1);

        public void visitHistoricalOp(HistoricalOp var1);
    }

    @SystemApi
    @Immutable
    public static class OpEntry
    implements Parcelable {
        private final int mOp;
        private final int mMode;
        private final Map<String, AttributedOpEntry> mAttributedOpEntries;
        public static final Parcelable.Creator<OpEntry> CREATOR = new Parcelable.Creator<OpEntry>(){

            public OpEntry[] newArray(int size) {
                return new OpEntry[size];
            }

            @Override
            public OpEntry createFromParcel(Parcel in) {
                return new OpEntry(in);
            }
        };

        @UnsupportedAppUsage(publicAlternatives="{@code #getOpStr()}")
        public int getOp() {
            return this.mOp;
        }

        public String getOpStr() {
            return sOpToString[this.mOp];
        }

        @Deprecated
        @UnsupportedAppUsage(publicAlternatives="{@code #getLastAccessTime(int)}")
        public long getTime() {
            return this.getLastAccessTime(31);
        }

        public long getLastAccessTime(int flags) {
            return this.getLastAccessTime(100, 700, flags);
        }

        public long getLastAccessForegroundTime(int flags) {
            return this.getLastAccessTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastAccessBackgroundTime(int flags) {
            return this.getLastAccessTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastAccessEvent(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastAccessEvent = null;
            for (AttributedOpEntry attributionEntry : this.mAttributedOpEntries.values()) {
                NoteOpEvent lastAttributionAccessEvent = attributionEntry.getLastAccessEvent(fromUidState, toUidState, flags);
                if (lastAccessEvent != null && (lastAttributionAccessEvent == null || lastAttributionAccessEvent.getNoteTime() <= lastAccessEvent.getNoteTime())) continue;
                lastAccessEvent = lastAttributionAccessEvent;
            }
            return lastAccessEvent;
        }

        public long getLastAccessTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        @Deprecated
        @UnsupportedAppUsage(publicAlternatives="{@code #getLastRejectTime(int)}")
        public long getRejectTime() {
            return this.getLastRejectTime(31);
        }

        public long getLastRejectTime(int flags) {
            return this.getLastRejectTime(100, 700, flags);
        }

        public long getLastRejectForegroundTime(int flags) {
            return this.getLastRejectTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastRejectBackgroundTime(int flags) {
            return this.getLastRejectTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastRejectEvent(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastAccessEvent = null;
            for (AttributedOpEntry attributionEntry : this.mAttributedOpEntries.values()) {
                NoteOpEvent lastAttributionAccessEvent = attributionEntry.getLastRejectEvent(fromUidState, toUidState, flags);
                if (lastAccessEvent != null && (lastAttributionAccessEvent == null || lastAttributionAccessEvent.getNoteTime() <= lastAccessEvent.getNoteTime())) continue;
                lastAccessEvent = lastAttributionAccessEvent;
            }
            return lastAccessEvent;
        }

        public long getLastRejectTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastRejectEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public boolean isRunning() {
            for (AttributedOpEntry opAttributionEntry : this.mAttributedOpEntries.values()) {
                if (!opAttributionEntry.isRunning()) continue;
                return true;
            }
            return false;
        }

        @Deprecated
        public long getDuration() {
            return this.getLastDuration(31);
        }

        public long getLastDuration(int flags) {
            return this.getLastDuration(100, 700, flags);
        }

        public long getLastForegroundDuration(int flags) {
            return this.getLastDuration(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastBackgroundDuration(int flags) {
            return this.getLastDuration(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getLastDuration(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getDuration();
        }

        @Deprecated
        public int getProxyUid() {
            OpEventProxyInfo proxy = this.getLastProxyInfo(31);
            if (proxy == null) {
                return -1;
            }
            return proxy.getUid();
        }

        @Deprecated
        public int getProxyUid(int uidState, int flags) {
            OpEventProxyInfo proxy = this.getLastProxyInfo(uidState, uidState, flags);
            if (proxy == null) {
                return -1;
            }
            return proxy.getUid();
        }

        @Deprecated
        public String getProxyPackageName() {
            OpEventProxyInfo proxy = this.getLastProxyInfo(31);
            if (proxy == null) {
                return null;
            }
            return proxy.getPackageName();
        }

        @Deprecated
        public String getProxyPackageName(int uidState, int flags) {
            OpEventProxyInfo proxy = this.getLastProxyInfo(uidState, uidState, flags);
            if (proxy == null) {
                return null;
            }
            return proxy.getPackageName();
        }

        public OpEventProxyInfo getLastProxyInfo(int flags) {
            return this.getLastProxyInfo(100, 700, flags);
        }

        public OpEventProxyInfo getLastForegroundProxyInfo(int flags) {
            return this.getLastProxyInfo(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public OpEventProxyInfo getLastBackgroundProxyInfo(int flags) {
            return this.getLastProxyInfo(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public OpEventProxyInfo getLastProxyInfo(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return null;
            }
            return lastEvent.getProxy();
        }

        public OpEntry(int op, int mode, Map<String, AttributedOpEntry> attributedOpEntries) {
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 99L);
            this.mMode = mode;
            AnnotationValidations.validate(Mode.class, null, this.mMode);
            this.mAttributedOpEntries = attributedOpEntries;
            AnnotationValidations.validate(NonNull.class, null, this.mAttributedOpEntries);
        }

        public int getMode() {
            return this.mMode;
        }

        public Map<String, AttributedOpEntry> getAttributedOpEntries() {
            return this.mAttributedOpEntries;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mOp);
            dest.writeInt(this.mMode);
            dest.writeMap(this.mAttributedOpEntries);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        OpEntry(Parcel in) {
            int op = in.readInt();
            int mode = in.readInt();
            LinkedHashMap<String, AttributedOpEntry> attributions = new LinkedHashMap<String, AttributedOpEntry>();
            in.readMap(attributions, AttributedOpEntry.class.getClassLoader());
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 99L);
            this.mMode = mode;
            AnnotationValidations.validate(Mode.class, null, this.mMode);
            this.mAttributedOpEntries = attributions;
            AnnotationValidations.validate(NonNull.class, null, this.mAttributedOpEntries);
        }
    }

    @SystemApi
    @Immutable
    public static class AttributedOpEntry
    implements Parcelable {
        private final int mOp;
        private final boolean mRunning;
        private final LongSparseArray<NoteOpEvent> mAccessEvents;
        private final LongSparseArray<NoteOpEvent> mRejectEvents;
        static Parcelling<LongSparseArray<NoteOpEvent>> sParcellingForAccessEvents = Parcelling.Cache.get(LongSparseArrayParceling.class);
        static Parcelling<LongSparseArray<NoteOpEvent>> sParcellingForRejectEvents;
        public static final Parcelable.Creator<AttributedOpEntry> CREATOR;

        public ArraySet<Long> collectKeys() {
            int i;
            int numEvents;
            ArraySet<Long> keys = new ArraySet<Long>();
            if (this.mAccessEvents != null) {
                numEvents = this.mAccessEvents.size();
                for (i = 0; i < numEvents; ++i) {
                    keys.add(this.mAccessEvents.keyAt(i));
                }
            }
            if (this.mRejectEvents != null) {
                numEvents = this.mRejectEvents.size();
                for (i = 0; i < numEvents; ++i) {
                    keys.add(this.mRejectEvents.keyAt(i));
                }
            }
            return keys;
        }

        public long getLastAccessTime(int flags) {
            return this.getLastAccessTime(100, 700, flags);
        }

        public long getLastAccessForegroundTime(int flags) {
            return this.getLastAccessTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastAccessBackgroundTime(int flags) {
            return this.getLastAccessTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastAccessEvent(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.getLastEvent(this.mAccessEvents, fromUidState, toUidState, flags);
        }

        public long getLastAccessTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public long getLastRejectTime(int flags) {
            return this.getLastRejectTime(100, 700, flags);
        }

        public long getLastRejectForegroundTime(int flags) {
            return this.getLastRejectTime(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastRejectBackgroundTime(int flags) {
            return this.getLastRejectTime(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        private NoteOpEvent getLastRejectEvent(int fromUidState, int toUidState, int flags) {
            return AppOpsManager.getLastEvent(this.mRejectEvents, fromUidState, toUidState, flags);
        }

        public long getLastRejectTime(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastRejectEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getNoteTime();
        }

        public long getLastDuration(int flags) {
            return this.getLastDuration(100, 700, flags);
        }

        public long getLastForegroundDuration(int flags) {
            return this.getLastDuration(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public long getLastBackgroundDuration(int flags) {
            return this.getLastDuration(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public long getLastDuration(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return -1L;
            }
            return lastEvent.getDuration();
        }

        public OpEventProxyInfo getLastProxyInfo(int flags) {
            return this.getLastProxyInfo(100, 700, flags);
        }

        public OpEventProxyInfo getLastForegroundProxyInfo(int flags) {
            return this.getLastProxyInfo(100, AppOpsManager.resolveFirstUnrestrictedUidState(this.mOp), flags);
        }

        public OpEventProxyInfo getLastBackgroundProxyInfo(int flags) {
            return this.getLastProxyInfo(AppOpsManager.resolveLastRestrictedUidState(this.mOp), 700, flags);
        }

        public OpEventProxyInfo getLastProxyInfo(int fromUidState, int toUidState, int flags) {
            NoteOpEvent lastEvent = this.getLastAccessEvent(fromUidState, toUidState, flags);
            if (lastEvent == null) {
                return null;
            }
            return lastEvent.getProxy();
        }

        public AttributedOpEntry(int op, boolean running, LongSparseArray<NoteOpEvent> accessEvents, LongSparseArray<NoteOpEvent> rejectEvents) {
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 99L);
            this.mRunning = running;
            this.mAccessEvents = accessEvents;
            this.mRejectEvents = rejectEvents;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mRunning) {
                flg = (byte)(flg | 2);
            }
            if (this.mAccessEvents != null) {
                flg = (byte)(flg | 4);
            }
            if (this.mRejectEvents != null) {
                flg = (byte)(flg | 8);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mOp);
            sParcellingForAccessEvents.parcel(this.mAccessEvents, dest, flags);
            sParcellingForRejectEvents.parcel(this.mRejectEvents, dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        AttributedOpEntry(Parcel in) {
            byte flg = in.readByte();
            boolean running = (flg & 2) != 0;
            int op = in.readInt();
            LongSparseArray<NoteOpEvent> accessEvents = sParcellingForAccessEvents.unparcel(in);
            LongSparseArray<NoteOpEvent> rejectEvents = sParcellingForRejectEvents.unparcel(in);
            this.mOp = op;
            AnnotationValidations.validate(IntRange.class, null, this.mOp, "from", 0L, "to", 99L);
            this.mRunning = running;
            this.mAccessEvents = accessEvents;
            this.mRejectEvents = rejectEvents;
        }

        static {
            if (sParcellingForAccessEvents == null) {
                sParcellingForAccessEvents = Parcelling.Cache.put(new LongSparseArrayParceling());
            }
            if ((sParcellingForRejectEvents = Parcelling.Cache.get(LongSparseArrayParceling.class)) == null) {
                sParcellingForRejectEvents = Parcelling.Cache.put(new LongSparseArrayParceling());
            }
            CREATOR = new Parcelable.Creator<AttributedOpEntry>(){

                public AttributedOpEntry[] newArray(int size) {
                    return new AttributedOpEntry[size];
                }

                @Override
                public AttributedOpEntry createFromParcel(Parcel in) {
                    return new AttributedOpEntry(in);
                }
            };
        }

        private static class LongSparseArrayParceling
        implements Parcelling<LongSparseArray<NoteOpEvent>> {
            private LongSparseArrayParceling() {
            }

            @Override
            public void parcel(LongSparseArray<NoteOpEvent> array2, Parcel dest, int parcelFlags) {
                if (array2 == null) {
                    dest.writeInt(-1);
                    return;
                }
                int numEntries = array2.size();
                dest.writeInt(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    dest.writeLong(array2.keyAt(i));
                    dest.writeParcelable(array2.valueAt(i), parcelFlags);
                }
            }

            @Override
            public LongSparseArray<NoteOpEvent> unparcel(Parcel source) {
                int numEntries = source.readInt();
                if (numEntries == -1) {
                    return null;
                }
                LongSparseArray<NoteOpEvent> array2 = new LongSparseArray<NoteOpEvent>(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    array2.put(source.readLong(), (NoteOpEvent)source.readParcelable(null));
                }
                return array2;
            }
        }
    }

    public static class NoteOpEvent
    implements Parcelable {
        private long mNoteTime;
        private long mDuration;
        private OpEventProxyInfo mProxy;
        public static final Parcelable.Creator<NoteOpEvent> CREATOR = new Parcelable.Creator<NoteOpEvent>(){

            public NoteOpEvent[] newArray(int size) {
                return new NoteOpEvent[size];
            }

            @Override
            public NoteOpEvent createFromParcel(Parcel in) {
                return new NoteOpEvent(in);
            }
        };

        public void reinit(long noteTime, long duration, OpEventProxyInfo proxy, Pools.Pool<OpEventProxyInfo> proxyPool) {
            this.mNoteTime = Preconditions.checkArgumentNonnegative(noteTime);
            this.mDuration = Preconditions.checkArgumentInRange(duration, -1L, Long.MAX_VALUE, "duration");
            if (this.mProxy != null) {
                proxyPool.release(this.mProxy);
            }
            this.mProxy = proxy;
        }

        public NoteOpEvent(NoteOpEvent original) {
            this(original.mNoteTime, original.mDuration, original.mProxy != null ? new OpEventProxyInfo(original.mProxy) : null);
        }

        public NoteOpEvent(long noteTime, long duration, OpEventProxyInfo proxy) {
            this.mNoteTime = noteTime;
            AnnotationValidations.validate(IntRange.class, null, this.mNoteTime, "from", 0L);
            this.mDuration = duration;
            AnnotationValidations.validate(IntRange.class, null, this.mDuration, "from", -1L);
            this.mProxy = proxy;
        }

        public long getNoteTime() {
            return this.mNoteTime;
        }

        public long getDuration() {
            return this.mDuration;
        }

        public OpEventProxyInfo getProxy() {
            return this.mProxy;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mProxy != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeLong(this.mNoteTime);
            dest.writeLong(this.mDuration);
            if (this.mProxy != null) {
                dest.writeTypedObject(this.mProxy, flags);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        NoteOpEvent(Parcel in) {
            byte flg = in.readByte();
            long noteTime = in.readLong();
            long duration = in.readLong();
            OpEventProxyInfo proxy = (flg & 4) == 0 ? null : in.readTypedObject(OpEventProxyInfo.CREATOR);
            this.mNoteTime = noteTime;
            AnnotationValidations.validate(IntRange.class, null, this.mNoteTime, "from", 0L);
            this.mDuration = duration;
            AnnotationValidations.validate(IntRange.class, null, this.mDuration, "from", -1L);
            this.mProxy = proxy;
        }
    }

    @SystemApi
    public static class OpEventProxyInfo
    implements Parcelable {
        private int mUid;
        private String mPackageName;
        private String mAttributionTag;
        public static final Parcelable.Creator<OpEventProxyInfo> CREATOR = new Parcelable.Creator<OpEventProxyInfo>(){

            public OpEventProxyInfo[] newArray(int size) {
                return new OpEventProxyInfo[size];
            }

            @Override
            public OpEventProxyInfo createFromParcel(Parcel in) {
                return new OpEventProxyInfo(in);
            }
        };

        public void reinit(int uid, String packageName, String attributionTag) {
            this.mUid = Preconditions.checkArgumentNonnegative(uid);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }

        public OpEventProxyInfo(int uid, String packageName, String attributionTag) {
            this.mUid = uid;
            AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }

        public OpEventProxyInfo(OpEventProxyInfo orig) {
            this.mUid = orig.mUid;
            this.mPackageName = orig.mPackageName;
            this.mAttributionTag = orig.mAttributionTag;
        }

        public int getUid() {
            return this.mUid;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            byte flg = 0;
            if (this.mPackageName != null) {
                flg = (byte)(flg | 2);
            }
            if (this.mAttributionTag != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mUid);
            if (this.mPackageName != null) {
                dest.writeString(this.mPackageName);
            }
            if (this.mAttributionTag != null) {
                dest.writeString(this.mAttributionTag);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        OpEventProxyInfo(Parcel in) {
            byte flg = in.readByte();
            int uid = in.readInt();
            String packageName = (flg & 2) == 0 ? null : in.readString();
            String attributionTag = (flg & 4) == 0 ? null : in.readString();
            this.mUid = uid;
            AnnotationValidations.validate(IntRange.class, null, this.mUid, "from", 0L);
            this.mPackageName = packageName;
            this.mAttributionTag = attributionTag;
        }
    }

    @SystemApi
    public static class PackageOps
    implements Parcelable {
        private final String mPackageName;
        private final int mUid;
        private final List<OpEntry> mEntries;
        public static final Parcelable.Creator<PackageOps> CREATOR = new Parcelable.Creator<PackageOps>(){

            @Override
            public PackageOps createFromParcel(Parcel source) {
                return new PackageOps(source);
            }

            public PackageOps[] newArray(int size) {
                return new PackageOps[size];
            }
        };

        @UnsupportedAppUsage
        public PackageOps(String packageName, int uid, List<OpEntry> entries) {
            this.mPackageName = packageName;
            this.mUid = uid;
            this.mEntries = entries;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public int getUid() {
            return this.mUid;
        }

        public List<OpEntry> getOps() {
            return this.mEntries;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mPackageName);
            dest.writeInt(this.mUid);
            dest.writeInt(this.mEntries.size());
            for (int i = 0; i < this.mEntries.size(); ++i) {
                this.mEntries.get(i).writeToParcel(dest, flags);
            }
        }

        PackageOps(Parcel source) {
            this.mPackageName = source.readString();
            this.mUid = source.readInt();
            this.mEntries = new ArrayList<OpEntry>();
            int N = source.readInt();
            for (int i = 0; i < N; ++i) {
                this.mEntries.add(OpEntry.CREATOR.createFromParcel(source));
            }
        }
    }

    public static class RestrictionBypass {
        public boolean isPrivileged;
        public boolean isRecordAudioRestrictionExcept;
        public static RestrictionBypass UNRESTRICTED = new RestrictionBypass(true, true);

        public RestrictionBypass(boolean isPrivileged, boolean isRecordAudioRestrictionExcept) {
            this.isPrivileged = isPrivileged;
            this.isRecordAudioRestrictionExcept = isRecordAudioRestrictionExcept;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ShouldCollectNoteOp {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    public static @interface DataBucketKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SamplingStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OpFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UidState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HistoricalMode {
    }
}

