/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.compat.Compatibility;
import android.os.Process;
import com.android.internal.compat.ChangeReporter;
import java.util.Arrays;

public class AppCompatCallbacks
extends Compatibility.Callbacks {
    private final long[] mDisabledChanges;
    private final ChangeReporter mChangeReporter;

    public static void install(long[] disabledChanges) {
        Compatibility.setCallbacks(new AppCompatCallbacks(disabledChanges));
    }

    private AppCompatCallbacks(long[] disabledChanges) {
        this.mDisabledChanges = Arrays.copyOf(disabledChanges, disabledChanges.length);
        Arrays.sort(this.mDisabledChanges);
        this.mChangeReporter = new ChangeReporter(1);
    }

    @Override
    protected void reportChange(long changeId) {
        this.reportChange(changeId, 3);
    }

    @Override
    protected boolean isChangeEnabled(long changeId) {
        if (Arrays.binarySearch(this.mDisabledChanges, changeId) < 0) {
            this.reportChange(changeId, 1);
            return true;
        }
        this.reportChange(changeId, 2);
        return false;
    }

    private void reportChange(long changeId, int state) {
        int uid = Process.myUid();
        this.mChangeReporter.reportChange(uid, changeId, state);
    }
}

