/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.gradle;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTrackerSettings;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmValidationUtil;

public final class ImportGradleProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%importGradleProject";

    public ImportGradleProjectCommand(@NotNull String text, int line) {
        if (text == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        this.runWhenGradleImportAndIndexingFinished(context, () -> ImportGradleProjectCommand.lambda$_execute$0((ActionCallback)actionCallback));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private void runWhenGradleImportAndIndexingFinished(@NotNull PlaybackContext context, @NotNull Runnable runnable) {
        if (context == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(4);
        }
        Project project = context.getProject();
        ExternalSystemProjectTrackerSettings projectTrackerSettings = ExternalSystemProjectTrackerSettings.getInstance((Project)project);
        ExternalSystemProjectTrackerSettings.AutoReloadType currentAutoReloadType = projectTrackerSettings.getAutoReloadType();
        projectTrackerSettings.setAutoReloadType(ExternalSystemProjectTrackerSettings.AutoReloadType.NONE);
        context.message("Waiting for open and initialized Gradle project", this.getLine());
        ExternalProjectsManagerImpl.getInstance((Project)project).runWhenInitialized(() -> DumbService.getInstance((Project)project).runWhenSmart(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.waitForCurrentResolveTasks(context, project).thenAsync(o -> {
            context.message("Import of the project has been started", this.getLine());
            AsyncPromise promise = new AsyncPromise();
            GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
            this.linkGradleProjectIfNeeded(project, context, gradleSettings).onError(throwable -> promise.setError(throwable)).onSuccess(unused -> this.doGradleSync(project, context, (AsyncPromise<Void>)promise, gradleSettings));
            return promise;
        }).onProcessed(promise -> {
            context.message("Import has been finished", this.getLine());
            projectTrackerSettings.setAutoReloadType(currentAutoReloadType);
            DumbService.getInstance((Project)project).runWhenSmart(DisposeAwareRunnable.create((Runnable)runnable, (Project)project));
        }))));
    }

    private Promise<?> waitForCurrentResolveTasks(@NotNull PlaybackContext context, @NotNull Project project) {
        if (context == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(6);
        }
        AsyncPromise promise = new AsyncPromise();
        context.message("Waiting for current import resolve tasks", this.getLine());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ApplicationManager.getApplication().getService(ExternalSystemProcessingManager.class);
            while (processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project)) {
                Object lock;
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            promise.setResult(null);
        });
        return promise.onProcessed(o -> context.message("Import resolve tasks has been completed", this.getLine()));
    }

    private void doGradleSync(final @NotNull Project project, final @NotNull PlaybackContext context, final @NotNull AsyncPromise<Void> promise, @NotNull GradleSettings gradleSettings) {
        if (project == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(7);
        }
        if (context == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(8);
        }
        if (promise == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(9);
        }
        if (gradleSettings == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(10);
        }
        Collection projectsSettings = gradleSettings.getLinkedProjectsSettings();
        final List projectsPaths = ContainerUtil.map((Collection)projectsSettings, ExternalProjectSettings::getExternalProjectPath);
        final AtomicInteger gradleProjectsToRefreshCount = new AtomicInteger(projectsSettings.size());
        final StringBuilder projectsWithResolveErrors = new StringBuilder();
        for (final GradleProjectSettings settings : projectsSettings) {
            final ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
            importSpecBuilder.callback(new ExternalProjectRefreshCallback(){
                private final ImportSpecBuilder.DefaultProjectRefreshCallback defaultCallback;
                {
                    this.defaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback(importSpecBuilder.build());
                }

                public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                    assert (externalProject != null);
                    context.message("Gradle resolve finished for: " + ((ProjectData)externalProject.getData()).getLinkedExternalProjectPath(), ImportGradleProjectCommand.this.getLine());
                    final SimpleMessageBusConnection connection = project.getMessageBus().simpleConnect();
                    connection.subscribe(ProjectDataImportListener.TOPIC, (Object)new ProjectDataImportListener(){

                        public void onImportFinished(String projectPath) {
                            this._onImportFinished(projectPath);
                        }

                        public void onImportFailed(String projectPath) {
                            this._onImportFinished(projectPath);
                        }

                        private void _onImportFinished(String projectPath) {
                            if (!projectsPaths.contains(projectPath)) {
                                return;
                            }
                            connection.disconnect();
                            if (gradleProjectsToRefreshCount.decrementAndGet() == 0) {
                                ApplicationManager.getApplication().invokeLater(() -> promise.setResult(null));
                            }
                        }
                    });
                    this.defaultCallback.onSuccess(externalProject);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                    if (errorMessage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    context.error("Gradle resolve failed for: " + settings.getExternalProjectPath(), ImportGradleProjectCommand.this.getLine());
                    StringBuilder stringBuilder = projectsWithResolveErrors;
                    synchronized (stringBuilder) {
                        if (projectsWithResolveErrors.length() != 0) {
                            projectsWithResolveErrors.append(", ");
                        }
                        projectsWithResolveErrors.append(String.format("'%s'", new File(settings.getExternalProjectPath()).getName()));
                    }
                    this.defaultCallback.onFailure(errorMessage, errorDetails);
                    if (gradleProjectsToRefreshCount.decrementAndGet() == 0) {
                        ApplicationManager.getApplication().invokeLater(() -> promise.setError(projectsWithResolveErrors.toString()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/jetbrains/performancePlugin/gradle/ImportGradleProjectCommand$1", "onFailure"));
                }
            });
            ExternalSystemUtil.refreshProject((String)settings.getExternalProjectPath(), (ImportSpecBuilder)importSpecBuilder);
        }
    }

    private Promise<Void> linkGradleProjectIfNeeded(@NotNull Project project, @NotNull PlaybackContext context, @NotNull GradleSettings gradleSettings) {
        if (project == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(12);
        }
        if (gradleSettings == null) {
            ImportGradleProjectCommand.$$$reportNull$$$0(13);
        }
        if (gradleSettings.getLinkedProjectsSettings().isEmpty()) {
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
            assert (projectDir != null);
            Object[] children = projectDir.getChildren();
            boolean isGradleProject = ContainerUtil.exists((Object[])children, file -> GradleConstants.KNOWN_GRADLE_FILES.contains(file.getName()));
            if (!isGradleProject) {
                context.error("Unable to find Gradle project at " + projectDir.getPath(), this.getLine());
                context.message("Files found at the path: " + Arrays.toString(ContainerUtil.map2Array((Object[])children, VirtualFile::getName)), this.getLine());
                return Promises.rejectedPromise();
            }
            GradleProjectSettings projectSettings = new GradleProjectSettings();
            GradleProjectImportUtil.setupGradleSettings((GradleSettings)gradleSettings);
            Path projectDirectory = projectDir.toNioPath();
            GradleProjectImportUtil.setupGradleProjectSettings((GradleProjectSettings)projectSettings, (Project)project, (Path)projectDirectory);
            GradleVersion gradleVersion = GradleJvmResolutionUtil.suggestGradleVersion((Project)project);
            if (gradleVersion != null) {
                GradleJvmResolutionUtil.setupGradleJvm((Project)project, (GradleProjectSettings)projectSettings, (GradleVersion)gradleVersion);
                GradleJvmValidationUtil.validateJavaHome((Project)project, (Path)projectDirectory, (GradleVersion)gradleVersion);
            }
            AsyncPromise promise = new AsyncPromise();
            ApplicationManager.getApplication().invokeLater(() -> {
                gradleSettings.linkProject((ExternalProjectSettings)projectSettings);
                promise.setResult(null);
            });
            return promise;
        }
        return Promises.resolvedPromise();
    }

    private static /* synthetic */ void lambda$_execute$0(ActionCallback actionCallback) {
        actionCallback.setDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/gradle/ImportGradleProjectCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/gradle/ImportGradleProjectCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runWhenGradleImportAndIndexingFinished";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitForCurrentResolveTasks";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doGradleSync";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "linkGradleProjectIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

