/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.security;

import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.security.Http2HttpsQuickFix;
import com.intellij.httpClient.http.security.HttpUrlsUsageInspection;
import com.intellij.httpClient.http.security.IgnoreUrlQuickFix;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.text.StringTokenizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 =2\u00020\u0001:\u0003=>?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\u00020\u00052\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u001dH\u0002J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u000203H\u0002J,\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0002J\u0010\u00109\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u001dH\u0002J2\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\u0006\u0010;\u001a\u00020\u00052\u0006\u0010/\u001a\u0002032\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0002J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "defaultIgnoredUrls", "", "", "ignoreComments", "", "ignoreIpAddresses", "ignoredUrls", "", "withTldOnly", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createCheckboxPanel", "Ljavax/swing/JPanel;", "createOptionsPanel", "Ljavax/swing/JComponent;", "createUrlListPanel", "decodeLiteralValue", "escaper", "Lcom/intellij/psi/LiteralTextEscaper;", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "wholeRange", "Lcom/intellij/openapi/util/TextRange;", "findUrl", "Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;", "literalFragment", "Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "getLiteralFragments", "injectionHost", "xmlAttributeValue", "Lcom/intellij/psi/xml/XmlAttributeValue;", "getOffsetMapper", "Lkotlin/Function1;", "", "attributeValue", "getQuickFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "urlFragment", "(Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;)[Lcom/intellij/codeInspection/LocalQuickFix;", "hasInjectedRegexp", "hasNonPublicTld", "host", "isIpAddressIgnored", "mayContainHttpSchema", "element", "Lcom/intellij/psi/PsiElement;", "nextLinkLiteral", "tokenizer", "Lcom/intellij/util/text/StringTokenizer;", "psiElement", "offsetMap", "shouldReport", "splitLiterals", "literal", "tldIgnored", "Companion", "LiteralFragment", "UrlFragment", "intellij.restClient"})
public final class HttpUrlsUsageInspection
extends LocalInspectionTool {
    private final List<String> defaultIgnoredUrls = CollectionsKt.listOf((Object[])new String[]{"http://localhost", "http://127.0.0.1", "http://0.0.0.0", "http://www.w3.org/", "http://json-schema.org/draft", "http://java.sun.com/", "http://xmlns.jcp.org/", "http://javafx.com/javafx/", "http://javafx.com/fxml", "http://maven.apache.org/xsd/", "http://maven.apache.org/POM/", "http://www.springframework.org/schema/", "http://www.springframework.org/tags", "http://www.springframework.org/security/tags", "http://www.thymeleaf.org", "http://www.jboss.org/j2ee/schema/", "http://www.jboss.com/xml/ns/", "http://www.ibm.com/webservices/xsd", "http://activemq.apache.org/schema/", "http://schema.cloudfoundry.org/spring/", "http://schemas.xmlsoap.org/", "http://cxf.apache.org/schemas/", "http://primefaces.org/ui", "http://tiles.apache.org/"});
    @JvmField
    public boolean ignoreComments = true;
    @JvmField
    public boolean withTldOnly = true;
    @JvmField
    public boolean ignoreIpAddresses = true;
    @JvmField
    @NotNull
    public final List<String> ignoredUrls = new ArrayList(this.defaultIgnoredUrls);
    @NotNull
    public static final String HTTP_PREFIX = "http://";
    @NotNull
    public static final String HTTPS_PREFIX = "https://";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ HttpUrlsUsageInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                List list;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (this.this$0.ignoreComments && element instanceof PsiComment) {
                    return;
                }
                if (element.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) {
                    return;
                }
                PsiElement psiElement = element;
                if (psiElement instanceof XmlAttributeValue) {
                    list = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (XmlAttributeValue)element);
                } else if (psiElement instanceof PsiLanguageInjectionHost) {
                    list = HttpUrlsUsageInspection.access$getLiteralFragments(this.this$0, (PsiLanguageInjectionHost)element);
                } else {
                    return;
                }
                List literals = list;
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)literals), (Function1)((Function1)new Function1<LiteralFragment, UrlFragment>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    @Nullable
                    public final UrlFragment invoke(@NotNull LiteralFragment it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return HttpUrlsUsageInspection.access$findUrl(this.this$0.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })), (Function1)((Function1)new Function1<UrlFragment, Boolean>(this){
                    final /* synthetic */ buildVisitor.1 this$0;

                    public final boolean invoke(@NotNull UrlFragment it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return HttpUrlsUsageInspection.access$shouldReport(this.this$0.this$0, it);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    UrlFragment it = (UrlFragment)element$iv;
                    boolean bl = false;
                    LocalQuickFix[] localQuickFixArray = HttpUrlsUsageInspection.access$getQuickFixes(this.this$0, it);
                    this.$holder.registerProblem(it.getHostElement(), it.getSchemaRangeInHost(), RestClientBundle.message("inspection.template", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final boolean shouldReport(UrlFragment urlFragment) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.ignoredUrls;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)urlFragment.getWholeUrl(), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && !this.tldIgnored(urlFragment) && !this.isIpAddressIgnored(urlFragment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean tldIgnored(UrlFragment urlFragment) {
        if (!this.withTldOnly) return false;
        URL uRL = urlFragment.getUrl();
        if (uRL == null) return false;
        String string = uRL.getHost();
        if (string == null) return false;
        String string2 = urlFragment.getUrl().getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"urlFragment.url.host");
        if (!this.hasNonPublicTld(string2)) return false;
        return true;
    }

    private final boolean hasNonPublicTld(String host) {
        try {
            return !InternetDomainName.from((String)host).hasPublicSuffix();
        }
        catch (IllegalArgumentException ie) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIpAddressIgnored(UrlFragment urlFragment) {
        if (!this.ignoreIpAddresses) return false;
        URL uRL = urlFragment.getUrl();
        if (uRL == null) return false;
        String string = uRL.getHost();
        if (string == null) return false;
        if (!InetAddresses.isUriInetAddress((String)urlFragment.getUrl().getHost())) return false;
        return true;
    }

    private final UrlFragment findUrl(LiteralFragment literalFragment) {
        int urlStart = StringsKt.indexOf$default((CharSequence)literalFragment.getValue(), (String)HTTP_PREFIX, (int)0, (boolean)false, (int)6, null);
        if (urlStart == -1) {
            return null;
        }
        int schemaRangeStart = urlStart + literalFragment.getDecodedRange().getStartOffset();
        boolean bl = false;
        boolean bl2 = false;
        LiteralFragment $this$with = literalFragment;
        boolean bl3 = false;
        TextRange textRange = TextRange.create((int)((Number)$this$with.getOffsetMap().invoke((Object)schemaRangeStart)).intValue(), (int)((Number)$this$with.getOffsetMap().invoke((Object)(schemaRangeStart + HTTP_PREFIX.length()))).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"with(literalFragment) {\n\u2026TTP_PREFIX.length))\n    }");
        TextRange schemaRange = textRange;
        String string = literalFragment.getValue();
        bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(urlStart);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return new UrlFragment(string3, schemaRange, literalFragment.getElement());
    }

    private final LocalQuickFix[] getQuickFixes(UrlFragment urlFragment) {
        URL url = urlFragment.getUrl();
        if (url == null) {
            return new LocalQuickFix[]{new Http2HttpsQuickFix()};
        }
        return new LocalQuickFix[]{new Http2HttpsQuickFix(), new IgnoreUrlQuickFix(HTTP_PREFIX + url.getHost())};
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.add((Component)this.createCheckboxPanel(), "North");
        $this$apply.add((Component)this.createUrlListPanel(), "Center");
        return jPanel;
    }

    private final List<LiteralFragment> splitLiterals(String literal, PsiElement host, Function1<? super Integer, Integer> offsetMap) {
        StringTokenizer tokenizer = new StringTokenizer(literal, " \t\n\r\f'\"");
        SmartList literals = new SmartList();
        while (tokenizer.hasMoreTokens()) {
            LiteralFragment linkLiteral = this.nextLinkLiteral(tokenizer, host, offsetMap);
            literals.add((Object)linkLiteral);
        }
        return (List)literals;
    }

    private final List<LiteralFragment> getLiteralFragments(PsiLanguageInjectionHost injectionHost) {
        if (!injectionHost.isValidHost()) {
            return CollectionsKt.emptyList();
        }
        if (!this.mayContainHttpSchema((PsiElement)injectionHost)) {
            return CollectionsKt.emptyList();
        }
        if (this.hasInjectedRegexp(injectionHost)) {
            return CollectionsKt.emptyList();
        }
        LiteralTextEscaper literalTextEscaper = injectionHost.createLiteralTextEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"injectionHost.createLiteralTextEscaper()");
        LiteralTextEscaper escaper = literalTextEscaper;
        TextRange textRange = escaper.getRelevantTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"escaper.relevantTextRange");
        TextRange wholeRange = textRange;
        String literalValue = this.decodeLiteralValue((LiteralTextEscaper<? extends PsiLanguageInjectionHost>)escaper, wholeRange);
        return this.splitLiterals(literalValue, (PsiElement)injectionHost, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(escaper, wholeRange){
            final /* synthetic */ LiteralTextEscaper $escaper;
            final /* synthetic */ TextRange $wholeRange;

            public final int invoke(int it) {
                return this.$escaper.getOffsetInHost(it, this.$wholeRange);
            }
            {
                this.$escaper = literalTextEscaper;
                this.$wholeRange = textRange;
                super(1);
            }
        }));
    }

    private final boolean hasInjectedRegexp(PsiLanguageInjectionHost injectionHost) {
        boolean bl;
        block4: {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)injectionHost.getProject());
            List list = injectedLanguageManager.getInjectedPsiFiles((PsiElement)injectionHost);
            if (list == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"injectedLanguageManager.\u2026tionHost) ?: return false");
            List files = list;
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    Object object = it.first;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.first");
                    if (!((PsiElement)object).getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<LiteralFragment> getLiteralFragments(XmlAttributeValue xmlAttributeValue) {
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtilKt.parentOfTypes$default((PsiElement)((PsiElement)xmlAttributeValue), (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(XmlAttribute.class)}, (boolean)false, (int)2, null);
        if (xmlAttribute == null) {
            return CollectionsKt.emptyList();
        }
        XmlAttribute attribute = xmlAttribute;
        if (!this.mayContainHttpSchema((PsiElement)xmlAttributeValue)) {
            return CollectionsKt.emptyList();
        }
        String string = xmlAttributeValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlAttributeValue.value");
        String attributeValue = string;
        Function1<Integer, Integer> offsetMap = this.getOffsetMapper(attributeValue, xmlAttributeValue);
        List<LiteralFragment> literals = this.splitLiterals(attributeValue, (PsiElement)xmlAttributeValue, offsetMap);
        if (attribute.isNamespaceDeclaration()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)attribute.getLocalName(), (Object)"targetNamespace")) {
            PsiElement $this$parentOfType$iv = (PsiElement)xmlAttributeValue;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, XmlTag.class, (boolean)true);
            if (parentTag != null && Intrinsics.areEqual((Object)parentTag.getLocalName(), (Object)"schema") && parentTag.getParentTag() == null) {
                return CollectionsKt.emptyList();
            }
        }
        if (Intrinsics.areEqual((Object)attribute.getNamespace(), (Object)"http://www.w3.org/2001/XMLSchema-instance")) {
            String string2 = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"attribute.name");
            if (Intrinsics.areEqual((Object)StringsKt.replace$default((String)string2, (String)(attribute.getNamespacePrefix() + ':'), (String)"", (boolean)false, (int)4, null), (Object)"schemaLocation")) {
                void $this$filterIndexedTo$iv$iv;
                Iterable $this$filterIndexed$iv = literals;
                boolean $i$f$filterIndexed = false;
                Iterable withSelf$iv = $this$filterIndexed$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIndexedTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    void element$iv$iv;
                    int n = index$iv$iv$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl2 = false;
                    LiteralFragment literalFragment = (LiteralFragment)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl3 = false;
                    if (!(index % 2 == 1)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return literals;
    }

    private final Function1<Integer, Integer> getOffsetMapper(String attributeValue, XmlAttributeValue xmlAttributeValue) {
        int n = attributeValue.length();
        TextRange textRange = xmlAttributeValue.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"xmlAttributeValue.textRange");
        return n == textRange.getLength() ? (Function1)getOffsetMapper.1.INSTANCE : (Function1)getOffsetMapper.2.INSTANCE;
    }

    private final boolean mayContainHttpSchema(PsiElement element) {
        return element.textContains(':');
    }

    private final LiteralFragment nextLinkLiteral(StringTokenizer tokenizer, PsiElement psiElement, Function1<? super Integer, Integer> offsetMap) {
        String string = tokenizer.nextToken();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tokenizer.nextToken()");
        String value = string;
        int endPosition = tokenizer.getCurrentPosition();
        int startPosition = endPosition - value.length();
        return new LiteralFragment(value, new TextRange(startPosition, endPosition), psiElement, offsetMap);
    }

    private final String decodeLiteralValue(LiteralTextEscaper<? extends PsiLanguageInjectionHost> escaper, TextRange wholeRange) {
        StringBuilder stringBuilder = new StringBuilder();
        escaper.decode(wholeRange, stringBuilder);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    private final JComponent createUrlListPanel() {
        JComponent jComponent = new ListEditForm(RestClientBundle.message("column.name.ignored.urls", new Object[0]), RestClientBundle.message("column.name.ignored.urls.label", new Object[0]), this.ignoredUrls).getContentPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"ListEditForm(RestClientB\u2026ignoredUrls).contentPanel");
        return jComponent;
    }

    private final JPanel createCheckboxPanel() {
        MultipleCheckboxOptionsPanel multipleCheckboxOptionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        boolean bl = false;
        boolean bl2 = false;
        MultipleCheckboxOptionsPanel $this$apply = multipleCheckboxOptionsPanel;
        boolean bl3 = false;
        $this$apply.addCheckbox(RestClientBundle.message("checkbox.ignore.comments", new Object[0]), "ignoreComments");
        $this$apply.addCheckbox(RestClientBundle.message("checkbox.ignore.tldOnly", new Object[0]), "withTldOnly");
        $this$apply.addCheckbox(RestClientBundle.message("checkbox.ignore.ip", new Object[0]), "ignoreIpAddresses");
        return (JPanel)multipleCheckboxOptionsPanel;
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, XmlAttributeValue xmlAttributeValue) {
        return $this.getLiteralFragments(xmlAttributeValue);
    }

    public static final /* synthetic */ List access$getLiteralFragments(HttpUrlsUsageInspection $this, PsiLanguageInjectionHost injectionHost) {
        return $this.getLiteralFragments(injectionHost);
    }

    public static final /* synthetic */ UrlFragment access$findUrl(HttpUrlsUsageInspection $this, LiteralFragment literalFragment) {
        return $this.findUrl(literalFragment);
    }

    public static final /* synthetic */ boolean access$shouldReport(HttpUrlsUsageInspection $this, UrlFragment urlFragment) {
        return $this.shouldReport(urlFragment);
    }

    public static final /* synthetic */ LocalQuickFix[] access$getQuickFixes(HttpUrlsUsageInspection $this, UrlFragment urlFragment) {
        return $this.getQuickFixes(urlFragment);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$LiteralFragment;", "", "value", "", "decodedRange", "Lcom/intellij/openapi/util/TextRange;", "element", "Lcom/intellij/psi/PsiElement;", "offsetMap", "Lkotlin/Function1;", "", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)V", "getDecodedRange", "()Lcom/intellij/openapi/util/TextRange;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getOffsetMap", "()Lkotlin/jvm/functions/Function1;", "getValue", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.restClient"})
    private static final class LiteralFragment {
        @NotNull
        private final String value;
        @NotNull
        private final TextRange decodedRange;
        @NotNull
        private final PsiElement element;
        @NotNull
        private final Function1<Integer, Integer> offsetMap;

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final TextRange getDecodedRange() {
            return this.decodedRange;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @NotNull
        public final Function1<Integer, Integer> getOffsetMap() {
            return this.offsetMap;
        }

        public LiteralFragment(@NotNull String value, @NotNull TextRange decodedRange, @NotNull PsiElement element, @NotNull Function1<? super Integer, Integer> offsetMap) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)decodedRange, (String)"decodedRange");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(offsetMap, (String)"offsetMap");
            this.value = value;
            this.decodedRange = decodedRange;
            this.element = element;
            this.offsetMap = offsetMap;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final TextRange component2() {
            return this.decodedRange;
        }

        @NotNull
        public final PsiElement component3() {
            return this.element;
        }

        @NotNull
        public final Function1<Integer, Integer> component4() {
            return this.offsetMap;
        }

        @NotNull
        public final LiteralFragment copy(@NotNull String value, @NotNull TextRange decodedRange, @NotNull PsiElement element, @NotNull Function1<? super Integer, Integer> offsetMap) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)decodedRange, (String)"decodedRange");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(offsetMap, (String)"offsetMap");
            return new LiteralFragment(value, decodedRange, element, offsetMap);
        }

        public static /* synthetic */ LiteralFragment copy$default(LiteralFragment literalFragment, String string, TextRange textRange, PsiElement psiElement, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                string = literalFragment.value;
            }
            if ((n & 2) != 0) {
                textRange = literalFragment.decodedRange;
            }
            if ((n & 4) != 0) {
                psiElement = literalFragment.element;
            }
            if ((n & 8) != 0) {
                function1 = literalFragment.offsetMap;
            }
            return literalFragment.copy(string, textRange, psiElement, function1);
        }

        @NotNull
        public String toString() {
            return "LiteralFragment(value=" + this.value + ", decodedRange=" + this.decodedRange + ", element=" + this.element + ", offsetMap=" + this.offsetMap + ")";
        }

        public int hashCode() {
            String string = this.value;
            TextRange textRange = this.decodedRange;
            PsiElement psiElement = this.element;
            Function1<Integer, Integer> function1 = this.offsetMap;
            return (((string != null ? string.hashCode() : 0) * 31 + (textRange != null ? textRange.hashCode() : 0)) * 31 + (psiElement != null ? psiElement.hashCode() : 0)) * 31 + (function1 != null ? function1.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LiteralFragment)) break block3;
                    LiteralFragment literalFragment = (LiteralFragment)object;
                    if (!Intrinsics.areEqual((Object)this.value, (Object)literalFragment.value) || !Intrinsics.areEqual((Object)this.decodedRange, (Object)literalFragment.decodedRange) || !Intrinsics.areEqual((Object)this.element, (Object)literalFragment.element) || !Intrinsics.areEqual(this.offsetMap, literalFragment.offsetMap)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$UrlFragment;", "", "wholeUrl", "", "schemaRangeInHost", "Lcom/intellij/openapi/util/TextRange;", "hostElement", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;)V", "getHostElement", "()Lcom/intellij/psi/PsiElement;", "getSchemaRangeInHost", "()Lcom/intellij/openapi/util/TextRange;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "getWholeUrl", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.restClient"})
    private static final class UrlFragment {
        @Nullable
        private final URL url;
        @NotNull
        private final String wholeUrl;
        @Nullable
        private final TextRange schemaRangeInHost;
        @NotNull
        private final PsiElement hostElement;

        @Nullable
        public final URL getUrl() {
            return this.url;
        }

        @NotNull
        public final String getWholeUrl() {
            return this.wholeUrl;
        }

        @Nullable
        public final TextRange getSchemaRangeInHost() {
            return this.schemaRangeInHost;
        }

        @NotNull
        public final PsiElement getHostElement() {
            return this.hostElement;
        }

        public UrlFragment(@NotNull String wholeUrl, @Nullable TextRange schemaRangeInHost, @NotNull PsiElement hostElement) {
            URL uRL;
            UrlFragment urlFragment;
            Intrinsics.checkNotNullParameter((Object)wholeUrl, (String)"wholeUrl");
            Intrinsics.checkNotNullParameter((Object)hostElement, (String)"hostElement");
            this.wholeUrl = wholeUrl;
            this.schemaRangeInHost = schemaRangeInHost;
            this.hostElement = hostElement;
            UrlFragment urlFragment2 = this;
            try {
                urlFragment = urlFragment2;
                uRL = new URL(this.wholeUrl);
            }
            catch (MalformedURLException malformedURLException) {
                urlFragment = urlFragment2;
                uRL = null;
            }
            urlFragment.url = uRL;
        }

        @NotNull
        public final String component1() {
            return this.wholeUrl;
        }

        @Nullable
        public final TextRange component2() {
            return this.schemaRangeInHost;
        }

        @NotNull
        public final PsiElement component3() {
            return this.hostElement;
        }

        @NotNull
        public final UrlFragment copy(@NotNull String wholeUrl, @Nullable TextRange schemaRangeInHost, @NotNull PsiElement hostElement) {
            Intrinsics.checkNotNullParameter((Object)wholeUrl, (String)"wholeUrl");
            Intrinsics.checkNotNullParameter((Object)hostElement, (String)"hostElement");
            return new UrlFragment(wholeUrl, schemaRangeInHost, hostElement);
        }

        public static /* synthetic */ UrlFragment copy$default(UrlFragment urlFragment, String string, TextRange textRange, PsiElement psiElement, int n, Object object) {
            if ((n & 1) != 0) {
                string = urlFragment.wholeUrl;
            }
            if ((n & 2) != 0) {
                textRange = urlFragment.schemaRangeInHost;
            }
            if ((n & 4) != 0) {
                psiElement = urlFragment.hostElement;
            }
            return urlFragment.copy(string, textRange, psiElement);
        }

        @NotNull
        public String toString() {
            return "UrlFragment(wholeUrl=" + this.wholeUrl + ", schemaRangeInHost=" + this.schemaRangeInHost + ", hostElement=" + this.hostElement + ")";
        }

        public int hashCode() {
            String string = this.wholeUrl;
            TextRange textRange = this.schemaRangeInHost;
            PsiElement psiElement = this.hostElement;
            return ((string != null ? string.hashCode() : 0) * 31 + (textRange != null ? textRange.hashCode() : 0)) * 31 + (psiElement != null ? psiElement.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UrlFragment)) break block3;
                    UrlFragment urlFragment = (UrlFragment)object;
                    if (!Intrinsics.areEqual((Object)this.wholeUrl, (Object)urlFragment.wholeUrl) || !Intrinsics.areEqual((Object)this.schemaRangeInHost, (Object)urlFragment.schemaRangeInHost) || !Intrinsics.areEqual((Object)this.hostElement, (Object)urlFragment.hostElement)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/httpClient/http/security/HttpUrlsUsageInspection$Companion;", "", "()V", "HTTPS_PREFIX", "", "HTTP_PREFIX", "intellij.restClient"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

