/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.test;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.console.HttpResponsePrinter;
import com.intellij.httpClient.http.request.run.test.HttpClientTestUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class HttpResponseTestAdapter
extends HttpResponseOutputAdapter {
    private static final Logger LOG = Logger.getInstance(HttpResponseTestAdapter.class);
    private static final String DEFAULT_NAME = "undefined";
    private final Stack<String> myActiveTests;

    public HttpResponseTestAdapter(@NotNull HttpResponsePrinter printer) {
        if (printer == null) {
            HttpResponseTestAdapter.$$$reportNull$$$0(0);
        }
        super(printer);
        this.myActiveTests = new Stack();
    }

    @Override
    public void printStart(@NotNull String name) {
        if (name == null) {
            HttpResponseTestAdapter.$$$reportNull$$$0(1);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Start Test '" + name + "'");
        }
        this.myActiveTests.push((Object)name);
        HttpClientTestUtil.printTestStart(this, StringUtil.notNullize((String)name, (String)DEFAULT_NAME));
    }

    @Override
    public void printEnd(@NotNull String name, long duration) {
        if (name == null) {
            HttpResponseTestAdapter.$$$reportNull$$$0(2);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("End Test '" + name + "'");
        }
        if (this.myActiveTests.isEmpty()) {
            LOG.warn("Test " + name + " was not started!");
        } else {
            this.myActiveTests.pop();
        }
        HttpClientTestUtil.printTestEnd(this, StringUtil.notNullize((String)name, (String)DEFAULT_NAME), duration);
    }

    @Override
    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            HttpResponseTestAdapter.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            HttpResponseTestAdapter.$$$reportNull$$$0(4);
        }
        if (contentType == ConsoleViewContentType.ERROR_OUTPUT && !this.myActiveTests.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed Test '" + (String)this.myActiveTests.peek() + "'");
            }
            HttpClientTestUtil.printTestFailed(this, (String)this.myActiveTests.peek(), text);
        } else {
            super.print(text, contentType);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/test/HttpResponseTestAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "printStart";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "printEnd";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

