/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.environment.HttpRequestIndex;
import com.intellij.httpClient.http.request.microservices.endpoints.EmbeddedHttpClientEditor;
import com.intellij.httpClient.http.request.psi.HttpMethod;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTokenTypeSets;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.run.HttpRequestActionsProvider;
import com.intellij.httpClient.http.request.run.HttpRequestPlaceholderUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestLineMarkerProvider
extends RunLineMarkerContributor {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        HttpRequest request;
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (HttpRequestLineMarkerProvider.isHttpRequestRunElement(element) && (request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)element, HttpRequest.class)) != null) {
            if (!HttpRequestLineMarkerProvider.canBeExecuted(request)) {
                return null;
            }
            Project project = element.getProject();
            PsiFile containingFile = element.getContainingFile();
            HttpRequestEnvironment.clearDefaultIfInvalid(project, containingFile);
            Collection<String> envs2 = HttpRequestIndex.getAllEnvironments(project, containingFile);
            HttpRequestActionsProvider.HttpRequestActionsProviderStrategy strategy = HttpRequestActionsProvider.getActionsProvider();
            AnAction[] actions = strategy.provideActions(request, envs2).toArray(AnAction.EMPTY_ARRAY);
            return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run, actions, psiElement -> strategy.getTooltip());
        }
        return null;
    }

    private static boolean canBeExecuted(@NotNull HttpRequest request) {
        if (request == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return !EmbeddedHttpClientEditor.isInEmbeddedHttpClientEditor((PsiElement)request) && !HttpRequestPlaceholderUtil.containsPlaceholder(request);
    }

    @ApiStatus.Internal
    public static boolean isHttpRequestRunElement(@NotNull PsiElement element) {
        if (element == null) {
            HttpRequestLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (HttpRequestPsiUtils.isOfTypes(element, HttpRequestTokenTypeSets.METHODS)) {
            return true;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof HttpScheme) {
            HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)parent, HttpRequest.class);
            return request != null && !(request.getFirstChild() instanceof HttpMethod);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeExecuted";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isHttpRequestRunElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

