/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.progress.ProgressIndicator;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientRequestProcessHandler
extends ProcessHandler {
    public static final int SUCCEED = 0;
    public static final int INTERRUPTED = 1;
    public static final int INTERRUPTED_POST_PROCESSING = 2;
    private ProgressIndicator myPostProcessorIndicator = null;
    private final HttpClientTestsProcessHandler myPostProcessorHandler;
    private final List<Runnable> postponedForStartedActions = new ArrayList<Runnable>();

    public HttpClientRequestProcessHandler(boolean withPostProcessor) {
        this.myPostProcessorHandler = withPostProcessor ? new HttpClientTestsProcessHandler() : null;
    }

    public void setPostProcessorIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(0);
        }
        this.myPostProcessorIndicator = indicator;
    }

    public void doForStartedProgress(@NotNull Runnable action) {
        if (action == null) {
            HttpClientRequestProcessHandler.$$$reportNull$$$0(1);
        }
        if (this.isStartNotified()) {
            action.run();
        } else {
            this.postponedForStartedActions.add(action);
        }
    }

    @Nullable
    public ProcessHandler getPostProcessorHandler() {
        return this.myPostProcessorHandler;
    }

    public void startNotify() {
        super.startNotify();
        for (Runnable action : this.postponedForStartedActions) {
            action.run();
        }
        this.postponedForStartedActions.clear();
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.startNotify();
        }
    }

    public void onRunFinished() {
        if (this.isProcessTerminating() || this.isProcessTerminated()) {
            return;
        }
        this.notifyProcessTerminated(0);
        if (this.myPostProcessorHandler != null && !this.myPostProcessorHandler.isProcessTerminating() && !this.myPostProcessorHandler.isProcessTerminated()) {
            this.myPostProcessorHandler.notifyProcessTerminated(0);
        }
    }

    public boolean isProcessTerminated() {
        return super.isProcessTerminated() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminated());
    }

    public boolean isProcessTerminating() {
        return super.isProcessTerminating() && (this.myPostProcessorHandler == null || this.myPostProcessorHandler.isProcessTerminating());
    }

    protected void destroyProcessImpl() {
        boolean onPostProcessing = this.myPostProcessorIndicator != null && this.myPostProcessorIndicator.isRunning();
        this.notifyProcessTerminated(onPostProcessing ? 2 : 1);
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.destroyProcess();
        }
        if (this.myPostProcessorIndicator != null && !this.myPostProcessorIndicator.isCanceled()) {
            this.myPostProcessorIndicator.cancel();
        }
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        if (this.myPostProcessorHandler != null) {
            this.myPostProcessorHandler.detachProcess();
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientRequestProcessHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setPostProcessorIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doForStartedProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HttpClientTestsProcessHandler
    extends ProcessHandler {
        private HttpClientTestsProcessHandler() {
        }

        public void notifyProcessTerminated(int exitCode) {
            super.notifyProcessTerminated(exitCode);
        }

        protected void destroyProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        protected void detachProcessImpl() {
            this.notifyProcessTerminated(2);
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }
}

