/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.microservices;

import com.intellij.httpClient.actions.generation.HttpRequestGenerationManager;
import com.intellij.httpClient.actions.generation.HttpRequestGenerationUtil;
import com.intellij.httpClient.actions.generation.HttpRequestUrlsGenerationRequest;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.project.Project;
import icons.RestClientIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/httpClient/actions/microservices/OpenInHttpClientGotoRelatedItem;", "Lcom/intellij/navigation/GotoRelatedItem;", "project", "Lcom/intellij/openapi/project/Project;", "requests", "", "Lcom/intellij/httpClient/actions/generation/HttpRequestUrlsGenerationRequest;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getCustomIcon", "Ljavax/swing/Icon;", "getCustomName", "", "navigate", "", "intellij.restClient"})
public final class OpenInHttpClientGotoRelatedItem
extends GotoRelatedItem {
    private final Project project;
    private final List<HttpRequestUrlsGenerationRequest> requests;

    public void navigate() {
        new HttpRequestGenerationManager(this.project).generateRequestsInHttpEditor(this.requests);
    }

    @Nullable
    public String getCustomName() {
        return RestClientBundle.message("http.request.open.in.http.client.goto.related.name", HttpRequestGenerationUtil.getRequestsPresentation(this.requests));
    }

    @Nullable
    public Icon getCustomIcon() {
        return RestClientIcons.Http_requests_filetype;
    }

    public OpenInHttpClientGotoRelatedItem(@NotNull Project project, @NotNull List<HttpRequestUrlsGenerationRequest> requests) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        super(null, RestClientBundle.message("group.HTTPClientGroup.text", new Object[0]), -1);
        this.project = project;
        this.requests = requests;
    }
}

