/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions.copyPaste;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.httpClient.converters.curl.Utils;
import com.intellij.httpClient.converters.curl.exceptions.CurlParseException;
import com.intellij.httpClient.converters.curl.parser.CurlParser;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpClientConversionsLogger;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurlCopyPastePreProcessor
implements CopyPastePreProcessor {
    private static final Logger LOG = Logger.getInstance(CurlCopyPastePreProcessor.class);

    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        if (file2 instanceof HttpRequestPsiFile) {
            if (!Utils.isCurlString(text)) {
                String string = text;
                if (string == null) {
                    CurlCopyPastePreProcessor.$$$reportNull$$$0(0);
                }
                return string;
            }
            HttpClientConversionsLogger.logFromCurlStarted();
            Object convertedText = text;
            try {
                CurlParser curlParser = new CurlParser();
                PsiElement caretPsiElement = PsiUtilCore.getElementAtOffset((PsiFile)file2, (int)editor.getCaretModel().getCurrentCaret().getOffset());
                PsiElement prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)caretPsiElement);
                RestClientRequest request = curlParser.parseToRestClientRequest(text);
                convertedText = prevElement != null && !HttpRequestPsiUtils.isOfType(prevElement, HttpRequestElementTypes.REQUEST_SEPARATOR) && !(prevElement instanceof HttpRequestPsiFile) ? "###\n\n" + Utils.createCurlStringComment(text) + HttpRequestPsiConverter.toPsiHttpRequest(request) : Utils.createCurlStringComment(text) + HttpRequestPsiConverter.toPsiHttpRequest(request);
                HttpClientConversionsLogger.logFromCurlSucceed();
            }
            catch (CurlParseException e) {
                LOG.warn(e.getMessage());
                HttpClientConversionsLogger.logFromCurlFailed(e.getType());
            }
            String string = convertedText;
            if (string == null) {
                CurlCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            CurlCopyPastePreProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/httpClient/actions/copyPaste/CurlCopyPastePreProcessor", "preprocessOnPaste"));
    }
}

