/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientDataKeys;
import com.intellij.httpClient.http.request.HttpRequestFileType;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.UIBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddHttpRequestAction
extends AnAction {
    private static final List<String> liveTemplatesNames = ContainerUtil.newArrayList((Object[])new String[]{"gtrp", "ptr", "ptrp", "mptr", "fptr"});

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            AddHttpRequestAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            AddHttpRequestAction.showRequestsPopup(project, editor, e);
        }
    }

    private static void showRequestsPopup(final @NotNull Project project, final @NotNull Editor editor, final @NotNull AnActionEvent event) {
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            AddHttpRequestAction.$$$reportNull$$$0(2);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(3);
        }
        String title = RestClientBundle.message("action.HTTPClient.AddRequest.text", new Object[0]);
        final Map<String, String> templateToDescriptionMap = AddHttpRequestAction.getTemplateToDescriptionMap();
        ListPopup requestsCollectionPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(title, AddHttpRequestAction.getRequestDescriptions()){

            public PopupStep<?> onChosen(String requestName, boolean finalChoice) {
                return this.doFinalStep(() -> AddHttpRequestAction.performHttpLiveTemplateAction(project, editor, (String)templateToDescriptionMap.get(requestName), event));
            }
        });
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            requestsCollectionPopup.showUnderneathOf((Component)hyperlinkLabel);
        } else {
            requestsCollectionPopup.showInBestPositionFor(editor);
        }
    }

    static void performHttpLiveTemplateAction(@NotNull Project project, @Nullable Editor editor, @NotNull String liveTemplateName, @NotNull AnActionEvent event) {
        TemplateImpl httpRequestTemplate;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(4);
        }
        if (liveTemplateName == null) {
            AddHttpRequestAction.$$$reportNull$$$0(5);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(6);
        }
        if ((httpRequestTemplate = TemplateSettings.getInstance().getTemplate(liveTemplateName, "HTTP Request")) == null) {
            AddHttpRequestAction.showErrorBalloon(event, RestClientBundle.message("http.request.add.request.action.failed.find.template", new Object[0]));
            return;
        }
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (editor == null || selectedFiles.length == 0 || HttpRequestFileUtils.isHttpRequestSystemFile(project, selectedFiles[0].getPath()) || !FileTypeRegistry.getInstance().isFileOfType(selectedFiles[0], (FileType)HttpRequestFileType.INSTANCE)) {
            AddHttpRequestAction.createScratchFileAndStartTemplate(project, event, (Template)httpRequestTemplate);
        } else {
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(0);
            Document document = editor.getDocument();
            WriteCommandAction.runWriteCommandAction((Project)project, (String)RestClientBundle.message("http.request.add.http.request.command", new Object[0]), null, () -> AddHttpRequestAction.lambda$performHttpLiveTemplateAction$0(document, project, editor, (Template)httpRequestTemplate), (PsiFile[])new PsiFile[0]);
        }
    }

    private static void createScratchFileAndStartTemplate(@NotNull Project project, @NotNull AnActionEvent event, @NotNull Template template) {
        FileEditor[] fileEditors;
        VirtualFile file2;
        if (project == null) {
            AddHttpRequestAction.$$$reportNull$$$0(7);
        }
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(8);
        }
        if (template == null) {
            AddHttpRequestAction.$$$reportNull$$$0(9);
        }
        String fileName = PathUtil.makeFileName((String)"rest-api", (String)HttpRequestFileType.INSTANCE.getDefaultExtension());
        ScratchFileService fileService = ScratchFileService.getInstance();
        try {
            file2 = fileService.findFile((RootType)ScratchRootType.getInstance(), fileName, ScratchFileService.Option.create_new_always);
        }
        catch (IOException e) {
            AddHttpRequestAction.showErrorBalloon(event, UIBundle.message((String)"create.new.file.could.not.create.file.error.message", (Object[])new Object[]{fileName}));
            return;
        }
        for (FileEditor curFileEditor : fileEditors = FileEditorManager.getInstance((Project)project).openFile(file2, true)) {
            VirtualFile curFile;
            if (!(curFileEditor instanceof TextEditor) || (curFile = curFileEditor.getFile()) == null || !curFile.getPath().equals(file2.getPath())) continue;
            TemplateManager.getInstance((Project)project).startTemplate(((TextEditor)curFileEditor).getEditor(), template);
            return;
        }
        Messages.showErrorDialog((Project)project, (String)RestClientBundle.message("http.request.add.request.action.error.adding.request.message", new Object[0]), (String)RestClientBundle.message("http.request.add.request.action.error.adding.request", new Object[0]));
    }

    public static void showErrorBalloon(@NotNull AnActionEvent event, @NotNull @NlsContexts.PopupContent String message2) {
        if (event == null) {
            AddHttpRequestAction.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            AddHttpRequestAction.$$$reportNull$$$0(11);
        }
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.ERROR, null).setFadeoutTime(2000L);
        Balloon errorBalloon = builder.createBalloon();
        HyperlinkLabel hyperlinkLabel = (HyperlinkLabel)event.getDataContext().getData(HttpClientDataKeys.ADD_REQUEST_TOOLBAR_HYPERLINK_LABEL);
        if (hyperlinkLabel != null) {
            errorBalloon.showInCenterOf((JComponent)hyperlinkLabel);
        } else {
            errorBalloon.show(JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext()), Balloon.Position.below);
        }
    }

    private static @NotNull List<@NlsActions.ActionText String> getRequestDescriptions() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new String[]{RestClientBundle.message("http.request.add.request.action.get", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.text.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.post.parameters.body", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.text.field", new Object[0]), RestClientBundle.message("http.request.add.request.action.form.file.field", new Object[0])});
        if (arrayList == null) {
            AddHttpRequestAction.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static @NotNull Map<@NlsActions.ActionText String, String> getTemplateToDescriptionMap() {
        Map map = ContainerUtil.newHashMap(AddHttpRequestAction.getRequestDescriptions(), liveTemplatesNames);
        if (map == null) {
            AddHttpRequestAction.$$$reportNull$$$0(13);
        }
        return map;
    }

    private static /* synthetic */ void lambda$performHttpLiveTemplateAction$0(Document document, Project project, Editor editor, Template httpRequestTemplate) {
        document.insertString(0, (CharSequence)"\n");
        TemplateManager.getInstance((Project)project).startTemplate(editor, httpRequestTemplate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liveTemplateName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/AddHttpRequestAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/AddHttpRequestAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestDescriptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateToDescriptionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showRequestsPopup";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performHttpLiveTemplateAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createScratchFileAndStartTemplate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

