/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.Imported;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.Legacy;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.New;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u000eJ\u001e\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H&J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000eJ\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000b\u001a\u00020\u0006H&J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "gradleWrapperEnding", "", "roots", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootIndex;", "getRoots", "()Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootIndex;", "localPath", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLocalPath", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "findAffectedFileRoot", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;", "filePath", "findGradleWrapperPropertiesBuildDir", "findScriptBuildRoot", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "gradleKtsFile", "searchNearestLegacy", "", "getAllRoots", "", "getBuildRootByWorkingDir", "gradleWorkingDir", "getScriptFirstSeenTs", "", "path", "getScriptInfo", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleScriptInfo;", "file", "isAffectedGradleProjectFile", "maybeAffectedGradleProjectFile", "NotificationKind", "ScriptUnderRoot", "kotlin.gradle.gradle-idea"})
public abstract class GradleBuildRootsLocator {
    @NotNull
    private final GradleBuildRootIndex roots;
    private final String gradleWrapperEnding;
    private final Project project;

    @NotNull
    protected final GradleBuildRootIndex getRoots() {
        return this.roots;
    }

    @Nullable
    public abstract GradleScriptInfo getScriptInfo(@NotNull String var1);

    @NotNull
    public final Collection<GradleBuildRoot> getAllRoots() {
        return this.roots.getList();
    }

    @Nullable
    public final GradleBuildRoot getBuildRootByWorkingDir(@NotNull String gradleWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)gradleWorkingDir, (String)"gradleWorkingDir");
        return this.roots.getBuildByRootDir(gradleWorkingDir);
    }

    @Nullable
    public final GradleScriptInfo getScriptInfo(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getScriptInfo(this.getLocalPath(file));
    }

    private final String getLocalPath(VirtualFile $this$localPath) {
        String string = $this$localPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return string;
    }

    public final boolean maybeAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    public final boolean isAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.findAffectedFileRoot(filePath) != null || this.roots.isStandaloneScript(filePath);
    }

    @Nullable
    public final GradleBuildRoot findAffectedFileRoot(@NotNull String filePath) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                if (StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null)) {
                    return this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null));
                }
                object = this.findGradleWrapperPropertiesBuildDir(filePath);
                if (object == null) break block4;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object = this.roots.getBuildByRootDir(it);
                if (object != null) break block5;
            }
            ScriptUnderRoot scriptUnderRoot = this.findScriptBuildRoot(filePath, false);
            object = scriptUnderRoot != null ? scriptUnderRoot.getRoot() : null;
        }
        return object;
    }

    @Nullable
    public final String findGradleWrapperPropertiesBuildDir(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null)) {
            String string = filePath;
            int n = 0;
            int n2 = filePath.length() - this.gradleWrapperEnding.length();
            boolean bl = false;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }
        return null;
    }

    public abstract long getScriptFirstSeenTs(@NotNull String var1);

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull VirtualFile gradleKtsFile) {
        Intrinsics.checkNotNullParameter((Object)gradleKtsFile, (String)"gradleKtsFile");
        String string = gradleKtsFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gradleKtsFile.path");
        return GradleBuildRootsLocator.findScriptBuildRoot$default(this, string, false, 2, null);
    }

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull String filePath, boolean searchNearestLegacy) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.project.isDisposed()) {
            return null;
        }
        if (!StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null)) {
            return null;
        }
        GradleScriptInfo scriptInfo = this.getScriptInfo(filePath);
        Object object = scriptInfo;
        if (object != null && (object = object.getBuildRoot()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return new ScriptUnderRoot(this, filePath, (GradleBuildRoot)it, scriptInfo, false, null, 24, null);
        }
        GradleBuildRoot gradleBuildRoot = this.roots.getStandaloneScriptRoot(filePath);
        if (gradleBuildRoot != null) {
            GradleBuildRoot gradleBuildRoot2 = gradleBuildRoot;
            boolean bl = false;
            boolean bl4 = false;
            GradleBuildRoot it = gradleBuildRoot2;
            boolean bl5 = false;
            return new ScriptUnderRoot(this, filePath, it, null, true, null, 20, null);
        }
        if (StringsKt.endsWith$default((String)filePath, (String)"/build.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/settings.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/init.gradle.kts", (boolean)false, (int)2, null)) {
            GradleBuildRoot gradleBuildRoot3 = this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null));
            if (gradleBuildRoot3 != null) {
                GradleBuildRoot gradleBuildRoot4 = gradleBuildRoot3;
                boolean bl = false;
                boolean bl6 = false;
                GradleBuildRoot it = gradleBuildRoot4;
                boolean bl7 = false;
                return new ScriptUnderRoot(this, filePath, it, null, false, null, 28, null);
            }
        }
        GradleBuildRoot nearest = searchNearestLegacy ? this.roots.findNearestRoot(filePath) : null;
        return new ScriptUnderRoot(this, filePath, null, null, false, nearest, 12, null);
    }

    public static /* synthetic */ ScriptUnderRoot findScriptBuildRoot$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findScriptBuildRoot");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleBuildRootsLocator.findScriptBuildRoot(string, bl);
    }

    public GradleBuildRootsLocator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.roots = new GradleBuildRootIndex(this.project);
        this.gradleWrapperEnding = "/gradle/wrapper/gradle-wrapper.properties";
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator$NotificationKind;", "", "(Ljava/lang/String;I)V", "dontCare", "legacy", "legacyOutside", "outsideAnything", "wasNotImportedAfterCreation", "notEvaluatedInLastImport", "standalone", "standaloneLegacy", "kotlin.gradle.gradle-idea"})
    public static final class NotificationKind
    extends Enum<NotificationKind> {
        public static final /* enum */ NotificationKind dontCare;
        public static final /* enum */ NotificationKind legacy;
        public static final /* enum */ NotificationKind legacyOutside;
        public static final /* enum */ NotificationKind outsideAnything;
        public static final /* enum */ NotificationKind wasNotImportedAfterCreation;
        public static final /* enum */ NotificationKind notEvaluatedInLastImport;
        public static final /* enum */ NotificationKind standalone;
        public static final /* enum */ NotificationKind standaloneLegacy;
        private static final /* synthetic */ NotificationKind[] $VALUES;

        static {
            NotificationKind[] notificationKindArray = new NotificationKind[8];
            NotificationKind[] notificationKindArray2 = notificationKindArray;
            notificationKindArray[0] = dontCare = new NotificationKind();
            notificationKindArray[1] = legacy = new NotificationKind();
            notificationKindArray[2] = legacyOutside = new NotificationKind();
            notificationKindArray[3] = outsideAnything = new NotificationKind();
            notificationKindArray[4] = wasNotImportedAfterCreation = new NotificationKind();
            notificationKindArray[5] = notEvaluatedInLastImport = new NotificationKind();
            notificationKindArray[6] = standalone = new NotificationKind();
            notificationKindArray[7] = standaloneLegacy = new NotificationKind();
            $VALUES = notificationKindArray;
        }

        public static NotificationKind[] values() {
            return (NotificationKind[])$VALUES.clone();
        }

        public static NotificationKind valueOf(String string) {
            return Enum.valueOf(NotificationKind.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0014\u0010\u001c\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "", "filePath", "", "root", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;", "script", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleScriptInfo;", "standalone", "", "nearest", "(Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleScriptInfo;ZLorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;)V", "getFilePath", "()Ljava/lang/String;", "importing", "getImporting", "()Z", "isImported", "getNearest", "()Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRoot;", "notificationKind", "Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator$NotificationKind;", "getNotificationKind", "()Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleBuildRootsLocator$NotificationKind;", "getRoot", "getScript", "()Lorg/jetbrains/kotlin/idea/scripting/gradle/roots/GradleScriptInfo;", "getStandalone", "wasImportedAndNotEvaluated", "getWasImportedAndNotEvaluated", "toString", "kotlin.gradle.gradle-idea"})
    public final class ScriptUnderRoot {
        @NotNull
        private final String filePath;
        @Nullable
        private final GradleBuildRoot root;
        @Nullable
        private final GradleScriptInfo script;
        private final boolean standalone;
        @Nullable
        private final GradleBuildRoot nearest;
        final /* synthetic */ GradleBuildRootsLocator this$0;

        @NotNull
        public final NotificationKind getNotificationKind() {
            NotificationKind notificationKind;
            if (this.isImported()) {
                notificationKind = NotificationKind.dontCare;
            } else if (this.standalone) {
                GradleBuildRoot gradleBuildRoot = this.nearest;
                notificationKind = gradleBuildRoot instanceof Legacy ? NotificationKind.standaloneLegacy : NotificationKind.standalone;
            } else if (this.nearest == null) {
                notificationKind = NotificationKind.outsideAnything;
            } else if (this.getImporting()) {
                notificationKind = NotificationKind.dontCare;
            } else {
                GradleBuildRoot gradleBuildRoot = this.nearest;
                if (gradleBuildRoot instanceof Legacy) {
                    GradleBuildRoot gradleBuildRoot2 = this.root;
                    notificationKind = gradleBuildRoot2 == null ? NotificationKind.legacyOutside : NotificationKind.legacy;
                } else if (gradleBuildRoot instanceof New) {
                    notificationKind = NotificationKind.wasNotImportedAfterCreation;
                } else if (gradleBuildRoot instanceof Imported) {
                    notificationKind = this.getWasImportedAndNotEvaluated() ? NotificationKind.notEvaluatedInLastImport : NotificationKind.wasNotImportedAfterCreation;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return notificationKind;
        }

        private final boolean getImporting() {
            return this.nearest != null && this.nearest.isImportingInProgress();
        }

        private final boolean isImported() {
            return this.script != null;
        }

        private final boolean getWasImportedAndNotEvaluated() {
            return this.nearest instanceof Imported && this.this$0.getScriptFirstSeenTs(this.filePath) < ((Imported)this.nearest).getData().getImportTs();
        }

        @NotNull
        public String toString() {
            return "ScriptUnderRoot(root=" + this.root + ", script=" + (Object)((Object)this.script) + ", standalone=" + this.standalone + ", nearest=" + this.nearest + ')';
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final GradleBuildRoot getRoot() {
            return this.root;
        }

        @Nullable
        public final GradleScriptInfo getScript() {
            return this.script;
        }

        public final boolean getStandalone() {
            return this.standalone;
        }

        @Nullable
        public final GradleBuildRoot getNearest() {
            return this.nearest;
        }

        public ScriptUnderRoot(@NotNull GradleBuildRootsLocator this$0, @Nullable String filePath, @Nullable GradleBuildRoot root, GradleScriptInfo script, @Nullable boolean standalone, GradleBuildRoot nearest) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.this$0 = this$0;
            this.filePath = filePath;
            this.root = root;
            this.script = script;
            this.standalone = standalone;
            this.nearest = nearest;
        }

        public /* synthetic */ ScriptUnderRoot(GradleBuildRootsLocator gradleBuildRootsLocator, String string, GradleBuildRoot gradleBuildRoot, GradleScriptInfo gradleScriptInfo, boolean bl, GradleBuildRoot gradleBuildRoot2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                gradleScriptInfo = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                gradleBuildRoot2 = gradleBuildRoot;
            }
            this(gradleBuildRootsLocator, string, gradleBuildRoot, gradleScriptInfo, bl, gradleBuildRoot2);
        }
    }
}

