/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.host.ScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionSourceAsContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManagerKt;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.scripting.gradle.ErrorGradleScriptDefinition;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleKotlinScriptDefinitionWrapper;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleScriptDefinitionsContributor;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.Imported;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.WithoutScriptModels;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettingsListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0002()B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u001c\u001a\u00020\fH\u0002JN\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\rH\u0002J\"\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fJ\b\u0010$\u001a\u00020\u001aH\u0002J\f\u0010%\u001a\u00020&*\u00020\fH\u0002J\f\u0010'\u001a\u00020\u001a*\u00020\fH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleScriptDefinitionsContributor;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionSourceAsContributor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "definitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getDefinitions", "()Lkotlin/sequences/Sequence;", "definitionsByRoots", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "id", "", "getId", "()Ljava/lang/String;", "createHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "projectPath", "gradleHome", "javaHome", "gradleExeSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleExecutionSettings;", "forceReload", "", "loadGradleDefinitions", "root", "loadGradleTemplates", "templateClass", "templateClasspath", "Ljava/nio/file/Path;", "additionalClassPath", "reloadIfNeeded", "workingDir", "subscribeToGradleSettingChanges", "isError", "", "markAsError", "Companion", "LightGradleBuildRoot", "kotlin.gradle.gradle-idea"})
public final class GradleScriptDefinitionsContributor
implements ScriptDefinitionSourceAsContributor {
    @NotNull
    private final String id;
    private final ConcurrentHashMap<LightGradleBuildRoot, List<ScriptDefinition>> definitionsByRoots;
    private final Project project;
    private static final Regex kotlinDslDependencySelector;
    private static final Regex kotlinStdLibSelector;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return this.id;
    }

    private final void markAsError(LightGradleBuildRoot $this$markAsError) {
        ((Map)this.definitionsByRoots).put($this$markAsError, CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, null, 2, null))));
    }

    private final boolean isError(LightGradleBuildRoot $this$isError) {
        boolean bl;
        block5: {
            List<ScriptDefinition> list = this.definitionsByRoots.get($this$isError);
            if (list != null) {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ScriptDefinition it = (ScriptDefinition)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof ErrorGradleScriptDefinition)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final void forceReload() {
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"definitionsByRoots.keys()");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            LightGradleBuildRoot key;
            LightGradleBuildRoot lightGradleBuildRoot = key = (LightGradleBuildRoot)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)lightGradleBuildRoot, (String)"key");
            this.markAsError(lightGradleBuildRoot);
        }
        ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy((ScriptDefinitionsSource)this);
    }

    /*
     * WARNING - void declaration
     */
    public final void reloadIfNeeded(@NotNull String workingDir, @Nullable String gradleHome, @Nullable String javaHome) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome, javaHome);
        List<ScriptDefinition> value = this.definitionsByRoots.get(root);
        if (value != null) {
            if (this.isError(root)) {
                ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy((ScriptDefinitionsSource)this);
            }
        } else {
            Map rootWithChangedGradleHome;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = this.definitionsByRoots;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var12_13 = $this$filterTo$iv$iv;
            boolean bl = false;
            Iterator iterator = var12_13.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)((LightGradleBuildRoot)it.getKey()).getWorkingDir(), (Object)workingDir)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = rootWithChangedGradleHome = destination$iv$iv;
            $i$f$filter = false;
            if (!$this$filter$iv.isEmpty()) {
                Map $this$forEach$iv = rootWithChangedGradleHome;
                boolean $i$f$forEach = false;
                map = $this$forEach$iv;
                boolean bl3 = false;
                Iterator iterator2 = map.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    this.definitionsByRoots.remove(it.getKey());
                }
            }
            this.markAsError(root);
            ScriptDefinitionsManager.Companion.getInstance(this.project).reloadDefinitionsBy((ScriptDefinitionsSource)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinition> loadGradleDefinitions(LightGradleBuildRoot root) {
        try {
            void templateClasspath2;
            Pair pair = GradleScriptDefinitionsContributor.Companion.getFullDefinitionsClasspath(root.getGradleHome());
            List list = (List)pair.component1();
            List additionalClassPath = (List)pair.component2();
            ArrayList kotlinDslTemplates = new ArrayList();
            String projectPath = root.getWorkingDir();
            Collection<Object> collection = this.loadGradleTemplates(projectPath, "org.gradle.kotlin.dsl.KotlinInitScript", root.getGradleHome(), root.getJavaHome(), (List<? extends Path>)templateClasspath2, additionalClassPath);
            boolean bl = false;
            boolean bl2 = false;
            List<ScriptDefinition> it = collection;
            boolean bl3 = false;
            kotlinDslTemplates.addAll(it);
            collection = this.loadGradleTemplates(projectPath, "org.gradle.kotlin.dsl.KotlinSettingsScript", root.getGradleHome(), root.getJavaHome(), (List<? extends Path>)templateClasspath2, additionalClassPath);
            bl = false;
            bl2 = false;
            it = collection;
            boolean bl4 = false;
            kotlinDslTemplates.addAll(it);
            collection = this.loadGradleTemplates(projectPath, "org.gradle.kotlin.dsl.KotlinBuildScript", root.getGradleHome(), root.getJavaHome(), (List<? extends Path>)templateClasspath2, additionalClassPath);
            bl = false;
            bl2 = false;
            it = collection;
            boolean bl5 = false;
            kotlinDslTemplates.addAll(it);
            collection = kotlinDslTemplates;
            bl = false;
            if (!collection.isEmpty()) {
                return CollectionsKt.distinct((Iterable)kotlinDslTemplates);
            }
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                ScriptUtilsKt.scriptingInfoLog((String)("IllegalStateException loading gradle script templates: " + t.getMessage()));
            } else {
                ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)((Function0)new Function0<String>(t){
                    final /* synthetic */ Throwable $t;

                    @NotNull
                    public final String invoke() {
                        return "error loading gradle script templates " + this.$t.getMessage();
                    }
                    {
                        this.$t = throwable;
                        super(0);
                    }
                }), (int)1, null);
            }
            return CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, t.getMessage())));
        }
        return CollectionsKt.listOf((Object)((Object)new ErrorGradleScriptDefinition(this.project, null, 2, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ScriptDefinition> loadGradleTemplates(String projectPath, String templateClass, String gradleHome, String javaHome, List<? extends Path> templateClasspath2, List<? extends Path> additionalClassPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        LanguageVersion it;
        Object object;
        GradleExecutionSettings gradleExeSettings;
        block11: {
            block10: {
                gradleExeSettings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)projectPath, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                object = Companion.findStdLibLanguageVersion(templateClasspath2);
                if (object == null) break block10;
                LanguageVersion languageVersion = object;
                boolean bl = false;
                boolean bl2 = false;
                it = languageVersion;
                boolean bl3 = false;
                object = CollectionsKt.listOf((Object[])new String[]{"-language-version", it.getVersionString()});
                if (object != null) break block11;
            }
            object = CollectionsKt.emptyList();
        }
        Object defaultCompilerOptions = object;
        GradleExecutionSettings gradleExecutionSettings = gradleExeSettings;
        Intrinsics.checkNotNullExpressionValue((Object)gradleExecutionSettings, (String)"gradleExeSettings");
        ScriptingHostConfiguration hostConfiguration = this.createHostConfiguration(projectPath, gradleHome, javaHome, gradleExecutionSettings);
        Iterable iterable = ScriptDefinitionsManagerKt.loadDefinitionsFromTemplatesByPaths((List)CollectionsKt.listOf((Object)templateClass), templateClasspath2, (ScriptingHostConfiguration)hostConfiguration, additionalClassPath, (Iterable)((Iterable)defaultCompilerOptions));
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScriptDefinition scriptDefinition;
            KotlinScriptDefinition kotlinScriptDefinition;
            void it2;
            ScriptDefinition scriptDefinition2 = (ScriptDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void this_$iv = it2;
            boolean $i$f$asLegacyOrNull = false;
            if (this_$iv instanceof ScriptDefinition.FromLegacy) {
                KotlinScriptDefinition kotlinScriptDefinition2 = this_$iv.getLegacyDefinition();
                if (!(kotlinScriptDefinition2 instanceof KotlinScriptDefinitionFromAnnotatedTemplate)) {
                    kotlinScriptDefinition2 = null;
                }
                kotlinScriptDefinition = (KotlinScriptDefinition)((KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition2);
            } else {
                kotlinScriptDefinition = null;
            }
            if ((KotlinScriptDefinitionFromAnnotatedTemplate)kotlinScriptDefinition != null) {
                KotlinScriptDefinitionFromAnnotatedTemplate kotlinScriptDefinitionFromAnnotatedTemplate;
                boolean bl4 = false;
                boolean bl5 = false;
                KotlinScriptDefinitionFromAnnotatedTemplate legacyDef = kotlinScriptDefinitionFromAnnotatedTemplate;
                boolean bl6 = false;
                String string = GradleInstallationManager.getGradleVersion((String)gradleHome);
                if (string == null) {
                    GradleVersion gradleVersion = GradleVersion.current();
                    Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"GradleVersion.current()");
                    string = gradleVersion.getVersion();
                }
                String version = string;
                ScriptingHostConfiguration scriptingHostConfiguration = it2.getHostConfiguration();
                String string2 = version;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"version");
                scriptDefinition = (ScriptDefinition)new GradleKotlinScriptDefinitionWrapper(scriptingHostConfiguration, legacyDef, string2, (Iterable)defaultCompilerOptions);
            } else {
                scriptDefinition = it2;
            }
            void var26_28 = scriptDefinition;
            collection.add(var26_28);
        }
        return (List)destination$iv$iv;
    }

    private final ScriptingHostConfiguration createHostConfiguration(String projectPath, String gradleHome, String javaHome, GradleExecutionSettings gradleExeSettings) {
        Map map;
        File file;
        File file2;
        String p1;
        Pair[] pairArray;
        Pair[] pairArray2;
        int n;
        String string;
        boolean bl;
        boolean bl2;
        String string2;
        List list = gradleExeSettings.getJvmArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"gradleExeSettings.jvmArguments");
        List gradleJvmOptions = list;
        Pair[] pairArray3 = new Pair[6];
        Pair[] pairArray4 = pairArray3;
        Pair[] pairArray5 = pairArray3;
        int n2 = 0;
        String string3 = "gradleHome";
        String string4 = gradleHome;
        if (string4 != null) {
            string2 = string4;
            bl2 = false;
            bl = false;
            String string5 = string2;
            string = string3;
            n = n2;
            pairArray2 = pairArray4;
            pairArray = pairArray5;
            boolean bl3 = false;
            file2 = new File(p1);
            pairArray5 = pairArray;
            pairArray4 = pairArray2;
            n2 = n;
            string3 = string;
            file = file2;
        } else {
            file = null;
        }
        pairArray4[n2] = TuplesKt.to((Object)string3, file);
        pairArray5[1] = TuplesKt.to((Object)"gradleJavaHome", (Object)javaHome);
        string2 = projectPath;
        bl2 = false;
        bl = false;
        p1 = string2;
        string = "projectRoot";
        n = 2;
        pairArray2 = pairArray5;
        pairArray = pairArray5;
        boolean bl4 = false;
        file2 = new File(p1);
        pairArray2[n] = TuplesKt.to((Object)string, (Object)file2);
        Pair[] pairArray6 = pairArray;
        pairArray[3] = TuplesKt.to((Object)"gradleOptions", (Object)CollectionsKt.emptyList());
        pairArray6[4] = TuplesKt.to((Object)"gradleJvmOptions", (Object)gradleJvmOptions);
        if (gradleExeSettings.isPassParentEnvs()) {
            Map map2 = EnvironmentUtil.getEnvironmentMap();
            map = map2;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"EnvironmentUtil.getEnvironmentMap()");
        } else {
            map = MapsKt.emptyMap();
        }
        pairArray6[5] = TuplesKt.to((Object)"gradleEnvironmentVariables", (Object)map);
        Map environment = MapsKt.mapOf((Pair[])pairArray6);
        return new ScriptingHostConfiguration(new ScriptingHostConfiguration[]{JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration()}, (Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>(environment){
            final /* synthetic */ Map $environment;

            public final void invoke(@NotNull ScriptingHostConfiguration.Builder $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment((ScriptingHostConfigurationKeys)((ScriptingHostConfigurationKeys)$receiver)), (Object)new Function0<Map<String, ? extends Object>>(this){
                    final /* synthetic */ createHostConfiguration.1 this$0;

                    @NotNull
                    public final Map<String, Object> invoke() {
                        return this.this$0.$environment;
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$environment = map;
                super(1);
            }
        });
    }

    private final void subscribeToGradleSettingChanges() {
        GradleSettingsListenerAdapter listener2 = new GradleSettingsListenerAdapter(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;

            public void onGradleVmOptionsChange(@Nullable String oldOptions, @Nullable String newOptions) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleHomeChange(@Nullable String oldPath, @Nullable String newPath, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onServiceDirectoryPathChange(@Nullable String oldPath, @Nullable String newPath) {
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }

            public void onGradleDistributionTypeChange(@Nullable DistributionType currentValue, @NotNull String linkedProjectPath) {
                Intrinsics.checkNotNullParameter((Object)linkedProjectPath, (String)"linkedProjectPath");
                GradleScriptDefinitionsContributor.access$forceReload(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.project.getMessageBus().connect().subscribe(GradleSettingsListener.TOPIC, (Object)listener2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Sequence<ScriptDefinition> getDefinitions() {
        Object object;
        Object object2;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object object3;
        Enumeration<LightGradleBuildRoot> enumeration = this.definitionsByRoots.keys();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"definitionsByRoots.keys()");
        CollectionsKt.iterator(enumeration).forEachRemaining(new Consumer(this){
            final /* synthetic */ GradleScriptDefinitionsContributor this$0;

            public final void accept(LightGradleBuildRoot root) {
                LightGradleBuildRoot lightGradleBuildRoot = root;
                Intrinsics.checkNotNullExpressionValue((Object)lightGradleBuildRoot, (String)"root");
                if (GradleScriptDefinitionsContributor.access$isError(this.this$0, lightGradleBuildRoot)) {
                    ((Map)GradleScriptDefinitionsContributor.access$getDefinitionsByRoots$p(this.this$0)).put(root, GradleScriptDefinitionsContributor.access$loadGradleDefinitions(this.this$0, root));
                }
            }
            {
                this.this$0 = gradleScriptDefinitionsContributor;
            }
        });
        if (this.definitionsByRoots.isEmpty() && (object3 = GradleBuildRootsManager.Companion.getInstance(this.project)) != null && (object3 = ((GradleBuildRootsLocator)object3).getAllRoots()) != null) {
            $this$forEach$iv = (Iterable)object3;
            $i$f$forEach = false;
            object2 = $this$forEach$iv.iterator();
            while (object2.hasNext()) {
                void gradleHome;
                Pair pair;
                Object element$iv = object2.next();
                GradleBuildRoot it = (GradleBuildRoot)element$iv;
                boolean bl = false;
                String workingDir = it.getPathPrefix();
                object = it;
                if (object instanceof Imported) {
                    pair = TuplesKt.to((Object)((Imported)it).getData().getGradleHome(), (Object)((Imported)it).getData().getJavaHome());
                } else if (object instanceof WithoutScriptModels) {
                    GradleExecutionSettings settings;
                    GradleExecutionSettings gradleExecutionSettings = settings = (GradleExecutionSettings)ExternalSystemApiUtil.getExecutionSettings((Project)this.project, (String)workingDir, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                    Intrinsics.checkNotNullExpressionValue((Object)gradleExecutionSettings, (String)"settings");
                    pair = TuplesKt.to((Object)gradleExecutionSettings.getGradleHome(), (Object)settings.getJavaHome());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Pair pair2 = pair;
                String string = (String)pair2.component1();
                String javaHome = (String)pair2.component2();
                LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, (String)gradleHome, javaHome);
                ((Map)this.definitionsByRoots).put(root, this.loadGradleDefinitions(root));
            }
        }
        $this$forEach$iv = this.definitionsByRoots;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            void $this$flatMapTo$iv$iv;
            Map $this$flatMap$iv = this.definitionsByRoots;
            boolean $i$f$flatMap = false;
            object2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            void bl = $this$flatMapTo$iv$iv;
            boolean bl2 = false;
            object = bl.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = (Map.Entry)object.next();
                boolean bl3 = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        }
        return SequencesKt.sequenceOf((Object[])new ErrorGradleScriptDefinition[]{new ErrorGradleScriptDefinition(this.project, null, 2, null)});
    }

    public GradleScriptDefinitionsContributor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.id = "Gradle Kotlin DSL";
        this.definitionsByRoots = new ConcurrentHashMap();
        this.subscribeToGradleSettingChanges();
    }

    static {
        Companion = new Companion(null);
        kotlinDslDependencySelector = new Regex("^gradle-(?:kotlin-dsl|core).*\\.jar$");
        kotlinStdLibSelector = new Regex("^(kotlin-compiler-embeddable|kotlin-stdlib)-(\\d+\\.\\d+).*\\.jar$");
    }

    @NotNull
    public List<KotlinScriptDefinition> getDefinitions() {
        return ScriptDefinitionSourceAsContributor.DefaultImpls.getDefinitions((ScriptDefinitionSourceAsContributor)this);
    }

    public static final /* synthetic */ void access$forceReload(GradleScriptDefinitionsContributor $this) {
        $this.forceReload();
    }

    public static final /* synthetic */ List access$loadGradleDefinitions(GradleScriptDefinitionsContributor $this, LightGradleBuildRoot root) {
        return $this.loadGradleDefinitions(root);
    }

    public static final /* synthetic */ Regex access$getKotlinDslDependencySelector$cp() {
        return kotlinDslDependencySelector;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleScriptDefinitionsContributor$LightGradleBuildRoot;", "", "workingDir", "", "gradleHome", "javaHome", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGradleHome", "()Ljava/lang/String;", "getJavaHome", "getWorkingDir", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.gradle.gradle-idea"})
    private static final class LightGradleBuildRoot {
        @NotNull
        private final String workingDir;
        @Nullable
        private final String gradleHome;
        @Nullable
        private final String javaHome;

        @NotNull
        public final String getWorkingDir() {
            return this.workingDir;
        }

        @Nullable
        public final String getGradleHome() {
            return this.gradleHome;
        }

        @Nullable
        public final String getJavaHome() {
            return this.javaHome;
        }

        public LightGradleBuildRoot(@NotNull String workingDir, @Nullable String gradleHome, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            this.workingDir = workingDir;
            this.gradleHome = gradleHome;
            this.javaHome = javaHome;
        }

        @NotNull
        public final String component1() {
            return this.workingDir;
        }

        @Nullable
        public final String component2() {
            return this.gradleHome;
        }

        @Nullable
        public final String component3() {
            return this.javaHome;
        }

        @NotNull
        public final LightGradleBuildRoot copy(@NotNull String workingDir, @Nullable String gradleHome, @Nullable String javaHome) {
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            return new LightGradleBuildRoot(workingDir, gradleHome, javaHome);
        }

        public static /* synthetic */ LightGradleBuildRoot copy$default(LightGradleBuildRoot lightGradleBuildRoot, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = lightGradleBuildRoot.workingDir;
            }
            if ((n & 2) != 0) {
                string2 = lightGradleBuildRoot.gradleHome;
            }
            if ((n & 4) != 0) {
                string3 = lightGradleBuildRoot.javaHome;
            }
            return lightGradleBuildRoot.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "LightGradleBuildRoot(workingDir=" + this.workingDir + ", gradleHome=" + this.gradleHome + ", javaHome=" + this.javaHome + ")";
        }

        public int hashCode() {
            String string = this.workingDir;
            String string2 = this.gradleHome;
            String string3 = this.javaHome;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LightGradleBuildRoot)) break block3;
                    LightGradleBuildRoot lightGradleBuildRoot = (LightGradleBuildRoot)object;
                    if (!Intrinsics.areEqual((Object)this.workingDir, (Object)lightGradleBuildRoot.workingDir) || !Intrinsics.areEqual((Object)this.gradleHome, (Object)lightGradleBuildRoot.gradleHome) || !Intrinsics.areEqual((Object)this.javaHome, (Object)lightGradleBuildRoot.javaHome)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ2\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010J*\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleScriptDefinitionsContributor$Companion;", "", "()V", "kotlinDslDependencySelector", "Lkotlin/text/Regex;", "kotlinStdLibSelector", "findStdLibLanguageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "classpath", "", "Ljava/nio/file/Path;", "getDefinitions", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "workingDir", "", "gradleHome", "javaHome", "getDefinitionsTemplateClasspath", "getFullDefinitionsClasspath", "Lkotlin/Pair;", "kotlinStdlibAndCompiler", "gradleLibDir", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final List<ScriptDefinition> getDefinitions(@NotNull Project project, @NotNull String workingDir, @Nullable String gradleHome, @Nullable String javaHome) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
            List list = ScriptDefinitionContributor.Companion.getEP_NAME().getExtensions((AreaInstance)project);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ScriptDefinitionContribu\u2026ME.getExtensions(project)");
            Iterable iterable = list;
            boolean $i$f$filterIsInstance = false;
            void var8_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof GradleScriptDefinitionsContributor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            GradleScriptDefinitionsContributor contributor = (GradleScriptDefinitionsContributor)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
            if (contributor == null) {
                ScriptUtilsKt.scriptingInfoLog((String)("cannot find gradle script definitions contributor in ScriptDefinitionContributor.EP_NAME list: " + "workingDir=" + workingDir + " gradleHome=" + gradleHome));
                return null;
            }
            if (gradleHome == null) {
                ScriptUtilsKt.scriptingInfoLog((String)(KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]) + ": workingDir=" + workingDir + " gradleHome=" + gradleHome));
                return null;
            }
            LightGradleBuildRoot root = new LightGradleBuildRoot(workingDir, gradleHome, javaHome);
            $i$f$filterIsInstance = false;
            boolean bl = false;
            GradleScriptDefinitionsContributor $this$with = contributor;
            boolean bl2 = false;
            if ($this$with.isError(root)) {
                return null;
            }
            List definitions2 = (List)contributor.definitionsByRoots.get(root);
            if (definitions2 == null) {
                ScriptUtilsKt.scriptingInfoLog((String)("script definitions aren't loaded yet. They should be loaded by invoking GradleScriptDefinitionsContributor.reloadIfNeeded from KotlinDslSyncListener: " + "workingDir=" + workingDir + " gradleHome=" + gradleHome));
                return null;
            }
            return definitions2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getDefinitionsTemplateClasspath(@Nullable String gradleHome) {
            List list;
            try {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)this.getFullDefinitionsClasspath(gradleHome).getFirst();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void receiver;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = PathKt.getSystemIndependentPath((Path)((Path)receiver));
                    collection.add(string);
                }
                list = (List)destination$iv$iv;
            }
            catch (Throwable e) {
                ScriptUtilsKt.scriptingInfoLog((String)("cannot get gradle classpath for Gradle Kotlin DSL scripts: " + e.getMessage()));
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final Pair<List<Path>, List<Path>> getFullDefinitionsClasspath(String gradleHome) {
            if (gradleHome == null) {
                var2_2 = KotlinIdeaGradleBundle.message("error.text.unable.to.get.gradle.home.directory", new Object[0]);
                var3_4 = false;
                throw (Throwable)new IllegalStateException(var2_2.toString());
            }
            var3_5 /* !! */  = new String[]{"lib"};
            var4_6 = false;
            v0 = Paths.get(gradleHome, Arrays.copyOf(var3_5 /* !! */ , var3_5 /* !! */ .length));
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"Paths.get(base, *subpaths)");
            var3_5 /* !! */  = v0;
            var4_6 = false;
            var5_8 = false;
            it /* !! */  = var3_5 /* !! */ ;
            $i$a$-let-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1 = false;
            var8_17 = it /* !! */ ;
            var9_19 = false;
            var10_20 = false;
            it /* !! */  = var8_17;
            $i$a$-takeIf-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$gradleLibDir$1$1 = false;
            var13_23 /* !! */  = it /* !! */ ;
            var14_24 = new LinkOption[]{};
            var15_25 = false;
            if (!Files.exists((Path)var13_23 /* !! */ , Arrays.copyOf(var14_24, var14_24.length))) ** GOTO lbl-1000
            var13_23 /* !! */  = it /* !! */ ;
            var14_24 = new LinkOption[]{};
            var15_25 = false;
            if (Files.isDirectory((Path)var13_23 /* !! */ , Arrays.copyOf(var14_24, var14_24.length))) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            v2 /* !! */  = v1 != false ? var8_17 : null;
            if (v2 /* !! */  == null) {
                var8_17 = KotlinIdeaGradleBundle.message("error.text.invalid.gradle.libraries.directory", new Object[]{it /* !! */ });
                var9_19 = false;
                throw (Throwable)new IllegalStateException(var8_17.toString());
            }
            gradleLibDir /* !! */  = v2 /* !! */ ;
            var4_7 = Files.newDirectoryStream((Path)gradleLibDir /* !! */ , getFullDefinitionsClasspath.templateClasspath.1.INSTANCE);
            var5_8 = false;
            it = false;
            it = null;
            try {
                p1 = (DirectoryStream)var4_7;
                $i$a$-unknown-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$templateClasspath$2 = false;
                var7_14 = CollectionsKt.toList((Iterable)p1);
            }
            catch (Throwable var7_15) {
                it = var7_15;
                throw var7_15;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var4_7, (Throwable)it);
            }
            var4_7 = (Collection)var7_14;
            var5_8 = false;
            if (var4_7.isEmpty()) {
                $i$a$-ifEmpty-GradleScriptDefinitionsContributor$Companion$getFullDefinitionsClasspath$templateClasspath$3 = false;
                var7_14 = KotlinIdeaGradleBundle.message("error.text.missing.jars.in.gradle.directory", new Object[0]);
                var8_18 = false;
                throw (Throwable)new IllegalStateException(var7_14.toString());
            }
            templateClasspath = (List)var4_7;
            ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)((Function0)new Function0<String>(templateClasspath){
                final /* synthetic */ List $templateClasspath;

                @NotNull
                public final String invoke() {
                    return "gradle script templates classpath " + this.$templateClasspath;
                }
                {
                    this.$templateClasspath = list;
                    super(0);
                }
            }), (int)1, null);
            additionalClassPath = this.kotlinStdlibAndCompiler((Path)gradleLibDir /* !! */ );
            ScriptUtilsKt.scriptingDebugLog$default(null, (Function0)((Function0)new Function0<String>(templateClasspath){
                final /* synthetic */ List $templateClasspath;

                @NotNull
                public final String invoke() {
                    return "gradle script templates additional classpath " + this.$templateClasspath;
                }
                {
                    this.$templateClasspath = list;
                    super(0);
                }
            }), (int)1, null);
            return TuplesKt.to((Object)templateClasspath, additionalClassPath);
        }

        private final List<Path> kotlinStdlibAndCompiler(Path gradleLibDir) {
            List list;
            boolean bl;
            Path path;
            Path path2 = (Path)CollectionsKt.firstOrNull((List)PathsKt.listDirectoryEntries((Path)gradleLibDir, (String)"{kotlin-compiler-embeddable,kotlin-stdlib}*"));
            if (path2 != null) {
                path = path2;
                bl = false;
                boolean bl2 = false;
                Path p1 = path;
                boolean bl3 = false;
                list = CollectionsKt.listOf((Object)p1);
            } else {
                list = null;
            }
            path = list;
            bl = false;
            Iterable<Path> iterable = path;
            if (iterable == null) {
                iterable = CollectionsKt.emptyList();
            }
            return iterable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Nullable
        public final LanguageVersion findStdLibLanguageVersion(@NotNull List<? extends Path> classpath) {
            void $this$mapNotNullTo$iv$iv;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
            Iterable $this$map$iv = classpath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path = it.getParent();
                collection.add(path);
            }
            Iterable $this$mapNotNull$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            boolean $i$f$mapNotNull = false;
            $this$mapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                LanguageVersion languageVersion;
                LanguageVersion languageVersion2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Path path = (Path)element$iv$iv;
                boolean bl2 = false;
                Closeable closeable = Files.newDirectoryStream(path, findStdLibLanguageVersion.2.1.INSTANCE);
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    MatchResult matchResult;
                    Path resultPath;
                    DirectoryStream it = (DirectoryStream)closeable;
                    boolean bl5 = false;
                    DirectoryStream directoryStream = it;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
                    languageVersion2 = (Path)CollectionsKt.firstOrNull((Iterable)directoryStream) == null ? null : (Regex.find$default((Regex)kotlinStdLibSelector, (CharSequence)PathsKt.getName((Path)resultPath), (int)0, (int)2, null) == null ? null : LanguageVersion.Companion.fromVersionString((String)matchResult.getGroupValues().get(2)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                if (languageVersion2 == null) continue;
                boolean bl6 = false;
                boolean bl7 = false;
                LanguageVersion it$iv$iv = languageVersion;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (LanguageVersion)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

