/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\n\u001a2\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00120\u00110\u0010\"\b\b\u0000\u0010\u0012*\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"KOTLIN_PLUGIN_CLASSPATH_MARKER", "", "KOTLIN_PLUGIN_PATH_MARKER", "KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO", "findGradleProjectStructure", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "findKotlinPluginVersion", "classpathData", "Lorg/jetbrains/plugins/gradle/model/data/BuildScriptClasspathData;", "getResolvedKotlinGradleVersion", "findAll", "", "Lorg/jetbrains/kotlin/idea/inspections/gradle/NodeWithData;", "T", "", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleInspectionVisitorKt {
    @NotNull
    public static final String KOTLIN_PLUGIN_CLASSPATH_MARKER = "org.jetbrains.kotlin:kotlin-gradle-plugin:";
    private static final String KOTLIN_PLUGIN_PATH_MARKER = "org.jetbrains.kotlin/kotlin-gradle-plugin/";
    private static final String KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO = StringsKt.replace$default((String)"org.jetbrains.kotlin", (char)'.', (char)'/', (boolean)false, (int)4, null) + "/kotlin-gradle-plugin/";

    @Nullable
    public static final String getResolvedKotlinGradleVersion(@NotNull PsiFile file) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module2;
            boolean bl3 = false;
            Module module3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
            string = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(module3);
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getResolvedKotlinGradleVersion(@NotNull Module module) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(module);
        if (dataNode == null) {
            return null;
        }
        DataNode<ProjectData> projectStructureNode = dataNode;
        Key key = ProjectKeys.MODULE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ProjectKeys.MODULE");
        Iterable $this$filter$iv = KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NodeWithData it = (NodeWithData)element$iv$iv;
            boolean bl = false;
            Object t = it.getData();
            Intrinsics.checkNotNullExpressionValue(t, (String)"it.data");
            if (!Intrinsics.areEqual((Object)((ModuleData)t).getInternalName(), (Object)module.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (NodeWithData moduleData : (List)destination$iv$iv) {
            DataNode<?> dataNode2 = moduleData.getNode();
            Key key2 = BuildScriptClasspathData.KEY;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"BuildScriptClasspathData.KEY");
            NodeWithData nodeWithData = (NodeWithData)CollectionsKt.firstOrNull(KotlinGradleInspectionVisitorKt.findAll(dataNode2, key2));
            if (nodeWithData == null || (nodeWithData = (BuildScriptClasspathData)nodeWithData.getData()) == null) {
                continue;
            }
            NodeWithData buildScriptClasspathData = nodeWithData;
            String kotlinPluginVersion = KotlinGradleInspectionVisitorKt.findKotlinPluginVersion((BuildScriptClasspathData)buildScriptClasspathData);
            if (kotlinPluginVersion == null) continue;
            return kotlinPluginVersion;
        }
        return null;
    }

    @Nullable
    public static final String findKotlinPluginVersion(@NotNull BuildScriptClasspathData classpathData) {
        Intrinsics.checkNotNullParameter((Object)classpathData, (String)"classpathData");
        List list = classpathData.getClasspathEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classpathData.classpathEntries");
        Iterator iterator = CollectionsKt.asReversedMutable((List)list).iterator();
        while (iterator.hasNext()) {
            BuildScriptClasspathData.ClasspathEntry classPathEntry;
            BuildScriptClasspathData.ClasspathEntry classpathEntry = classPathEntry = (BuildScriptClasspathData.ClasspathEntry)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)classpathEntry, (String)"classPathEntry");
            Iterator iterator2 = classpathEntry.getClassesFile().iterator();
            while (iterator2.hasNext()) {
                String versionSubstring;
                String path;
                String string = path = (String)iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                String uniformedPath = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                if (!(StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)KOTLIN_PLUGIN_PATH_MARKER, (boolean)false, (int)2, null) ? Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)KOTLIN_PLUGIN_PATH_MARKER, null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>") ^ true : StringsKt.contains$default((CharSequence)uniformedPath, (CharSequence)KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO, (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)(versionSubstring = StringsKt.substringBefore((String)StringsKt.substringAfter$default((String)uniformedPath, (String)KOTLIN_PLUGIN_PATH_MARKER_FOR_MAVEN_LOCAL_REPO, null, (int)2, null), (char)'/', (String)"<error>")), (Object)"<error>") ^ true)) continue;
                return versionSubstring;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<NodeWithData<T>> findAll(@NotNull DataNode<?> $this$findAll, @NotNull Key<T> key) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findAll, (String)"$this$findAll");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Collection collection = ExternalSystemApiUtil.findAll($this$findAll, key);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.findAll(this, key)");
        Collection nodes = collection;
        Iterable $this$mapNotNull$iv = nodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NodeWithData<Object> nodeWithData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            if (it.getData(key) == null) {
                nodeWithData = null;
            } else {
                Object data;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"it.getData(key) ?: return@mapNotNull null");
                DataNode dataNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
                nodeWithData = new NodeWithData<Object>(dataNode, data);
            }
            if (nodeWithData == null) continue;
            NodeWithData<Object> nodeWithData2 = nodeWithData;
            boolean bl3 = false;
            boolean bl4 = false;
            NodeWithData<Object> it$iv$iv = nodeWithData2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull PsiFile file) {
        DataNode<ProjectData> dataNode;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        if (module != null) {
            Module module2 = module;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module2;
            boolean bl3 = false;
            Module module3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
            dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(module3);
        } else {
            dataNode = null;
        }
        return dataNode;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemApiUtil.ge\u2026th(module) ?: return null");
        String externalProjectPath = string;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)KotlinLibraryUtilKt.getGRADLE_SYSTEM_ID(), (String)externalProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"ExternalSystemUtil.getEx\u2026ojectPath) ?: return null");
        ExternalProjectInfo projectInfo = externalProjectInfo;
        return projectInfo.getExternalProjectStructure();
    }
}

