/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ExternalLibraryInfo;
import org.jetbrains.kotlin.idea.configuration.LibraryUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootGroup;
import org.jetbrains.kotlin.idea.configuration.ModuleSourceRootMapKt;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.inspections.gradle.DeprecatedGradleDependencyInspectionKt;
import org.jetbrains.kotlin.idea.inspections.gradle.DifferentStdlibGradleVersionInspection;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u00012\u00020\u0002:\u0002\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DeprecatedGradleDependencyInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "DependencyFinder", "kotlin.gradle.gradle-idea"})
public final class DeprecatedGradleDependencyInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new DependencyFinder();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0012\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DeprecatedGradleDependencyInspection$DependencyFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "()V", "reportOnElement", "Lcom/intellij/psi/PsiElement;", "classpathEntry", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "deprecatedInfo", "Lorg/jetbrains/kotlin/idea/versions/DeprecatedLibInfo;", "visitClosure", "", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "visitDependencyEntry", "dependencyStatement", "kotlin.gradle.gradle-idea"})
    private static class DependencyFinder
    extends KotlinGradleInspectionVisitor {
        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
            boolean $i$f$getStrictParentOfType = false;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            GrExpression grExpression = dependenciesCall.getInvokedExpression();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"dependenciesCall.invokedExpression");
            if (Intrinsics.areEqual((Object)grExpression.getText(), (Object)"dependencies") ^ true) {
                return;
            }
            List<GrCallExpression> dependencyEntries = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleHeuristicHelper.INSTANCE.getPRODUCTION_DEPENDENCY_STATEMENTS());
            for (GrCallExpression dependencyStatement : dependencyEntries) {
                this.visitDependencyEntry(dependencyStatement);
            }
        }

        public void visitDependencyEntry(@NotNull GrCallExpression dependencyStatement) {
            Intrinsics.checkNotNullParameter((Object)dependencyStatement, (String)"dependencyStatement");
            for (DeprecatedLibInfo outdatedInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
                String libVersion;
                Character afterMarkerChar;
                String dependencyText = dependencyStatement.getText();
                String libMarker = DeprecatedGradleDependencyInspectionKt.access$getGradleMarker$p(outdatedInfo.getOld());
                String string = dependencyText;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependencyText");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)libMarker, (boolean)false, (int)2, null)) continue;
                Character c = afterMarkerChar = StringsKt.getOrNull((CharSequence)StringsKt.substringAfter$default((String)dependencyText, (String)libMarker, null, (int)2, null), (int)0);
                if (c == null || c.charValue() != '\'') {
                    Character c2 = afterMarkerChar;
                    if (c2 == null || c2.charValue() != '\"') {
                        Character c3 = afterMarkerChar;
                        if (c3 == null || c3.charValue() != ':') continue;
                    }
                }
                PsiFile psiFile = dependencyStatement.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"dependencyStatement.containingFile");
                String string2 = DifferentStdlibGradleVersionInspection.Companion.getResolvedLibVersion(psiFile, outdatedInfo.getOld().getGroupId(), CollectionsKt.listOf((Object)outdatedInfo.getOld().getName()));
                if (string2 == null) {
                    PsiFile psiFile2 = dependencyStatement.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"dependencyStatement.containingFile");
                    string2 = Companion.libraryVersionFromOrderEntry(psiFile2, outdatedInfo.getOld().getName());
                }
                if ((libVersion = string2) == null || VersionComparatorUtil.COMPARATOR.compare(libVersion, outdatedInfo.getOutdatedAfterVersion()) < 0) continue;
                PsiElement reportOnElement = this.reportOnElement(dependencyStatement, outdatedInfo);
                this.registerError(reportOnElement, outdatedInfo.getMessage(), (LocalQuickFix[])new ReplaceStringInDocumentFix[]{new ReplaceStringInDocumentFix(reportOnElement, outdatedInfo.getOld().getName(), outdatedInfo.getNew().getName())}, ProblemHighlightType.LIKE_DEPRECATED);
                break;
            }
        }

        private final PsiElement reportOnElement(GrCallExpression classpathEntry, DeprecatedLibInfo deprecatedInfo) {
            String string = classpathEntry.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classpathEntry.text");
            int indexOf = StringsKt.indexOf$default((CharSequence)string, (String)deprecatedInfo.getOld().getName(), (int)0, (boolean)false, (int)6, null);
            if (indexOf < 0) {
                return (PsiElement)classpathEntry;
            }
            PsiElement psiElement = classpathEntry.findElementAt(indexOf);
            if (psiElement == null) {
                psiElement = (PsiElement)classpathEntry;
            }
            return psiElement;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DeprecatedGradleDependencyInspection$Companion;", "", "()V", "libraryVersionFromOrderEntry", "", "file", "Lcom/intellij/psi/PsiFile;", "libraryId", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String libraryVersionFromOrderEntry(@NotNull PsiFile file, @NotNull String libraryId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            Module module = projectRootManager.getFileIndex().getModuleForFile(file.getVirtualFile());
            if (module == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ProjectRootManager.getIn\u2026rtualFile) ?: return null");
            Module module2 = module;
            String libMarker = ':' + libraryId + ':';
            for (Module moduleInGroup : ModuleSourceRootMapKt.allModules((ModuleSourceRootGroup)ModuleSourceRootMapKt.getWholeModuleGroup((Module)module2))) {
                void libVersion;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                ModuleRootManager.getInstance((Module)moduleInGroup).orderEntries().forEachLibrary(new Processor(libMarker, (Ref.ObjectRef)libVersion){
                    final /* synthetic */ String $libMarker;
                    final /* synthetic */ Ref.ObjectRef $libVersion;

                    public final boolean process(Library library) {
                        Library library2 = library;
                        Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"library");
                        String string = library2.getName();
                        if (string != null) {
                            if (StringsKt.contains$default((CharSequence)string, (CharSequence)this.$libMarker, (boolean)false, (int)2, null)) {
                                ExternalLibraryInfo externalLibraryInfo = LibraryUtilsKt.parseExternalLibraryName((Library)library);
                                this.$libVersion.element = externalLibraryInfo != null ? externalLibraryInfo.getVersion() : null;
                            }
                        }
                        return (String)this.$libVersion.element == null;
                    }
                    {
                        this.$libMarker = string;
                        this.$libVersion = objectRef;
                    }
                });
                if ((String)libVersion.element == null) continue;
                return (String)libVersion.element;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

