/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.task.ExecuteRunConfigurationTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.run.KotlinRunConfiguration;
import org.jetbrains.plugins.gradle.execution.build.GradleBaseApplicationEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JT\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/execution/KotlinGradleAppEnvProvider;", "Lorg/jetbrains/plugins/gradle/execution/build/GradleBaseApplicationEnvironmentProvider;", "Lorg/jetbrains/kotlin/idea/run/KotlinRunConfiguration;", "()V", "generateInitScript", "", "applicationConfiguration", "module", "Lcom/intellij/openapi/module/Module;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "gradleTaskPath", "runAppTaskName", "mainClass", "Lcom/intellij/psi/PsiClass;", "javaExePath", "sourceSetName", "javaModuleName", "isApplicable", "", "task", "Lcom/intellij/task/ExecuteRunConfigurationTask;", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleAppEnvProvider
extends GradleBaseApplicationEnvironmentProvider<KotlinRunConfiguration> {
    public boolean isApplicable(@NotNull ExecuteRunConfigurationTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        boolean enabled = Registry.is((String)"kotlin.gradle-run.enabled", (boolean)false);
        return enabled && task.getRunProfile() instanceof KotlinRunConfiguration;
    }

    @Nullable
    public String generateInitScript(@NotNull KotlinRunConfiguration applicationConfiguration, @NotNull Module module, @NotNull JavaParameters params, @NotNull String gradleTaskPath, @NotNull String runAppTaskName, @NotNull PsiClass mainClass, @NotNull String javaExePath, @NotNull String sourceSetName, @Nullable String javaModuleName) {
        String string;
        boolean bl;
        String string2;
        String rootProjectName;
        Intrinsics.checkNotNullParameter((Object)applicationConfiguration, (String)"applicationConfiguration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)gradleTaskPath, (String)"gradleTaskPath");
        Intrinsics.checkNotNullParameter((Object)runAppTaskName, (String)"runAppTaskName");
        Intrinsics.checkNotNullParameter((Object)mainClass, (String)"mainClass");
        Intrinsics.checkNotNullParameter((Object)javaExePath, (String)"javaExePath");
        Intrinsics.checkNotNullParameter((Object)sourceSetName, (String)"sourceSetName");
        String string3 = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (string3 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ExternalSystemApiUtil.ge\u2026th(module) ?: return null");
        String extProjectPath = string3;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module.getProject(), (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)extProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"ExternalSystemUtil.getEx\u2026ojectPath) ?: return null");
        ExternalProjectInfo extProjectInfo = externalProjectInfo;
        DataNode dataNode = GradleProjectResolverUtil.findModule((DataNode)extProjectInfo.getExternalProjectStructure(), (String)extProjectPath);
        if (dataNode == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"GradleProjectResolverUti\u2026ojectPath) ?: return null");
        DataNode extModuleData = dataNode;
        Object object = extModuleData.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extModuleData.data");
        String string4 = ((ModuleData)object).getId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"extModuleData.data.id");
        String projectPath = string4;
        if (StringsKt.startsWith$default((CharSequence)projectPath, (char)':', (boolean)false, (int)2, null)) {
            Object object2;
            DataNode dataNode2 = extModuleData.getParent();
            Object object3 = dataNode2 != null ? dataNode2.getData() : null;
            if (!(object3 instanceof ProjectData)) {
                object3 = null;
            }
            if ((object2 = (ProjectData)object3) == null || (object2 = object2.getExternalName()) == null) {
                object2 = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"(extModuleData.parent?.d\u2026Data)?.externalName ?: \"\"");
            rootProjectName = object2;
            string2 = rootProjectName + projectPath;
        } else {
            rootProjectName = projectPath;
            boolean bl2 = false;
            bl = false;
            String it = rootProjectName;
            boolean bl3 = false;
            string2 = StringsKt.contains$default((CharSequence)it, (char)':', (boolean)false, (int)2, null) ? rootProjectName : null;
            if (string2 == null) {
                string2 = projectPath + ':';
            }
        }
        String gradleProjectId = string2;
        String string5 = ProgramParametersUtil.getWorkingDir((CommonProgramRunConfigurationParameters)((CommonProgramRunConfigurationParameters)applicationConfiguration), (Project)module.getProject(), (Module)module);
        if (string5 != null) {
            String string6 = string5;
            bl = false;
            boolean bl4 = false;
            String it = string6;
            boolean bl5 = false;
            string = FileUtil.toSystemIndependentName((String)it);
        } else {
            string = null;
        }
        String workingDir = string;
        StringBuilder stringBuilder = new StringBuilder();
        ParametersList parametersList = params.getProgramParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList, (String)"params.programParametersList");
        List list = parametersList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"params.programParametersList.parameters");
        StringBuilder stringBuilder2 = stringBuilder.append(GradleBaseApplicationEnvironmentProvider.Companion.createEscapedParameters(list, "args"));
        ParametersList parametersList2 = params.getVMParametersList();
        Intrinsics.checkNotNullExpressionValue((Object)parametersList2, (String)"params.vmParametersList");
        List list2 = parametersList2.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"params.vmParametersList.parameters");
        String argsString = stringBuilder2.append(GradleBaseApplicationEnvironmentProvider.Companion.createEscapedParameters(list2, "jvmArgs")).toString();
        CharSequence charSequence = workingDir;
        boolean bl6 = false;
        boolean bl7 = false;
        String initScript = "\n    def gradleProjectId = '" + gradleProjectId + "'\n    def runAppTaskName = '" + runAppTaskName + "'\n    def mainClass = '" + mainClass.getQualifiedName() + "'\n    def javaExePath = '" + javaExePath + "'\n    def _workingDir = " + (charSequence == null || charSequence.length() == 0 ? "null\n" : '\'' + workingDir + "'\n") + "\n    def sourceSetName = '" + sourceSetName + "'\n    def javaModuleName = " + (javaModuleName == null ? "null\n" : '\'' + javaModuleName + "'\n") + "\n\n    allprojects {\n        afterEvaluate { project ->\n            if (project.rootProject.name + project.path == gradleProjectId) {\n                def overwrite = project.tasks.findByName(runAppTaskName) != null\n                project.tasks.create(name: runAppTaskName, overwrite: overwrite, type: JavaExec) {\n                    if (javaExePath) executable = javaExePath\n                    if (project.pluginManager.hasPlugin(\"org.jetbrains.kotlin.multiplatform\")) {\n                        project.kotlin.targets.each { target ->\n                            target.compilations.each { compilation ->\n                                if (compilation.defaultSourceSetName == sourceSetName) {\n                                    classpath = compilation.output.allOutputs + compilation.runtimeDependencyFiles\n                                }\n                            }\n                        }\n                    } else {\n                        classpath = project.sourceSets[sourceSetName].runtimeClasspath\n                    }\n    \n                    main = mainClass\n                    " + argsString + "\n                    if(_workingDir) workingDir = _workingDir\n                    standardInput = System.in\n                    if(javaModuleName) {\n                        inputs.property('moduleName', javaModuleName)\n                        doFirst {\n                            jvmArgs += [\n                                    '--module-path', classpath.asPath,\n                                    '--module', javaModuleName + '/' + mainClass\n                            ]\n                            classpath = files()\n                        }\n                    }\n                }\n            }\n        }\n    }\n    ";
        return initScript;
    }
}

