/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.utils;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.KotlinMPPGradleModel;
import org.jetbrains.kotlin.gradle.KotlinPlatform;
import org.jetbrains.kotlin.gradle.KotlinSourceSet;
import org.jetbrains.kotlin.idea.configuration.utils.TestSourceSetUtilsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a*\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\"*\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"*\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"immutable", "Lcom/google/common/graph/ImmutableGraph;", "T", "Lcom/google/common/graph/Graph;", "getImmutable", "(Lcom/google/common/graph/Graph;)Lcom/google/common/graph/ImmutableGraph;", "transitiveClosure", "getTransitiveClosure", "(Lcom/google/common/graph/Graph;)Lcom/google/common/graph/Graph;", "createSourceSetDependsOnGraph", "Lcom/google/common/graph/MutableGraph;", "Lorg/jetbrains/kotlin/gradle/KotlinSourceSet;", "sourceSetsByName", "", "", "model", "Lorg/jetbrains/kotlin/gradle/KotlinMPPGradleModel;", "createSourceSetVisibilityGraph", "getFixedDependsOnSourceSets", "", "sourceSet", "putInferredTestToProductionEdges", "", "kotlin.gradle.gradle-idea"})
public final class KotlinSourceSetGraphUtilKt {
    @NotNull
    public static final ImmutableGraph<KotlinSourceSet> createSourceSetVisibilityGraph(@NotNull KotlinMPPGradleModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MutableGraph<KotlinSourceSet> graph = KotlinSourceSetGraphUtilKt.createSourceSetDependsOnGraph(model);
        KotlinSourceSetGraphUtilKt.putInferredTestToProductionEdges(graph);
        return KotlinSourceSetGraphUtilKt.getImmutable((Graph)graph);
    }

    @NotNull
    public static final MutableGraph<KotlinSourceSet> createSourceSetDependsOnGraph(@NotNull KotlinMPPGradleModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return KotlinSourceSetGraphUtilKt.createSourceSetDependsOnGraph(model.getSourceSetsByName());
    }

    @NotNull
    public static final MutableGraph<KotlinSourceSet> createSourceSetDependsOnGraph(@NotNull Map<String, ? extends KotlinSourceSet> sourceSetsByName) {
        Intrinsics.checkNotNullParameter(sourceSetsByName, (String)"sourceSetsByName");
        MutableGraph graph = GraphBuilder.directed().build();
        Set sourceSets = CollectionsKt.toSet((Iterable)sourceSetsByName.values());
        for (KotlinSourceSet sourceSet : sourceSets) {
            graph.addNode((Object)sourceSet);
            Set<KotlinSourceSet> dependsOnSourceSets = KotlinSourceSetGraphUtilKt.getFixedDependsOnSourceSets(sourceSetsByName, sourceSet);
            for (KotlinSourceSet dependsOnSourceSet : dependsOnSourceSets) {
                graph.addNode((Object)dependsOnSourceSet);
                graph.putEdge((Object)sourceSet, (Object)dependsOnSourceSet);
            }
        }
        MutableGraph mutableGraph = graph;
        Intrinsics.checkNotNullExpressionValue((Object)mutableGraph, (String)"graph");
        return mutableGraph;
    }

    public static final void putInferredTestToProductionEdges(@NotNull MutableGraph<KotlinSourceSet> $this$putInferredTestToProductionEdges) {
        Intrinsics.checkNotNullParameter($this$putInferredTestToProductionEdges, (String)"$this$putInferredTestToProductionEdges");
        Set sourceSets = $this$putInferredTestToProductionEdges.nodes();
        for (KotlinSourceSet sourceSet : sourceSets) {
            KotlinSourceSet predictedMainSourceSet;
            Object v1;
            block3: {
                if (!sourceSet.isTestModule()) continue;
                String predictedMainSourceSetName = TestSourceSetUtilsKt.predictedProductionSourceSetName(sourceSet.getName());
                Set set = sourceSets;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sourceSets");
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KotlinSourceSet it = (KotlinSourceSet)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)predictedMainSourceSetName)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((KotlinSourceSet)v1 == null) {
                continue;
            }
            $this$putInferredTestToProductionEdges.putEdge((Object)sourceSet, (Object)predictedMainSourceSet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<KotlinSourceSet> getFixedDependsOnSourceSets(Map<String, ? extends KotlinSourceSet> sourceSetsByName, KotlinSourceSet sourceSet) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        List list;
        if (CollectionsKt.contains((Iterable)((Iterable)sourceSet.getActualPlatforms()), (Object)KotlinPlatform.ANDROID) && sourceSet.getDeclaredDependsOnSourceSets().isEmpty()) {
            String commonSourceSetName = sourceSet.isTestModule() ? "commonTest" : "commonMain";
            list = CollectionsKt.listOfNotNull((Object)sourceSetsByName.get(commonSourceSetName));
        } else {
            list = CollectionsKt.emptyList();
        }
        List implicitDependsOnEdgeForAndroid = list;
        Iterable $this$map$iv = sourceSet.getDeclaredDependsOnSourceSets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)MapsKt.getValue(sourceSetsByName, (Object)p1);
            collection.add(kotlinSourceSet);
        }
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)implicitDependsOnEdgeForAndroid);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinSourceSet dependencySourceSet = (KotlinSourceSet)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)dependencySourceSet, (Object)sourceSet) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final <T> Graph<T> getTransitiveClosure(@NotNull Graph<T> $this$transitiveClosure) {
        Intrinsics.checkNotNullParameter($this$transitiveClosure, (String)"$this$transitiveClosure");
        Graph graph = Graphs.transitiveClosure($this$transitiveClosure);
        Intrinsics.checkNotNullExpressionValue((Object)graph, (String)"Graphs.transitiveClosure(this)");
        return graph;
    }

    @NotNull
    public static final <T> ImmutableGraph<T> getImmutable(@NotNull Graph<T> $this$immutable) {
        Intrinsics.checkNotNullParameter($this$immutable, (String)"$this$immutable");
        ImmutableGraph immutableGraph = ImmutableGraph.copyOf($this$immutable);
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"ImmutableGraph.copyOf(this)");
        return immutableGraph;
    }
}

