/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.klib;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\r2\u0006\u0010\u000b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/KotlinNativeLibraryNameUtil;", "", "()V", "GRADLE_LIBRARY_PREFIX", "", "IDE_LIBRARY_NAME_REGEX", "Lkotlin/text/Regex;", "KOTLIN_NATIVE_LIBRARY_PREFIX", "KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE", "isGradleLibraryName", "", "ideLibraryName", "parseIDELibraryName", "Lkotlin/Triple;", "kotlin.gradle.gradle-idea"})
public final class KotlinNativeLibraryNameUtil {
    @NonNls
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX = "Kotlin/Native";
    @NotNull
    public static final String KOTLIN_NATIVE_LIBRARY_PREFIX_PLUS_SPACE = "Kotlin/Native ";
    @NonNls
    @NotNull
    public static final String GRADLE_LIBRARY_PREFIX = "Gradle: ";
    private static final Regex IDE_LIBRARY_NAME_REGEX;
    @NotNull
    public static final KotlinNativeLibraryNameUtil INSTANCE;

    @Nullable
    public final Triple<String, String, String> parseIDELibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        MatchResult matchResult = IDE_LIBRARY_NAME_REGEX.matchEntire((CharSequence)ideLibraryName);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        String kotlinVersion2 = matchGroup.getValue();
        MatchGroup matchGroup2 = match.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        String libraryName = matchGroup2.getValue();
        MatchGroup matchGroup3 = match.getGroups().get(4);
        String platformPart = matchGroup3 != null ? matchGroup3.getValue() : null;
        return new Triple((Object)kotlinVersion2, (Object)libraryName, (Object)platformPart);
    }

    public final boolean isGradleLibraryName(@NotNull String ideLibraryName) {
        Intrinsics.checkNotNullParameter((Object)ideLibraryName, (String)"ideLibraryName");
        return StringsKt.startsWith$default((String)ideLibraryName, (String)GRADLE_LIBRARY_PREFIX, (boolean)false, (int)2, null);
    }

    private KotlinNativeLibraryNameUtil() {
    }

    static {
        KotlinNativeLibraryNameUtil kotlinNativeLibraryNameUtil;
        INSTANCE = kotlinNativeLibraryNameUtil = new KotlinNativeLibraryNameUtil();
        IDE_LIBRARY_NAME_REGEX = new Regex("^Kotlin/Native ([^\\s]+) - ([^\\s]+)( \\[([\\w ,()*]+)])?$");
    }
}

