/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.klib;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.klib.DefaultKlibInfoProvider;
import org.jetbrains.kotlin.idea.configuration.klib.KlibInfo;
import org.jetbrains.kotlin.idea.configuration.klib.KlibInfoProvider;
import org.jetbrains.kotlin.idea.configuration.klib.KlibManifestProvider;
import org.jetbrains.kotlin.konan.properties.PropertiesKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/klib/DefaultKlibInfoProvider;", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfoProvider;", "kotlinNativeHome", "Ljava/io/File;", "manifestProvider", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibManifestProvider;", "(Ljava/io/File;Lorg/jetbrains/kotlin/idea/configuration/klib/KlibManifestProvider;)V", "nativeDistributionLibrarySourceFiles", "", "getNativeDistributionLibrarySourceFiles", "()Ljava/util/List;", "nativeDistributionLibrarySourceFiles$delegate", "Lkotlin/Lazy;", "findLibrarySources", "", "libraryFile", "manifest", "Ljava/util/Properties;", "getCommonizedKlibInfo", "Lorg/jetbrains/kotlin/idea/configuration/klib/KlibInfo;", "getKlibInfo", "getLibraryNameFromManifest", "", "kotlin.gradle.gradle-idea"})
public final class DefaultKlibInfoProvider
implements KlibInfoProvider {
    private final Lazy nativeDistributionLibrarySourceFiles$delegate;
    private final File kotlinNativeHome;
    private final KlibManifestProvider manifestProvider;

    private final List<File> getNativeDistributionLibrarySourceFiles() {
        Lazy lazy = this.nativeDistributionLibrarySourceFiles$delegate;
        DefaultKlibInfoProvider defaultKlibInfoProvider = this;
        Object var3_3 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    @Override
    @Nullable
    public KlibInfo getKlibInfo(@NotNull File libraryFile) {
        Intrinsics.checkNotNullParameter((Object)libraryFile, (String)"libraryFile");
        Path path = libraryFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"libraryFile.toPath()");
        Properties properties = this.manifestProvider.getManifest(path);
        if (properties == null) {
            return null;
        }
        Properties manifest = properties;
        if (PropertiesKt.hasProperty$default((Properties)manifest, (String)"commonizer_target", null, (int)2, null)) {
            return this.getCommonizedKlibInfo(libraryFile, manifest);
        }
        return this.getKlibInfo(libraryFile, manifest);
    }

    private final KlibInfo getCommonizedKlibInfo(File libraryFile, Properties manifest) {
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return null;
        }
        String string2 = manifest.getProperty("commonizer_target");
        if (string2 == null) {
            return null;
        }
        return new KlibInfo(libraryFile, CollectionsKt.emptyList(), string, false, true, FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome), new KlibInfo.NativeTargets.CommonizerIdentity(string2));
    }

    /*
     * WARNING - void declaration
     */
    private final KlibInfo getKlibInfo(File libraryFile, Properties manifest) {
        KlibInfo.NativeTargets.NativeTargetsList nativeTargetsList;
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return null;
        }
        String libraryName = string;
        boolean isFromNativeDistribution = FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome);
        boolean isStdlib = isFromNativeDistribution && Intrinsics.areEqual((Object)libraryName, (Object)"stdlib");
        File file = libraryFile;
        Collection collection = this.findLibrarySources(libraryFile, manifest);
        String string2 = libraryName;
        boolean bl = isStdlib;
        boolean bl2 = false;
        boolean bl3 = isFromNativeDistribution;
        String string3 = manifest.getProperty("native_targets");
        if (string3 != null) {
            void p1;
            String string4 = string3;
            boolean bl4 = false;
            boolean bl5 = false;
            String string5 = string4;
            boolean bl6 = bl3;
            boolean bl7 = bl2;
            boolean bl8 = bl;
            String string6 = string2;
            Collection collection2 = collection;
            File file2 = file;
            boolean bl9 = false;
            KlibInfo.NativeTargets.NativeTargetsList nativeTargetsList2 = new KlibInfo.NativeTargets.NativeTargetsList((String)p1);
            file = file2;
            collection = collection2;
            string2 = string6;
            bl = bl8;
            bl2 = bl7;
            bl3 = bl6;
            nativeTargetsList = nativeTargetsList2;
        } else {
            nativeTargetsList = null;
        }
        KlibInfo.NativeTargets nativeTargets = nativeTargetsList;
        boolean bl10 = bl3;
        boolean bl11 = bl2;
        boolean bl12 = bl;
        String string7 = string2;
        Collection collection3 = collection;
        File file3 = file;
        return new KlibInfo(file3, collection3, string7, bl12, bl11, bl10, nativeTargets);
    }

    private final String getLibraryNameFromManifest(Properties manifest) {
        String string = manifest.getProperty("short_name");
        if (string == null) {
            string = manifest.getProperty("unique_name");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<File> findLibrarySources(File libraryFile, Properties manifest) {
        void destination$iv;
        void $this$filterTo$iv;
        if (!FilesKt.startsWith((File)libraryFile, (File)this.kotlinNativeHome)) {
            return SetsKt.emptySet();
        }
        String string = this.getLibraryNameFromManifest(manifest);
        if (string == null) {
            return SetsKt.emptySet();
        }
        String libraryName = string;
        Function1 nameFilter2 = Intrinsics.areEqual((Object)libraryName, (Object)"stdlib") ? (Function1)findLibrarySources.nameFilter.1.INSTANCE : (Function1)new Function1<String, Boolean>(libraryName){
            final /* synthetic */ String $libraryName;

            public final boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$libraryName, (boolean)false, (int)2, null);
            }
            {
                this.$libraryName = string;
                super(1);
            }
        };
        Iterable iterable = this.getNativeDistributionLibrarySourceFiles();
        boolean bl = false;
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            File it = (File)element$iv;
            boolean bl2 = false;
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
            if (!((Boolean)nameFilter2.invoke((Object)string2)).booleanValue()) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    public DefaultKlibInfoProvider(@NotNull File kotlinNativeHome, @NotNull KlibManifestProvider manifestProvider) {
        Intrinsics.checkNotNullParameter((Object)kotlinNativeHome, (String)"kotlinNativeHome");
        Intrinsics.checkNotNullParameter((Object)manifestProvider, (String)"manifestProvider");
        this.kotlinNativeHome = kotlinNativeHome;
        this.manifestProvider = manifestProvider;
        this.nativeDistributionLibrarySourceFiles$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(this){
            final /* synthetic */ DefaultKlibInfoProvider this$0;

            @NotNull
            public final List<File> invoke() {
                File file = FilesKt.resolve((File)DefaultKlibInfoProvider.access$getKotlinNativeHome$p(this.this$0), (String)"sources");
                boolean bl = false;
                boolean bl2 = false;
                File it = file;
                boolean bl3 = false;
                Object object = it.isDirectory() ? file : null;
                if (object == null || (object = FilesKt.walkTopDown((File)object)) == null || (object = object.maxDepth(1)) == null || (object = SequencesKt.filter((Sequence)((Sequence)object), (Function1)nativeDistributionLibrarySourceFiles.2.INSTANCE)) == null || (object = SequencesKt.toList((Sequence)object)) == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
            {
                this.this$0 = defaultKlibInfoProvider;
                super(0);
            }
        }));
    }

    public /* synthetic */ DefaultKlibInfoProvider(File file, KlibManifestProvider klibManifestProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            klibManifestProvider = KlibManifestProvider.Companion.default();
        }
        this(file, klibManifestProvider);
    }

    public static final /* synthetic */ File access$getKotlinNativeHome$p(DefaultKlibInfoProvider $this) {
        return $this.kotlinNativeHome;
    }
}

