/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.DataNodeUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinMPPDataNodesKt;
import org.jetbrains.kotlin.idea.configuration.KotlinSourceSetInfo;
import org.jetbrains.kotlin.idea.configuration.KotlinTargetData;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J8\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinTargetDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinTargetData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "importData", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "kotlin.gradle.gradle-idea"})
public final class KotlinTargetDataService
extends AbstractProjectDataService<KotlinTargetData, Void> {
    @NotNull
    public Key<KotlinTargetData> getTargetDataKey() {
        return KotlinTargetData.Companion.getKEY();
    }

    public void importData(@NotNull Collection<? extends DataNode<KotlinTargetData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        for (DataNode<KotlinTargetData> dataNode : toImport) {
            Artifact it;
            Artifact artifact;
            String artifactName;
            File archiveFile;
            Method oldMethod;
            Object object = dataNode.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeToImport.data");
            KotlinTargetData targetData = (KotlinTargetData)((Object)object);
            if (targetData.getArchiveFile() == null) {
                continue;
            }
            try {
                oldMethod = modelsProvider.getClass().getMethod("getModifiableArtifactModel", new Class[0]);
                Object object2 = oldMethod.invoke((Object)modelsProvider, new Object[0]);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.packaging.artifacts.ModifiableArtifactModel");
                }
                oldMethod = (ModifiableArtifactModel)object2;
            }
            catch (Exception _) {
                Method newMethod = modelsProvider.getClass().getMethod("getModifiableModel", Class.class);
                Object packagingModifiableModel = newMethod.invoke((Object)modelsProvider, Class.forName("com.intellij.openapi.externalSystem.project.PackagingModifiableModel"));
                Object object3 = packagingModifiableModel.getClass().getMethod("getModifiableArtifactModel", new Class[0]).invoke(packagingModifiableModel, new Object[0]);
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.packaging.artifacts.ModifiableArtifactModel");
                }
                oldMethod = (ModifiableArtifactModel)object3;
            }
            Method artifactModel = oldMethod;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.getNameWithoutExtension((File)archiveFile), (String)"FileUtil.getNameWithoutExtension(archiveFile)");
            Artifact artifact2 = artifactModel.findArtifact(artifactName);
            if (artifact2 != null) {
                artifact = artifact2;
                boolean bl = false;
                boolean bl2 = false;
                it = artifact;
                boolean bl3 = false;
                artifactModel.removeArtifact(it);
            }
            artifact = artifactModel.addArtifact(artifactName, (ArtifactType)JarArtifactType.getInstance());
            boolean bl = false;
            boolean bl4 = false;
            it = artifact;
            boolean bl5 = false;
            Artifact artifact3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)artifact3, (String)"it");
            artifact3.setOutputPath(archiveFile.getParent());
            for (String moduleId : targetData.getModuleIds()) {
                Module moduleToPackage;
                KotlinSourceSetInfo kotlinSourceSet;
                DataNode<? extends ModuleData> dataNode2 = dataNode.getParent();
                if (dataNode2 == null || (dataNode2 = DataNodeUtilsKt.findChildModuleById(dataNode2, moduleId)) == null) {
                    continue;
                }
                DataNode<? extends ModuleData> compilationModuleDataNode = dataNode2;
                ModuleData compilationData = (ModuleData)compilationModuleDataNode.getData();
                if (KotlinMPPDataNodesKt.getKotlinSourceSet(compilationModuleDataNode) == null) {
                    continue;
                }
                if (kotlinSourceSet.isTestModule()) continue;
                if (modelsProvider.findIdeModule(compilationData) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)moduleToPackage, (String)"modelsProvider.findIdeMo\u2026pilationData) ?: continue");
                it.getRootElement().addOrFindChild((PackagingElement)new ProductionModuleOutputPackagingElement(project, ProjectRootsUtilKt.createPointer((Module)moduleToPackage)));
            }
        }
    }
}

