/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.util.PlatformUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"$\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\u00a8\u0006\n"}, d2={"value", "", "isNativeDebugSuggestionEnabled", "()Z", "setNativeDebugSuggestionEnabled", "(Z)V", "suggestNativeDebug", "", "projectPath", "", "kotlin.gradle.gradle-idea"})
public final class KotlinResolverUtilKt {
    private static final boolean isNativeDebugSuggestionEnabled() {
        return PropertiesComponent.getInstance().getBoolean("isNativeDebugSuggestionEnabled", true);
    }

    private static final void setNativeDebugSuggestionEnabled(boolean value) {
        PropertiesComponent.getInstance().setValue("isNativeDebugSuggestionEnabled", value);
    }

    public static final void suggestNativeDebug(@NotNull String projectPath) {
        Project project;
        PluginId pluginId;
        block5: {
            ProjectManager projectManager;
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            if (!PlatformUtils.isIdeaUltimate()) {
                return;
            }
            PluginId pluginId2 = PluginId.getId((String)"com.intellij.nativeDebug");
            Intrinsics.checkNotNullExpressionValue((Object)pluginId2, (String)"PluginId.getId(\"com.intellij.nativeDebug\")");
            pluginId = pluginId2;
            if (PluginManagerCore.isPluginInstalled((PluginId)pluginId)) {
                return;
            }
            if (!KotlinResolverUtilKt.isNativeDebugSuggestionEnabled()) {
                return;
            }
            ProjectManager projectManager2 = projectManager = ProjectManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)projectManager2, (String)"projectManager");
            Project[] projectArray = projectManager2.getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"projectManager.openProjects");
            Project[] $this$firstOrNull$iv = projectArray;
            boolean $i$f$firstOrNull = false;
            Project[] projectArray2 = $this$firstOrNull$iv;
            int n = projectArray2.length;
            for (int i = 0; i < n; ++i) {
                Project element$iv;
                Project it = element$iv = projectArray2[i];
                boolean bl = false;
                Project project2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"it");
                if (!Intrinsics.areEqual((Object)project2.getBasePath(), (Object)projectPath)) continue;
                project = element$iv;
                break block5;
            }
            project = null;
        }
        if (project == null) {
            return;
        }
        Project project3 = project;
        PluginsAdvertiser.getNotificationGroup().createNotification(KotlinIdeaGradleBundle.message("notification.title.plugin.suggestion", new Object[0]), KotlinIdeaGradleBundle.message("notification.text.native.debug.provides.debugger.for.kotlin.native", new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(pluginId, KotlinIdeaGradleBundle.message("action.text.install", new Object[0])){
            final /* synthetic */ PluginId $pluginId;

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                PluginsAdvertiser.installAndEnable((Set)SetsKt.setOf((Object)this.$pluginId), (Runnable)new Runnable(notification){
                    final /* synthetic */ Notification $notification;

                    public final void run() {
                        this.$notification.expire();
                    }
                    {
                        this.$notification = notification;
                    }
                });
            }
            {
                this.$pluginId = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }).addAction((AnAction)new NotificationAction(KotlinIdeaGradleBundle.message("action.text.dontShowAgain", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                KotlinResolverUtilKt.access$setNativeDebugSuggestionEnabled$p(false);
                notification.expire();
            }
        }).notify(project3);
    }

    public static final /* synthetic */ boolean access$isNativeDebugSuggestionEnabled$p() {
        return KotlinResolverUtilKt.isNativeDebugSuggestionEnabled();
    }

    public static final /* synthetic */ void access$setNativeDebugSuggestionEnabled$p(boolean bl) {
        KotlinResolverUtilKt.setNativeDebugSuggestionEnabled(bl);
    }
}

