/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ide.konan.NativeLibraryKind;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleSourceSetDataServiceKt;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.framework.LibraryKindsKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformUtil;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00020\u00020\u0006\u00a2\u0006\u0002\b\bH\u0016J8\u0010\t\u001a\u00020\n2\u0014\u0010\u000b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Ljava/lang/Void;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "postProcess", "", "toImport", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "looksAsNonJvmLibrary", "", "Lcom/intellij/openapi/roots/libraries/Library;", "Companion", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleLibraryDataService
extends AbstractProjectDataService<LibraryData, Void> {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> nonJvmSuffixes;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ProjectKeys.LIBRARY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void postProcess(@NotNull Collection<? extends DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        boolean bl;
        PersistentLibraryKind persistentLibraryKind;
        block12: {
            boolean bl2;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(toImport, (String)"toImport");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
            if (toImport.isEmpty()) {
                return;
            }
            DataNode dataNode = ((DataNode)CollectionsKt.first((Iterable)toImport)).getParent();
            Intrinsics.checkNotNull((Object)dataNode);
            Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"toImport.first().parent!!");
            DataNode projectDataNode = dataNode;
            Collection collection = projectDataNode.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"projectDataNode.children");
            Iterable $this$filter$iv = collection;
            boolean bl3 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            persistentLibraryKind = $this$filterTo$iv$iv.iterator();
            while (persistentLibraryKind.hasNext()) {
                Object element$iv$iv = persistentLibraryKind.next();
                DataNode it = (DataNode)element$iv$iv;
                bl2 = false;
                DataNode dataNode2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"it");
                if (!(dataNode2.getData() instanceof ModuleData)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDataNodes = (List)destination$iv$iv;
            Iterable iterable2 = moduleDataNodes;
            boolean $i$f$any = false;
            if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable2) {
                    Object object;
                    DataNode node = (DataNode)element$iv;
                    boolean bl32 = false;
                    if (KotlinGradleSourceSetDataServiceKt.detectPlatformKindByPlugin((DataNode<ModuleData>)node) != null) {
                        IdePlatformKind<?> idePlatformKind;
                        bl2 = false;
                        boolean bl4 = false;
                        IdePlatformKind<?> it = idePlatformKind;
                        boolean bl5 = false;
                        object = !JvmIdePlatformUtil.isJvm(it) ? idePlatformKind : null;
                    } else {
                        object = null;
                    }
                    if (!(object != null)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        boolean anyNonJvmModules = bl;
        for (DataNode<LibraryData> dataNode : toImport) {
            Library ideLibrary;
            if (modelsProvider.findIdeLibrary((LibraryData)dataNode.getData()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ideLibrary, (String)"modelsProvider.findIdeLi\u2026ataNode.data) ?: continue");
            Library.ModifiableModel modifiableModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
            if (modifiableModel == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx.ModifiableModelEx");
            }
            LibraryEx.ModifiableModelEx modifiableModel2 = (LibraryEx.ModifiableModelEx)modifiableModel;
            if (anyNonJvmModules || this.looksAsNonJvmLibrary(ideLibrary)) {
                VirtualFile[] virtualFileArray = modifiableModel2.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"modifiableModel.getFiles(OrderRootType.CLASSES)");
                if (LibraryKindsKt.detectLibraryKind((VirtualFile[])virtualFileArray) != null) {
                    boolean bl5 = false;
                    boolean bl6 = false;
                    PersistentLibraryKind it = persistentLibraryKind;
                    boolean bl8 = false;
                    modifiableModel2.setKind(it);
                }
                continue;
            }
            if (!(ideLibrary instanceof LibraryEx) || ((LibraryEx)ideLibrary).getKind() != JSLibraryKind.INSTANCE && ((LibraryEx)ideLibrary).getKind() != NativeLibraryKind.INSTANCE && ((LibraryEx)ideLibrary).getKind() != CommonLibraryKind.INSTANCE) continue;
            modifiableModel2.forgetKind();
        }
    }

    private final boolean looksAsNonJvmLibrary(Library $this$looksAsNonJvmLibrary) {
        block8: {
            block9: {
                boolean bl;
                String name;
                block7: {
                    String string = $this$looksAsNonJvmLibrary.getName();
                    if (string == null) break block8;
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    name = string2;
                    boolean bl4 = false;
                    Iterable $this$any$iv = nonJvmSuffixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            String string3 = name;
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) break block9;
                String string = name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                if (!StringsKt.startsWith$default((String)string, (String)"Kotlin/Native", (boolean)false, (int)2, null)) break block8;
            }
            return true;
        }
        Object[] objectArray = $this$looksAsNonJvmLibrary.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getFiles(OrderRootType.CLASSES)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray);
        return Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getExtension() : null), (Object)"klib");
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinGradleLibraryDataService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026yDataService::class.java)");
        LOG = logger;
        nonJvmSuffixes = CollectionsKt.listOf((Object[])new String[]{"-common", "-js", "-native", "-kjsm", "-metadata"});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleLibraryDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "nonJvmSuffixes", "", "", "getNonJvmSuffixes", "()Ljava/util/List;", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final List<String> getNonJvmSuffixes() {
            return nonJvmSuffixes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

