/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils.pathVariables;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.intellij.lang.regexp.RegExpLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public abstract class PathVariableRegexInjector
implements MultiHostInjector {
    @NotNull
    protected abstract UExpressionPattern<?, ?> getPattern();

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            PathVariableRegexInjector.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PathVariableRegexInjector.$$$reportNull$$$0(1);
        }
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return;
        }
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)context;
        if (!host.isValidHost()) {
            return;
        }
        Project project = context.getProject();
        if (project.isDefault()) {
            return;
        }
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)context, UExpression.class);
        if (uExpression == null || !this.isSupportedProject(project) || !this.getPattern().accepts((Object)uExpression)) {
            return;
        }
        if (!context.textContains(':')) {
            return;
        }
        String text = context.getText();
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)"{", (String)"}", (boolean)false, (boolean)true);
        if (ranges.isEmpty()) {
            return;
        }
        Collection<TextRange> ignoredRanges = this.getIgnoredRanges(text);
        LiteralTextEscaper escaper = host.createLiteralTextEscaper();
        for (TextRange textRange : ranges) {
            StringBuilder rangeValue;
            TextRange regexRange;
            String rangeSubString = textRange.substring(text);
            int i = rangeSubString.indexOf(58);
            if (i == -1) continue;
            int offset = textRange.getStartOffset() + i;
            if (ignoredRanges.stream().anyMatch(r -> r.contains(offset)) || !escaper.decode(regexRange = TextRange.from((int)(textRange.getStartOffset() + i + 1), (int)(textRange.getLength() - i - 1)), rangeValue = new StringBuilder()) || !this.validateRangeValue(rangeValue)) continue;
            registrar.startInjecting((Language)RegExpLanguage.INSTANCE).addPlace(null, null, host, regexRange).doneInjecting();
        }
    }

    protected boolean validateRangeValue(@NotNull StringBuilder rangeValue) {
        if (rangeValue == null) {
            PathVariableRegexInjector.$$$reportNull$$$0(2);
        }
        return true;
    }

    protected boolean isSupportedProject(@NotNull Project project) {
        if (project == null) {
            PathVariableRegexInjector.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected Collection<TextRange> getIgnoredRanges(String text) {
        return Collections.emptyList();
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiElement>> list = Collections.singletonList(PsiElement.class);
        if (list == null) {
            PathVariableRegexInjector.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/utils/pathVariables/PathVariableRegexInjector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/utils/pathVariables/PathVariableRegexInjector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateRangeValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedProject";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

