/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils.pathVariables;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.microservices.utils.pathVariables.InplaceRenameQuickFix;
import com.intellij.microservices.utils.pathVariables.PathVariableMethodInspection$createRenameQuickfix$;
import com.intellij.microservices.utils.pathVariables.PathVariableQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0016J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0#2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H&J\u0018\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0004H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006."}, d2={"Lcom/intellij/microservices/utils/pathVariables/PathVariableMethodInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "()V", "pathVariableAnnotationFQN", "", "getPathVariableAnnotationFQN", "()Ljava/lang/String;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "method", "Lorg/jetbrains/uast/UMethod;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createRenameQuickfix", "Lcom/intellij/codeInspection/LocalQuickFix;", "psiElement", "Lcom/intellij/psi/PsiElement;", "pathVariableName", "unusedDeclarations", "", "extractPathVariableUsageFromTheParameter", "Lcom/intellij/microservices/utils/pathVariables/PathVariableMethodInspection$PathVariableConsumerInfo;", "uParameter", "Lorg/jetbrains/uast/UParameter;", "getConsumedPathVariables", "", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "isApplicable", "module", "Lcom/intellij/openapi/module/Module;", "mayResolveToMethodBeanField", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "expectedName", "PathVariableConsumerInfo", "intellij.microservices.uast"})
public abstract class PathVariableMethodInspection
extends AbstractBaseUastLocalInspectionTool {
    public abstract boolean isApplicable(@NotNull Module var1);

    @NotNull
    public abstract UrlPathContext getUrlPathContext(@NotNull UMethod var1);

    @NotNull
    public abstract String getPathVariableAnnotationFQN();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ModuleUtilCore.findModul\u2026mentVisitor.EMPTY_VISITOR");
        Module module2 = module;
        if (!this.isApplicable(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"PsiElementVisitor.EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"super.buildVisitor(holder, isOnTheFly, session)");
        return psiElementVisitor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Map<String, PathVariableConsumerInfo> consumersMap;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        UrlPathContext urlPathContext = this.getUrlPathContext(method);
        if (urlPathContext.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Set allDeclaredPathVariableNamesForContext = CollectionsKt.toSet((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext));
        if (Intrinsics.areEqual((Object)allDeclaredPathVariableNamesForContext, (consumersMap = this.getConsumedPathVariables(method)).keySet())) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Map undeclaredUsages = MapsKt.minus(consumersMap, (Iterable)allDeclaredPathVariableNamesForContext);
        Set unusedDeclarations = SetsKt.minus((Set)allDeclaredPathVariableNamesForContext, (Iterable)consumersMap.keySet());
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"ProblemDescriptor.EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)psiElement, isOnTheFly);
        Object object = undeclaredUsages;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void pathVariableName;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            PathVariableConsumerInfo consumerInfo = (PathVariableConsumerInfo)entry2.getValue();
            if (consumerInfo.getAnchor() == null || !consumerInfo.getReportIfNotDeclared()) continue;
            holder.registerProblem(consumerInfo.getAnchor(), MicroservicesBundle.message((String)"PathVariableInspection.cannot.resolve", (Object[])new Object[]{pathVariableName}), new LocalQuickFix[]{this.createRenameQuickfix(consumerInfo.getAnchor(), (String)pathVariableName, unusedDeclarations)});
        }
        for (String unConsumedVariable : unusedDeclarations) {
            if (this.mayResolveToMethodBeanField(method.getJavaPsi(), unConsumedVariable)) continue;
            UElement uElement = method.getUastAnchor();
            if (uElement == null || (uElement = uElement.getSourcePsi()) == null) {
                break;
            }
            UElement identifier = uElement;
            holder.registerProblem((PsiElement)identifier, MicroservicesBundle.message((String)"PathVariableReference.unconsumed.path.variable", (Object[])new Object[]{unConsumedVariable}), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new PathVariableQuickFix(method, unConsumedVariable, this.getPathVariableAnnotationFQN())});
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"holder.resultsArray");
        return problemDescriptorArray;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, PathVariableConsumerInfo> getConsumedPathVariables(UMethod method) {
        void $this$associateByTo$iv$iv;
        Sequence $this$associateBy$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)method.getUastParameters()), (Function1)((Function1)new Function1<UParameter, PathVariableConsumerInfo>(this){

            @Nullable
            public final PathVariableConsumerInfo invoke(@NotNull UParameter p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((PathVariableMethodInspection)((Object)this.receiver)).extractPathVariableUsageFromTheParameter(p1);
            }
        }));
        boolean $i$f$associateBy = false;
        Sequence sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PathVariableConsumerInfo pathVariableConsumerInfo = (PathVariableConsumerInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Nullable
    protected PathVariableConsumerInfo extractPathVariableUsageFromTheParameter(@NotNull UParameter uParameter) {
        PathVariableConsumerInfo pathVariableConsumerInfo;
        Object v0;
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
            Iterable iterable = uParameter.getUAnnotations();
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            bl = false;
            for (Object t : iterable2) {
                UAnnotation it = (UAnnotation)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.getPathVariableAnnotationFQN())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        UAnnotation uAnnotation = v0;
        if (uAnnotation == null) {
            return null;
        }
        UAnnotation pathAnnotation = uAnnotation;
        UExpression explicitPathVariableNameExpression2 = (UExpression)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])new String[]{"value", "name"}), (Function1)((Function1)new Function1<String, UExpression>(pathAnnotation){
            final /* synthetic */ UAnnotation $pathAnnotation;

            @Nullable
            public final UExpression invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$pathAnnotation.findDeclaredAttributeValue(it);
            }
            {
                this.$pathAnnotation = uAnnotation;
                super(1);
            }
        })));
        if (explicitPathVariableNameExpression2 != null) {
            String string = UastUtils.evaluateString((UExpression)explicitPathVariableNameExpression2);
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                bl = false;
                String it = string2;
                boolean bl5 = false;
                pathVariableConsumerInfo = new PathVariableConsumerInfo(it, explicitPathVariableNameExpression2.getSourcePsi(), true);
            } else {
                pathVariableConsumerInfo = null;
            }
        } else {
            String string = uParameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uParameter.name");
            UElement uElement = uParameter.getUastAnchor();
            pathVariableConsumerInfo = new PathVariableConsumerInfo(string, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), true);
        }
        return pathVariableConsumerInfo;
    }

    private final boolean mayResolveToMethodBeanField(PsiMethod psiMethod, String expectedName) {
        boolean bl;
        block4: {
            PsiParameterList psiParameterList = psiMethod.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterList, (String)"psiMethod.parameterList");
            PsiParameter[] psiParameterArray = psiParameterList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"psiMethod.parameterList.parameters");
            PsiParameter[] $this$any$iv = psiParameterArray;
            boolean $i$f$any = false;
            PsiParameter[] psiParameterArray2 = $this$any$iv;
            int n = psiParameterArray2.length;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                PsiClassType psiClassType;
                PsiParameter element$iv;
                PsiParameter psiParameter = element$iv = psiParameterArray2[i];
                boolean bl3 = false;
                PsiParameter psiParameter2 = psiParameter;
                Intrinsics.checkNotNullExpressionValue((Object)psiParameter2, (String)"psiParameter");
                PsiType psiType = psiParameter2.getType();
                if (!(psiType instanceof PsiClassType)) {
                    psiType = null;
                }
                if ((psiClassType = (PsiClassType)psiType) == null || (psiClassType = psiClassType.resolve()) == null) {
                    bl2 = false;
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"(psiParameter.type as? P\u2026lve() ?: return@any false");
                    PsiClassType psiClass = psiClassType;
                    List list = PropertyUtil.getSetters((PsiClass)psiClass, (String)expectedName);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PropertyUtil.getSetters(psiClass, expectedName)");
                    Collection collection = list;
                    boolean bl4 = false;
                    bl2 = !collection.isEmpty();
                }
                if (!bl2) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private final LocalQuickFix createRenameQuickfix(PsiElement psiElement, String pathVariableName, Set<String> unusedDeclarations) {
        if (unusedDeclarations.isEmpty()) {
            return null;
        }
        Sequence $this$filterIsInstance$iv = SequencesKt.take((Sequence)PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)true), (int)2);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)createRenameQuickfix$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        PsiNamedElement psiNamedElement = (PsiNamedElement)SequencesKt.firstOrNull((Sequence)sequence2);
        if (psiNamedElement == null) {
            return null;
        }
        PsiNamedElement namedElement = psiNamedElement;
        return (LocalQuickFix)new InplaceRenameQuickFix(namedElement, pathVariableName, (Iterable<String>)unusedDeclarations);
    }

    public PathVariableMethodInspection() {
        super(new Class[]{UMethod.class});
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/microservices/utils/pathVariables/PathVariableMethodInspection$PathVariableConsumerInfo;", "", "name", "", "anchor", "Lcom/intellij/psi/PsiElement;", "reportIfNotDeclared", "", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Z)V", "getAnchor", "()Lcom/intellij/psi/PsiElement;", "getName", "()Ljava/lang/String;", "getReportIfNotDeclared", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.microservices.uast"})
    protected static final class PathVariableConsumerInfo {
        @NotNull
        private final String name;
        @Nullable
        private final PsiElement anchor;
        private final boolean reportIfNotDeclared;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final PsiElement getAnchor() {
            return this.anchor;
        }

        public final boolean getReportIfNotDeclared() {
            return this.reportIfNotDeclared;
        }

        public PathVariableConsumerInfo(@NotNull String name, @Nullable PsiElement anchor, boolean reportIfNotDeclared) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.anchor = anchor;
            this.reportIfNotDeclared = reportIfNotDeclared;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final PsiElement component2() {
            return this.anchor;
        }

        public final boolean component3() {
            return this.reportIfNotDeclared;
        }

        @NotNull
        public final PathVariableConsumerInfo copy(@NotNull String name, @Nullable PsiElement anchor, boolean reportIfNotDeclared) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new PathVariableConsumerInfo(name, anchor, reportIfNotDeclared);
        }

        public static /* synthetic */ PathVariableConsumerInfo copy$default(PathVariableConsumerInfo pathVariableConsumerInfo, String string, PsiElement psiElement, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathVariableConsumerInfo.name;
            }
            if ((n & 2) != 0) {
                psiElement = pathVariableConsumerInfo.anchor;
            }
            if ((n & 4) != 0) {
                bl = pathVariableConsumerInfo.reportIfNotDeclared;
            }
            return pathVariableConsumerInfo.copy(string, psiElement, bl);
        }

        @NotNull
        public String toString() {
            return "PathVariableConsumerInfo(name=" + this.name + ", anchor=" + this.anchor + ", reportIfNotDeclared=" + this.reportIfNotDeclared + ")";
        }

        public int hashCode() {
            String string = this.name;
            PsiElement psiElement = this.anchor;
            int n = ((string != null ? string.hashCode() : 0) * 31 + (psiElement != null ? psiElement.hashCode() : 0)) * 31;
            int n2 = this.reportIfNotDeclared ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PathVariableConsumerInfo)) break block3;
                    PathVariableConsumerInfo pathVariableConsumerInfo = (PathVariableConsumerInfo)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariableConsumerInfo.name) || !Intrinsics.areEqual((Object)this.anchor, (Object)pathVariableConsumerInfo.anchor) || this.reportIfNotDeclared != pathVariableConsumerInfo.reportIfNotDeclared) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

