/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.utils.pathVariables;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J3\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0096\u0002R\u0014\u0010\t\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/microservices/utils/pathVariables/InplaceRenameQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "namedElement", "Lcom/intellij/psi/PsiNamedElement;", "oldName", "", "namesToSuggest", "", "(Lcom/intellij/psi/PsiNamedElement;Ljava/lang/String;Ljava/lang/Iterable;)V", "nameToSuggest", "getNameToSuggest", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.microservices.uast"})
final class InplaceRenameQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String oldName;
    private final Iterable<String> namesToSuggest;

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.message(\"rename.element.family\")");
        return string;
    }

    private final String getNameToSuggest() {
        String string = (String)CollectionsKt.firstOrNull(this.namesToSuggest);
        if (string == null) {
            string = this.oldName;
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{this.oldName, this.getNameToSuggest()});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CodeInsightBundle.messag\u2026, oldName, nameToSuggest)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        LinkedHashSet linkedHashSet;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement psiElement = this.getStartElement();
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        PsiNamedElement namedElement = (PsiNamedElement)psiElement;
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        VariableInplaceRenamer variableInplaceRenamer = new VariableInplaceRenamer(namedElement, editor2, project, this.getNameToSuggest(), this.oldName);
        Iterable<String> iterable = this.namesToSuggest;
        if (!(iterable instanceof LinkedHashSet)) {
            iterable = null;
        }
        if ((linkedHashSet = (LinkedHashSet)iterable) == null) {
            boolean bl = false;
            linkedHashSet = (LinkedHashSet)CollectionsKt.toCollection(this.namesToSuggest, (Collection)new LinkedHashSet());
        }
        variableInplaceRenamer.performInplaceRefactoring(linkedHashSet);
    }

    public InplaceRenameQuickFix(@NotNull PsiNamedElement namedElement, @NotNull String oldName, @NotNull Iterable<String> namesToSuggest) {
        Intrinsics.checkNotNullParameter((Object)namedElement, (String)"namedElement");
        Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
        Intrinsics.checkNotNullParameter(namesToSuggest, (String)"namesToSuggest");
        super((PsiElement)namedElement);
        this.oldName = oldName;
        this.namesToSuggest = namesToSuggest;
    }
}

