/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.uast.oas;

import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.microservices.uast.oas.FormatAndType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getOasParameterFormatAndType", "Lcom/intellij/microservices/uast/oas/FormatAndType;", "type", "Lcom/intellij/psi/PsiType;", "intellij.microservices.uast"})
@JvmName(name="JvmSwaggerUtils")
public final class JvmSwaggerUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final FormatAndType getOasParameterFormatAndType(@NotNull PsiType type) {
        FormatAndType formatAndType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type instanceof PsiPrimitiveType) {
            String string = ((PsiPrimitiveType)type).getBoxedTypeName();
            if (string == null) return null;
            switch (string) {
                case "java.lang.Boolean": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.BOOLEAN, null, 2, null);
                    return formatAndType2;
                }
                case "java.lang.Integer": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.INT_32);
                    return formatAndType2;
                }
                case "java.lang.Long": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.INT_64);
                    return formatAndType2;
                }
                case "java.lang.Double": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.DOUBLE);
                    return formatAndType2;
                }
                case "java.lang.Float": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.FLOAT);
                    return formatAndType2;
                }
                case "java.lang.Byte": {
                    FormatAndType formatAndType2 = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.BYTE);
                    return formatAndType2;
                }
                default: {
                    return null;
                }
            }
        }
        if (type.equalsToText("java.lang.Boolean")) {
            formatAndType = new FormatAndType(OasSchemaType.BOOLEAN, null, 2, null);
            return formatAndType;
        } else if (type.equalsToText("java.lang.String")) {
            formatAndType = new FormatAndType(OasSchemaType.STRING, null, 2, null);
            return formatAndType;
        } else if (type.equalsToText("java.lang.Integer")) {
            formatAndType = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.INT_32);
            return formatAndType;
        } else if (type.equalsToText("java.lang.Long")) {
            formatAndType = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.INT_64);
            return formatAndType;
        } else if (type.equalsToText("java.lang.Double")) {
            formatAndType = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.DOUBLE);
            return formatAndType;
        } else if (type.equalsToText("java.lang.Float")) {
            formatAndType = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.FLOAT);
            return formatAndType;
        } else if (type.equalsToText("java.lang.Byte")) {
            formatAndType = new FormatAndType(OasSchemaType.NUMBER, OasSchemaFormat.BYTE);
            return formatAndType;
        } else if (type.equalsToText("java.util.Collection")) {
            formatAndType = new FormatAndType(OasSchemaType.ARRAY, null, 2, null);
            return formatAndType;
        } else if (type.equalsToText("java.util.List")) {
            formatAndType = new FormatAndType(OasSchemaType.ARRAY, null, 2, null);
            return formatAndType;
        } else if (type.equalsToText("java.util.Set")) {
            formatAndType = new FormatAndType(OasSchemaType.ARRAY, null, 2, null);
            return formatAndType;
        } else {
            if (!(type instanceof PsiArrayType)) return null;
            formatAndType = new FormatAndType(OasSchemaType.ARRAY, null, 2, null);
        }
        return formatAndType;
    }
}

