/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.mime.MimeTypeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/inspection/UastIncorrectMimeTypeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.microservices.uast"})
public final class UastIncorrectMimeTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                if (!(element instanceof PsiLanguageInjectionHost)) {
                    return;
                }
                UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
                if (uInjectionHost == null) {
                    return;
                }
                UInjectionHost expression = uInjectionHost;
                if (expression.getUastParent() instanceof UPolyadicExpression) {
                    return;
                }
                for (PsiReference reference : ((PsiLanguageInjectionHost)element).getReferences()) {
                    TextRange range;
                    if (!(reference instanceof MimeTypeReference) || ((MimeTypeReference)reference).isInjected() || reference.resolve() != null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)reference.getRangeInElement(), (String)"reference.getRangeInElement()");
                    if (range.isEmpty() && range.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)((PsiLanguageInjectionHost)element).getText())) {
                        String message;
                        Intrinsics.checkNotNullExpressionValue((Object)ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), (String)"ProblemsHolder.unresolve\u2026ferenceMessage(reference)");
                        this.$holder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                        continue;
                    }
                    this.$holder.registerProblem(reference);
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }
}

