/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.http.HttpHeaderReference;
import com.intellij.microservices.inspection.HttpHeaderInspection;
import com.intellij.microservices.inspection.HttpHeaderInspectionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/inspection/UastIncorrectHttpHeaderInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/microservices/inspection/HttpHeaderInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isCustomHeader", "header", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.microservices.uast"})
public final class UastIncorrectHttpHeaderInspection
extends LocalInspectionTool
implements HttpHeaderInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ UastIncorrectHttpHeaderInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                PsiElement $this$castSafelyTo$iv = element;
                boolean $i$f$castSafelyTo = false;
                PsiElement psiElement = $this$castSafelyTo$iv;
                if (!(psiElement instanceof PsiLanguageInjectionHost)) {
                    psiElement = null;
                }
                if ((object = (Object[])psiElement) != null && (object = object.getReferences()) != null && (object = ArraysKt.filterIsInstance((Object[])object, HttpHeaderReference.class)) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        HttpHeaderReference httpHeaderReference = (HttpHeaderReference)element$iv;
                        boolean bl = false;
                        String string = httpHeaderReference.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpHeaderReference.value");
                        PsiElement psiElement2 = httpHeaderReference.getElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"httpHeaderReference.element");
                        this.this$0.checkHeader(this.$holder, string, psiElement2);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    public boolean isCustomHeader(@NotNull String header, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return HttpHeaderInspectionBase.Companion.getCustomHeadersEnabled(psiElement) && HttpHeaderInspectionBase.Companion.getCustomHeaders(psiElement).contains(header);
    }

    public void checkHeader(@NotNull ProblemsHolder holder, @NotNull String header, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        HttpHeaderInspection.DefaultImpls.checkHeader((HttpHeaderInspection)this, (ProblemsHolder)holder, (String)header, (PsiElement)psiElement);
    }

    @Nullable
    public LocalQuickFix getCustomHttpHeaderFix(@NotNull PsiElement psiElement, @NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return HttpHeaderInspection.DefaultImpls.getCustomHttpHeaderFix((HttpHeaderInspection)this, (PsiElement)psiElement, (String)header);
    }
}

