/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public abstract class JSConvertIntegerIntentionBase
extends JSIntention {
    private static final BigInteger VALUE_ZERO = new BigInteger(new byte[]{0});

    @Override
    @NotNull
    public final JSElementPredicate getElementPredicate() {
        return new ConvertPredicate();
    }

    private static BigInteger getLiteralNumber(JSLiteralExpression expression) {
        Object value = expression.getValue();
        if (!(value instanceof Long)) {
            return VALUE_ZERO;
        }
        return BigInteger.valueOf((Long)value);
    }

    @Override
    public final void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSConvertIntegerIntentionBase.$$$reportNull$$$0(0);
        }
        JSLiteralExpression exp = (JSLiteralExpression)element;
        String newNumberString = JSConvertIntegerIntentionBase.getLiteralNumber(exp).toString(this.getRadix());
        String text = this.getNumberPrefix(exp) + newNumberString + (exp.isBigInteger() ? "n" : "");
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)text);
    }

    @NotNull
    protected abstract String getNumberPrefix(@NotNull JSLiteralExpression var1);

    protected abstract int getRadix();

    protected abstract boolean isSatisfy(@NotNull JSLiteralExpression var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase", "processIntention"));
    }

    private class ConvertPredicate
    implements JSElementPredicate {
        private ConvertPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ConvertPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSLiteralExpression)) {
                return false;
            }
            JSLiteralExpression literalExpression = (JSLiteralExpression)element;
            if (!literalExpression.getExpressionKind(true).isInteger()) {
                return false;
            }
            return JSConvertIntegerIntentionBase.this.isSatisfy(literalExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSConvertIntegerIntentionBase$ConvertPredicate", "satisfiedBy"));
        }
    }
}

