/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.intentions.JSSplitDeclarationIntention;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationAndInitializationIntention
extends JSMutablyNamedIntention {
    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("initialization.split-declaration-and-initialization.family-name", new Object[0]);
        if (string == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = JSVariablesWithInitializerPredicate.PREDICATE;
        if (jSElementPredicate == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(1);
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSVarStatement varStatement;
        if (element == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(2);
        }
        JSVarStatement jSVarStatement = varStatement = element instanceof JSVarStatement ? (JSVarStatement)element : null;
        assert (varStatement != null);
        String declarationText = JSSplitDeclarationAndInitializationIntention.getDeclarationStatementText(varStatement, (Condition<? super JSVariable>)Conditions.alwaysTrue());
        String statementTail = JSCodeStyleSettings.getSemicolon((PsiElement)element) + "\n";
        List initializations = ContainerUtil.mapNotNull((Object[])varStatement.getDeclarations(), declaration -> {
            JSExpression initializer = declaration.getInitializer();
            if (initializer == null) {
                return null;
            }
            if (declaration instanceof JSDestructuringElement) {
                JSDestructuringContainer target = ((JSDestructuringElement)declaration).getTarget();
                if (target == null) {
                    return null;
                }
                boolean isDestructuringObject = target instanceof JSDestructuringObject;
                String initializationText = JSSplitDeclarationAndInitializationIntention.getTargetText(target) + "=" + initializer.getText();
                return (isDestructuringObject ? "(" + initializationText + ")" : initializationText) + statementTail;
            }
            return declaration.getName() + "=" + initializer.getText() + statementTail;
        });
        this.doReplacement(declarationText, initializations, varStatement);
    }

    @NotNull
    private static String getTargetText(@NotNull JSDestructuringContainer target) {
        if (target == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(3);
        }
        if (!DialectDetector.isFlow((PsiElement)target)) {
            String string = target.getText();
            if (string == null) {
                JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(4);
            }
            return string;
        }
        PsiElement copy = target.copy();
        SyntaxTraverser.psiTraverser((PsiElement)copy).filter(JSTypeDeclarationOwner.class).map(o -> o.getTypeElement()).filter(Conditions.notNull()).forEach(e -> {
            PsiElement prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)e);
            if (PsiUtilCore.getElementType((PsiElement)prevElement) == JSTokenTypes.COLON) {
                e.delete();
                prevElement.delete();
            }
        });
        String string = copy.getText();
        if (string == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return super.stopTraversingUp(element) || element instanceof JSFunction || element instanceof JSClass;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof JSVarStatement && ((JSVarStatement)element).getVarKeyword() == JSVarStatement.VarKeyword.CONST) {
            return JSIntentionBundle.message("initialization.split-declaration-and-initialization.let.display-name", new Object[0]);
        }
        return JSIntentionBundle.message("initialization.split-declaration-and-initialization.display-name", new Object[0]);
    }

    @NotNull
    public static String getDeclarationStatementText(@NotNull JSVarStatement varStatement, Condition<? super JSVariable> toRemoveInitializer) {
        if (varStatement == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(6);
        }
        JSVarStatement.VarKeyword keyword = JSSplitDeclarationAndInitializationIntention.getKeyword(varStatement);
        Object varStatementKeyword = JSPsiImplUtils.hasModifier((JSAttributeListOwner)varStatement, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.EXPORT) ? "export " + keyword.getText() : keyword.getText();
        String lineTail = JSCodeStyleSettings.getSemicolon((PsiElement)varStatement) + "\n";
        StringBuilder declarationBuffer = new StringBuilder();
        for (JSVariable variable : varStatement.getVariables()) {
            String docCommentText;
            JSDocComment docComment = JSSplitDeclarationIntention.getDocComment((JSVariable)variable, (JSVarStatement)varStatement);
            String string = docCommentText = docComment != null ? docComment.getText() : "";
            if (declarationBuffer.length() == 0) {
                declarationBuffer.append(docCommentText);
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n");
                }
                declarationBuffer.append((String)varStatementKeyword).append(" ");
            } else {
                declarationBuffer.append(",");
                if (!StringUtil.isEmpty((String)docCommentText)) {
                    declarationBuffer.append("\n").append(docCommentText).append("\n");
                }
            }
            if (toRemoveInitializer.value((Object)variable)) {
                declarationBuffer.append(variable.getName());
                String typeString = JSSplitDeclarationAndInitializationIntention.getTypeString((JSInitializerOwner)variable);
                if (typeString == null) continue;
                declarationBuffer.append(":").append(typeString);
                continue;
            }
            declarationBuffer.append(variable.getText());
        }
        declarationBuffer.append(lineTail);
        String string = declarationBuffer.toString();
        if (string == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static JSVarStatement.VarKeyword getKeyword(@NotNull JSVarStatement varStatement) {
        JSVarStatement.VarKeyword keyword;
        if (varStatement == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(8);
        }
        JSVarStatement.VarKeyword varKeyword = (keyword = varStatement.getVarKeyword()) == JSVarStatement.VarKeyword.CONST || keyword == null ? JSVarStatement.VarKeyword.LET : keyword;
        if (varKeyword == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(9);
        }
        return varKeyword;
    }

    @Nullable
    private static String getTypeString(@NotNull JSInitializerOwner element) {
        JSType result;
        if (element == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(10);
        }
        if (!DialectDetector.hasFeature((PsiElement)element, (JSLanguageFeature)JSLanguageFeature.TYPES)) {
            return null;
        }
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSElement)element);
        if (type != null) {
            return type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)element);
        if (holder == null) {
            return null;
        }
        JSType jSType = holder.isECMA4 ? ActionScriptResolveUtil.getQualifiedExpressionJSType((JSExpression)element.getInitializer()) : (result = element instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)element).getJSType() : JSResolveUtil.getExpressionJSType((JSExpression)element.getInitializer()));
        if (result == null) {
            return null;
        }
        return JSVariablesWithInitializerPredicate.formatType((JSType)result, (PsiElement)element);
    }

    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSStatement newVarStatement = JSPsiElementFactory.createJSStatement((String)declarations, (PsiElement)oldVarStatement);
        PsiElement parent = oldVarStatement.getParent();
        if (parent instanceof JSVariableDeclaringScope) {
            parent.getParent().addBefore((PsiElement)newVarStatement, parent);
            PsiElement newElement = JSSplitDeclarationAndInitializationIntention.createForParent(oldVarStatement, parent, initializations);
            oldVarStatement.replace(newElement);
            return;
        }
        newVarStatement = oldVarStatement.replace(newVarStatement);
        int startOffset = newVarStatement.getTextOffset();
        JSStatement anchor = newVarStatement;
        for (String initialization : initializations) {
            anchor = anchor.addStatementAfter(JSPsiElementFactory.createJSStatement((String)initialization, (PsiElement)anchor));
        }
        int endOffset = anchor.getTextRange().getEndOffset();
        Document document = PsiDocumentManager.getInstance((Project)newVarStatement.getProject()).getDocument(newVarStatement.getContainingFile());
        if (document != null) {
            CodeStyleManager.getInstance((Project)newVarStatement.getProject()).reformatText(newVarStatement.getContainingFile(), startOffset, endOffset);
        }
    }

    @NotNull
    static PsiElement createForParent(JSVarStatement statement, PsiElement parent, List<String> initializations) {
        if (parent instanceof JSForInStatement && ((JSForInStatement)parent).isForEach()) {
            JSVarStatement.VarKeyword sourceKeyword = statement.getVarKeyword();
            String keywordText = sourceKeyword == null ? "" : sourceKeyword.getText();
            String text = statement.getText().substring(keywordText.length()).trim();
            JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)text, (PsiElement)parent);
            if (jSExpression == null) {
                JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(11);
            }
            return jSExpression;
        }
        JSVariable[] variables = statement.getVariables();
        ArrayList<JSAssignmentExpression> assignments = new ArrayList<JSAssignmentExpression>(variables.length);
        for (int i = 0; i < variables.length; ++i) {
            String initializer = (String)ContainerUtil.getOrElse(initializations, (int)i, null);
            String expressionText = initializer != null ? StringUtil.trimEnd((String)initializer, (char)';') : variables[i].getText() + " = q";
            JSAssignmentExpression expression = (JSAssignmentExpression)JSPsiElementFactory.createJSExpression((String)expressionText, (PsiElement)parent, JSAssignmentExpression.class);
            if (initializer == null) {
                expression.getROperand().delete();
                ASTNode sign = expression.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS);
                sign.getPsi().delete();
            }
            assignments.add(expression);
        }
        assert (assignments.size() > 0);
        if (parent instanceof JSForInStatement || assignments.size() == 1) {
            PsiElement psiElement = (PsiElement)assignments.get(0);
            if (psiElement == null) {
                JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)assignments.stream().map(PsiElement::getText).collect(Collectors.joining(", ")), (PsiElement)parent, JSCommaExpression.class);
        if (jSExpression == null) {
            JSSplitDeclarationAndInitializationIntention.$$$reportNull$$$0(13);
        }
        return jSExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationStatementText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyword";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createForParent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationStatementText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getKeyword";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

