/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.variables;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCompositeType;
import com.intellij.freemarker.psi.variables.FtlDataModelVariable;
import com.intellij.freemarker.psi.variables.FtlHashType;
import com.intellij.freemarker.psi.variables.FtlHashVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlImplicitVariable
extends RenameableFakePsiElement
implements FtlHashVariable,
FtlDataModelVariable {
    private final PsiComment myComment;
    private final String myName;
    private final FtlFile myScopeFile;
    private final List<String> myTypes;
    private final Map<String, FtlImplicitVariable> mySubVariables;
    @NonNls
    public static final String STATIC_MARKER = ".static";

    public FtlImplicitVariable(PsiComment comment, @NotNull String name, FtlFile scopeFile) {
        if (name == null) {
            FtlImplicitVariable.$$$reportNull$$$0(0);
        }
        super((PsiElement)comment.getContainingFile());
        this.myTypes = new SmartList();
        this.mySubVariables = new HashMap<String, FtlImplicitVariable>();
        this.myComment = comment;
        this.myName = name;
        this.myScopeFile = scopeFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            FtlImplicitVariable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiComment psiComment = this.myComment;
        if (psiComment == null) {
            FtlImplicitVariable.$$$reportNull$$$0(2);
        }
        return psiComment;
    }

    public PsiElement getParent() {
        return this.myComment;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Collection<FtlImplicitVariable> getSubVariables() {
        return this.mySubVariables.values();
    }

    public FtlImplicitVariable addSubVariable(String name) {
        return (FtlImplicitVariable)ContainerUtil.getOrCreate(this.mySubVariables, (Object)name, () -> new FtlImplicitVariable(this.myComment, name, this.myScopeFile));
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            FtlImplicitVariable.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    public void addType(String type) {
        this.myTypes.add(type);
    }

    @Override
    @NotNull
    public FtlType getType() {
        FtlType ftlType = (FtlType)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)this.calcType(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (ftlType == null) {
            FtlImplicitVariable.$$$reportNull$$$0(4);
        }
        return ftlType;
    }

    private FtlType calcType() {
        FtlHashType hashType = new FtlHashType(this);
        SmartList result = new SmartList();
        for (String type : this.myTypes) {
            try {
                ContainerUtil.addIfNotNull((Collection)result, (Object)FtlImplicitVariable.getDeclaredType(type, (PsiElement)this.myComment));
            }
            catch (PsiTypeCodeFragment.IncorrectTypeException incorrectTypeException) {}
        }
        if (result.size() > 0) {
            result.add(hashType);
            return new FtlCompositeType(result.toArray(new FtlType[0]));
        }
        return hashType;
    }

    @Nullable
    public static FtlType getDeclaredType(@Nullable String type, @NotNull PsiElement context) throws PsiTypeCodeFragment.IncorrectTypeException {
        if (context == null) {
            FtlImplicitVariable.$$$reportNull$$$0(5);
        }
        if (type == null) {
            return null;
        }
        boolean _static = false;
        if (type.endsWith(STATIC_MARKER)) {
            _static = true;
            type = type.substring(0, type.length() - STATIC_MARKER.length());
        }
        try {
            PsiTypeCodeFragment fragment = JavaCodeFragmentFactory.getInstance((Project)context.getProject()).createTypeCodeFragment(type, null, false);
            fragment.forceResolveScope(context.getResolveScope());
            PsiType psiType = fragment.getType();
            if (!_static && InheritanceUtil.isInheritor((PsiType)psiType, (String)"freemarker.template.TemplateMethodModel")) {
                return FtlCallableType.TEMPLATE_METHOD_TYPE;
            }
            if (!_static && InheritanceUtil.isInheritor((PsiType)psiType, (String)"freemarker.template.TemplateNodeModel")) {
                return FtlNodeType.INSTANCE;
            }
            return new FtlPsiType(psiType, _static);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public static PsiType getPsiType(String typeText, Project project) {
        if (typeText == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeFromText(typeText, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    public boolean isGlobal() {
        return this.myScopeFile == null && !this.myComment.getText().contains("file=\"");
    }

    public boolean isForFile(@NotNull FtlFile file) {
        if (file == null) {
            FtlImplicitVariable.$$$reportNull$$$0(6);
        }
        return file.isEquivalentTo((PsiElement)this.myScopeFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/variables/FtlImplicitVariable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/variables/FtlImplicitVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

