/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlDeclarationCache;
import com.intellij.freemarker.psi.directives.FtlDeclarationHolder;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.ResolveStateParameters;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlIfDirective
extends FtlDirective {
    public static final Key<Boolean> MAYBE_UNDEFINED = Key.create((String)"mayBeUndefined");
    private static final Condition<FtlDirective> BRANCH_CONDITION = ftlDirective -> FtlIfDirective.isBranch((PsiElement)ftlDirective);
    private static final Hash.Strategy<FtlAssignmentDeclaration> BY_NAME_STRATEGY = new Hash.Strategy<FtlAssignmentDeclaration>(){

        public int hashCode(@Nullable FtlAssignmentDeclaration object) {
            return object == null ? 0 : object.getName().hashCode();
        }

        public boolean equals(@Nullable FtlAssignmentDeclaration o1, @Nullable FtlAssignmentDeclaration o2) {
            return o1 == o2 || o1 != null && o2 != null && o1.getName().equals(o2.getName());
        }
    };
    private final FtlDeclarationCache<FtlIfDirective> myDeclarationCache = new FtlDeclarationCache<FtlIfDirective>(this){

        @Override
        protected FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters parameters) {
            return FtlIfDirective.this.calcDeclarationHolder(parameters);
        }
    };

    public FtlIfDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    public FtlExpression getCondition() {
        return (FtlExpression)this.findChildByClass(FtlExpression.class);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlIfDirective.$$$reportNull$$$0(0);
        }
        if (state == null) {
            FtlIfDirective.$$$reportNull$$$0(1);
        }
        if (place == null) {
            FtlIfDirective.$$$reportNull$$$0(2);
        }
        if (FtlIfDirective.isBranch(lastParent)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        if (lastParent != null) {
            return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
        }
        return this.myDeclarationCache.processDirectiveDeclarations(processor, state, honorAssigns);
    }

    private FtlDeclarationHolder calcDeclarationHolder(ResolveStateParameters parameters) {
        List<FtlDirective> branches = this.getBranches();
        final ArrayList normalDeclarations = new ArrayList();
        Object2ObjectOpenCustomHashMap map = new Object2ObjectOpenCustomHashMap(BY_NAME_STRATEGY);
        IntOpenHashSet successfulBranches = new IntOpenHashSet();
        ResolveState state = parameters.createState();
        class BranchProcessor
        implements PsiScopeProcessor {
            final int branchIndex;
            final /* synthetic */ Map val$map;
            final /* synthetic */ List val$normalDeclarations;

            BranchProcessor(int branchIndex) {
                this.val$map = map;
                this.val$normalDeclarations = list;
                this.branchIndex = branchIndex;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    BranchProcessor.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    BranchProcessor.$$$reportNull$$$0(1);
                }
                if (element instanceof FtlAssignmentDeclaration) {
                    FtlAssignmentDeclaration assignmentDeclaration = (FtlAssignmentDeclaration)element;
                    IntSet intSet = (IntSet)this.val$map.get(assignmentDeclaration);
                    if (intSet == null) {
                        intSet = new IntOpenHashSet();
                        this.val$map.put(assignmentDeclaration, intSet);
                    }
                    intSet.add(this.branchIndex);
                } else {
                    this.val$normalDeclarations.add(Pair.create((Object)element, (Object)state));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/psi/directives/FtlIfDirective$1BranchProcessor";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        if (super.processDirectiveDeclarations(new BranchProcessor(0), state, null, parameters.honorAssigns)) {
            successfulBranches.add(0);
        }
        for (int i = 0; i < branches.size(); ++i) {
            if (!branches.get(i).processDirectiveDeclarations(new BranchProcessor(i + 1), state, null, parameters.honorAssigns)) continue;
            successfulBranches.add(i + 1);
        }
        final boolean hasElseBranch = !branches.isEmpty() && FtlDirectiveType.isDirective((PsiElement)branches.get(branches.size() - 1), "else");
        final HashMap<FtlAssignmentDeclaration, Boolean> assignmentsUndefined = new HashMap<FtlAssignmentDeclaration, Boolean>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            FtlAssignmentDeclaration declaration;
            IntSet branchesWithDefinition = (IntSet)map.get(declaration = (FtlAssignmentDeclaration)iterator.next());
            boolean definedEverywhere = branchesWithDefinition.containsAll((IntCollection)successfulBranches);
            assignmentsUndefined.put(declaration, !definedEverywhere);
        }
        return new FtlDeclarationHolder((IntSet)successfulBranches){
            final /* synthetic */ IntSet val$successfulBranches;
            {
                this.val$successfulBranches = intSet;
            }

            @Override
            public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state) {
                if (!normalDeclarations.isEmpty()) {
                    for (Pair pair : normalDeclarations) {
                        if (processor.execute((PsiElement)pair.first, (ResolveState)pair.second)) continue;
                        return false;
                    }
                }
                for (Map.Entry entry : assignmentsUndefined.entrySet()) {
                    if (processor.execute((PsiElement)entry.getKey(), (Boolean)entry.getValue() != false ? state.put(MAYBE_UNDEFINED, (Object)Boolean.TRUE) : state)) continue;
                    return false;
                }
                return !hasElseBranch || !this.val$successfulBranches.isEmpty();
            }
        };
    }

    public static boolean isBranch(PsiElement lastParent) {
        return FtlDirectiveType.isDirective(lastParent, "else", "elseIf");
    }

    public List<FtlDirective> getBranches() {
        return ContainerUtil.findAll((Object[])this.getSubDirectives(), BRANCH_CONDITION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "place";
                break;
            }
        }
        objectArray[1] = "com/intellij/freemarker/psi/directives/FtlIfDirective";
        objectArray[2] = "processDeclarations";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

