/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.AbstractFtlExpression;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlAssignmentNamespace;
import com.intellij.freemarker.psi.FtlBinaryExpression;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlCompositeElementType;
import com.intellij.freemarker.psi.FtlExistsExpression;
import com.intellij.freemarker.psi.FtlHashLiteral;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlLambda;
import com.intellij.freemarker.psi.FtlLanguage;
import com.intellij.freemarker.psi.FtlLiteralExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlParenthesizedExpression;
import com.intellij.freemarker.psi.FtlQualifierType;
import com.intellij.freemarker.psi.FtlRangeExpression;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlSequenceLiteral;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlUnaryExpression;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IFileElementType;
import org.jetbrains.annotations.NonNls;

public interface FtlCompositeElementTypes {
    public static final IFileElementType FTL_SQUARE_FILE = new IFileElementType("FTL_FILE", FtlLanguage.SQUARE_INSTANCE);
    public static final FtlCompositeElementType ROOT_TAG = new FtlCompositeElementType("FtlRootTag"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlXmlRootTag(node);
        }
    };
    public static final FtlCompositeElementType INTERPOLATION = new FtlCompositeElementType("Interpolation"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlInterpolation(node);
        }
    };
    public static final FtlCompositeElementType NUMBER_LITERAL = new FtlQualifierType("NumberLiteral"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlLiteralExpression(node){

                @Override
                public FtlType getType() {
                    @NonNls String text = this.getText();
                    return FtlPsiType.wrap((PsiType)(text.contains(".") || text.contains("e") ? PsiType.DOUBLE : PsiType.INT));
                }
            };
        }
    };
    public static final FtlCompositeElementType BOOLEAN_LITERAL = new FtlQualifierType("BooleanLiteral"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlLiteralExpression(node){

                @Override
                public Object getConstantValue() {
                    return Boolean.valueOf(this.getText());
                }

                @Override
                public FtlType getType() {
                    return FtlPsiType.wrap((PsiType)PsiType.BOOLEAN);
                }
            };
        }
    };
    public static final FtlCompositeElementType FORMAT_LITERAL = new FtlQualifierType("FormatLiteral");
    public static final FtlCompositeElementType KEY_VALUE_PAIR = new FtlCompositeElementType("KeyValuePair");
    public static final FtlCompositeElementType RANGE_EXPRESSION = new FtlQualifierType("RangeExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlRangeExpression(node);
        }
    };
    public static final FtlCompositeElementType UNARY_EXPRESSION = new FtlQualifierType("UnaryExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlUnaryExpression(node);
        }
    };
    public static final FtlCompositeElementType BINARY_EXPRESSION = new FtlCompositeElementType("BinaryExpression"){

        public FtlCompositeElement createPsiElement(ASTNode node) {
            return new FtlBinaryExpression(node);
        }
    };
    public static final FtlCompositeElementType STRING_LITERAL = new FtlQualifierType("StringLiteral"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlStringLiteral(node);
        }
    };
    public static final FtlCompositeElementType SEQUENCE_LITERAL = new FtlQualifierType("SequenceLiteral"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlSequenceLiteral(node);
        }
    };
    public static final FtlCompositeElementType HASH_LITERAL = new FtlQualifierType("HashLiteral"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlHashLiteral(node);
        }
    };
    public static final FtlCompositeElementType PARENTHESIZED_EXPRESSION = new FtlQualifierType("ParenthesizedExpression"){

        @Override
        public AbstractFtlExpression createPsiElement(ASTNode node) {
            return new FtlParenthesizedExpression(node);
        }
    };
    public static final FtlCompositeElementType REFERENCE_EXPRESSION = new FtlQualifierType("ReferenceExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlReferenceExpression(node);
        }
    };
    public static final FtlCompositeElementType INDEX_EXPRESSION = new FtlQualifierType("IndexExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlIndexExpression(node);
        }
    };
    public static final FtlCompositeElementType BUILT_IN_EXPRESSION = new FtlQualifierType("BuiltInExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlBuiltIn(node);
        }
    };
    public static final FtlCompositeElementType DEFAULT_VALUE_EXPRESSION = new FtlQualifierType("DefautValueExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new AbstractFtlExpression(node){

                @Override
                public FtlType getType() {
                    return this.getExpressionType(0);
                }
            };
        }
    };
    public static final FtlCompositeElementType EXISTS_EXPRESSION = new FtlQualifierType("ExistsExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlExistsExpression(node);
        }
    };
    public static final FtlCompositeElementType METHOD_CALL_EXPRESSION = new FtlQualifierType("MethodCallExpression"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlMethodCallExpression(node);
        }
    };
    public static final FtlCompositeElementType ARGUMENT_LIST = new FtlCompositeElementType("ArgumentList"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlArgumentList(node, true);
        }
    };
    public static final FtlCompositeElementType NAMED_PARAMETER_LIST = new FtlCompositeElementType("NamedParameterList"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlArgumentList(node, false);
        }
    };
    public static final FtlCompositeElementType ATTRIBUTE_NAME = new FtlCompositeElementType("AttributeName");
    public static final FtlCompositeElementType NAME_VALUE_PAIR = new FtlCompositeElementType("NameValuePair"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlNameValuePair(node);
        }
    };
    public static final FtlCompositeElementType PARAMETER_DECLARATION = new FtlCompositeElementType("ParameterDeclaration"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlParameterDeclaration(node);
        }
    };
    public static final FtlCompositeElementType ASSIGNMENT_NAMESPACE = new FtlCompositeElementType("AssignmentNamespace"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlAssignmentNamespace(node);
        }
    };
    public static final FtlCompositeElementType USER_DIRECTIVE = new FtlCompositeElementType("UserDirective"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlMacro(node);
        }
    };
    public static final FtlCompositeElementType LOOP_VARIABLE = new FtlCompositeElementType("LoopVariable"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlMacroLoopVariable(node);
        }
    };
    public static final FtlCompositeElementType LOCAL_LAMBDA = new FtlCompositeElementType("LocalLambda"){

        @Override
        public PsiElement createPsiElement(ASTNode node) {
            return new FtlLambda(node);
        }
    };
}

