/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.translate.context.InlineFunctionContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceFile;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006*\u00020\u0002H\u0002\u001a&\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a \u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001a\u001a\u0010\u0016\u001a\u00020\n*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\"\u0010\u001b\u001a\u00020\u000e*\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001d"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "reportInlineFunction", "", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumer;", "descriptor", "translatedFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sourceInfo", "Lcom/intellij/psi/PsiElement;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "outerContext", "js.translator"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $this$translateAndAliasParameters, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        boolean bl;
        Object object;
        Object paramName232;
        Object object2;
        Object suggestedName;
        Object paramNameForType;
        Intrinsics.checkNotNullParameter((Object)$this$translateAndAliasParameters, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(targetList2, (String)"targetList");
        boolean bl2 = false;
        Map aliases = new LinkedHashMap();
        for (TypeParameterDescriptor translationContext : FunctionTranslatorKt.getCorrectTypeParameters(descriptor2)) {
            if (!translationContext.isReified()) continue;
            Object object3 = $this$translateAndAliasParameters.getNameForDescriptor(translationContext);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getNameForDescriptor(type)");
            paramNameForType = object3;
            object3 = targetList2;
            Object object4 = new JsParameter((JsName)paramNameForType);
            boolean bl3 = false;
            object3.add(object4);
            object4 = Namer.isInstanceSuggestedName(translationContext);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"isInstanceSuggestedName(type)");
            suggestedName = object4;
            object2 = JsScope.declareTemporaryName((String)suggestedName);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"declareTemporaryName(suggestedName)");
            paramName232 = object2;
            object2 = targetList2;
            object = new JsParameter((JsName)paramName232);
            boolean bl4 = false;
            object2.add(object);
            object2 = aliases;
            Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"type");
            object = translationContext;
            JsNameRef jsNameRef = ((JsName)paramName232).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"paramName.makeRef()");
            bl = false;
            object2.put(object, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName jsName = JsScope.declareTemporaryName(Namer.getReceiverParameterName());
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"declareTemporaryName(Namer.getReceiverParameterName())");
            JsName receiverParameterName = jsName;
            paramNameForType = receiverParameterName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)paramNameForType, (String)"receiverParameterName.makeRef()");
            HasMetadata hasMetadata = paramNameForType;
            JsExpression jsExpression = hasMetadata;
            paramNameForType = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)paramNameForType);
            MetadataProperties.setType(jsExpression, paramNameForType.getType());
            paramNameForType = aliases;
            paramName232 = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)paramName232);
            suggestedName = paramName232;
            boolean paramName232 = false;
            paramNameForType.put(suggestedName, hasMetadata);
            paramNameForType = targetList2;
            suggestedName = new JsParameter(receiverParameterName);
            paramName232 = false;
            paramNameForType.add(suggestedName);
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
            suggestedName = $this$translateAndAliasParameters.getNameForDescriptor(valueParameterDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)suggestedName, (String)"getNameForDescriptor(valueParameter)");
            JsName name = suggestedName;
            object2 = JsScope.declareTemporaryName(name.getIdent());
            boolean bl5 = false;
            boolean bl6 = false;
            JsName it = object2;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            MetadataProperties.setDescriptor(it, (DeclarationDescriptor)valueParameterDescriptor);
            JsName paramName232 = object2;
            Intrinsics.checkNotNullExpressionValue((Object)paramName232, (String)"declareTemporaryName(name.ident).also { it.descriptor = valueParameter }");
            JsName tmpName = paramName232;
            object2 = JsAstUtils.pureFqn(tmpName, null);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pureFqn(tmpName, null)");
            Object parameterRef = object2;
            MetadataProperties.setType((JsExpression)parameterRef, valueParameterDescriptor.getType());
            object2 = aliases;
            Intrinsics.checkNotNullExpressionValue((Object)valueParameterDescriptor, (String)"valueParameter");
            object = valueParameterDescriptor;
            bl6 = false;
            object2.put(object, parameterRef);
            object2 = targetList2;
            object = new JsParameter(tmpName);
            bl6 = false;
            bl = false;
            Object $this$translateAndAliasParameters_u24lambda_u2d1 = object;
            boolean bl8 = false;
            MetadataProperties.setHasDefaultValue((JsParameter)$this$translateAndAliasParameters_u24lambda_u2d1, ArgumentsUtilsKt.hasDefaultValue(valueParameterDescriptor));
            bl6 = false;
            object2.add(object);
        }
        ValueParameterDescriptor continuationDescriptor = $this$translateAndAliasParameters.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($this$translateAndAliasParameters.getNameForDescriptor(continuationDescriptor));
            Object object5 = targetList2;
            boolean bl7 = false;
            object5.add(jsParameter);
            object5 = aliases;
            JsExpression jsExpression = JsAstUtils.stateMachineReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"stateMachineReceiver()");
            boolean bl8 = false;
            object5.put(continuationDescriptor, jsExpression);
        }
        TranslationContext translationContext = $this$translateAndAliasParameters.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkNotNullExpressionValue((Object)translationContext, (String)"this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(FunctionDescriptor $this$getCorrectTypeParameters) {
        PropertyDescriptor propertyDescriptor;
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        PropertyAccessorDescriptor propertyAccessorDescriptor2 = propertyAccessorDescriptor = $this$getCorrectTypeParameters instanceof PropertyAccessorDescriptor ? (PropertyAccessorDescriptor)$this$getCorrectTypeParameters : null;
        List<TypeParameterDescriptor> list2 = propertyAccessorDescriptor == null ? null : ((propertyDescriptor = propertyAccessorDescriptor.getCorrespondingProperty()) == null ? null : propertyDescriptor.getTypeParameters());
        List<TypeParameterDescriptor> list3 = list2 == null ? $this$getCorrectTypeParameters.getTypeParameters() : list2;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"(this as? PropertyAccessorDescriptor)?.correspondingProperty?.typeParameters ?: typeParameters");
        return list3;
    }

    private static final boolean getRequiresExtensionReceiverParameter(FunctionDescriptor $this$requiresExtensionReceiverParameter) {
        return DescriptorUtils.isExtension($this$requiresExtensionReceiverParameter);
    }

    public static final void translateFunction(@NotNull TranslationContext $this$translateFunction, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)$this$translateFunction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        FunctionDescriptor functionDescriptor = BindingUtils.getFunctionDescriptor($this$translateFunction.bindingContext(), declaration);
        Intrinsics.checkNotNullExpressionValue((Object)functionDescriptor, (String)"getFunctionDescriptor(bindingContext(), declaration)");
        FunctionDescriptor descriptor2 = functionDescriptor;
        if (declaration.hasBody()) {
            JsBlock jsBlock = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $this$translateFunction);
            Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"translateFunctionBody(descriptor, declaration, this)");
            JsBlock body2 = jsBlock;
            jsBlock = function2.getBody();
            Collection<JsStatement> collection = jsBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"function.body.statements");
            collection = collection;
            Iterable<JsStatement> iterable = body2.getStatements();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"body.statements");
            iterable = iterable;
            boolean bl = false;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $this$wrapWithInlineMetadata, @NotNull TranslationContext outerContext, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$wrapWithInlineMetadata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outerContext, (String)"outerContext");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Object object2 = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.source");
        PsiElement sourceInfo = KotlinSourceElementKt.getPsi((SourceElement)object2);
        if (descriptor2.isInline()) {
            List<JsStatement> list2;
            boolean bl;
            JsExpression jsExpression;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            object2 = $this$wrapWithInlineMetadata.getConfig();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"config");
            if (org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.shouldBeExported(declarationDescriptor, (JsConfig)object2)) {
                InlineMetadata metadata = InlineMetadata.Companion.compose(function2, descriptor2, $this$wrapWithInlineMetadata);
                jsExpression = metadata.functionWithMetadata(outerContext, sourceInfo);
            } else {
                InlineFunctionContext inlineFunctionContext = $this$wrapWithInlineMetadata.getInlineFunctionContext();
                Intrinsics.checkNotNull((Object)inlineFunctionContext);
                bl = false;
                boolean bl2 = false;
                InlineFunctionContext it = inlineFunctionContext;
                boolean bl3 = false;
                list2 = it.getImportBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"it.importBlock.statements");
                Collection collection = list2;
                list2 = it.getPrototypeBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"it.prototypeBlock.statements");
                Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
                list2 = it.getDeclarationsBlock().getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"it.declarationsBlock.statements");
                JsBlock block = new JsBlock(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)list2), (Object)new JsReturn(function2)));
                jsExpression = InlineMetadata.Companion.wrapFunction(outerContext, new FunctionWithWrapper(function2, block), sourceInfo);
            }
            object2 = jsExpression;
            boolean bl4 = false;
            bl = false;
            Object it = object2;
            boolean bl5 = false;
            IncrementalResultsConsumer incrementalResults = $this$wrapWithInlineMetadata.getConfig().getConfiguration().get(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER);
            list2 = incrementalResults;
            if (list2 != null) {
                FunctionTranslatorKt.reportInlineFunction(list2, descriptor2, (JsExpression)it, sourceInfo);
            }
            object = object2;
        } else {
            object = function2;
        }
        return object;
    }

    private static final void reportInlineFunction(IncrementalResultsConsumer $this$reportInlineFunction, FunctionDescriptor descriptor2, JsExpression translatedFunction, PsiElement sourceInfo) {
        ASTNode aSTNode;
        Object object;
        Object object2;
        PsiFile psiFile;
        Object object3 = descriptor2.getSource().getContainingFile();
        Object object4 = object3 instanceof PsiSourceFile ? (PsiSourceFile)object3 : null;
        PsiFile psiFile2 = psiFile = object4 == null ? null : ((PsiSourceFile)object4).getPsiFile();
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile3 = psiFile;
        object4 = VfsUtilCore.virtualToIoFile((VirtualFile)psiFile3.getVirtualFile());
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"virtualToIoFile(psiFile.virtualFile)");
        Object file2 = object4;
        object4 = descriptor2.getVisibility();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"descriptor.visibility");
        if (EffectiveVisibilityUtilsKt.effectiveVisibility((DescriptorVisibility)object4, descriptor2, true).getPrivateApi()) {
            return;
        }
        object3 = descriptor2;
        if (object3 instanceof PropertyGetterDescriptor) {
            object2 = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.correspondingProperty");
            object = Intrinsics.stringPlus((String)"<get>", (Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object2).asString());
        } else if (object3 instanceof PropertySetterDescriptor) {
            object2 = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.correspondingProperty");
            object = Intrinsics.stringPlus((String)"<set>", (Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object2).asString());
        } else {
            object2 = DescriptorUtilsKt.getFqNameSafe(descriptor2).asString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor.fqNameSafe.asString()");
            object = object2;
        }
        Object fqName2 = object;
        object2 = sourceInfo;
        Integer offset2 = object2 == null ? null : ((aSTNode = object2.getNode()) == null ? null : Integer.valueOf(aSTNode.getStartOffset()));
        Document document = psiFile3.getViewProvider().getDocument();
        int sourceLine = -1;
        int sourceColumn = -1;
        if (offset2 != null && document != null) {
            sourceLine = document.getLineNumber(offset2.intValue());
            sourceColumn = offset2 - document.getLineStartOffset(sourceLine);
        }
        $this$reportInlineFunction.processInlineFunction((File)file2, (String)fqName2, translatedFunction, sourceLine, sourceColumn);
    }
}

