/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016JD\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\"H\u0002J)\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\t2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010&J!\u0010'\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J!\u0010*\u001a\u00020\f2\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0%\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010(J\u0018\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0002J(\u0010.\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J(\u00100\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J(\u00101\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J \u00102\u001a\u00020\f*\u00020\u00112\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u00103\u001a\u00020\bH\u0002RB\u0010\u0005\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "compatibilityTypeMap", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;", "Lkotlin/collections/HashMap;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkCompatibilityType", "firstModifier", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifier;", "secondModifier", "reportedNodes", "", "owner", "checkModifiers", "list", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierList;", "deduceCompatibilityType", "firstKeyword", "secondKeyword", "isDeclarationMappedToSourceCorrectly", "", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "recordCompatibilityType", "compatibilityType", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "recordDeprecatedPairs", "([Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "recordIncompatiblePairs", "recordPairsCompatibleForClasses", "recordRedundantPairs", "redundantKeyword", "sufficientKeyword", "reportDeprecatedModifierPair", "modifier", "reportIncompatibleModifiers", "reportRedundantModifier", "reportRepeatedModifier", "keyword", "CompatibilityType", "checkers"})
public final class FirModifierChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirModifierChecker INSTANCE = new FirModifierChecker();
    @NotNull
    private static final HashMap<Pair<KtModifierKeywordToken, KtModifierKeywordToken>, CompatibilityType> compatibilityTypeMap;

    private FirModifierChecker() {
    }

    private final void recordCompatibilityType(CompatibilityType compatibilityType, KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = list2;
        int n = 0;
        int n2 = ktModifierKeywordTokenArray.length;
        while (n < n2) {
            KtModifierKeywordToken firstKeyword = ktModifierKeywordTokenArray[n];
            ++n;
            for (KtModifierKeywordToken secondKeyword : list2) {
                if (Intrinsics.areEqual((Object)((Object)firstKeyword), (Object)((Object)secondKeyword))) continue;
                Map map = compatibilityTypeMap;
                Pair pair = new Pair((Object)firstKeyword, (Object)secondKeyword);
                boolean bl = false;
                map.put(pair, compatibilityType);
            }
        }
    }

    private final void recordPairsCompatibleForClasses(KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[list2.length];
        System.arraycopy(list2, 0, ktModifierKeywordTokenArray, 0, list2.length);
        this.recordCompatibilityType(CompatibilityType.COMPATIBLE_FOR_CLASSES, ktModifierKeywordTokenArray);
    }

    private final void recordDeprecatedPairs(KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[list2.length];
        System.arraycopy(list2, 0, ktModifierKeywordTokenArray, 0, list2.length);
        this.recordCompatibilityType(CompatibilityType.DEPRECATED, ktModifierKeywordTokenArray);
    }

    private final void recordIncompatiblePairs(KtModifierKeywordToken ... list2) {
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[list2.length];
        System.arraycopy(list2, 0, ktModifierKeywordTokenArray, 0, list2.length);
        this.recordCompatibilityType(CompatibilityType.INCOMPATIBLE, ktModifierKeywordTokenArray);
    }

    private final void recordRedundantPairs(KtModifierKeywordToken redundantKeyword, KtModifierKeywordToken sufficientKeyword) {
        Map map = compatibilityTypeMap;
        Pair pair = new Pair((Object)redundantKeyword, (Object)sufficientKeyword);
        CompatibilityType compatibilityType = CompatibilityType.REDUNDANT_1_TO_2;
        boolean bl = false;
        map.put(pair, compatibilityType);
        map = compatibilityTypeMap;
        pair = new Pair((Object)sufficientKeyword, (Object)redundantKeyword);
        compatibilityType = CompatibilityType.REDUNDANT_2_TO_1;
        bl = false;
        map.put(pair, compatibilityType);
    }

    private final CompatibilityType deduceCompatibilityType(KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        CompatibilityType compatibilityType;
        if (Intrinsics.areEqual((Object)((Object)firstKeyword), (Object)((Object)secondKeyword))) {
            compatibilityType = CompatibilityType.REPEATED;
        } else {
            CompatibilityType compatibilityType2 = compatibilityTypeMap.get(new Pair((Object)firstKeyword, (Object)secondKeyword));
            CompatibilityType compatibilityType3 = compatibilityType2 == null ? CompatibilityType.COMPATIBLE : compatibilityType2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)compatibilityType3), (String)"{\n            compatibilityTypeMap[Pair(firstKeyword, secondKeyword)] ?: CompatibilityType.COMPATIBLE\n        }");
            compatibilityType = compatibilityType3;
        }
        return compatibilityType;
    }

    private final void checkCompatibilityType(FirModifier<?> firstModifier, FirModifier<?> secondModifier, DiagnosticReporter reporter, Set<FirModifier<?>> reportedNodes, FirDeclaration owner) {
        KtModifierKeywordToken firstToken = firstModifier.getToken();
        KtModifierKeywordToken secondToken = secondModifier.getToken();
        CompatibilityType compatibilityType = this.deduceCompatibilityType(firstToken, secondToken);
        int n = WhenMappings.$EnumSwitchMapping$0[compatibilityType.ordinal()];
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (!reportedNodes.add(secondModifier)) break;
                this.reportRepeatedModifier(reporter, secondModifier, secondToken);
                break;
            }
            case 3: {
                this.reportRedundantModifier(reporter, secondModifier, secondToken, firstToken);
                break;
            }
            case 4: {
                this.reportRedundantModifier(reporter, firstModifier, firstToken, secondToken);
                break;
            }
            case 5: {
                this.reportDeprecatedModifierPair(reporter, firstModifier, firstToken, secondToken);
                this.reportDeprecatedModifierPair(reporter, secondModifier, secondToken, firstToken);
                break;
            }
            case 6: 
            case 7: {
                if (n == 7 && owner instanceof FirClass) {
                    return;
                }
                if (reportedNodes.add(firstModifier)) {
                    this.reportIncompatibleModifiers(reporter, firstModifier, firstToken, secondToken);
                }
                if (!reportedNodes.add(secondModifier)) break;
                this.reportIncompatibleModifiers(reporter, secondModifier, secondToken, firstToken);
            }
        }
    }

    private final void checkModifiers(FirModifierList list2, FirDeclaration owner, DiagnosticReporter reporter) {
        boolean bl = false;
        HashSet reportedNodes = new HashSet();
        List<FirModifier<?>> modifiers2 = list2.getModifiers();
        for (FirModifier<?> secondModifier : modifiers2) {
            for (FirModifier<?> firstModifier : modifiers2) {
                if (Intrinsics.areEqual(firstModifier, secondModifier)) break;
                this.checkCompatibilityType(firstModifier, secondModifier, reporter, reportedNodes, owner);
            }
        }
    }

    private final boolean isDeclarationMappedToSourceCorrectly(FirDeclaration declaration, FirSourceElement source) {
        IElementType iElementType = source.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CLASS) ? declaration instanceof FirClass : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.OBJECT_DECLARATION) ? declaration instanceof FirClass : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.PROPERTY) ? declaration instanceof FirProperty : (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER) ? declaration instanceof FirValueParameter : true)));
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration instanceof FirFile) {
            return;
        }
        FirSourceElement firSourceElement = declaration.getSource();
        if (firSourceElement == null) {
            return;
        }
        FirSourceElement source = firSourceElement;
        if (!this.isDeclarationMappedToSourceCorrectly(declaration, source)) {
            return;
        }
        if (CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirDefaultPropertyAccessor) {
            return;
        }
        Object object = FirModifierList.Companion;
        boolean bl = false;
        boolean bl2 = false;
        FirModifierList.Companion $this$check_u24lambda_u2d0 = object;
        boolean bl3 = false;
        FirModifierList modifierList2 = $this$check_u24lambda_u2d0.getModifierList(source);
        object = modifierList2;
        if (object != null) {
            Object object2 = object;
            bl2 = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            INSTANCE.checkModifiers((FirModifierList)it, declaration, reporter);
        }
    }

    private final void reportRepeatedModifier(DiagnosticReporter $this$reportRepeatedModifier, FirModifier<?> modifier, KtModifierKeywordToken keyword) {
        $this$reportRepeatedModifier.report((FirDiagnostic)FirErrors.INSTANCE.getREPEATED_MODIFIER().on(modifier.getSource(), keyword));
    }

    private final void reportRedundantModifier(DiagnosticReporter $this$reportRedundantModifier, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        $this$reportRedundantModifier.report((FirDiagnostic)FirErrors.INSTANCE.getREDUNDANT_MODIFIER().on(modifier.getSource(), firstKeyword, secondKeyword));
    }

    private final void reportDeprecatedModifierPair(DiagnosticReporter $this$reportDeprecatedModifierPair, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        $this$reportDeprecatedModifierPair.report((FirDiagnostic)FirErrors.INSTANCE.getDEPRECATED_MODIFIER_PAIR().on(modifier.getSource(), firstKeyword, secondKeyword));
    }

    private final void reportIncompatibleModifiers(DiagnosticReporter $this$reportIncompatibleModifiers, FirModifier<?> modifier, KtModifierKeywordToken firstKeyword, KtModifierKeywordToken secondKeyword) {
        $this$reportIncompatibleModifiers.report((FirDiagnostic)FirErrors.INSTANCE.getINCOMPATIBLE_MODIFIERS().on(modifier.getSource(), firstKeyword, secondKeyword));
    }

    static {
        boolean bl = false;
        compatibilityTypeMap = new HashMap();
        Object object = new KtModifierKeywordToken[2];
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.IN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"IN_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OUT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OUT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[4];
        ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.PROTECTED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PROTECTED_KEYWORD");
        object[1] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.PUBLIC_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PUBLIC_KEYWORD");
        object[2] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.INTERNAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"INTERNAL_KEYWORD");
        object[3] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[4];
        ktModifierKeywordToken = KtTokens.HEADER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"HEADER_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.EXPECT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"EXPECT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.IMPL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"IMPL_KEYWORD");
        object[2] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.ACTUAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ACTUAL_KEYWORD");
        object[3] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"FINAL_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[3];
        ktModifierKeywordToken = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"FINAL_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"SEALED_KEYWORD");
        object[2] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.CROSSINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"CROSSINLINE_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.NOINLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"NOINLINE_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"DATA_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"DATA_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"INNER_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"DATA_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"DATA_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"SEALED_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.DATA_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"DATA_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.INLINE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"INLINE_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"CONST_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"CONST_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.CONST_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"CONST_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OVERRIDE_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OVERRIDE_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPEN_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordPairsCompatibleForClasses((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.PRIVATE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"PRIVATE_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"ABSTRACT_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordPairsCompatibleForClasses((KtModifierKeywordToken)((Object)object));
        object = new KtModifierKeywordToken[2];
        ktModifierKeywordToken = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"SEALED_KEYWORD");
        object[0] = ktModifierKeywordToken;
        ktModifierKeywordToken = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"INNER_KEYWORD");
        object[1] = ktModifierKeywordToken;
        INSTANCE.recordIncompatiblePairs((KtModifierKeywordToken)((Object)object));
        object = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPEN_KEYWORD");
        Object object2 = object;
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
        INSTANCE.recordRedundantPairs((KtModifierKeywordToken)((Object)object2), (KtModifierKeywordToken)((Object)object));
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
        Object object3 = object;
        object = KtTokens.SEALED_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"SEALED_KEYWORD");
        INSTANCE.recordRedundantPairs((KtModifierKeywordToken)((Object)object3), (KtModifierKeywordToken)((Object)object));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirModifierChecker$CompatibilityType;", "", "(Ljava/lang/String;I)V", "COMPATIBLE", "COMPATIBLE_FOR_CLASSES", "REDUNDANT_1_TO_2", "REDUNDANT_2_TO_1", "DEPRECATED", "REPEATED", "INCOMPATIBLE", "checkers"})
    private static final class CompatibilityType
    extends Enum<CompatibilityType> {
        public static final /* enum */ CompatibilityType COMPATIBLE = new CompatibilityType();
        public static final /* enum */ CompatibilityType COMPATIBLE_FOR_CLASSES = new CompatibilityType();
        public static final /* enum */ CompatibilityType REDUNDANT_1_TO_2 = new CompatibilityType();
        public static final /* enum */ CompatibilityType REDUNDANT_2_TO_1 = new CompatibilityType();
        public static final /* enum */ CompatibilityType DEPRECATED = new CompatibilityType();
        public static final /* enum */ CompatibilityType REPEATED = new CompatibilityType();
        public static final /* enum */ CompatibilityType INCOMPATIBLE = new CompatibilityType();
        private static final /* synthetic */ CompatibilityType[] $VALUES;

        public static CompatibilityType[] values() {
            CompatibilityType[] compatibilityTypeArray = $VALUES;
            CompatibilityType[] compatibilityTypeArray2 = new CompatibilityType[compatibilityTypeArray.length];
            System.arraycopy(compatibilityTypeArray, 0, compatibilityTypeArray2, 0, compatibilityTypeArray.length);
            return compatibilityTypeArray2;
        }

        public static CompatibilityType valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(CompatibilityType.class, value2);
        }

        static {
            $VALUES = compatibilityTypeArray = new CompatibilityType[]{CompatibilityType.COMPATIBLE, CompatibilityType.COMPATIBLE_FOR_CLASSES, CompatibilityType.REDUNDANT_1_TO_2, CompatibilityType.REDUNDANT_2_TO_1, CompatibilityType.DEPRECATED, CompatibilityType.REPEATED, CompatibilityType.INCOMPATIBLE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompatibilityType.values().length];
            nArray[CompatibilityType.COMPATIBLE.ordinal()] = 1;
            nArray[CompatibilityType.REPEATED.ordinal()] = 2;
            nArray[CompatibilityType.REDUNDANT_2_TO_1.ordinal()] = 3;
            nArray[CompatibilityType.REDUNDANT_1_TO_2.ordinal()] = 4;
            nArray[CompatibilityType.DEPRECATED.ordinal()] = 5;
            nArray[CompatibilityType.INCOMPATIBLE.ordinal()] = 6;
            nArray[CompatibilityType.COMPATIBLE_FOR_CLASSES.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

