/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.tracing;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.opentelemetry.export.AttributeNames;
import com.newrelic.telemetry.opentelemetry.export.NewRelicMetricExporter;
import com.newrelic.telemetry.opentelemetry.export.NewRelicSpanExporter;
import fleet.util.tracing.FileMetricExporter;
import fleet.util.tracing.FleetTelemetryKt;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.propagation.HttpTraceContext;
import io.opentelemetry.context.propagation.DefaultContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.MeterSdkProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u001a<\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u001c\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u0001\u001a\u0006\u0010\u001f\u001a\u00020\u0019\u001a\b\u0010 \u001a\u00020\u0019H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0004\u0010\u0006\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\f\u0010\u0006\"\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011\"\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"INSTRUMENTER_NAME", "", "intervalMetricReader", "Lio/opentelemetry/sdk/metrics/export/IntervalMetricReader;", "isMetricEnabled", "", "()Z", "isMetricEnabled$delegate", "Lkotlin/Lazy;", "isTelemetrySet", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "isTracingEnabled", "isTracingEnabled$delegate", "meter", "Lio/opentelemetry/api/metrics/Meter;", "getMeter", "()Lio/opentelemetry/api/metrics/Meter;", "meter$delegate", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "getTracer", "()Lio/opentelemetry/api/trace/Tracer;", "tracer$delegate", "setupTelemetry", "", "apiKey", "metricsLog", "exporterUri", "metricExporterUri", "defaultServiceName", "shutdownTelemetry", "waitForTelemetrySetup", "fleet.util.telemetry"})
public final class FleetTelemetryKt {
    private static final String INSTRUMENTER_NAME = "test.instrumenter.whatever";
    @NotNull
    private static final Lazy isTracingEnabled$delegate = LazyKt.lazy((Function0)isTracingEnabled.2.INSTANCE);
    @NotNull
    private static final Lazy isMetricEnabled$delegate = LazyKt.lazy((Function0)isMetricEnabled.2.INSTANCE);
    @NotNull
    private static final Lazy tracer$delegate = LazyKt.lazy((Function0)tracer.2.INSTANCE);
    @NotNull
    private static final Lazy meter$delegate = LazyKt.lazy((Function0)meter.2.INSTANCE);
    private static IntervalMetricReader intervalMetricReader;
    private static final MutableStateFlow<Integer> isTelemetrySet;

    public static final boolean isTracingEnabled() {
        Lazy lazy = isTracingEnabled$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public static final boolean isMetricEnabled() {
        Lazy lazy = isMetricEnabled$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public static final Tracer getTracer() {
        Lazy lazy = tracer$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Tracer)lazy.getValue();
    }

    @NotNull
    public static final Meter getMeter() {
        Lazy lazy = meter$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Meter)lazy.getValue();
    }

    private static final void waitForTelemetrySetup() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.first((Flow)((Flow)FleetTelemetryKt.access$isTelemetrySet$p()), (Function2)((Function2)new Function2<Integer, Continuation<? super Boolean>, Object>(null){
                            private /* synthetic */ int I$0;
                            int label;

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        int it = this.I$0;
                                        return Boxing.boxBoolean((it == 0 || it == 2 ? 1 : 0) != 0);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<Integer, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                int n = function2.I$0 = ((Number)value).intValue();
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Integer>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setupTelemetry(@Nullable String apiKey, @Nullable String metricsLog, @NotNull String exporterUri, @NotNull String metricExporterUri, @NotNull String defaultServiceName) {
        Intrinsics.checkNotNullParameter((Object)exporterUri, (String)"exporterUri");
        Intrinsics.checkNotNullParameter((Object)metricExporterUri, (String)"metricExporterUri");
        Intrinsics.checkNotNullParameter((Object)defaultServiceName, (String)"defaultServiceName");
        if (!FleetTelemetryKt.isTracingEnabled() && !FleetTelemetryKt.isMetricEnabled()) {
            return;
        }
        if (apiKey == null && metricsLog == null) {
            String string = "WARNING: tracing = " + FleetTelemetryKt.isTracingEnabled() + ", metrics = " + FleetTelemetryKt.isMetricEnabled() + ", but both New Relic and file logging cannot be configured";
            boolean bl = false;
            System.out.println((Object)string);
            string = "         Please specify -Dfleet.metric.log=<path> or -Dfleet.newrelic.api=<new_relic_key>";
            bl = false;
            System.out.println((Object)string);
            return;
        }
        isTelemetrySet.setValue((Object)1);
        try {
            MetricExporter exporter;
            String serviceName = System.getProperty("fleet.telemetry.service.name", defaultServiceName);
            OpenTelemetrySdk sdk = OpenTelemetrySdk.get();
            OpenTelemetrySdk.Builder sdkBuilder = sdk.toBuilder();
            if (FleetTelemetryKt.isTracingEnabled() && apiKey != null) {
                exporter = NewRelicSpanExporter.newBuilder().apiKey(apiKey).commonAttributes(new Attributes().put(AttributeNames.SERVICE_NAME, serviceName)).uriOverride(new URI(exporterUri)).enableAuditLogging().build();
                BatchSpanProcessor batchSpanProcessor = BatchSpanProcessor.builder((SpanExporter)((SpanExporter)exporter)).setScheduleDelayMillis(10000L).build();
                Intrinsics.checkNotNullExpressionValue((Object)batchSpanProcessor, (String)"BatchSpanProcessor.build\u2026le delay\n        .build()");
                BatchSpanProcessor spanProcessor = batchSpanProcessor;
                OpenTelemetrySdk.getGlobalTracerManagement().addSpanProcessor((SpanProcessor)spanProcessor);
                sdkBuilder.setPropagators(DefaultContextPropagators.builder().addTextMapPropagator((TextMapPropagator)HttpTraceContext.getInstance()).build());
            }
            if (FleetTelemetryKt.isMetricEnabled()) {
                MetricExporter metricExporter;
                if (metricsLog != null) {
                    metricExporter = new FileMetricExporter(metricsLog);
                } else if (apiKey != null) {
                    metricExporter = (MetricExporter)NewRelicMetricExporter.newBuilder().apiKey(apiKey).commonAttributes(new Attributes().put(AttributeNames.SERVICE_NAME, serviceName)).uriOverride(new URI(metricExporterUri)).enableAuditLogging().build();
                } else {
                    String string = "Missing metrics log and api key";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                exporter = metricExporter;
                IntervalMetricReader.Builder builder = IntervalMetricReader.builder().setExportIntervalMillis(10000L).setMetricExporter(exporter);
                MeterSdkProvider meterSdkProvider = OpenTelemetrySdk.getGlobalMeterProvider();
                Intrinsics.checkNotNullExpressionValue((Object)meterSdkProvider, (String)"OpenTelemetrySdk.getGlobalMeterProvider()");
                intervalMetricReader = builder.setMetricProducers((Collection)SetsKt.setOf((Object)meterSdkProvider.getMetricProducer())).build();
            }
            OpenTelemetry.set((OpenTelemetry)((OpenTelemetry)sdkBuilder.build()));
        }
        finally {
            isTelemetrySet.setValue((Object)2);
        }
    }

    public static /* synthetic */ void setupTelemetry$default(String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = System.getProperty("fleet.newrelic.api", null);
        }
        if ((n & 2) != 0) {
            string2 = System.getProperty("fleet.metric.log", null);
        }
        if ((n & 4) != 0) {
            String string6 = System.getProperty("fleet.newrelic.exporter.uri", "https://trace-api.eu.newrelic.com/trace/v1");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"System.getProperty(EXPOR\u2026u.newrelic.com/trace/v1\")");
            string3 = string6;
        }
        if ((n & 8) != 0) {
            String string7 = System.getProperty("fleet.newrelic.exporter.metrics.uri", "https://metric-api.eu.newrelic.com/metric/v1");
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"System.getProperty(METRI\u2026.newrelic.com/metric/v1\")");
            string4 = string7;
        }
        if ((n & 0x10) != 0) {
            string5 = "FleetUnknownService";
        }
        FleetTelemetryKt.setupTelemetry(string, string2, string3, string4, string5);
    }

    public static final void shutdownTelemetry() {
        block0: {
            CompletableResultCode code = OpenTelemetrySdk.getGlobalTracerManagement().forceFlush();
            code.join(3000L, TimeUnit.MILLISECONDS);
            OpenTelemetrySdk.getGlobalTracerManagement().shutdown();
            IntervalMetricReader intervalMetricReader = FleetTelemetryKt.intervalMetricReader;
            if (intervalMetricReader == null) break block0;
            intervalMetricReader.shutdown();
        }
    }

    static {
        isTelemetrySet = StateFlowKt.MutableStateFlow((Object)0);
    }

    public static final /* synthetic */ MutableStateFlow access$isTelemetrySet$p() {
        return isTelemetrySet;
    }

    public static final /* synthetic */ void access$waitForTelemetrySetup() {
        FleetTelemetryKt.waitForTelemetrySetup();
    }
}

