/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logging;

import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggerFactory;
import fleet.util.logging.KLoggerStaticFactoryKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bj\u0002`\rH\u0016J\u0014\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0014\u0010\b\u001a\u00020\t2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lfleet/util/logging/KLoggerStaticFactory;", "Lfleet/util/logging/KLoggerFactory;", "()V", "customFactory", "getCustomFactory", "()Lfleet/util/logging/KLoggerFactory;", "setCustomFactory", "(Lfleet/util/logging/KLoggerFactory;)V", "logger", "Lfleet/util/logging/KLogger;", "nameSource", "Lkotlin/Function0;", "", "Lfleet/util/logging/LoggerNameSource;", "owner", "Ljava/lang/Class;", "", "name", "Lkotlin/reflect/KClass;", "fleet.util"})
public final class KLoggerStaticFactory
implements KLoggerFactory {
    @Nullable
    private static KLoggerFactory customFactory;
    @NotNull
    public static final KLoggerStaticFactory INSTANCE;

    @Nullable
    public final KLoggerFactory getCustomFactory() {
        return customFactory;
    }

    public final void setCustomFactory(@Nullable KLoggerFactory kLoggerFactory) {
        customFactory = kLoggerFactory;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = customFactory;
        if (object == null || (object = object.logger(name)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(name);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(JvmClassMappingKt.getKotlinClass(owner.getClass()));
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Class<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(owner);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull KClass<?> owner) {
        Intrinsics.checkNotNullParameter(owner, (String)"owner");
        Object object = customFactory;
        if (object == null || (object = object.logger(owner)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(owner);
        }
        return object;
    }

    @Override
    @NotNull
    public KLogger logger(@NotNull Function0<String> nameSource) {
        Intrinsics.checkNotNullParameter(nameSource, (String)"nameSource");
        Object object = customFactory;
        if (object == null || (object = object.logger(nameSource)) == null) {
            object = KLoggerStaticFactoryKt.access$defaultLogger(KLoggerStaticFactoryKt.loggerNameFromSource(nameSource));
        }
        return object;
    }

    private KLoggerStaticFactory() {
    }

    static {
        KLoggerStaticFactory kLoggerStaticFactory;
        INSTANCE = kLoggerStaticFactory = new KLoggerStaticFactory();
    }
}

