/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logging;

import fleet.util.UID;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.slf4j.MDCContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\fJ\u001c\u0010\u0011\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0004J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J?\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0013j\u0002`\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lfleet/util/logging/FleetMDC;", "", "()V", "BACKEND_UID", "", "FRONTEND_UID", "NETWORK_SENT", "ROLE", "WORKSPACE_UID", "forBackend", "Lkotlinx/coroutines/slf4j/MDCContext;", "backendId", "Lfleet/util/UID;", "forFrontend", "frontendId", "workspaceId", "forWorkspace", "mdcWith", "map", "", "role", "roleId", "roleMap", "withMDC", "T", "context", "Lkotlinx/coroutines/slf4j/MDCContextMap;", "f", "Lkotlin/Function0;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "fleet.util"})
public final class FleetMDC {
    @NotNull
    public static final String FRONTEND_UID = "frontendUID";
    @NotNull
    public static final String WORKSPACE_UID = "workspaceUID";
    @NotNull
    public static final String BACKEND_UID = "backendUID";
    @NotNull
    public static final String ROLE = "role";
    @NotNull
    public static final String NETWORK_SENT = "network";
    @NotNull
    public static final FleetMDC INSTANCE;

    @NotNull
    public final MDCContext role(@NotNull String roleId) {
        Intrinsics.checkNotNullParameter((Object)roleId, (String)"roleId");
        boolean bl = roleId.length() == 2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Rule must be two letters, e.g. \"WS\"";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.mdcWith(this.roleMap(roleId));
    }

    @NotNull
    public final MDCContext forWorkspace(@NotNull UID workspaceId) {
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        return this.mdcWith(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)WORKSPACE_UID, (Object)workspaceId.getId())), this.roleMap("WS")));
    }

    @NotNull
    public final MDCContext forBackend(@NotNull UID backendId) {
        Intrinsics.checkNotNullParameter((Object)backendId, (String)"backendId");
        return this.mdcWith(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)BACKEND_UID, (Object)backendId.getId())), this.roleMap("BK")));
    }

    @NotNull
    public final MDCContext forFrontend(@NotNull UID frontendId, @NotNull UID workspaceId) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        return this.mdcWith(MapsKt.plus(this.roleMap("FR"), (Map)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)WORKSPACE_UID, (Object)workspaceId.getId()), TuplesKt.to((Object)FRONTEND_UID, (Object)frontendId.getId())})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withMDC(@Nullable Map<String, String> context, @NotNull Function0<? extends T> f) {
        int $i$f$withMDC = 0;
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Map previous = MDC.getCopyOfContextMap();
        if (context == null) {
            MDC.clear();
        } else {
            MDC.setContextMap(context);
        }
        try {
            Object object = f.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            if (previous == null) {
                MDC.clear();
            } else {
                MDC.setContextMap((Map)previous);
            }
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final Map<String, String> roleMap(String roleId) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)ROLE, (Object)roleId));
    }

    private final MDCContext mdcWith(Map<String, String> map2) {
        Map map3 = new MDCContext(null, 1, null).getContextMap();
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        return new MDCContext(MapsKt.plus((Map)map3, map2));
    }

    private FleetMDC() {
    }

    static {
        FleetMDC fleetMDC;
        INSTANCE = fleetMDC = new FleetMDC();
    }
}

