/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import fleet.util.UID;
import fleet.util.logging.FleetDeferredAppender;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u001c\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lfleet/util/logging/FleetDeferredAppender;", "Lch/qos/logback/core/AppenderBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "workspaceAppenders", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lch/qos/logback/core/Appender;", "workspaceQueues", "Ljava/util/concurrent/BlockingQueue;", "append", "", "eventObject", "defineWorkspaceEndpoint", "workspaceId", "Lfleet/util/UID;", "appender", "undefineWorkspaceEndpoint", "fleet.util"})
public final class FleetDeferredAppender
extends AppenderBase<ILoggingEvent> {
    private final ConcurrentHashMap<String, Appender<ILoggingEvent>> workspaceAppenders = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, BlockingQueue<ILoggingEvent>> workspaceQueues = new ConcurrentHashMap();

    public final void defineWorkspaceEndpoint(@NotNull UID workspaceId, @NotNull Appender<ILoggingEvent> appender) {
        boolean bl;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        Intrinsics.checkNotNullParameter(appender, (String)"appender");
        BlockingQueue<ILoggingEvent> queue = this.workspaceQueues.get(workspaceId.getId());
        if (queue != null) {
            while (true) {
                collection = queue;
                bl = false;
                if (!(!collection.isEmpty())) break;
                appender.doAppend((Object)queue.take());
            }
        }
        ((Map)this.workspaceAppenders).put(workspaceId.getId(), appender);
        if (queue != null) {
            while (true) {
                collection = queue;
                bl = false;
                if (!(!collection.isEmpty())) break;
                appender.doAppend((Object)queue.take());
            }
        }
    }

    public final void undefineWorkspaceEndpoint(@NotNull UID workspaceId) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
            BlockingQueue<ILoggingEvent> blockingQueue = this.workspaceQueues.remove(workspaceId.getId());
            if (blockingQueue != null) {
                blockingQueue.clear();
            }
            Appender<ILoggingEvent> appender = this.workspaceAppenders.remove(workspaceId.getId());
            if (appender == null) break block1;
            appender.stop();
        }
    }

    protected void append(@NotNull ILoggingEvent eventObject) {
        Intrinsics.checkNotNullParameter((Object)eventObject, (String)"eventObject");
        Map map2 = eventObject.getMDCPropertyMap();
        String workspaceId = (String)map2.get("workspaceUID");
        if (workspaceId == null) {
            return;
        }
        Appender<ILoggingEvent> appender = this.workspaceAppenders.get(workspaceId);
        if (appender != null) {
            appender.doAppend((Object)eventObject);
        } else {
            this.workspaceQueues.computeIfAbsent(workspaceId, append.1.INSTANCE).offer(eventObject);
        }
    }
}

