/*
 * Decompiled with CFR 0.152.
 */
package fleet.util.diagnostics;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lfleet/util/diagnostics/RotatingFileWriter;", "", "dir", "Ljava/nio/file/Path;", "size", "", "(Ljava/nio/file/Path;I)V", "getDir", "()Ljava/nio/file/Path;", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "getQueue", "()Ljava/util/concurrent/ArrayBlockingQueue;", "getSize", "()I", "initQueue", "", "writeFile", "path", "content", "", "fleet.util"})
public final class RotatingFileWriter {
    @NotNull
    private final ArrayBlockingQueue<Path> queue;
    @NotNull
    private final Path dir;
    private final int size;

    @NotNull
    public final ArrayBlockingQueue<Path> getQueue() {
        return this.queue;
    }

    public final void writeFile(@NotNull Path path, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        boolean bl = path.startsWith(this.dir);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.queue.size() == this.size) {
            Path path2 = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"queue.take()");
            Path path3 = path2;
            bl2 = false;
            Files.deleteIfExists(path3);
        }
        PathsKt.writeText$default((Path)path, (CharSequence)content, null, (OpenOption[])new OpenOption[0], (int)2, null);
        this.queue.add(path);
    }

    private final void initQueue() {
        Path it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Path path = this.dir;
        Object[] objectArray = new LinkOption[]{};
        boolean bl = false;
        if (!Files.exists(path, Arrays.copyOf(objectArray, objectArray.length))) {
            path = this.dir;
            objectArray = new FileAttribute[]{};
            bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
            return;
        }
        path = this.dir;
        objectArray = new LinkOption[]{};
        bl = false;
        boolean bl2 = Files.isDirectory(path, (LinkOption[])Arrays.copyOf(objectArray, objectArray.length));
        boolean bl3 = false;
        bl = false;
        bl = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Iterable $this$sortedBy$iv = PathsKt.listDirectoryEntries$default((Path)this.dir, null, (int)1, null);
        boolean $i$f$sortedBy = false;
        bl4 = false;
        List entries = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Path it = (Path)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)PathsKt.getName((Path)it));
                it = (Path)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = PathsKt.getName((Path)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        if (entries.size() > this.size) {
            $this$forEach$iv = CollectionsKt.take((Iterable)entries, (int)(entries.size() - this.size));
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Path)element$iv;
                boolean bl6 = false;
                Path path2 = it;
                boolean bl7 = false;
                Files.deleteIfExists(path2);
            }
        }
        $this$forEach$iv = CollectionsKt.takeLast((List)entries, (int)this.size);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Path)element$iv;
            boolean bl8 = false;
            this.queue.add(it);
        }
    }

    @NotNull
    public final Path getDir() {
        return this.dir;
    }

    public final int getSize() {
        return this.size;
    }

    public RotatingFileWriter(@NotNull Path dir, int size) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.size = size;
        this.queue = new ArrayBlockingQueue(this.size);
        this.initQueue();
    }

    public /* synthetic */ RotatingFileWriter(Path path, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(path, n);
    }
}

