/*
 * Decompiled with CFR 0.152.
 */
package fleet.rpc;

import fleet.api.workspace.AssumptionsViolatedException;
import fleet.rpc.FailureInfo;
import fleet.rpc.RpcMessage;
import fleet.rpc.ValidationError;
import fleet.rpc.ValidationResult;
import fleet.rpc.client.StreamDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u000e\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0003*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0013"}, d2={"INTERNAL_SERVER_ERROR_MESSAGE", "", "internalFailure", "Lfleet/rpc/FailureInfo;", "getInternalFailure", "(Lfleet/rpc/FailureInfo;)Ljava/lang/String;", "rpcCallFailureMessage", "request", "Lfleet/rpc/RpcMessage$CallRequest;", "message", "rpcStreamFailureMessage", "stream", "Lfleet/rpc/client/StreamDescriptor;", "asString", "", "Lfleet/rpc/ValidationResult;", "messageQuick", "Lfleet/rpc/ValidationError;", "toFailureInfo", "fleet.protocol"})
public final class RpcFailureKt {
    @NotNull
    public static final String INTERNAL_SERVER_ERROR_MESSAGE = "Internal server error occurred. Please contact the server administrator or see server logs for details.";

    @NotNull
    public static final String asString(@NotNull Throwable $this$asString) {
        Intrinsics.checkNotNullParameter((Object)$this$asString, (String)"$this$asString");
        StringWriter stringWriter = new StringWriter();
        boolean bl = false;
        boolean bl2 = false;
        StringWriter $this$apply = stringWriter;
        boolean bl3 = false;
        $this$asString.printStackTrace(new PrintWriter($this$apply));
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringWriter().apply {\n \u2026ter(this))\n  }.toString()");
        return string;
    }

    @NotNull
    public static final FailureInfo toFailureInfo(@NotNull Throwable $this$toFailureInfo) {
        FailureInfo failureInfo;
        Intrinsics.checkNotNullParameter((Object)$this$toFailureInfo, (String)"$this$toFailureInfo");
        Throwable throwable = $this$toFailureInfo;
        if (throwable instanceof InvocationTargetException) {
            Throwable throwable2 = ((InvocationTargetException)$this$toFailureInfo).getTargetException();
            Intrinsics.checkNotNullExpressionValue((Object)throwable2, (String)"targetException");
            failureInfo = RpcFailureKt.toFailureInfo(throwable2);
        } else {
            failureInfo = throwable instanceof AssumptionsViolatedException ? new FailureInfo(null, null, null, null, null, "Conflict", null, 95, null) : new FailureInfo(null, null, null, RpcFailureKt.asString($this$toFailureInfo), null, null, null, 119, null);
        }
        return failureInfo;
    }

    @Nullable
    public static final String getInternalFailure(@NotNull FailureInfo $this$internalFailure) {
        Intrinsics.checkNotNullParameter((Object)$this$internalFailure, (String)"$this$internalFailure");
        return $this$internalFailure.getAuthenticationError() != null || $this$internalFailure.getValidationError() != null || $this$internalFailure.getSecurityError() != null || $this$internalFailure.getRequestError() != null || $this$internalFailure.getTransportError() != null || $this$internalFailure.getConflict() != null ? null : INTERNAL_SERVER_ERROR_MESSAGE;
    }

    @NotNull
    public static final String message(@NotNull FailureInfo $this$message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        if ($this$message.getAuthenticationError() != null) {
            string = $this$message.getAuthenticationError();
        } else if ($this$message.getSecurityError() != null) {
            string = $this$message.getSecurityError();
        } else if ($this$message.getValidationError() != null) {
            string = RpcFailureKt.message($this$message.getValidationError());
        } else if ($this$message.getRequestError() != null) {
            string = $this$message.getRequestError();
        } else if ($this$message.getTransportError() != null) {
            string = $this$message.getTransportError();
        } else if ($this$message.getConflict() != null) {
            string = $this$message.getConflict();
        } else if ($this$message.getServiceNotReady() != null) {
            string = $this$message.getServiceNotReady();
        } else {
            String string2 = RpcFailureKt.getInternalFailure($this$message);
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        return string;
    }

    @NotNull
    public static final String message(@NotNull ValidationResult $this$message) {
        Intrinsics.checkNotNullParameter((Object)$this$message, (String)"$this$message");
        Object object = (ValidationError)ArraysKt.firstOrNull((Object[])$this$message.getErrors());
        if (object == null || (object = RpcFailureKt.messageQuick((ValidationError)object)) == null) {
            object = "Validation error";
        }
        return object;
    }

    @NotNull
    public static final String messageQuick(@NotNull ValidationError $this$messageQuick) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$messageQuick, (String)"$this$messageQuick");
                string = $this$messageQuick.getParameter();
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = "Validation of parameter " + it + " failed: " + $this$messageQuick.getMessage();
                if (string != null) break block3;
            }
            string = $this$messageQuick.getMessage();
        }
        return string;
    }

    @NotNull
    public static final String rpcCallFailureMessage(@NotNull RpcMessage.CallRequest request, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return "Remote call <" + request.classMethodDisplayName() + "> has failed: " + message;
    }

    @NotNull
    public static final String rpcStreamFailureMessage(@NotNull StreamDescriptor stream, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return "Remote channel <" + stream.getDisplayName() + "> was closed with error: " + message;
    }
}

