/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import fleet.diff.FileTextKt;
import fleet.diff.LineEnding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lfleet/diff/LineTokenizer;", "", "text", "", "(Ljava/lang/CharSequence;)V", "atEnd", "", "getAtEnd", "()Z", "setAtEnd", "(Z)V", "length", "", "getLength", "()I", "setLength", "(I)V", "lineSeparator", "Lfleet/diff/LineEnding;", "getLineSeparator", "()Lfleet/diff/LineEnding;", "setLineSeparator", "(Lfleet/diff/LineEnding;)V", "offset", "getOffset", "setOffset", "getText", "()Ljava/lang/CharSequence;", "advance", "", "fleet.andel.common"})
public final class LineTokenizer {
    private int offset;
    private int length;
    @Nullable
    private LineEnding lineSeparator;
    private boolean atEnd;
    @NotNull
    private final CharSequence text;

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    @Nullable
    public final LineEnding getLineSeparator() {
        return this.lineSeparator;
    }

    public final void setLineSeparator(@Nullable LineEnding lineEnding) {
        this.lineSeparator = lineEnding;
    }

    public final boolean getAtEnd() {
        return this.atEnd;
    }

    public final void setAtEnd(boolean bl) {
        this.atEnd = bl;
    }

    public final void advance() {
        char c;
        int textLength;
        int i = this.offset + this.length + FileTextKt.getLength(this.lineSeparator);
        if (i >= (textLength = this.text.length())) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.text.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.offset += this.length + FileTextKt.getLength(this.lineSeparator);
        this.length = i - this.offset;
        this.lineSeparator = i < textLength && this.text.charAt(i) == '\r' ? (i < textLength - 1 && this.text.charAt(i + 1) == '\n' ? LineEnding.CRLF : LineEnding.CR) : (i < textLength && this.text.charAt(i) == '\n' ? LineEnding.LF : null);
    }

    @NotNull
    public final CharSequence getText() {
        return this.text;
    }

    public LineTokenizer(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.offset = 0;
        this.advance();
    }
}

