/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff;

import andel.text.TextRange;
import fleet.diff.CodeLine;
import fleet.diff.DiffChange;
import fleet.diff.DiffType;
import fleet.diff.FileContent;
import fleet.diff.FileDiffBuilder;
import fleet.diff.FileDiffBuilderKt;
import fleet.diff.GitDiffSize;
import fleet.diff.InlineDiff;
import fleet.diff.InlineDiffLine;
import fleet.diff.SideBySideDiff;
import fleet.diff.SideBySideDiffFragment;
import fleet.diff.SideBySideDiffFragmentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a5\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00050\tH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a\n\u0010\u0013\u001a\u00020\u000e*\u00020\u0014\u001a\u0012\u0010\u0015\u001a\u00020\f*\u00020\f2\u0006\u0010\u0016\u001a\u00020\f\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0018\u001a\u00020\f\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000e\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0010\u001a\u001c\u0010\u001a\u001a\u00020\u000e*\f\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u000e\u001a\u001c\u0010\u001f\u001a\u00020\u000e*\f\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u000e\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\f2\u0006\u0010\u0018\u001a\u00020\f\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0014\u001a\n\u0010!\u001a\u00020\u0001*\u00020\f\u001a\u0012\u0010\"\u001a\u00020\u000e*\u00020#2\u0006\u0010$\u001a\u00020\u000e\u001a\u001e\u0010%\u001a\f\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002`\u001d*\f\u0012\u0004\u0012\u00020\u001c0\u001bj\u0002`\u001d\u001a \u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001b*\u00020(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000e\u001a\u0012\u0010+\u001a\u00020\f*\u00020\f2\u0006\u0010,\u001a\u00020\u000e\u001a\u0012\u0010-\u001a\u00020\f*\u00020\f2\u0006\u0010,\u001a\u00020\u000e\u001a\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0\u001b*\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\f00\u001a\n\u00101\u001a\u00020\u0012*\u00020\f\u001a\n\u00102\u001a\u00020\f*\u00020\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003*\n\u00103\"\u0002042\u000204*\u0016\u00105\"\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00066"}, d2={"isEmpty", "", "Lfleet/diff/GitDiffSize;", "(Lfleet/diff/GitDiffSize;)Z", "ifTrue", "T", "", "condition", "exec", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "rangeOf", "Landel/text/TextRange;", "start", "", "length", "", "r", "Lkotlin/ranges/IntRange;", "calcMaxLineNumber", "Lfleet/diff/InlineDiff;", "coerce", "limits", "contains", "other", "offset", "findDiffFragmentByRightLine", "", "Lfleet/diff/SideBySideDiffFragment;", "Lfleet/diff/SideBySideDiffFragments;", "lineNumber", "findExactDiffFragmentByRightLine", "intersectsStrict", "isNotEmpty", "lineOffset", "Lfleet/diff/FileContent;", "index", "mergeSuccessiveFragments", "queryRight", "Lfleet/diff/DiffChange;", "Lfleet/diff/SideBySideDiff;", "fromLine", "toLine", "shift", "delta", "shrinkEach", "subtractAll", "ranges", "", "toRange", "toTextRange", "InlineDiffLineType", "Lfleet/diff/DiffType;", "SideBySideDiffFragments", "fleet.andel.common"})
public final class FileDiffBuilderKt {
    public static final boolean isEmpty(@NotNull GitDiffSize $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"$this$isEmpty");
        return $this$isEmpty.getAdded() == 0 && $this$isEmpty.getDeleted() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEmpty(@NotNull InlineDiff $this$isEmpty) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"$this$isEmpty");
        Iterable $this$all$iv = $this$isEmpty.getLines();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            InlineDiffLine it = (InlineDiffLine)element$iv;
            boolean bl2 = false;
            List<TextRange> list = it.getInserts();
            if (!(list != null ? list.isEmpty() : true)) return false;
            List<TextRange> list2 = it.getDeletes();
            if (!(list2 != null ? list2.isEmpty() : true)) return false;
            if (it.getType() != null) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final int calcMaxLineNumber(@NotNull InlineDiff $this$calcMaxLineNumber) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$calcMaxLineNumber, (String)"$this$calcMaxLineNumber");
        Iterable $this$flatMap$iv = $this$calcMaxLineNumber.getLines();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            InlineDiffLine it = (InlineDiffLine)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new Integer[]{it.getOldLineNum(), it.getNewLineNum()});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        return n != null ? n : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SideBySideDiffFragment> mergeSuccessiveFragments(@NotNull List<SideBySideDiffFragment> $this$mergeSuccessiveFragments) {
        Intrinsics.checkNotNullParameter($this$mergeSuccessiveFragments, (String)"$this$mergeSuccessiveFragments");
        mergeSuccessiveFragments.1 $fun$merge$1 = mergeSuccessiveFragments.1.INSTANCE;
        if ($this$mergeSuccessiveFragments.isEmpty()) {
            return $this$mergeSuccessiveFragments;
        }
        List result2 = CollectionsKt.mutableListOf((Object[])new SideBySideDiffFragment[]{(SideBySideDiffFragment)CollectionsKt.first($this$mergeSuccessiveFragments)});
        int n = 1;
        int n2 = $this$mergeSuccessiveFragments.size();
        while (n < n2) {
            void i;
            SideBySideDiffFragment last = (SideBySideDiffFragment)CollectionsKt.last((List)result2);
            if (last.getType() == SideBySideDiffFragmentType.MODIFIED && $this$mergeSuccessiveFragments.get((int)i).getType() == SideBySideDiffFragmentType.MODIFIED && last.getLeftStartLine() + last.getLeftLineCount() == $this$mergeSuccessiveFragments.get((int)i).getLeftStartLine() && last.getRightStartLine() + last.getRightLineCount() == $this$mergeSuccessiveFragments.get((int)i).getRightStartLine()) {
                result2.set(result2.size() - 1, $fun$merge$1.invoke(last, $this$mergeSuccessiveFragments.get((int)i)));
            } else {
                result2.add($this$mergeSuccessiveFragments.get((int)i));
            }
            ++i;
        }
        return result2;
    }

    private static final TextRange rangeOf(long start2, long length) {
        return new TextRange(start2, start2 + length);
    }

    @NotNull
    public static final TextRange rangeOf(int start2, int length) {
        boolean bl = start2 >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = length >= 0;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new TextRange(start2, start2 + length);
    }

    @NotNull
    public static final TextRange rangeOf(@NotNull IntRange r2) {
        Intrinsics.checkNotNullParameter((Object)r2, (String)"r");
        return new TextRange(r2.getFirst(), r2.getLast());
    }

    @NotNull
    public static final TextRange toTextRange(@NotNull IntRange $this$toTextRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextRange, (String)"$this$toTextRange");
        return FileDiffBuilderKt.rangeOf($this$toTextRange);
    }

    @NotNull
    public static final IntRange toRange(@NotNull TextRange $this$toRange) {
        Intrinsics.checkNotNullParameter((Object)$this$toRange, (String)"$this$toRange");
        return new IntRange((int)$this$toRange.getStart(), (int)$this$toRange.getEnd());
    }

    public static final boolean intersectsStrict(@NotNull TextRange $this$intersectsStrict, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$intersectsStrict, (String)"$this$intersectsStrict");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        long l = $this$intersectsStrict.getStart();
        long l2 = other.getStart();
        boolean bl = false;
        long l3 = Math.max(l, l2);
        l = $this$intersectsStrict.getEnd();
        l2 = other.getEnd();
        bl = false;
        return l3 < Math.min(l, l2);
    }

    @NotNull
    public static final TextRange shift(@NotNull TextRange $this$shift, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shift, (String)"$this$shift");
        return new TextRange($this$shift.getStart() + (long)delta, $this$shift.getEnd() + (long)delta);
    }

    @NotNull
    public static final TextRange shrinkEach(@NotNull TextRange $this$shrinkEach, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shrinkEach, (String)"$this$shrinkEach");
        return new TextRange($this$shrinkEach.getStart() + (long)delta, $this$shrinkEach.getEnd() - (long)delta);
    }

    @NotNull
    public static final TextRange coerce(@NotNull TextRange $this$coerce, @NotNull TextRange limits) {
        Intrinsics.checkNotNullParameter((Object)$this$coerce, (String)"$this$coerce");
        Intrinsics.checkNotNullParameter((Object)limits, (String)"limits");
        long l = $this$coerce.getStart();
        long l2 = limits.getStart();
        boolean bl = false;
        long l3 = Math.max(l, l2);
        l = $this$coerce.getEnd();
        l2 = limits.getEnd();
        bl = false;
        return new TextRange(l3, Math.min(l, l2));
    }

    public static final boolean contains(@NotNull TextRange $this$contains, @NotNull TextRange other) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$contains.getStart() <= other.getStart() && $this$contains.getEnd() >= other.getEnd();
    }

    public static final boolean contains(@NotNull TextRange $this$contains, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        long l = offset;
        return $this$contains.getStart() <= l && $this$contains.getEnd() > l;
    }

    public static final boolean contains(@NotNull TextRange $this$contains, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        long l = offset;
        return $this$contains.getStart() <= l && $this$contains.getEnd() > l;
    }

    public static final boolean isEmpty(@NotNull TextRange $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"$this$isEmpty");
        return $this$isEmpty.getLength() <= 0L;
    }

    public static final boolean isNotEmpty(@NotNull TextRange $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"$this$isNotEmpty");
        return $this$isNotEmpty.getLength() > 0L;
    }

    @NotNull
    public static final List<TextRange> subtractAll(@NotNull TextRange $this$subtractAll, @NotNull Collection<TextRange> ranges) {
        Intrinsics.checkNotNullParameter((Object)$this$subtractAll, (String)"$this$subtractAll");
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        ArrayList result2 = new ArrayList();
        Function2<Integer, Integer, Unit> $fun$tryAddToResult$1 = new Function2<Integer, Integer, Unit>(result2){
            final /* synthetic */ ArrayList $result;

            public final void invoke(int start2, int end) {
                if (start2 < end) {
                    this.$result.add(new TextRange(start2, end));
                }
            }
            {
                this.$result = arrayList;
                super(2);
            }
        };
        int pos = (int)$this$subtractAll.getStart();
        Iterable $this$sortedBy$iv = ranges;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        for (TextRange range : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                TextRange it = (TextRange)a;
                boolean bl2 = false;
                Comparable comparable = Long.valueOf(it.getStart());
                it = (TextRange)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Long l = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        })) {
            int n = (int)range.getStart();
            int n2 = (int)$this$subtractAll.getEnd();
            bl = false;
            $fun$tryAddToResult$1.invoke(pos, Math.min(n, n2));
            n = (int)range.getEnd();
            n2 = 0;
            pos = Math.max(n, pos);
        }
        $fun$tryAddToResult$1.invoke(pos, (int)$this$subtractAll.getEnd());
        return result2;
    }

    @Nullable
    public static final <T> T ifTrue(boolean condition, @NotNull Function0<? extends T> exec) {
        int $i$f$ifTrue = 0;
        Intrinsics.checkNotNullParameter(exec, (String)"exec");
        return (T)(condition ? exec.invoke() : null);
    }

    public static final int lineOffset(@NotNull FileContent $this$lineOffset, int index) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$lineOffset, (String)"$this$lineOffset");
        int n2 = index;
        int n3 = n2;
        if (0 <= n3 && ((Collection)$this$lineOffset.getLines()).size() > n3) {
            n = $this$lineOffset.getLines().get(index).getOffset();
        } else if (n2 == $this$lineOffset.getLines().size()) {
            n = ((CodeLine)CollectionsKt.last($this$lineOffset.getLines())).getOffset() + ((CodeLine)CollectionsKt.last($this$lineOffset.getLines())).getText().length();
        } else {
            String string = "invalid line index: " + index;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<DiffChange> queryRight(@NotNull SideBySideDiff $this$queryRight, int fromLine, int toLine) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable $this$takeWhile$iv;
        Intrinsics.checkNotNullParameter((Object)$this$queryRight, (String)"$this$queryRight");
        int startIndex = FileDiffBuilderKt.findDiffFragmentByRightLine($this$queryRight.getFragments(), fromLine);
        boolean bl = false;
        ArrayList<DiffChange> result2 = new ArrayList<DiffChange>();
        Iterable iterable = $this$queryRight.getFragments().subList(startIndex, $this$queryRight.getFragments().size());
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            SideBySideDiffFragment fragment = (SideBySideDiffFragment)item$iv;
            boolean bl2 = false;
            if (!(fragment.getRightStartLine() <= toLine)) break;
            list$iv.add(item$iv);
        }
        $this$takeWhile$iv = list$iv;
        boolean $i$f$flatMap = false;
        list$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        int $i$f$flatMapTo = 0;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            SideBySideDiffFragment fragment = (SideBySideDiffFragment)element$iv$iv;
            boolean bl3 = false;
            int leftStart = FileDiffBuilderKt.lineOffset($this$queryRight.getLeft(), fragment.getLeftStartLine());
            int rightStart = FileDiffBuilderKt.lineOffset($this$queryRight.getRight(), fragment.getRightStartLine());
            List<FileDiffBuilder.InlineDiffFragment> list2 = fragment.getWordDiff();
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FileDiffBuilder.InlineDiffFragment inlineDiffFragment = (FileDiffBuilder.InlineDiffFragment)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    Pair pair = TuplesKt.to((Object)FileDiffBuilderKt.shift(it.getOldRange(), leftStart), (Object)FileDiffBuilderKt.shift(it.getNewRange(), rightStart));
                    collection.add(pair);
                }
                list = (List)destination$iv$iv2;
            } else {
                SideBySideDiff sideBySideDiff = $this$queryRight;
                boolean bl5 = false;
                boolean bl6 = false;
                SideBySideDiff $this$run = sideBySideDiff;
                boolean bl7 = false;
                list = CollectionsKt.listOf((Object)TuplesKt.to((Object)new TextRange(leftStart, FileDiffBuilderKt.lineOffset($this$run.getLeft(), fragment.getLeftStartLine() + fragment.getLeftLineCount())), (Object)new TextRange(rightStart, FileDiffBuilderKt.lineOffset($this$run.getRight(), fragment.getRightStartLine() + fragment.getRightLineCount()))));
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List changes = (List)destination$iv$iv;
        long currentDeletionStart = -1L;
        long currentInsertionStart = -1L;
        $i$f$flatMapTo = 0;
        int n = ((Collection)changes).size();
        while ($i$f$flatMapTo < n) {
            void changeIndex;
            if (currentDeletionStart == -1L) {
                currentDeletionStart = ((TextRange)((Pair)changes.get((int)changeIndex)).getFirst()).getStart();
                currentInsertionStart = ((TextRange)((Pair)changes.get((int)changeIndex)).getSecond()).getStart();
            }
            if (changeIndex >= changes.size() - 1 || ((TextRange)((Pair)changes.get((int)changeIndex)).getFirst()).getEnd() != ((TextRange)((Pair)changes.get((int)(changeIndex + true))).getFirst()).getStart() || ((TextRange)((Pair)changes.get((int)changeIndex)).getSecond()).getEnd() != ((TextRange)((Pair)changes.get((int)(changeIndex + true))).getSecond()).getStart()) {
                TextRange leftRange = new TextRange(currentDeletionStart, ((TextRange)((Pair)changes.get((int)changeIndex)).getFirst()).getEnd());
                TextRange rightRange = new TextRange(currentInsertionStart, ((TextRange)((Pair)changes.get((int)changeIndex)).getSecond()).getEnd());
                DiffType type = FileDiffBuilderKt.isEmpty(leftRange) ? DiffType.ADDED : (FileDiffBuilderKt.isEmpty(rightRange) ? DiffType.DELETED : DiffType.MODIFIED);
                result2.add(new DiffChange(leftRange, rightRange, type, false, 8, null));
                currentInsertionStart = -1L;
                currentDeletionStart = -1L;
            }
            ++changeIndex;
        }
        return result2;
    }

    public static final int findExactDiffFragmentByRightLine(@NotNull List<SideBySideDiffFragment> $this$findExactDiffFragmentByRightLine, int lineNumber) {
        Intrinsics.checkNotNullParameter($this$findExactDiffFragmentByRightLine, (String)"$this$findExactDiffFragmentByRightLine");
        return CollectionsKt.binarySearch$default($this$findExactDiffFragmentByRightLine, (int)0, (int)0, (Function1)((Function1)new Function1<SideBySideDiffFragment, Integer>(lineNumber){
            final /* synthetic */ int $lineNumber;

            public final int invoke(@NotNull SideBySideDiffFragment it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$lineNumber == it.getRightStartLine() || this.$lineNumber >= it.getRightStartLine() && this.$lineNumber < it.getRightStartLine() + it.getRightLineCount() ? 0 : (this.$lineNumber < it.getRightStartLine() ? 1 : -1);
            }
            {
                this.$lineNumber = n;
                super(1);
            }
        }), (int)3, null);
    }

    public static final int findDiffFragmentByRightLine(@NotNull List<SideBySideDiffFragment> $this$findDiffFragmentByRightLine, int lineNumber) {
        Intrinsics.checkNotNullParameter($this$findDiffFragmentByRightLine, (String)"$this$findDiffFragmentByRightLine");
        int binarySearch = FileDiffBuilderKt.findExactDiffFragmentByRightLine($this$findDiffFragmentByRightLine, lineNumber);
        return binarySearch >= 0 ? binarySearch : -binarySearch - 1;
    }

    public static final /* synthetic */ TextRange access$rangeOf(long start2, long length) {
        return FileDiffBuilderKt.rangeOf(start2, length);
    }
}

