/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebuggerFieldPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OnceUsedChecker;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0019J\u0018\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010 \u001a\u00020%H\u0002J\u0012\u0010,\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u000204H\u0002J$\u00105\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*2\u0006\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010(H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010\u00192\u0006\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010\u00192\u0006\u0010.\u001a\u00020\u00182\u0006\u0010 \u001a\u00020>H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020@H\u0002J\u0015\u0010A\u001a\u00020$*\u00020%2\u0006\u0010B\u001a\u00020%H\u0082\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "evaluationStatus", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;)V", "containingPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getContainingPrimaryConstructor", "()Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "containingPrimaryConstructor$delegate", "Lkotlin/Lazy;", "crossingBounds", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "onceUsedChecker", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/OnceUsedChecker;", "parameters", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "Lkotlin/collections/LinkedHashMap;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "checkBounds", "", "descriptor", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parameter", "doesCrossInlineBounds", "", "Lcom/intellij/psi/PsiElement;", "declaration", "getLabel", "", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isAssignmentLValue", "isCodeFragmentDeclaration", "isContainingPrimaryConstructorParameter", "target", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isFakeFunctionForJavaContext", "processCoroutineContextCall", "processDebugLabel", "processDispatchReceiver", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "processExtensionReceiver", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "label", "processFakeJavaCodeReceiver", "processReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processSyntheticFieldVariable", "Lorg/jetbrains/kotlin/descriptors/impl/SyntheticFieldDescriptor;", "isInside", "parent", "kotlin.jvm-debugger.evaluation"})
public final class CodeFragmentParameterAnalyzer {
    private final LinkedHashMap<DeclarationDescriptor, CodeFragmentParameter.Smart> parameters;
    private final Set<CodeFragmentParameter.Dumb> crossingBounds;
    private final OnceUsedChecker onceUsedChecker;
    private final Lazy containingPrimaryConstructor$delegate;
    private final ExecutionContext context;
    private final KtCodeFragment codeFragment;
    private final BindingContext bindingContext;
    private final EvaluationStatus evaluationStatus;

    private final ConstructorDescriptor getContainingPrimaryConstructor() {
        Lazy lazy = this.containingPrimaryConstructor$delegate;
        CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConstructorDescriptor)lazy.getValue();
    }

    @NotNull
    public final CodeFragmentParameterInfo analyze() {
        this.onceUsedChecker.trigger();
        this.codeFragment.accept((KtVisitor)new KtTreeVisitor<Unit>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;

            @Nullable
            public Void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall == null) {
                    return null;
                }
                ResolvedCall resolvedCall2 = resolvedCall;
                this.processResolvedCall(resolvedCall2, expression);
                return null;
            }

            private final void processResolvedCall(ResolvedCall<?> resolvedCall, KtSimpleNameExpression expression) {
                DeclarationDescriptor descriptor;
                ReceiverValue dispatchReceiver;
                ReceiverParameterDescriptor extensionParameter;
                CallableDescriptor descriptor2;
                if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall(), expression);
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall(), expression);
                    return;
                }
                analyze.1 var3_3 = this;
                boolean bl = false;
                boolean bl2 = false;
                analyze.1 $this$run = var3_3;
                boolean bl3 = false;
                CallableDescriptor callableDescriptor = descriptor2 = resolvedCall.getResultingDescriptor();
                Object object = callableDescriptor != null ? callableDescriptor.getContainingDeclaration() : null;
                if (!(object instanceof ClassDescriptor)) {
                    object = null;
                }
                ClassDescriptor containingClass = (ClassDescriptor)object;
                CallableDescriptor callableDescriptor2 = descriptor2;
                Object object2 = extensionParameter = callableDescriptor2 != null ? callableDescriptor2.getExtensionReceiverParameter() : null;
                if (descriptor2 != null && !(descriptor2 instanceof DebuggerFieldPropertyDescriptor) && extensionParameter != null && containingClass != null && containingClass.getKind() != ClassKind.OBJECT) {
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, containingClass);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor2, (KtExpression)expression, parameter);
                }
                if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(expression){
                    final /* synthetic */ KtSimpleNameExpression $expression;

                    public final boolean invoke() {
                        return KtPsiUtilKt.isDotSelector((KtExpression)((KtExpression)this.$expression));
                    }
                    {
                        this.$expression = ktSimpleNameExpression;
                        super(0);
                    }
                }))).booleanValue()) {
                    CallableDescriptor descriptor3 = resolvedCall.getResultingDescriptor();
                    CallableDescriptor callableDescriptor3 = resolvedCall.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor3, (String)"resolvedCall.resultingDescriptor");
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, (DeclarationDescriptor)callableDescriptor3);
                    if (parameter != null) {
                        this.this$0.checkBounds((DeclarationDescriptor)descriptor3, (KtExpression)expression, parameter);
                    }
                    return;
                }
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, (DeclarationDescriptor)resolvedCall.getResultingDescriptor())) {
                    return;
                }
                boolean processed = false;
                ReceiverValue extensionReceiver = resolvedCall.getExtensionReceiver();
                if (extensionReceiver instanceof ImplicitReceiver) {
                    DeclarationDescriptor descriptor4 = ((ImplicitReceiver)extensionReceiver).getDeclarationDescriptor();
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)extensionReceiver);
                    this.this$0.checkBounds(descriptor4, (KtExpression)expression, parameter);
                    processed = true;
                }
                if ((dispatchReceiver = resolvedCall.getDispatchReceiver()) instanceof ImplicitReceiver) {
                    descriptor = ((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor();
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)dispatchReceiver);
                    if (parameter != null) {
                        this.this$0.checkBounds(descriptor, (KtExpression)expression, parameter);
                        processed = true;
                    }
                }
                if (!processed && resolvedCall.getResultingDescriptor() instanceof SyntheticFieldDescriptor) {
                    CallableDescriptor callableDescriptor4 = resolvedCall.getResultingDescriptor();
                    if (callableDescriptor4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor");
                    }
                    descriptor = (SyntheticFieldDescriptor)callableDescriptor4;
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processSyntheticFieldVariable(this.this$0, (SyntheticFieldDescriptor)descriptor);
                    if (parameter != null) {
                        this.this$0.checkBounds(descriptor, (KtExpression)expression, parameter);
                        processed = true;
                    }
                }
                if (!processed) {
                    DeclarationDescriptor declarationDescriptor = descriptor = resolvedCall.getResultingDescriptor();
                    Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor");
                    CodeFragmentParameter.Smart parameter = this.processDescriptor(declarationDescriptor, expression);
                    this.this$0.checkBounds(descriptor, (KtExpression)expression, parameter);
                }
            }

            private final CodeFragmentParameter.Smart processDescriptor(DeclarationDescriptor descriptor, KtSimpleNameExpression expression) {
                CodeFragmentParameter.Smart smart;
                CodeFragmentParameter.Smart smart2 = CodeFragmentParameterAnalyzer.access$processDebugLabel(this.this$0, descriptor);
                if (smart2 == null) {
                    smart2 = smart = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, descriptor);
                }
                if (smart2 == null) {
                    smart = CodeFragmentParameterAnalyzer.access$processSimpleNameExpression(this.this$0, descriptor, expression);
                }
                return smart;
            }

            @Nullable
            public Void visitThisExpression(@NotNull KtThisExpression expression, @Nullable Unit data) {
                CodeFragmentParameter.Smart parameter;
                CodeFragmentParameter.Smart smart;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtReferenceExpression>(expression){
                    final /* synthetic */ KtThisExpression $expression;

                    @NotNull
                    public final KtReferenceExpression invoke() {
                        return this.$expression.getInstanceReference();
                    }
                    {
                        this.$expression = ktThisExpression;
                        super(0);
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { expression.instanceReference }");
                KtReferenceExpression instanceReference2 = (KtReferenceExpression)object;
                DeclarationDescriptor target = (DeclarationDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)instanceReference2);
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, target)) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = target;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    smart = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, (ClassDescriptor)target);
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    KotlinType type2;
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression);
                    KotlinType kotlinType = type2 = kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
                    if (kotlinType != null) {
                        KotlinType kotlinType2 = kotlinType;
                        boolean bl = false;
                        boolean bl2 = false;
                        KotlinType it = kotlinType2;
                        boolean bl3 = false;
                        smart = CodeFragmentParameterAnalyzer.access$processExtensionReceiver(this.this$0, (CallableDescriptor)target, type2, expression.getLabelName());
                    } else {
                        smart = null;
                    }
                } else {
                    smart = parameter = null;
                }
                if (parameter != null) {
                    this.this$0.checkBounds(target, (KtExpression)expression, parameter);
                }
                return null;
            }

            @Nullable
            public Void visitSuperExpression(@NotNull KtSuperExpression expression, @Nullable Unit data) {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    KotlinType kotlinType = (KotlinType)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, (Object)expression);
                    if (kotlinType == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"bindingContext[BindingCo\u2026xpression] ?: return null");
                    KotlinType type2 = kotlinType;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
                    if (classDescriptor == null) {
                        return null;
                    }
                    ClassDescriptor descriptor = classDescriptor;
                    Map $this$getOrPut$iv = CodeFragmentParameterAnalyzer.access$getParameters$p(this.this$0);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(descriptor);
                    if (value$iv != null) break block3;
                    boolean bl = false;
                    String string = descriptor.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"descriptor.name.asString()");
                    String name = string;
                    CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "super@" + name), type2, (DeclarationDescriptor)descriptor, false, 8, null);
                    $this$getOrPut$iv.put(descriptor, answer$iv);
                }
                return null;
            }

            @Nullable
            public Void visitCallExpression(@NotNull KtCallExpression expression, @Nullable Unit data) {
                CallableDescriptor descriptor;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall != null && (descriptor = resolvedCall.getResultingDescriptor()) instanceof ConstructorDescriptor && KotlinBuiltIns.isNothing((KotlinType)((ConstructorDescriptor)descriptor).getReturnType())) {
                    EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.nothing.initialization", new Object[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026                        )");
                    throw (Throwable)evaluateException;
                }
                return (Void)super.visitCallExpression(expression, (Object)data);
            }
            {
                this.this$0 = this$0;
            }
        }, (Object)Unit.INSTANCE);
        Collection<CodeFragmentParameter.Smart> collection = this.parameters.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"parameters.values");
        return new CodeFragmentParameterInfo(CollectionsKt.toList((Iterable)collection), this.crossingBounds);
    }

    private final CodeFragmentParameter.Smart processReceiver(ImplicitReceiver receiver) {
        CodeFragmentParameter.Smart smart;
        if (this.isCodeFragmentDeclaration(receiver.getDeclarationDescriptor())) {
            return null;
        }
        ImplicitReceiver implicitReceiver = receiver;
        if (implicitReceiver instanceof ImplicitClassReceiver) {
            smart = this.processDispatchReceiver(((ImplicitClassReceiver)receiver).getClassDescriptor());
        } else if (implicitReceiver instanceof ExtensionReceiver) {
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"receiver.declarationDescriptor");
            KotlinType kotlinType = ((ExtensionReceiver)receiver).getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiver.type");
            smart = this.processExtensionReceiver(callableDescriptor, kotlinType, null);
        } else {
            smart = null;
        }
        return smart;
    }

    private final CodeFragmentParameter.Smart processDispatchReceiver(ClassDescriptor descriptor) {
        Object object;
        if (descriptor.getKind() == ClassKind.OBJECT || this.getContainingPrimaryConstructor() != null) {
            return null;
        }
        SimpleType simpleType = descriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"descriptor.defaultType");
        SimpleType type2 = simpleType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl = false;
            Name name = descriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"descriptor.name");
            Name name2 = name;
            String debugLabel = name2.isSpecial() ? "" : "@" + name2.asString();
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "this" + debugLabel), (KotlinType)type2, (DeclarationDescriptor)descriptor, false, 8, null);
            $this$getOrPut$iv.put(descriptor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processExtensionReceiver(CallableDescriptor descriptor, KotlinType receiverType, String label) {
        Object object;
        if (this.isFakeFunctionForJavaContext(descriptor)) {
            return this.processFakeJavaCodeReceiver(descriptor);
        }
        String string = label;
        if (string == null) {
            string = this.getLabel(descriptor);
        }
        if (string == null) {
            return null;
        }
        String actualLabel = string;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"descriptor.extensionRece\u2026rParameter ?: return null");
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, actualLabel, "this@" + actualLabel), receiverType, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final String getLabel(CallableDescriptor callableDescriptor) {
        SourceElement sourceElement = callableDescriptor.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"callableDescriptor.source");
        PsiElement source = KotlinSourceElementKt.getPsi((SourceElement)sourceElement);
        if (source instanceof KtFunctionLiteral) {
            String string = CodegenUtilKt.getCallLabelForLambdaArgument((KtFunctionLiteral)((KtFunctionLiteral)source), (BindingContext)this.bindingContext);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        Name name = callableDescriptor.getName();
        boolean bl = false;
        boolean bl4 = false;
        Name it = name;
        boolean bl5 = false;
        Name name2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"it");
        Object object = !name2.isSpecial() ? name : null;
        return object != null ? object.asString() : null;
    }

    private final boolean isFakeFunctionForJavaContext(CallableDescriptor descriptor) {
        return descriptor instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor).getName().asString(), (Object)"_java_locals_debug_fun_") && this.codeFragment.getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null;
    }

    private final CodeFragmentParameter.Smart processFakeJavaCodeReceiver(CallableDescriptor descriptor) {
        Object object;
        CallableDescriptor callableDescriptor = descriptor;
        boolean bl = false;
        boolean bl2 = false;
        CallableDescriptor it = callableDescriptor;
        boolean bl3 = false;
        Object object2 = descriptor instanceof FunctionDescriptor ? callableDescriptor : null;
        if (object2 == null || (object2 = object2.getExtensionReceiverParameter()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"descriptor\n            .\u2026           ?: return null");
        CallableDescriptor receiverParameter = object2;
        String label = "_java_locals_debug_fun_";
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"receiverParameter.type");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl4 = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, label, "this"), type2, (DeclarationDescriptor)receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSyntheticFieldVariable(SyntheticFieldDescriptor descriptor) {
        Object object;
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor();
        String string = propertyDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertyDescriptor.name.asString()");
        String fieldName = string;
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"propertyDescriptor.type");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, fieldName, "field"), type2, (DeclarationDescriptor)descriptor, false, 8, null);
            $this$getOrPut$iv.put(descriptor, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSimpleNameExpression(DeclarationDescriptor target, KtSimpleNameExpression expression) {
        CodeFragmentParameter.Smart smart;
        boolean isPrimaryConstructorParameter;
        if (target instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)target).isCrossinline()) {
            this.evaluationStatus.error(EvaluationError.CrossInlineLambda);
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.crossinline.lambda.evaluation", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026valuation\")\n            )");
            throw (Throwable)evaluateException;
        }
        DeclarationDescriptor declarationDescriptor = target;
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithVisibility)) {
            declarationDescriptor = null;
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)declarationDescriptor;
        boolean isLocalTarget = Intrinsics.areEqual((Object)(declarationDescriptorWithVisibility != null ? declarationDescriptorWithVisibility.getVisibility() : null), (Object)DescriptorVisibilities.LOCAL);
        boolean bl = isPrimaryConstructorParameter = !isLocalTarget && target instanceof PropertyDescriptor && this.isContainingPrimaryConstructorParameter((PropertyDescriptor)target);
        if (!isLocalTarget && !isPrimaryConstructorParameter) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor2 = target;
        if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
            Object object;
            KotlinType kotlinType = FunctionsTypingVisitorKt.createFunctionType$default((SimpleFunctionDescriptor)((SimpleFunctionDescriptor)target), (KotlinBuiltIns)DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)target), (boolean)((SimpleFunctionDescriptor)target).isSuspend(), (boolean)false, (int)4, null);
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl2 = false;
                String string = ((SimpleFunctionDescriptor)target).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name.asString()");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.LOCAL_FUNCTION, string, null, 4, null);
                SimpleFunctionDescriptor simpleFunctionDescriptor = ((SimpleFunctionDescriptor)target).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"target.original");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, type2, (DeclarationDescriptor)simpleFunctionDescriptor, false, 8, null);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else if (declarationDescriptor2 instanceof ValueDescriptor) {
            Object object;
            boolean bl3;
            KtExpression unwrappedExpression;
            KtExpression ktExpression = unwrappedExpression = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression));
            if (ktExpression != null) {
                KtExpression $i$f$getOrPut = ktExpression;
                boolean value$iv = false;
                boolean bl2 = false;
                KtExpression it = $i$f$getOrPut;
                boolean bl4 = false;
                bl3 = this.isAssignmentLValue((PsiElement)it);
            } else {
                bl3 = false;
            }
            boolean isLValue = bl3;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl5 = false;
                CodeFragmentParameter.Kind kind = target instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)target).isDelegated() ? CodeFragmentParameter.Kind.DELEGATED : CodeFragmentParameter.Kind.ORDINARY;
                String string = ((ValueDescriptor)target).getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"target.name.asString()");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(kind, string, null, 4, null);
                KotlinType kotlinType = ((ValueDescriptor)target).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"target.type");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, kotlinType, target, isLValue);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else {
            smart = null;
        }
        return smart;
    }

    private final boolean isAssignmentLValue(PsiElement expression) {
        Object object;
        block5: {
            block4: {
                PsiElement psiElement = expression.getParent();
                if (!(psiElement instanceof KtBinaryExpression)) {
                    psiElement = null;
                }
                if ((object = (KtBinaryExpression)psiElement) == null) break block4;
                KtBinaryExpression ktBinaryExpression = object;
                boolean bl = false;
                boolean bl2 = false;
                KtBinaryExpression it = ktBinaryExpression;
                boolean bl3 = false;
                object = KtPsiUtil.isAssignment((PsiElement)((PsiElement)it)) ? ktBinaryExpression : null;
                if (object != null) break block5;
            }
            return false;
        }
        KtBinaryExpression assignmentExpression = object;
        return Intrinsics.areEqual((Object)assignmentExpression.getLeft(), (Object)expression);
    }

    private final boolean isContainingPrimaryConstructorParameter(PropertyDescriptor target) {
        ConstructorDescriptor constructorDescriptor = this.getContainingPrimaryConstructor();
        if (constructorDescriptor == null) {
            return false;
        }
        ConstructorDescriptor primaryConstructor = constructorDescriptor;
        for (ValueParameterDescriptor parameter : primaryConstructor.getValueParameters()) {
            PropertyDescriptor property = (PropertyDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.VALUE_PARAMETER_AS_PROPERTY, (Object)parameter);
            if (!Intrinsics.areEqual((Object)target, (Object)property)) continue;
            return true;
        }
        return false;
    }

    private final CodeFragmentParameter.Smart processCoroutineContextCall(DeclarationDescriptor target) {
        if (target instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)target), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME())) {
            Object object;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl = false;
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null);
                KotlinType kotlinType = ((PropertyDescriptor)target).getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"target.type");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, kotlinType, target, false, 8, null);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (CodeFragmentParameter.Smart)object;
        }
        return null;
    }

    private final CodeFragmentParameter.Smart processDebugLabel(DeclarationDescriptor target) {
        Object object;
        DeclarationDescriptor declarationDescriptor = target;
        if (!(declarationDescriptor instanceof DebugLabelPropertyDescriptor)) {
            declarationDescriptor = null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor = (DebugLabelPropertyDescriptor)declarationDescriptor;
        if (debugLabelPropertyDescriptor == null) {
            return null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor2 = debugLabelPropertyDescriptor;
        String labelName = debugLabelPropertyDescriptor2.getLabelName();
        String string = debugLabelPropertyDescriptor2.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"debugLabelPropertyDescriptor.name.asString()");
        String debugString = string;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(target);
        if (value$iv == null) {
            boolean bl = false;
            KotlinType kotlinType = debugLabelPropertyDescriptor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"debugLabelPropertyDescriptor.type");
            KotlinType type2 = kotlinType;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DEBUG_LABEL, labelName, debugString), type2, (DeclarationDescriptor)debugLabelPropertyDescriptor2, false, 8, null);
            $this$getOrPut$iv.put(target, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    public final void checkBounds(@Nullable DeclarationDescriptor descriptor, @NotNull KtExpression expression, @Nullable CodeFragmentParameter.Smart parameter) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (parameter == null || !(descriptor instanceof DeclarationDescriptorWithSource)) {
            return;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        PsiElement targetPsi = KotlinSourceElementKt.getPsi((SourceElement)sourceElement);
        if (targetPsi != null && this.doesCrossInlineBounds((PsiElement)expression, targetPsi)) {
            Collection collection = this.crossingBounds;
            CodeFragmentParameter.Dumb dumb = parameter.getDumb();
            boolean bl = false;
            collection.add(dumb);
        }
    }

    private final boolean doesCrossInlineBounds(PsiElement expression, PsiElement declaration) {
        PsiElement psiElement;
        Object object;
        PsiElement declarationParent;
        block7: {
            block6: {
                PsiElement psiElement2 = declaration.getParent();
                if (psiElement2 == null) {
                    return false;
                }
                declarationParent = psiElement2;
                object = expression.getParent();
                if (object == null) break block6;
                psiElement = object;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement;
                boolean bl3 = false;
                object = this.isInside(it, declarationParent) ? psiElement : null;
                if (object != null) break block7;
            }
            return false;
        }
        PsiElement currentParent = object;
        while (currentParent != null && Intrinsics.areEqual((Object)currentParent, (Object)declarationParent) ^ true) {
            SimpleFunctionDescriptor functionDescriptor;
            if (currentParent instanceof KtFunction && (functionDescriptor = (SimpleFunctionDescriptor)this.bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)currentParent)) != null && !functionDescriptor.isInline()) {
                return true;
            }
            psiElement = currentParent;
            currentParent = psiElement instanceof KtCodeFragment ? ((KtCodeFragment)currentParent).getContext() : currentParent.getParent();
        }
        return false;
    }

    private final boolean isCodeFragmentDeclaration(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ValueParameterDescriptor && this.isCodeFragmentDeclaration((DeclarationDescriptor)((ValueParameterDescriptor)descriptor).getContainingDeclaration())) {
            return true;
        }
        if (!(descriptor instanceof DeclarationDescriptorWithSource)) {
            return false;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor).getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
        PsiElement psiElement = KotlinSourceElementKt.getPsi((SourceElement)sourceElement);
        return (psiElement != null ? psiElement.getContainingFile() : null) instanceof KtCodeFragment;
    }

    private final boolean isInside(PsiElement $this$isInside, PsiElement parent) {
        while (!PsiUtilsKt.isAncestor$default((PsiElement)parent, (PsiElement)$this$isInside, (boolean)false, (int)2, null)) {
            KtCodeFragment ktCodeFragment;
            PsiFile psiFile = $this$isInside.getContainingFile();
            if (!(psiFile instanceof KtCodeFragment)) {
                psiFile = null;
            }
            if ((ktCodeFragment = (KtCodeFragment)psiFile) == null || (ktCodeFragment = ktCodeFragment.getContext()) == null) {
                return false;
            }
            KtCodeFragment context = ktCodeFragment;
            $this$isInside = context;
        }
        return true;
    }

    public CodeFragmentParameterAnalyzer(@NotNull ExecutionContext context, @NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext, @NotNull EvaluationStatus evaluationStatus) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)evaluationStatus, (String)"evaluationStatus");
        this.context = context;
        this.codeFragment = codeFragment;
        this.bindingContext = bindingContext;
        this.evaluationStatus = evaluationStatus;
        this.parameters = new LinkedHashMap();
        boolean bl = false;
        this.crossingBounds = new LinkedHashSet();
        this.onceUsedChecker = new OnceUsedChecker(CodeFragmentParameterAnalyzer.class);
        this.containingPrimaryConstructor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConstructorDescriptor>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConstructorDescriptor invoke() {
                PsiElement psiElement;
                block7: {
                    block6: {
                        void $this$getParentOfType$iv;
                        block5: {
                            block4: {
                                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)((StackFrameProxy)CodeFragmentParameterAnalyzer.access$getContext$p(this.this$0).getFrameProxy()));
                                if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) break block4;
                                Comparable<Location> comparable2 = comparable;
                                boolean bl = false;
                                boolean bl2 = false;
                                Comparable<Location> it = comparable2;
                                boolean bl3 = false;
                                comparable = it.isConstructor() ? comparable2 : null;
                                if (comparable != null) break block5;
                            }
                            return null;
                        }
                        psiElement = CodeFragmentParameterAnalyzer.access$getCodeFragment$p(this.this$0).getContext();
                        if (psiElement == null) break block6;
                        PsiElement psiElement2 = psiElement;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        psiElement = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                        if (psiElement != null) break block7;
                    }
                    return null;
                }
                PsiElement constructor = psiElement;
                return (ConstructorDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get((ReadOnlySlice)BindingContext.CONSTRUCTOR, (Object)constructor);
            }
            {
                this.this$0 = codeFragmentParameterAnalyzer;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.bindingContext;
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDispatchReceiver(CodeFragmentParameterAnalyzer $this, ClassDescriptor descriptor) {
        return $this.processDispatchReceiver(descriptor);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processCoroutineContextCall(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processCoroutineContextCall(target);
    }

    public static final /* synthetic */ boolean access$isCodeFragmentDeclaration(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor descriptor) {
        return $this.isCodeFragmentDeclaration(descriptor);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processReceiver(CodeFragmentParameterAnalyzer $this, ImplicitReceiver receiver) {
        return $this.processReceiver(receiver);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSyntheticFieldVariable(CodeFragmentParameterAnalyzer $this, SyntheticFieldDescriptor descriptor) {
        return $this.processSyntheticFieldVariable(descriptor);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDebugLabel(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processDebugLabel(target);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSimpleNameExpression(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target, KtSimpleNameExpression expression) {
        return $this.processSimpleNameExpression(target, expression);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processExtensionReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor, KotlinType receiverType, String label) {
        return $this.processExtensionReceiver(descriptor, receiverType, label);
    }

    public static final /* synthetic */ LinkedHashMap access$getParameters$p(CodeFragmentParameterAnalyzer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ ExecutionContext access$getContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ KtCodeFragment access$getCodeFragment$p(CodeFragmentParameterAnalyzer $this) {
        return $this.codeFragment;
    }
}

