/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoUtilsKt;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegen;
import org.jetbrains.kotlin.codegen.CodeFragmentCodegenInfo;
import org.jetbrains.kotlin.codegen.KotlinCodegenFacade;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledDataDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorMemberScopeForMethod;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorModuleDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ReflectionCallClassPatcher;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u0003678B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015JD\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J.\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J*\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020(0&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\b2\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u000bH\u0002J \u00101\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\b\u0012\u0004\u0012\u0002050\b*\b\u0012\u0004\u0012\u0002050\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "status", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;)V", "collectGeneratedClasses", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "compile", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "filesToCompile", "Lorg/jetbrains/kotlin/psi/KtFile;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDescriptorsForCodeFragment", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "declaration", "className", "Lorg/jetbrains/kotlin/name/Name;", "methodName", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "packageFragmentDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "doCompile", "getLocalFunctionSuffixes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "getMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "methodDescriptor", "state", "getReturnType", "defaultReturnType", "Lorg/jetbrains/kotlin/types/SimpleType;", "filterCodeFragmentClassFiles", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "Companion", "CompilationResult", "GeneratedClassFilterForCodeFragment", "kotlin.jvm-debugger.evaluation"})
public final class CodeFragmentCompiler {
    private final ExecutionContext executionContext;
    private final EvaluationStatus status;
    @NotNull
    private static final Key<Companion.FragmentCompilerBackend> KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CompilationResult compile(@NotNull KtCodeFragment codeFragment, @NotNull List<? extends KtFile> filesToCompile, @NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Result result2 = (Result)ReadAction.nonBlocking((Callable)new Callable(this, codeFragment, filesToCompile, bindingContext, moduleDescriptor){
            final /* synthetic */ CodeFragmentCompiler this$0;
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ List $filesToCompile;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ ModuleDescriptor $moduleDescriptor;

            public final Result<? extends CompilationResult> call() {
                Object object;
                CodeFragmentCompiler codeFragmentCompiler = this.this$0;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    CodeFragmentCompiler $this$runCatching = codeFragmentCompiler;
                    boolean bl2 = false;
                    CompilationResult compilationResult = CodeFragmentCompiler.access$doCompile($this$runCatching, this.$codeFragment, this.$filesToCompile, this.$bindingContext, this.$moduleDescriptor);
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)compilationResult);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return Result.box-impl((Object)object);
            }
            {
                this.this$0 = codeFragmentCompiler;
                this.$codeFragment = ktCodeFragment;
                this.$filesToCompile = list;
                this.$bindingContext = bindingContext;
                this.$moduleDescriptor = moduleDescriptor;
            }
        }).executeSynchronously();
        Object object = result2.unbox-impl();
        boolean bl = false;
        ResultKt.throwOnFailure((Object)object);
        return (CompilationResult)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompilationResult doCompile(KtCodeFragment codeFragment, List<? extends KtFile> filesToCompile, BindingContext bindingContext, ModuleDescriptor moduleDescriptor) {
        void classDescriptor;
        boolean bl = codeFragment instanceof KtBlockCodeFragment || codeFragment instanceof KtExpressionCodeFragment;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Unsupported code fragment type: " + codeFragment;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Project project = codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"codeFragment.project");
        Project project2 = project;
        ResolutionFacade resolutionFacade = KotlinEvaluatorBuilderKt.getResolutionFacadeForCodeFragment(codeFragment);
        ResolveSession resolveSession = (ResolveSession)resolutionFacade.getFrontendService(ResolveSession.class);
        EvaluatorModuleDescriptor moduleDescriptorWrapper = new EvaluatorModuleDescriptor(codeFragment, moduleDescriptor, filesToCompile, resolveSession);
        SimpleType simpleType = moduleDescriptor.getBuiltIns().getUnitType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"moduleDescriptor.builtIns.unitType");
        SimpleType defaultReturnType = simpleType;
        KotlinType returnType = this.getReturnType(codeFragment, bindingContext, defaultReturnType);
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)compilerConfiguration, (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings((PsiElement)((PsiElement)codeFragment)));
        ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.BINARIES;
        Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"ClassBuilderFactories.BINARIES");
        Pair<ClassDescriptor, FunctionDescriptor> pair = new Pair<ClassDescriptor, FunctionDescriptor>(project2, classBuilderFactory, (ModuleDescriptor)moduleDescriptorWrapper, bindingContext, filesToCompile, compilerConfiguration);
        boolean bl5 = false;
        boolean bl6 = false;
        Pair<ClassDescriptor, FunctionDescriptor> $this$apply = pair;
        boolean bl7 = false;
        Companion.FragmentCompilerBackend fragmentCompilerBackend = (Companion.FragmentCompilerBackend)((Object)this.executionContext.getDebugProcess().getUserData(KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND));
        if (fragmentCompilerBackend == Companion.FragmentCompilerBackend.JVM_IR) {
            Pair<ClassDescriptor, FunctionDescriptor> pair2 = $this$apply;
            String string = "Not implemented yet: EE-IR Fragment Compiler";
            boolean bl8 = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        $this$apply.generateDeclaredClassFilter((GenerationState.GenerateClassFilter)new GeneratedClassFilterForCodeFragment(codeFragment));
        GenerationState generationState = pair.build();
        CodeFragmentParameterInfo parameterInfo = new CodeFragmentParameterAnalyzer(this.executionContext, codeFragment, bindingContext, this.status).analyze();
        Name name = Name.identifier((String)"Generated_for_debugger_class");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(GENERATED_CLASS_NAME)");
        Name name2 = Name.identifier((String)"generated_for_debugger_fun");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.identifier(GENERATED_FUNCTION_NAME)");
        $this$apply = this.createDescriptorsForCodeFragment(codeFragment, name, name2, parameterInfo, returnType, (PackageFragmentDescriptor)moduleDescriptorWrapper.getPackageFragmentForEvaluator());
        ClassDescriptor classDescriptor2 = (ClassDescriptor)$this$apply.component1();
        FunctionDescriptor methodDescriptor = (FunctionDescriptor)$this$apply.component2();
        CodeFragmentCodegenInfo codegenInfo = new CodeFragmentCodegenInfo((ClassDescriptor)classDescriptor, methodDescriptor, parameterInfo.getParameters());
        CodeFragmentCodegen.Companion.setCodeFragmentInfo(codeFragment, codegenInfo);
        try {
            KotlinCodegenFacade.compileCorrectFiles((GenerationState)generationState);
            List<ClassToLoad> classes = this.collectGeneratedClasses(generationState);
            CompiledDataDescriptor.MethodSignature methodSignature = this.getMethodSignature(methodDescriptor, parameterInfo, generationState);
            Map<CodeFragmentParameter.Dumb, String> functionSuffixes = this.getLocalFunctionSuffixes(parameterInfo.getParameters(), generationState.getTypeMapper());
            generationState.destroy();
            CompilationResult compilationResult = new CompilationResult(classes, parameterInfo, functionSuffixes, methodSignature);
            return compilationResult;
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            throw (Throwable)new CodeFragmentCodegenException(e);
        }
        finally {
            CodeFragmentCodegen.Companion.clearCodeFragmentInfo(codeFragment);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassToLoad> collectGeneratedClasses(GenerationState generationState) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Project project = generationState.getProject();
        boolean useBytecodePatcher = ReflectionCallClassPatcher.INSTANCE.isEnabled();
        ModuleInfo moduleInfo = ModuleInfoUtilsKt.getModuleInfo((ModuleDescriptor)generationState.getModule());
        if (!(moduleInfo instanceof ModuleSourceInfo)) {
            moduleInfo = null;
        }
        ModuleSourceInfo moduleSourceInfo = (ModuleSourceInfo)moduleInfo;
        Object module = moduleSourceInfo != null ? moduleSourceInfo.getModule() : null;
        GlobalSearchScope globalSearchScope = module == null ? GlobalSearchScope.allScope((Project)project) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"when (val module = (gene\u2026e(module, true)\n        }");
        GlobalSearchScope scope = globalSearchScope;
        List list = generationState.getFactory().asList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"generationState.factory.asList()");
        module = this.filterCodeFragmentClassFiles(list);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputFile outputFile = (OutputFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] rawBytes = it.asByteArray();
            byte[] bytes2 = useBytecodePatcher ? ReflectionCallClassPatcher.INSTANCE.patch(rawBytes, project, scope) : rawBytes;
            ClassToLoad classToLoad = new ClassToLoad(CodeFragmentCompilerKt.access$getInternalClassName$p((OutputFile)it), it.getRelativePath(), bytes2);
            collection.add(classToLoad);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OutputFile> filterCodeFragmentClassFiles(List<? extends OutputFile> $this$filterCodeFragmentClassFiles) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterCodeFragmentClassFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OutputFile classFile = (OutputFile)element$iv$iv;
            boolean bl = false;
            String path = classFile.getRelativePath();
            if (!(Intrinsics.areEqual((Object)path, (Object)"Generated_for_debugger_class.class") || StringsKt.startsWith$default((String)path, (String)"Generated_for_debugger_class$", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)path, (String)".class", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Map<CodeFragmentParameter.Dumb, String> getLocalFunctionSuffixes(List<CodeFragmentParameter.Smart> parameters, KotlinTypeMapper typeMapper) {
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (CodeFragmentParameter.Smart parameter : parameters) {
            String ownerClassName;
            if (parameter.getKind() != CodeFragmentParameter.Kind.LOCAL_FUNCTION) continue;
            String string = ownerClassName = typeMapper.mapOwner(parameter.getTargetDescriptor()).getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ownerClassName");
            Integer n = StringsKt.lastIndexOf$default((CharSequence)string, (char)'$', (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            boolean bl3 = false;
            int it = ((Number)n).intValue();
            boolean bl4 = false;
            Integer n2 = it >= 0 ? n : null;
            if (n2 == null) {
                continue;
            }
            int lastDollarIndex = n2;
            result2.put(parameter.getDumb(), StringsKt.drop((String)ownerClassName, (int)lastDollarIndex));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final CompiledDataDescriptor.MethodSignature getMethodSignature(FunctionDescriptor methodDescriptor, CodeFragmentParameterInfo parameterInfo, GenerationState state) {
        void $this$mapTo$iv$iv;
        KotlinTypeMapper typeMapper = state.getTypeMapper();
        JvmMethodSignature asmSignature = KotlinTypeMapper.mapSignatureSkipGeneric$default((KotlinTypeMapper)typeMapper, (FunctionDescriptor)methodDescriptor, null, (int)2, null);
        Iterable iterable = parameterInfo.getParameters();
        List list = asmSignature.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"asmSignature.valueParameters");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)list);
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            void $dstr$param$sigParam;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CodeFragmentParameter.Smart smart = (CodeFragmentParameter.Smart)$dstr$param$sigParam.component1();
            JvmMethodParameterSignature sigParam = (JvmMethodParameterSignature)$dstr$param$sigParam.component2();
            Type type2 = CodeFragmentCodegen.Companion.getSharedTypeIfApplicable((CodeFragmentCodegenInfo.IParameter)param, typeMapper);
            if (type2 == null) {
                JvmMethodParameterSignature jvmMethodParameterSignature = sigParam;
                Intrinsics.checkNotNullExpressionValue((Object)jvmMethodParameterSignature, (String)"sigParam");
                Type type3 = jvmMethodParameterSignature.getAsmType();
                type2 = type3;
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"sigParam.asmType");
            }
            Type type4 = type2;
            collection.add(type4);
        }
        List asmParameters = (List)destination$iv$iv;
        Type type5 = asmSignature.getReturnType();
        Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"asmSignature.returnType");
        return new CompiledDataDescriptor.MethodSignature(asmParameters, type5);
    }

    private final KotlinType getReturnType(KtCodeFragment codeFragment, BindingContext bindingContext, SimpleType defaultReturnType) {
        KotlinType kotlinType;
        KtCodeFragment ktCodeFragment = codeFragment;
        if (ktCodeFragment instanceof KtExpressionCodeFragment) {
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)((KtExpressionCodeFragment)codeFragment).getContentElement());
            kotlinType = typeInfo;
            if (kotlinType == null || (kotlinType = kotlinType.getType()) == null) {
                kotlinType = (KotlinType)defaultReturnType;
            }
        } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
            KtBlockExpression blockExpression = ((KtBlockCodeFragment)codeFragment).getContentElement();
            List list = blockExpression.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blockExpression.statements");
            KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list);
            if (ktExpression == null) {
                return (KotlinType)defaultReturnType;
            }
            KtExpression lastStatement = ktExpression;
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)lastStatement);
            kotlinType = typeInfo;
            if (kotlinType == null || (kotlinType = kotlinType.getType()) == null) {
                kotlinType = (KotlinType)defaultReturnType;
            }
        } else {
            kotlinType = (KotlinType)defaultReturnType;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ClassDescriptor, FunctionDescriptor> createDescriptorsForCodeFragment(KtCodeFragment declaration, Name className, Name methodName, CodeFragmentParameterInfo parameterInfo, KotlinType returnType, PackageFragmentDescriptor packageFragmentDescriptor) {
        void $this$mapIndexedTo$iv$iv;
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl((DeclarationDescriptor)packageFragmentDescriptor, className, Modality.FINAL, ClassKind.OBJECT, (Collection)CollectionsKt.emptyList(), (SourceElement)new KotlinSourceElement((KtElement)declaration), false, LockBasedStorageManager.NO_LOCKS);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor), (Annotations)Annotations.Companion.getEMPTY(), (Name)methodName, (CallableMemberDescriptor.Kind)CallableMemberDescriptor.Kind.SYNTHESIZED, (SourceElement)classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"SimpleFunctionDescriptor\u2026scriptor.source\n        )");
        SimpleFunctionDescriptorImpl methodDescriptor = simpleFunctionDescriptorImpl;
        Iterable $this$mapIndexed$iv = parameterInfo.getParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameter;
            void index;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            CodeFragmentParameter.Smart smart = (CodeFragmentParameter.Smart)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CallableDescriptor callableDescriptor = (CallableDescriptor)methodDescriptor;
            Annotations annotations = Annotations.Companion.getEMPTY();
            Name name = Name.identifier((String)("" + 'p' + (int)index));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"Name.identifier(\"p$index\")");
            KotlinType kotlinType = parameter.getTargetType();
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, null, (int)index, annotations, name, kotlinType, false, false, false, null, sourceElement);
            collection.add(valueParameterDescriptorImpl);
        }
        List parameters = (List)destination$iv$iv;
        methodDescriptor.initialize(null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), parameters, returnType, Modality.FINAL, DescriptorVisibilities.PUBLIC);
        EvaluatorMemberScopeForMethod memberScope2 = new EvaluatorMemberScopeForMethod((SimpleFunctionDescriptor)methodDescriptor);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create((ClassDescriptor)((ClassDescriptor)classDescriptor), (Annotations)Annotations.Companion.getEMPTY(), (boolean)true, (SourceElement)classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptorImpl, (String)"ClassConstructorDescript\u2026, classDescriptor.source)");
        ClassConstructorDescriptorImpl constructor = classConstructorDescriptorImpl;
        classDescriptor.initialize((MemberScope)memberScope2, SetsKt.setOf((Object)constructor), (ClassConstructorDescriptor)constructor);
        return new Pair((Object)classDescriptor, (Object)methodDescriptor);
    }

    public CodeFragmentCompiler(@NotNull ExecutionContext executionContext, @NotNull EvaluationStatus status) {
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        this.executionContext = executionContext;
        this.status = status;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"KOTLIN_EVALU\u2026AGMENT_COMPILER_BACKEND\")");
        KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND = key;
    }

    public static final /* synthetic */ CompilationResult access$doCompile(CodeFragmentCompiler $this, KtCodeFragment codeFragment, List filesToCompile, BindingContext bindingContext, ModuleDescriptor moduleDescriptor) {
        return $this.doCompile(codeFragment, filesToCompile, bindingContext, moduleDescriptor);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\fH\u00c6\u0003JC\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\nH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "localFunctionSuffixes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "", "mainMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "(Ljava/util/List;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;Ljava/util/Map;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;)V", "getClasses", "()Ljava/util/List;", "getLocalFunctionSuffixes", "()Ljava/util/Map;", "getMainMethodSignature", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledDataDescriptor$MethodSignature;", "getParameterInfo", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.evaluation"})
    public static final class CompilationResult {
        @NotNull
        private final List<ClassToLoad> classes;
        @NotNull
        private final CodeFragmentParameterInfo parameterInfo;
        @NotNull
        private final Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes;
        @NotNull
        private final CompiledDataDescriptor.MethodSignature mainMethodSignature;

        @NotNull
        public final List<ClassToLoad> getClasses() {
            return this.classes;
        }

        @NotNull
        public final CodeFragmentParameterInfo getParameterInfo() {
            return this.parameterInfo;
        }

        @NotNull
        public final Map<CodeFragmentParameter.Dumb, String> getLocalFunctionSuffixes() {
            return this.localFunctionSuffixes;
        }

        @NotNull
        public final CompiledDataDescriptor.MethodSignature getMainMethodSignature() {
            return this.mainMethodSignature;
        }

        public CompilationResult(@NotNull List<ClassToLoad> classes, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledDataDescriptor.MethodSignature mainMethodSignature) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter((Object)parameterInfo, (String)"parameterInfo");
            Intrinsics.checkNotNullParameter(localFunctionSuffixes, (String)"localFunctionSuffixes");
            Intrinsics.checkNotNullParameter((Object)mainMethodSignature, (String)"mainMethodSignature");
            this.classes = classes;
            this.parameterInfo = parameterInfo;
            this.localFunctionSuffixes = localFunctionSuffixes;
            this.mainMethodSignature = mainMethodSignature;
        }

        @NotNull
        public final List<ClassToLoad> component1() {
            return this.classes;
        }

        @NotNull
        public final CodeFragmentParameterInfo component2() {
            return this.parameterInfo;
        }

        @NotNull
        public final Map<CodeFragmentParameter.Dumb, String> component3() {
            return this.localFunctionSuffixes;
        }

        @NotNull
        public final CompiledDataDescriptor.MethodSignature component4() {
            return this.mainMethodSignature;
        }

        @NotNull
        public final CompilationResult copy(@NotNull List<ClassToLoad> classes, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledDataDescriptor.MethodSignature mainMethodSignature) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter((Object)parameterInfo, (String)"parameterInfo");
            Intrinsics.checkNotNullParameter(localFunctionSuffixes, (String)"localFunctionSuffixes");
            Intrinsics.checkNotNullParameter((Object)mainMethodSignature, (String)"mainMethodSignature");
            return new CompilationResult(classes, parameterInfo, localFunctionSuffixes, mainMethodSignature);
        }

        public static /* synthetic */ CompilationResult copy$default(CompilationResult compilationResult, List list, CodeFragmentParameterInfo codeFragmentParameterInfo, Map map, CompiledDataDescriptor.MethodSignature methodSignature, int n, Object object) {
            if ((n & 1) != 0) {
                list = compilationResult.classes;
            }
            if ((n & 2) != 0) {
                codeFragmentParameterInfo = compilationResult.parameterInfo;
            }
            if ((n & 4) != 0) {
                map = compilationResult.localFunctionSuffixes;
            }
            if ((n & 8) != 0) {
                methodSignature = compilationResult.mainMethodSignature;
            }
            return compilationResult.copy(list, codeFragmentParameterInfo, map, methodSignature);
        }

        @NotNull
        public String toString() {
            return "CompilationResult(classes=" + this.classes + ", parameterInfo=" + this.parameterInfo + ", localFunctionSuffixes=" + this.localFunctionSuffixes + ", mainMethodSignature=" + this.mainMethodSignature + ")";
        }

        public int hashCode() {
            List<ClassToLoad> list = this.classes;
            CodeFragmentParameterInfo codeFragmentParameterInfo = this.parameterInfo;
            Map<CodeFragmentParameter.Dumb, String> map = this.localFunctionSuffixes;
            CompiledDataDescriptor.MethodSignature methodSignature = this.mainMethodSignature;
            return (((list != null ? ((Object)list).hashCode() : 0) * 31 + (codeFragmentParameterInfo != null ? codeFragmentParameterInfo.hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0)) * 31 + (methodSignature != null ? methodSignature.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompilationResult)) break block3;
                    CompilationResult compilationResult = (CompilationResult)object;
                    if (!Intrinsics.areEqual(this.classes, compilationResult.classes) || !Intrinsics.areEqual((Object)this.parameterInfo, (Object)compilationResult.parameterInfo) || !Intrinsics.areEqual(this.localFunctionSuffixes, compilationResult.localFunctionSuffixes) || !Intrinsics.areEqual((Object)this.mainMethodSignature, (Object)compilationResult.mainMethodSignature)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0003H\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$GeneratedClassFilterForCodeFragment;", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "shouldAnnotateClass", "", "processingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "shouldGenerateClass", "shouldGenerateCodeFragment", "script", "shouldGeneratePackagePart", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldGenerateScript", "Lorg/jetbrains/kotlin/psi/KtScript;", "kotlin.jvm-debugger.evaluation"})
    private static final class GeneratedClassFilterForCodeFragment
    extends GenerationState.GenerateClassFilter {
        private final KtCodeFragment codeFragment;

        public boolean shouldGeneratePackagePart(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return Intrinsics.areEqual((Object)file, (Object)this.codeFragment);
        }

        public boolean shouldAnnotateClass(@NotNull KtClassOrObject processingClassOrObject) {
            Intrinsics.checkNotNullParameter((Object)processingClassOrObject, (String)"processingClassOrObject");
            return true;
        }

        public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
            Intrinsics.checkNotNullParameter((Object)processingClassOrObject, (String)"processingClassOrObject");
            return Intrinsics.areEqual((Object)processingClassOrObject.getContainingFile(), (Object)this.codeFragment);
        }

        public boolean shouldGenerateCodeFragment(@NotNull KtCodeFragment script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            return Intrinsics.areEqual((Object)script, (Object)this.codeFragment);
        }

        public boolean shouldGenerateScript(@NotNull KtScript script) {
            Intrinsics.checkNotNullParameter((Object)script, (String)"script");
            return false;
        }

        public GeneratedClassFilterForCodeFragment(@NotNull KtCodeFragment codeFragment) {
            Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
            this.codeFragment = codeFragment;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$Companion;", "", "()V", "KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$Companion$FragmentCompilerBackend;", "getKOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND", "()Lcom/intellij/openapi/util/Key;", "FragmentCompilerBackend", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        @NotNull
        public final Key<FragmentCompilerBackend> getKOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND() {
            return KOTLIN_EVALUATOR_FRAGMENT_COMPILER_BACKEND;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$Companion$FragmentCompilerBackend;", "", "(Ljava/lang/String;I)V", "JVM", "JVM_IR", "kotlin.jvm-debugger.evaluation"})
        public static final class FragmentCompilerBackend
        extends Enum<FragmentCompilerBackend> {
            public static final /* enum */ FragmentCompilerBackend JVM;
            public static final /* enum */ FragmentCompilerBackend JVM_IR;
            private static final /* synthetic */ FragmentCompilerBackend[] $VALUES;

            static {
                FragmentCompilerBackend[] fragmentCompilerBackendArray = new FragmentCompilerBackend[2];
                FragmentCompilerBackend[] fragmentCompilerBackendArray2 = fragmentCompilerBackendArray;
                fragmentCompilerBackendArray[0] = JVM = new FragmentCompilerBackend();
                fragmentCompilerBackendArray[1] = JVM_IR = new FragmentCompilerBackend();
                $VALUES = fragmentCompilerBackendArray;
            }

            public static FragmentCompilerBackend[] values() {
                return (FragmentCompilerBackend[])$VALUES.clone();
            }

            public static FragmentCompilerBackend valueOf(String string) {
                return Enum.valueOf(FragmentCompilerBackend.class, string);
            }
        }
    }
}

