/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.AndroidOClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.OrdinaryClassLoadingAdapter;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH&J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "", "isApplicable", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "info", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "mirrorOfByteArray", "Lcom/sun/jdi/ArrayReference;", "bytes", "", "Companion", "kotlin.jvm-debugger.evaluation"})
public interface ClassLoadingAdapter {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter$Companion.$$INSTANCE;

    public boolean isApplicable(@NotNull ExecutionContext var1, @NotNull Companion.ClassInfoForEvaluator var2);

    @NotNull
    public ClassLoaderReference loadClasses(@NotNull ExecutionContext var1, @NotNull Collection<ClassToLoad> var2);

    @NotNull
    public ArrayReference mirrorOfByteArray(@NotNull byte[] var1, @NotNull ExecutionContext var2);

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static ArrayReference mirrorOfByteArray(@NotNull ClassLoadingAdapter $this, @NotNull byte[] bytes2, @NotNull ExecutionContext context) {
            int chunkSize;
            Intrinsics.checkNotNullParameter((Object)bytes2, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ClassLoaderReference classLoader = context.getClassLoader();
            ReferenceType referenceType = context.findClass("byte[]", classLoader);
            if (referenceType == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ArrayType");
            }
            ArrayType arrayClass = (ArrayType)referenceType;
            ArrayReference reference = context.newInstance(arrayClass, bytes2.length);
            context.keepReference((ObjectReference)reference);
            ArrayList mirrors = new ArrayList(bytes2.length);
            for (byte by : bytes2) {
                Collection collection = mirrors;
                ByteValue byteValue = context.getVm().mirrorOf(by);
                boolean bl = false;
                collection.add(byteValue);
            }
            for (int loaded = 0; loaded < mirrors.size(); loaded += chunkSize) {
                int n = 4096;
                int n2 = mirrors.size() - loaded;
                boolean bl = false;
                chunkSize = Math.min(n, n2);
                reference.setValues(loaded, mirrors, loaded, chunkSize);
            }
            return reference;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion;", "", "()V", "ADAPTERS", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter;", "CHUNK_SIZE", "", "analyzeClass", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "classToLoad", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "info", "loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "classes", "", "ClassInfoForEvaluator", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private static final int CHUNK_SIZE = 4096;
        private static final List<ClassLoadingAdapter> ADAPTERS;
        static final /* synthetic */ Companion $$INSTANCE;

        @Nullable
        public final ClassLoaderReference loadClasses(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter(classes, (String)"classes");
                Iterable $this$firstOrNull$iv = classes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ClassToLoad it = (ClassToLoad)element$iv;
                    boolean bl = false;
                    if (!it.isMainClass()) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            ClassToLoad classToLoad = v0;
            if (classToLoad == null) {
                return null;
            }
            ClassToLoad mainClass = classToLoad;
            ClassInfoForEvaluator info = new ClassInfoForEvaluator(false, false, classes.size() > 1, 3, null);
            if (!info.getContainsAdditionalClasses()) {
                info = this.analyzeClass(mainClass, info);
            }
            for (ClassLoadingAdapter adapter : ADAPTERS) {
                if (!adapter.isApplicable(context, info)) continue;
                return adapter.loadClasses(context, classes);
            }
            return null;
        }

        private final ClassInfoForEvaluator analyzeClass(ClassToLoad classToLoad, ClassInfoForEvaluator info) {
            ClassNode classNode = new ClassNode();
            boolean bl = false;
            boolean bl2 = false;
            ClassNode $this$apply = classNode;
            boolean bl3 = false;
            new ClassReader(classToLoad.getBytes()).accept((ClassVisitor)$this$apply, 0);
            ClassNode classNode2 = classNode;
            for (MethodNode method : classNode2.methods) {
                if ((method.access & 0x20) == 0) continue;
                return ClassInfoForEvaluator.copy$default(info, false, true, false, 5, null);
            }
            List list = classNode2.methods;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classNode.methods");
            Iterable $this$single$iv = list;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                MethodNode it = (MethodNode)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)"generated_for_debugger_fun")) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            MethodNode methodToRun = single$iv;
            $i$f$single = false;
            HashSet visitedLabels = new HashSet();
            Function2<AbstractInsnNode, ClassInfoForEvaluator, ClassInfoForEvaluator> $fun$analyzeInsn$1 = new Function2<AbstractInsnNode, ClassInfoForEvaluator, ClassInfoForEvaluator>(visitedLabels){
                final /* synthetic */ HashSet $visitedLabels;

                @NotNull
                public final ClassInfoForEvaluator invoke(@NotNull AbstractInsnNode insn, @NotNull ClassInfoForEvaluator info) {
                    while (true) {
                        AbstractInsnNode nextInsn;
                        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        AbstractInsnNode abstractInsnNode = insn;
                        if (abstractInsnNode instanceof LabelNode) {
                            Collection collection = this.$visitedLabels;
                            Label label = ((LabelNode)insn).getLabel();
                            boolean bl = false;
                            collection.add(label);
                        } else if (abstractInsnNode instanceof JumpInsnNode) {
                            LabelNode labelNode = ((JumpInsnNode)insn).label;
                            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insn.label");
                            if (this.$visitedLabels.contains(labelNode.getLabel())) {
                                return ClassInfoForEvaluator.copy$default(info, true, false, false, 6, null);
                            }
                        } else {
                            if (abstractInsnNode instanceof TableSwitchInsnNode || abstractInsnNode instanceof LookupSwitchInsnNode) {
                                return ClassInfoForEvaluator.copy$default(info, false, true, false, 5, null);
                            }
                            if (abstractInsnNode instanceof InsnNode && (((InsnNode)insn).getOpcode() == 194 || ((InsnNode)insn).getOpcode() == 195)) {
                                return ClassInfoForEvaluator.copy$default(info, false, true, false, 5, null);
                            }
                        }
                        if (insn.getNext() == null) {
                            return info;
                        }
                        insn = nextInsn;
                    }
                }
                {
                    this.$visitedLabels = hashSet;
                    super(2);
                }
            };
            InsnList insnList = methodToRun.instructions;
            if (insnList == null || (insnList = insnList.getFirst()) == null) {
                return info;
            }
            InsnList firstInsn = insnList;
            return $fun$analyzeInsn$1.invoke((AbstractInsnNode)firstInsn, info);
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            ADAPTERS = CollectionsKt.listOf((Object[])new ClassLoadingAdapter[]{new AndroidOClassLoadingAdapter(), new OrdinaryClassLoadingAdapter()});
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassLoadingAdapter$Companion$ClassInfoForEvaluator;", "", "containsLoops", "", "containsCodeUnsupportedInEval4J", "containsAdditionalClasses", "(ZZZ)V", "getContainsAdditionalClasses", "()Z", "getContainsCodeUnsupportedInEval4J", "getContainsLoops", "isCompilingEvaluatorPreferred", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.evaluation"})
        public static final class ClassInfoForEvaluator {
            private final boolean containsLoops;
            private final boolean containsCodeUnsupportedInEval4J;
            private final boolean containsAdditionalClasses;

            public final boolean isCompilingEvaluatorPreferred() {
                return this.containsLoops || this.containsCodeUnsupportedInEval4J || this.containsAdditionalClasses;
            }

            public final boolean getContainsLoops() {
                return this.containsLoops;
            }

            public final boolean getContainsCodeUnsupportedInEval4J() {
                return this.containsCodeUnsupportedInEval4J;
            }

            public final boolean getContainsAdditionalClasses() {
                return this.containsAdditionalClasses;
            }

            public ClassInfoForEvaluator(boolean containsLoops, boolean containsCodeUnsupportedInEval4J, boolean containsAdditionalClasses) {
                this.containsLoops = containsLoops;
                this.containsCodeUnsupportedInEval4J = containsCodeUnsupportedInEval4J;
                this.containsAdditionalClasses = containsAdditionalClasses;
            }

            public /* synthetic */ ClassInfoForEvaluator(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                if ((n & 4) != 0) {
                    bl3 = false;
                }
                this(bl, bl2, bl3);
            }

            public ClassInfoForEvaluator() {
                this(false, false, false, 7, null);
            }

            public final boolean component1() {
                return this.containsLoops;
            }

            public final boolean component2() {
                return this.containsCodeUnsupportedInEval4J;
            }

            public final boolean component3() {
                return this.containsAdditionalClasses;
            }

            @NotNull
            public final ClassInfoForEvaluator copy(boolean containsLoops, boolean containsCodeUnsupportedInEval4J, boolean containsAdditionalClasses) {
                return new ClassInfoForEvaluator(containsLoops, containsCodeUnsupportedInEval4J, containsAdditionalClasses);
            }

            public static /* synthetic */ ClassInfoForEvaluator copy$default(ClassInfoForEvaluator classInfoForEvaluator, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = classInfoForEvaluator.containsLoops;
                }
                if ((n & 2) != 0) {
                    bl2 = classInfoForEvaluator.containsCodeUnsupportedInEval4J;
                }
                if ((n & 4) != 0) {
                    bl3 = classInfoForEvaluator.containsAdditionalClasses;
                }
                return classInfoForEvaluator.copy(bl, bl2, bl3);
            }

            @NotNull
            public String toString() {
                return "ClassInfoForEvaluator(containsLoops=" + this.containsLoops + ", containsCodeUnsupportedInEval4J=" + this.containsCodeUnsupportedInEval4J + ", containsAdditionalClasses=" + this.containsAdditionalClasses + ")";
            }

            public int hashCode() {
                int n = this.containsLoops ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                int n2 = n * 31;
                int n3 = this.containsCodeUnsupportedInEval4J ? 1 : 0;
                if (n3 != 0) {
                    n3 = 1;
                }
                int n4 = (n2 + n3) * 31;
                int n5 = this.containsAdditionalClasses ? 1 : 0;
                if (n5 != 0) {
                    n5 = 1;
                }
                return n4 + n5;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ClassInfoForEvaluator)) break block3;
                        ClassInfoForEvaluator classInfoForEvaluator = (ClassInfoForEvaluator)object;
                        if (this.containsLoops != classInfoForEvaluator.containsLoops || this.containsCodeUnsupportedInEval4J != classInfoForEvaluator.containsCodeUnsupportedInEval4J || this.containsAdditionalClasses != classInfoForEvaluator.containsAdditionalClasses) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

