/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinEvaluatorBuilder;", "Lcom/intellij/debugger/engine/evaluation/expression/EvaluatorBuilder;", "()V", "build", "Lcom/intellij/debugger/engine/evaluation/expression/ExpressionEvaluator;", "codeFragment", "Lcom/intellij/psi/PsiElement;", "position", "Lcom/intellij/debugger/SourcePosition;", "kotlin.jvm-debugger.evaluation"})
public final class KotlinEvaluatorBuilder
implements EvaluatorBuilder {
    @NotNull
    public static final KotlinEvaluatorBuilder INSTANCE;

    @NotNull
    public ExpressionEvaluator build(@NotNull PsiElement codeFragment, @Nullable SourcePosition position) {
        PsiFile file;
        PsiElement context;
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        if (!(codeFragment instanceof KtCodeFragment)) {
            ExpressionEvaluator expressionEvaluator = EvaluatorBuilderImpl.getInstance().build(codeFragment, position);
            Intrinsics.checkNotNullExpressionValue((Object)expressionEvaluator, (String)"EvaluatorBuilderImpl.get\u2026d(codeFragment, position)");
            return expressionEvaluator;
        }
        PsiElement psiElement = context = ((KtCodeFragment)codeFragment).getContext();
        Object object = file = psiElement != null ? psiElement.getContainingFile() : null;
        if (file != null && !(file instanceof KtFile)) {
            PsiElement psiElement2 = ((KtCodeFragment)codeFragment).getContext();
            KotlinEvaluatorBuilderKt.reportError$default((KtCodeFragment)codeFragment, position, "Unknown context" + (psiElement2 != null ? psiElement2.getClass() : null), null, 8, null);
            Void void_ = KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.bad.context", new Object[0]));
            throw new KotlinNothingValueException();
        }
        return (ExpressionEvaluator)new ExpressionEvaluatorImpl((Evaluator)new KotlinEvaluator((KtCodeFragment)codeFragment, position));
    }

    private KotlinEvaluatorBuilder() {
    }

    static {
        KotlinEvaluatorBuilder kotlinEvaluatorBuilder;
        INSTANCE = kotlinEvaluatorBuilder = new KotlinEvaluatorBuilder();
    }
}

